package com.xdja.safeclient.certcreation.activity;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.EditText;

import com.aircert.BusProvider;
import com.aircert.util.ModuleLog;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.HttpResponseCallBack;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.bean.CertDetailInfo;
import com.xdja.safeclient.certcreation.bean.CertState;
import com.xdja.safeclient.certcreation.bean.ChipBean;
import com.xdja.safeclient.certcreation.bean.OkNetError;
import com.xdja.safeclient.certcreation.bean.request.Info;
import com.xdja.safeclient.certcreation.bean.request.RevokedCertRequest;
import com.xdja.safeclient.certcreation.bean.response.BaseErrorResponse;
import com.xdja.safeclient.certcreation.bean.response.CommonResponse;
import com.xdja.safeclient.certcreation.config.CertRule;
import com.xdja.safeclient.certcreation.config.CertType;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.exception.CardNotExistException;
import com.xdja.safeclient.certcreation.util.CryptoDevTypeUtil;
import com.xdja.safeclient.certcreation.util.EditTextUtil;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import com.xdja.safeclient.certcreation.view.NoDoubleClickListener;
import com.xdja.safeclient.certcreation.view.PinDialog;

import java.io.IOException;

import okhttp3.Call;

/**
 * Created by jff on 2018/6/29.
 */
public class ReasonActivity extends BaseActivity {

    public static final String TAG = "ReasonActivity";

    /**
     * 撤销证书
     */
    public static final int REVOKE = 2;

    /**
     * 解冻证书
     */
    public static final int RECOVERY = 1;

    private EditText reasonET;
    private Button submit;

    private CertDetailInfo certDetailInfo;

    public ChipBean chipBean;

    CryptoDevType cardType;

    public int containerNum;

    private String certRule;

    public String certType;

    public String cardID;


    /**
     * 禁止多次撤销
     */
    private boolean block;

    @Override
    protected void getIntentData() {
        super.getIntentData();

        chipBean = (ChipBean) getIntent().getSerializableExtra("chipBean");
        cardID = getIntent().getStringExtra("cardId");

        certType = getIntent().getStringExtra(ActivityParam.CERT_TYPE);
        containerNum = getIntent().getIntExtra(ActivityParam.CONTAINER_NUM, 0);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {

        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_reason);


        certDetailInfo = chipBean.getCertBean();

        cardType = CryptoDevTypeUtil.formatType(chipBean.getType());

        certRule = AppConfig.getInstance().getCertConfig()
                .getCertRule(cardType, containerNum);


        reasonET = (EditText) findViewById(R.id.reason);
        reasonET.addTextChangedListener(textWatcher);
        reasonET.setFilters(EditTextUtil.getDisableEmojFilter());

        submit = (Button) findViewById(R.id.submit);
        final Context context = this;
        submit.setOnClickListener(new NoDoubleClickListener() {
            @Override
            public void onNoDoubleClick(View v) {

                if (!block) {
                    if (reasonET.getText().length() > 0) {
                        hideSoft();
                        revokeCert();
                    } else {
                        ModuleToast.show(context, R.string.cert_creation_reason_input);
                    }
                } else {
                    ModuleLog.e("禁止多次撤销");
                }

                block = true;

                new Handler().postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        block = false;
                    }
                }, 2000);


            }
        });


    }

    private void revokeCert() {

        // TODO: 2018/12/20 0020 原来的Loading和默认的loading不太一样
        showLoading();

        // TODO: 2018/12/20 0020 判断网络状况，如果没有网络连接的话的话直接提示

        RevokedCertRequest request = buildRequest();
        if (request == null) {
            return;
        }

        service.revokedCert(request, cardID, new HttpResponseCallBack<CommonResponse>() {
            @Override
            public void onOtherException(Exception e) {
                dismissLoading();
                if (e instanceof CardNotExistException) {
                    // 提示卡设备不存在
                    ModuleToast.show(ReasonActivity.this,R.string.cert_creation_device_not_exist);
                } else {
                    e.printStackTrace();
                }
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                //                ModuleLog.e("注销异常： " + e.getMessage());
                //网络异常，请重试
                dismissLoading();
                ModuleToast.show(ReasonActivity.this, R.string.net_disconnected_text);
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                String result = commonResponse.getResult();

                if (result.equals("0")) {
                    chipBean.setState(CertState.WAITING_AGREE_REVOKE);
                } else if (result.equals("1")) {//撤销申请成功
                    chipBean.setState(CertState.AGREE_REVOKE);
                } else if (result.equals("2")) {//撤销被拒绝
                    chipBean.setState(CertState.REJECT_REVOKE);
                } else if (result.equals("5")) {
                    // todo 证书被冻结
                } else if (result.equals("6")) {
                    //todo 证书过期
                } else if (result.equals("45")) {
                    chipBean.setState(CertState.RA_REVOKE_WAIT_45);
                }

                BusProvider.getMainProvider().post(chipBean);

                OttoUtil.postRevokeResult(containerNum, chipBean, reasonET.getText().toString());

                finish();

            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                //                String message = baseErrorResponse.getMessage();
                ModuleLog.e("注销失败： " + baseErrorResponse.getErrCode());
                //                handleErrorResponse(baseErrorResponse.getErrCode());
                //                ModuleToast.show(ReasonActivity.this, baseErrorResponse.getMessage());
                ModuleToast.show(ReasonActivity.this, OkNetError.userError(getContext(), baseErrorResponse.getErrCode()));
                dismissDialog();
            }

            @Override
            public void dismissDialog() {
                dismissLoading();
            }
        });

    }

    private RevokedCertRequest buildRequest() {

        RevokedCertRequest revokeRequest = new RevokedCertRequest();
        Info info = new Info();
        String sn;
        if (certDetailInfo != null) {
            if (certType.equals(CertType.SIGNING) || certRule.equals(CertRule.SINGLE)) {
                sn = certDetailInfo.getSn();
            } else {
                sn = DeviceWrapper.getInstance().readCertFromContainer(cardType, containerNum, (CertType.SIGNING)).getSn();
            }
        } else {
            ModuleLog.e("sn为空");
            return null;

        }
        info.setSn(sn);
        // TODO: 2018/12/20 0020 原因是否需要增加判空
        info.setReason(reasonET.getText().toString());
        info.setTime(System.currentTimeMillis());
        revokeRequest.setInfo(info);
        String sign = DeviceWrapper.getInstance().signData(cardType, containerNum, info.toString());
        //        ModuleLog.e(TAG, "给1签名" + "\n" + DeviceWrapper.getInstance().signData(cardType, containerNum, "1"));

        if (sign != null) {
            if (sign.startsWith("errorCode")) {//签名时验证默认PIN码失败
                showPinDialog();
                return null;
            } else {
                revokeRequest.setSign(sign);
                ModuleLog.e("revoke sign " + sign + " 原文： " + info.toString());
            }
        } else {
            ModuleToast.show(getContext(), R.string.cert_creation_signFail);
        }

        revokeRequest.setCardType("" + CryptoDevTypeUtil.convertCardType(cardType.getType()));
        return revokeRequest;

    }

    private PinDialog pinDialog = null;

    /**
     * 显示输入pin码对话框
     */
    private void showPinDialog() {
        pinDialog = new PinDialog(getContext(), cardType);
        pinDialog.show();

    }


    private void hideSoft() {
        InputMethodManager imm = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
        if (imm != null) {
            imm.hideSoftInputFromWindow(getWindow().getDecorView().getWindowToken(), 0);
        }
    }


    @Override
    protected int getTitleRes() {
        return R.string.cert_creation_revoke_cert;
    }

    private TextWatcher textWatcher = new TextWatcher() {
        private CharSequence temp;
        private int selectionStart;
        private int selectionEnd;

        @Override
        public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

        }

        @Override
        public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            temp = charSequence;
            String editable = reasonET.getText().toString();
            String str = EditTextUtil.stringFilter(editable);
            if (!editable.equals(str)) {
                ModuleToast.show(ReasonActivity.this, R.string.cert_creation_reason_text_correct);
                reasonET.setText(str);
                reasonET.setSelection(str.length());
            }

        }

        @Override
        public void afterTextChanged(Editable editable) {
            selectionStart = reasonET.getSelectionStart();
            selectionEnd = reasonET.getSelectionEnd();

            if (temp.length() > 40) {
                ModuleToast.show(ReasonActivity.this, R.string.cert_creation_reason_text_length);
                editable.delete(selectionStart - 1, selectionEnd);
                int tempSelection = selectionEnd;
                reasonET.setText(editable);
                reasonET.setSelection(tempSelection);
            }
        }
    };


}
