package com.xdja.safeclient.certcreation.activity;

import android.Manifest;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.hardware.Camera;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.provider.MediaStore;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;

import com.baidu.idl.face.platform.ui.dialog.SinglePermissionDialog;
import com.squareup.otto.Subscribe;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.bean.response.BaseErrorResponse;
import com.xdja.safeclient.certcreation.bean.response.CommonResponse;
import com.xdja.safeclient.certcreation.bean.result.AuthResult;
import com.xdja.safeclient.certcreation.cache.ImageCache;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.event.FinishActivity;
import com.xdja.safeclient.certcreation.event.SpecificActivity;
import com.xdja.safeclient.certcreation.util.ApplyCertUtil;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import com.xdja.safeclient.certcreation.util.SharePreferencesUtil;

import java.io.File;
import java.io.FileInputStream;

import cn.cloudwalk.libproject.util.CameraUtil;
import ocr.activity.AuthenticationFailActivity;
import ocr.activity.IDReadyActivity;

import static com.xdja.safeclient.certcreation.activity.ActivityParam.CARD_NUM;
import static com.xdja.safeclient.certcreation.activity.ActivityParam.CARD_TYPE;
import static com.xdja.safeclient.certcreation.activity.ActivityParam.CONTAINER_NUM;
import static com.xdja.safeclient.certcreation.activity.ActivityParam.PHONE;
import static com.xdja.safeclient.certcreation.activity.ActivityParam.PHOTO_TYPE;


/**
 * 手持拍照提示页
 * 自拍照片确认页
 * Created by Administrator on 2018/5/31 0031.
 */
public class SelfieActivity extends BaseActivity {

    Button confirm;

    Button retake;

    ImageView selfie;

    public String cardNum;

    public CryptoDevType cardType;

    public String phone;

    public int containerNum = -1;

    private int photoType = -1;

    public static final int TYPE_SELFIE = 0;

    public static final int TYPE_ID_IMG = 1;

    /**
     * 布局初始化
     */
    private boolean init = false;


    SinglePermissionDialog dialog;

    Bitmap bitmap = null;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);


        if (TextUtils.isEmpty(cardNum)) {

            cardNum = DeviceWrapper.getInstance().getCardID(cardType);

            if (TextUtils.isEmpty(cardNum)) {
                ModuleToast.show(this, R.string.cert_creation_card_device_error);
                finish();
                return;
            }
        }

        photoType = SharePreferencesUtil.getSelfieStep(this);

        requestCameraPermission();

        if (containerNum == -1) {
            containerNum = SharePreferencesUtil.getContainerNum(this, cardNum);
        }

    }

    @Override
    protected void getIntentData() {
        super.getIntentData();
        photoType = getIntent().getIntExtra(PHOTO_TYPE, 0);
        cardNum = getIntent().getStringExtra(CARD_NUM);
        cardType = (CryptoDevType) getIntent().getSerializableExtra(CARD_TYPE);
        phone = getIntent().getStringExtra(PHONE);
        containerNum = getIntent().getIntExtra(CONTAINER_NUM, 0);
    }

    @Override
    protected void onResume() {
        super.onResume();
        if (photoType == TYPE_SELFIE) {
            setTitleRes(R.string.cert_creation_selfie_photo_ready_title);
        } else {
            setTitleRes(R.string.cert_creation_selfie_photo_title);
        }

        if (bitmap != null) {
            setTitleRes(R.string.cert_creation_photo_confirm);
        }
    }

    @Override
    protected void onPause() {
        super.onPause();
        left_title_tv.setText("");
    }

    private void initView() {

        hideBG();

        initPhoto();

        setLeftBtnListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                onBack();
            }
        });

    }

    private void initPhoto() {
        setTitleRes(R.string.cert_creation_photo_confirm);
        selfie = (ImageView) findViewById(R.id.selfie);
        confirm = (Button) findViewById(R.id.confirm);
        confirm.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                next();
            }
        });
        retake = (Button) findViewById(R.id.retake);
        retake.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                requestCameraPermission();
            }
        });

    }


    private void showPhoto() {
        overridePendingTransition(R.anim.left_in, R.anim.left_out);

        try {

            Uri uri = photoType == TYPE_SELFIE ? ImageCache.getSelfieURI() : ImageCache.getIDImageURI();
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {

//                                //获取ParcelFileDescriptor对象，"rw"代表可读写，"r"代表只读
//                                ParcelFileDescriptor pfd = getContentResolver().openFileDescriptor(uri, "rw");
//                                //获取FileDescriptor对象
//                                if (pfd != null) {
//                                    FileDescriptor fd = pfd.getFileDescriptor();
//                                    //获取文件输入输出流，这样我们就可操作共享文件了
//                                    FileInputStream fis = new FileInputStream(fd);
//
//                                    fis.available();
////                                    bitmap = BitmapFactory.decodeStream(fis);
//
//                                }


                String photoName;
                if (photoType == TYPE_SELFIE) {
                    photoName = "img.jpg";
                } else {
                    photoName = "id.jpg";
                }
                File file = new File(this.getExternalCacheDir(), photoName);
                bitmap = ImageCache.compressFile(file);

            } else {
                FileInputStream fis = new FileInputStream(uri.getPath());
                bitmap = BitmapFactory.decodeStream(fis);
            }

            if (bitmap != null) {
                if (photoType == TYPE_SELFIE) {
                    ImageCache.compressSelfie(TYPE_SELFIE, bitmap);
                } else {
                    ImageCache.compressIDImage(TYPE_ID_IMG, bitmap);
                }
            }

            selfie.setImageBitmap(bitmap);
        } catch (Exception e) {
            e.printStackTrace();
        }


    }

    public static final int PERMISSION_CODE = 23;

    /**
     * 申请相机权限
     */
 /*   @XdjaPermission(permissions = {
            Manifest.permission.CAMERA,
            Manifest.permission.WRITE_EXTERNAL_STORAGE,
    })*/

    /**
     * 切面获取权限，在融合版中不能使用
     */
    public void requestCameraPermission() {
        //android版本低于23时，不进行权限检测，执行当前方法 gyx 2018.8.29
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.M) {
            takePhotoFromSystem();
        }  else {
            ActivityCompat.requestPermissions(this,
                    new String[]{Manifest.permission.WRITE_EXTERNAL_STORAGE,
                            Manifest.permission.CAMERA,
                    },
                    PERMISSION_CODE);
        }

    }


    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        //必须全部授权
        boolean isGrant = false;
        for (int grantResult : grantResults) {
            if (grantResult != 0) {
                isGrant = false;
                break;
            } else {
                isGrant = true;
            }
        }

        if (isGrant) {
            takePhotoFromSystem();
        } else {
            showNoPermissionDialog();
        }

    }


    /**
     * 利用系统自带的相机应用:拍照
     */
    private void takePhotoFromSystem() {
        if (!CameraUtil.isHasCamera(Camera.CameraInfo.CAMERA_FACING_FRONT)) {
//            提示没有前置摄像头
            ModuleToast.show(this, R.string.cert_creation_no_face_camera);
            return;
        }
        Intent intent = new Intent(MediaStore.ACTION_IMAGE_CAPTURE);
        intent.putExtra("android.intent.extras.CAMERA_FACING", 1);
        // 此处这句intent的值设置关系到后面的onActivityResult中会进入那个分支，即关系到data是否为null
        // 如果此处指定，则后来的data为null
        // 只有指定路径才能获取原图
        intent.putExtra(MediaStore.EXTRA_OUTPUT, photoType == TYPE_SELFIE ? ImageCache.getSelfieURI() : ImageCache.getIDImageURI());

        startActivityForResult(intent, ImageCache.PHOTO_REQUEST_TAKEPHOTO);
        overridePendingTransition(R.anim.left_in, R.anim.left_out);

    }


    /**
     * 展示权限申请对话框
     */
    public void showNoPermissionDialog() {
        if (dialog == null) {
            initNoPermissionDialog();
        }
        dialog.show();
    }

    /**
     * 初始话权限禁用对话框+
     */
    private void initNoPermissionDialog() {

        dialog = new SinglePermissionDialog();
        dialog.build(this, SinglePermissionDialog.PERMISSION_STORAGE_TAKE_PHOTO);
    }


    @Override
    public void route() {
        super.route();

        if (photoType == TYPE_SELFIE) {

            SharePreferencesUtil.saveSelfieStep(this, TYPE_ID_IMG);

            SharePreferencesUtil.saveContainerNum(this, cardNum, containerNum);

                Intent intent = new Intent(this, IDReadyActivity.class);
                intent.putExtra(PHOTO_TYPE, TYPE_ID_IMG);
                intent.putExtra(CARD_NUM, cardNum);
                intent.putExtra(CARD_TYPE, cardType);
                intent.putExtra(PHONE, phone);
                startActivity(intent);

        } else if (photoType == TYPE_ID_IMG) {
            // 如果当前界面是身份证，那接下来进行实体认证
            start();
        }

    }


    @Override
    public String nextActivity() {
        return ActivityPath.ACTIVITY_CAMERA_ID_READY;
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);

        // 如果一开始就初始化布局，相机完全启动前会显示空白的没有照片的界面，因此在此延迟初始化界面
        if (!init) {
            setContentView(R.layout.selfie_photo);
            initView();
            init = true;
        }

        if (resultCode == RESULT_CANCELED) {
            //用户取消拍照

            // bitmap为空意味着从未拍照，所以直接退出该界面
            // 如果bitmap不为空，意思是重新拍照，所以拍照取消后依然停留在该界面
            if (bitmap == null) {
                overridePendingTransition(R.anim.right_in, R.anim.right_out);
                finish();
            }
        } else if (resultCode == RESULT_OK) {
            showPhoto();
        }
    }


    @Override
    protected int getTitleRes() {
        return R.string.cert_creation_selfie_photo_title;
    }


    @Override
    protected boolean isOCRActivity() {
        return true;
    }


    @Override
    public void onBackPressed() {
        onBack();
    }

    private void onBack() {
        overridePendingTransition(R.anim.right_in, R.anim.right_out);
        if (photoType == TYPE_ID_IMG) {
            OttoUtil.post(new SpecificActivity(SelfieActivity.class));
        }
        finish();
    }

    @Subscribe
    public void handleSpecificActivity(SpecificActivity activity) {
        if (getClass().getName().equals(activity.getTag())) {
            finish();
        }
    }

    /**
     * 实体认证
     */
    private void start() {

        if (containerNum == -1) {
            containerNum = SharePreferencesUtil.getContainerNum(this, cardNum);
        }

        ApplyCertUtil.start(SelfieActivity.this, containerNum, new ApplyCertUtil.WhatHappen() {
            @Override
            public void showDialog() {
                SelfieActivity.this.showLoading();
            }

            @Override
            public void cancelDialog() {
                SelfieActivity.this.dismissLoading();
            }

            @Override
            public void IOError() {
                SelfieActivity.this.dismissLoading();
                showRequestError();
            }

            @Override
            public void handleResult(CommonResponse response) {
                ApplyCertUtil.handleSuccessResult(SelfieActivity.this, response);
            }

            @Override
            public void handleError(BaseErrorResponse baseErrorResponse) {
                SelfieActivity.this.handleError(baseErrorResponse);
            }
        });

    }

    private void handleError(BaseErrorResponse baseErrorResponse) {


        AuthResult result = ApplyCertUtil.buildAuthResult(cardType, containerNum,
                cardNum, null, baseErrorResponse);

            Intent intent = new Intent(this, AuthenticationFailActivity.class);
            intent.putExtra(CONTAINER_NUM, containerNum);
            intent.putExtra("result", result.getResult());
            intent.putExtra("photoType", cardType);
            startActivity(intent);


    }

    @Subscribe
    public void handleFinishActivity(FinishActivity event) {
        finish();
    }


}
