package com.xdja.safeclient.certcreation.activity;

import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Looper;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.RadioGroup;

import com.aircert.util.CommonUtil;
import com.aircert.util.ModuleLog;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.HttpResponseCallBack;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.bean.CertDetailInfo;
import com.xdja.safeclient.certcreation.bean.CertState;
import com.xdja.safeclient.certcreation.bean.ChipBean;
import com.xdja.safeclient.certcreation.bean.OkNetError;
import com.xdja.safeclient.certcreation.bean.UpdateEventCode;
import com.xdja.safeclient.certcreation.bean.request.CertInfoUpdateRequest;
import com.xdja.safeclient.certcreation.bean.request.UpdateCertPwd;
import com.xdja.safeclient.certcreation.bean.request.UpdateCertPwdReq;
import com.xdja.safeclient.certcreation.bean.request.UpdateInfo;
import com.xdja.safeclient.certcreation.bean.response.BaseErrorResponse;
import com.xdja.safeclient.certcreation.bean.response.CertApplyRAStatusResponse;
import com.xdja.safeclient.certcreation.bean.response.CommonResponse;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.device.PKCS10Utils;
import com.xdja.safeclient.certcreation.dialog.DeleteCertDialog;
import com.xdja.safeclient.certcreation.event.UpdateEvent;
import com.xdja.safeclient.certcreation.util.CryptoDevTypeUtil;
import com.xdja.safeclient.certcreation.util.EditTextUtil;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import com.xdja.safeclient.certcreation.util.ThreadUtil;
import com.xdja.safeclient.certcreation.view.NoDoubleClickListener;

import java.io.IOException;

import okhttp3.Call;

/**
 * 证书更新选择项界面
 * Created by jff on 2018/10/30.
 */
public class UpdateCertActivity extends BaseActivity {
    private RadioGroup updateRadioGroup;
    private EditText updateReasonText;

    public ChipBean chipBean;

    private int containerNum;

    private CertDetailInfo certDetailInfo;

    private CryptoDevType chipBeanType;

    public String cardNum;

    @Override
    protected void getIntentData() {
        super.getIntentData();

        cardNum = getIntent().getStringExtra("cardNum");
        chipBean = (ChipBean) getIntent().getSerializableExtra("chipBean");
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_update_cert);

        init();

        certDetailInfo = chipBean.getCertBean();

        chipBeanType = CryptoDevTypeUtil.formatType(chipBean.getType());
        containerNum = AppConfig.getInstance().getCertConfig().getContainerNum(chipBeanType);
    }

    @Override
    protected int getTitleRes() {
        return R.string.cert_creation_updateCert_title;
    }

    private void init() {
        updateRadioGroup = (RadioGroup) findViewById(R.id.update_choose);
        updateReasonText = (EditText) findViewById(R.id.update_reason_text);
        updateReasonText.setFilters(EditTextUtil.getDisableEmojFilter());
        updateReasonText.addTextChangedListener(textWatcher);

        Button updateSubmitBtn = (Button) findViewById(R.id.update_submit_btn);
        updateSubmitBtn.setOnClickListener(new NoDoubleClickListener() {

            @Override
            public void onNoDoubleClick(View v) {
                int updateChoose = updateRadioGroup.getCheckedRadioButtonId();
                UpdateEvent updateEvent = new UpdateEvent();

                if (TextUtils.isEmpty(updateReasonText.getText().toString())) {
                    ModuleToast.show(getContext(), R.string.cert_creation_update_reason_input);
                    return;
                }

                if (updateChoose == R.id.delayRadio) {
                    updateEvent.setUpdateType(UpdateEventCode.DELAY_CERT.getType());
                    updateEvent.setReasonStr(updateReasonText.getText().toString());
                    reasonIsTemp(updateEvent);
                    ModuleLog.e("延期更新");
                }

                if (updateChoose == R.id.updateUserInfoRadio) {
                    updateEvent.setUpdateType(UpdateEventCode.USERINFO_UPDATE.getType());
                    updateEvent.setReasonStr(updateReasonText.getText().toString());
                    reasonIsTemp(updateEvent);
                    ModuleLog.e("用户信息更新");
                }

                if (updateChoose == R.id.updateCertPwdRadio) {
                    deleteCertBeforeUpdate();
                }
            }
        });
    }


    private void deleteCertBeforeUpdate() {

        DeleteCertDialog dialog = new DeleteCertDialog();
        dialog.setListener(new DeleteCertDialog.OnClickListener() {
            @Override
            public void onPositive() {

                showLoading(R.string.cc_delete_cert);
                ClearContainerTask task = new ClearContainerTask();
                task.execute();

            }
        });
        dialog.build(getContext());
        dialog.show();

    }

    private void updateKeyPair() {

        UpdateEvent updateEvent = new UpdateEvent();
        updateEvent.setUpdateType(UpdateEventCode.UPDATE_PWD.getType());
        updateEvent.setReasonStr(updateReasonText.getText().toString());
        reasonIsTemp(updateEvent);

    }


    private class ClearContainerTask extends AsyncTask {

        int result;

        public ClearContainerTask() {

        }

        @Override
        protected void onPreExecute() {
            super.onPreExecute();
            initUpdatePairRequest(updateReasonText.getText().toString());
        }

        @Override
        protected Object doInBackground(Object[] objects) {

            result = DeviceWrapper.getInstance().clearContainer(chipBeanType, containerNum);
            return result;
        }

        @Override
        protected void onPostExecute(Object o) {
            super.onPostExecute(o);

            if (result == 0) {
                updateKeyPair();

            } else {
                ModuleToast.show(getContext(), "删除失败" + result);
                dismissLoading();
            }
        }
    }

    private void update(UpdateEvent updateEvent) {

        showLoading(R.string.cert_creation_is_update_cert);

        CertInfoUpdateRequest certInfoUpdateRequest;
        int type = updateEvent.getUpdateType();

        String updateType = String.valueOf(type);
        String reason = updateEvent.getReasonStr();

        ModuleLog.e("更新证书，当前线程：" + ThreadUtil.Companion.isMainThread());

        if (type == UpdateEventCode.USERINFO_UPDATE.getType()) {
            certInfoUpdateRequest = getCertInfoUpdateRequest(updateType, reason);
            updateUserInfoOrDelay(certInfoUpdateRequest);
        }
        if (type == UpdateEventCode.DELAY_CERT.getType()) {
            certInfoUpdateRequest = getCertInfoUpdateRequest(updateType, reason);
            updateUserInfoOrDelay(certInfoUpdateRequest);
        }
        if (type == UpdateEventCode.UPDATE_PWD.getType()) {
            updateCertPwd(reason);
        }

    }


    /**
     * 更新证书使用者信息
     * 更新证书有效期
     *
     * @param certUpdateRequest 证书更新请求参数
     */
    private void updateUserInfoOrDelay(CertInfoUpdateRequest certUpdateRequest) {

        ModuleLog.e("更新用户信息 " + certUpdateRequest.toString());
        if(cardNum == null){
            ModuleToast.show(getContext(), "更新失败，请退出应用后重试");
            dismissLoading();
            return;
        }
        service.updateOrDelayCert(certUpdateRequest, cardNum, new HttpResponseCallBack<CommonResponse>() {
            @Override
            public void onOtherException(Exception e) {

            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                //网络异常，请重试
                int netRes;
                if (!CommonUtil.isNetworkConnected(getContext())) {
                    netRes = R.string.net_disconnected_text;
                } else {
                    netRes = R.string.net_timeout;

                }
                ModuleLog.e("onIoExceptionFailure " + e.getMessage());
                showException(getResources().getString(netRes));
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                String result = commonResponse.getResult();
                ModuleLog.e("更新用户信息 result = " + result);

                switch (result){
                    case "0":
                        //服务端正在审核
                        ModuleLog.d("更新用户信息/有效期，服务端审核中");
                        OttoUtil.postCertUpdateResult(R.string.cert_creation_update_ing, containerNum, chipBeanType);

                        chipBean.setState(CertState.WAITING_VERIFY);

                        OttoUtil.postCertOperate(containerNum, chipBean);

                        OttoUtil.postFinishSpecificActivity(CertDetailInfoActivity.class.getName());
                        finish();
                        break;
                    case "1":
                        ModuleLog.d("更新用户信息/有效期，成功");
                        String certStr = commonResponse.getMessage();//签名证书#交换证书
                        //需要将状态otto到详情页
                        ModuleToast.show(getContext(), "证书更新成功");

                        OttoUtil.postFinishSpecificActivity(CertDetailInfoActivity.class.getName());

                        OttoUtil.postWritUpdateCert(chipBeanType, containerNum, certStr, false);
                        finish();
                        break;
                    case "2":
                        ModuleLog.d("更新用户信息/有效期，拒绝");
                        String msg = commonResponse.getMessage();//拒绝理由
                        //需要将状态otto到详情页
                        ModuleToast.show(getContext(), msg);
                        //写卡成功更新状态
                        OttoUtil.postCertUpdateResult(R.string.cert_creation_cert_update_ra_reject, containerNum, chipBeanType);
                        finish();
                        break;
                    case "45":
                        //ra审核中
                        ModuleLog.d("更新用户信息/有效期，RA审核中");
                        OttoUtil.postFinishSpecificActivity(CertDetailInfoActivity.class.getName());

                        OttoUtil.postCertUpdateResult(R.string.cert_creation_cert_update_ra_wait, containerNum, chipBeanType);
                        finish();
                        break;
                }
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                String errorCode = baseErrorResponse.getErrCode();
                ModuleLog.e("405 UpdateCertActivity onFailResponse : ");
                handleErrorResponse(errorCode);
            }

            @Override
            public void dismissDialog() {

            }
        });
    }

    UpdateCertPwd updateCertPwd = new UpdateCertPwd();

    UpdateCertPwdReq updateCertPwdReq = new UpdateCertPwdReq();

    private void initUpdatePairRequest(String reason) {
        //更新公私钥对
        updateCertPwd.setSn(certDetailInfo.getSn());
        updateCertPwd.setTime(System.currentTimeMillis());
        updateCertPwd.setReason(reason);
        //如果是更新公私钥对，那么需要在删除公私钥对之前进行签名，否则服务端验签不过
        String sign = DeviceWrapper.getInstance().signData(chipBeanType, containerNum, updateCertPwd.toString());

        String p10 = PKCS10Utils.getInstance(chipBeanType, containerNum).getP10RequestBC(chipBeanType, containerNum, certDetailInfo.getSubjectCn(), false);
        updateCertPwdReq.setInfo(updateCertPwd);
        updateCertPwdReq.setP10(p10);
        updateCertPwdReq.setSign(sign);
        updateCertPwdReq.setCardType(chipBeanType.getType());
    }

    public boolean isMainThread() {
        return Looper.getMainLooper().getThread() == Thread.currentThread();
    }

    /**
     * 更新证书密钥对
     *
     * @param reason
     */
    private void updateCertPwd(String reason) {
        //此处重新生成P10是因为在更新密钥的时候需要重新生成公私钥对，卡内的公私钥对已经删除
        String p10 = PKCS10Utils.getInstance(chipBeanType, containerNum).getP10RequestBC(chipBeanType, containerNum, certDetailInfo.getSubjectCn(), true);
        updateCertPwdReq.setP10(p10);

        ModuleLog.e("更新密钥对 " + updateCertPwdReq.toString());
        ModuleLog.e("当前线程" + isMainThread());
        showLoading(R.string.cert_creation_is_update_cert);

        service.updateCertPwd(updateCertPwdReq, cardNum, new HttpResponseCallBack<CertApplyRAStatusResponse>() {

            @Override
            public void onOtherException(Exception e) {

            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                //网络异常，请重试
                int netRes;
                if (!CommonUtil.isNetworkConnected(getContext())) {
                    netRes = R.string.net_disconnected_text;
                } else {
                    netRes = R.string.net_timeout;
                }
                //                            ModuleLog.e("onIoExceptionFailure " + e.getMessage());
                showException(getResources().getString(netRes));
            }

            @Override
            public void onSuccessfulResponse(Call call, CertApplyRAStatusResponse certApplyResponse) {
                String result = certApplyResponse.getResult();
                if (result.equals("0")) {//密钥更新审核中
                    //写卡成功更新状态
                    ModuleLog.d("更新密钥对，服务端审核中");
                    OttoUtil.postUpdateKeyPairEvent(chipBeanType, containerNum, R.string.cert_creation_update_ing);
                } else if (result.equals("1")) {//密钥更新成功
                    //写卡成功更新状态
                    // TODO: 2020/3/28 jff
                    String certStr = certApplyResponse.getMessage();
                    ModuleLog.d("更新密钥对，成功");
                    OttoUtil.postWritUpdateCert(chipBeanType, containerNum, certStr, true);

                } else if (result.equals("2")) {//密钥更新拒绝
                    // 服务端更新审核拒绝的情况下，接下来理应调用查询接口
                    // 如果这时候误重新调用更新接口的话，会出现此情况
                    //写卡成功更新状态
                    ModuleLog.d("密钥更新，被拒绝");
                    OttoUtil.postCertUpdateResult(R.string.cert_creation_cert_update_ra_reject, containerNum, chipBeanType);
                } else if (result.equals("45")) {//ra审核中
                    //写卡成功更新状态
                    ModuleLog.d("密钥更新，RA审核中");
                    //                    OttoUtil.postCertUpdateResult(R.string.cert_creation_update_ing);

                    OttoUtil.postUpdateKeyPairEvent(chipBeanType, containerNum, R.string.cc_cert_pass_ra_wait);

                }
                OttoUtil.postFinishSpecificActivity(CertDetailInfoActivity.class.getName());
                finish();
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                String errorCode = baseErrorResponse.getErrCode();
                //需要将状态otto到详情页
                handleErrorResponse(errorCode);
            }

            @Override
            public void dismissDialog() {
                dismissLoading();
            }
        });

    }

    private void showException(final String message) {
        ModuleToast.show(this, message);
    }

    /**
     * 处理服务器返回的错误码
     *
     * @param errorCode
     */
    private void handleErrorResponse(String errorCode) {
        String msg = OkNetError.handleErrorCodeToMsg(this, errorCode);
        showException(msg);
        Log.e("jff", "533 UpdateCertActivity handleErrorResponse : ");
        OttoUtil.postRefreshListEvent();
        finish();
    }

    private CertInfoUpdateRequest getCertInfoUpdateRequest(String type, String reason) {

        UpdateInfo updateInfo = new UpdateInfo();
        updateInfo.setSn(certDetailInfo.getSn());
        updateInfo.setTime(System.currentTimeMillis());
        updateInfo.setType(type);//1 证书信息更新   3延期申请
        updateInfo.setReason(reason);
        String p10 = PKCS10Utils.getInstance(chipBeanType, containerNum).getP10RequestBC(chipBeanType, containerNum, certDetailInfo.getSubjectCn(), false);
        updateInfo.setP10(p10);

        String sign = DeviceWrapper.getInstance().signData(chipBeanType, containerNum, updateInfo.toString());
        final CertInfoUpdateRequest certUpdateRequest = new CertInfoUpdateRequest();
        certUpdateRequest.setSign(sign);
        certUpdateRequest.setInfo(updateInfo);
        certUpdateRequest.setCardType(chipBeanType.getType());
        return certUpdateRequest;
    }

    public void reasonIsTemp(UpdateEvent updateEvent) {
        update(updateEvent);
    }


    private TextWatcher textWatcher = new TextWatcher() {
        private CharSequence temp;
        private int selectionStart;
        private int selectionEnd;

        @Override
        public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

        }

        @Override
        public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            temp = charSequence;
            String editable = updateReasonText.getText().toString();
            String str = EditTextUtil.stringFilter(editable);
            if (!editable.equals(str)) {
                ModuleToast.show(UpdateCertActivity.this, R.string.cert_creation_reason_text_correct);
                updateReasonText.setText(str);
                updateReasonText.setSelection(str.length());
            }

        }

        @Override
        public void afterTextChanged(Editable editable) {
            selectionStart = updateReasonText.getSelectionStart();
            selectionEnd = updateReasonText.getSelectionEnd();

            if (temp.length() > 40) {
                ModuleToast.show(UpdateCertActivity.this, R.string.cert_creation_reason_text_length);
                editable.delete(selectionStart - 1, selectionEnd);
                int tempSelection = selectionEnd;
                updateReasonText.setText(editable);
                updateReasonText.setSelection(tempSelection);
            }
        }
    };


}
