package com.xdja.safeclient.certcreation.adapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import com.aircert.util.ModuleLog;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.bean.CertDetailInfo;
import com.xdja.safeclient.certcreation.bean.CertItemBean;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import static android.view.View.GONE;
import static android.view.View.VISIBLE;

/**
 * Created by Administrator on 2020/4/20 0020.
 */

public class EmbeddedCertAdapter extends RecyclerView.Adapter<EmbeddedCertAdapter.ViewHolder> {

    private Context context;

    private List<CertItemBean> certItemBeans = new ArrayList<>();

    private HashMap<String, Integer> cards = new HashMap<>();

    public EmbeddedCertAdapter(Context context, List<CertItemBean> certItemBeans) {
        this.context = context;
        this.certItemBeans = certItemBeans;
    }

    @Override
    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(context).inflate(R.layout.cert_list_layout_embedded, null);
        ViewHolder hold = new ViewHolder(view);
        return hold;
    }

    @Override
    public void onBindViewHolder(ViewHolder holder, int position) {

        if (certItemBeans == null) {
            return;
        }

        if (certItemBeans.size() == 0) {
            return;
        }

        CertItemBean certItemBean = certItemBeans.get(position);

        CertDetailInfo info =
                DeviceWrapper.getInstance().readCertFromContainer(certItemBean.getCryptoDevInfo()
                                .getType(),
                        certItemBean.getCertConfig().getContainerNum(),
                        certItemBean.getCertConfig().getCertType());

        String cardType = certItemBeans.get(position).getCertConfig().getCardType();

        int current = certItemBeans.get(position).getCertConfig().getContainerNum();

        boolean isFirst;

        // 如果获取为空，代表这是这个卡设备中第一个容器
        if (cards.get(cardType) == null) {
            isFirst = true;
            cards.put(cardType, current);
        } else {
            // 同一张卡有多个容器，如果容器号不是最小的容器号，就隐藏设备类型
            int min = cards.get(cardType);
            isFirst = current == min;

            if (current < min) {
                cards.put(cardType, current);
            }

        }

        if (isFirst) {
            holder.item.setVisibility(VISIBLE);
        } else {
            holder.item.setVisibility(GONE);
        }

        CryptoDevType chipBeanType = certItemBean.getCryptoDevInfo().getType();

        if (chipBeanType == CryptoDevType.DEV_TYPE_SdCard) {
            holder.name.setText(R.string.cert_creation_tf_cert);
            holder.icon.setBackgroundResource(R.drawable.tf_card);
        } else if (chipBeanType == CryptoDevType.DEV_TYPE_Chip) {
            holder.name.setText(R.string.cert_creation_chip_cert);
            holder.icon.setBackgroundResource(R.drawable.chip);
        } else if (chipBeanType == CryptoDevType.DEV_TYPE_SimKey) {
            holder.name.setText(R.string.cert_creation_tiemo_cert);
            holder.icon.setBackgroundResource(R.drawable.sim_card);
        } else if (chipBeanType == CryptoDevType.DEV_TYPE_Soft) {
            holder.name.setText(R.string.cert_creation_soft_cert);
            holder.icon.setBackgroundResource(R.drawable.vhsm);
        }

        holder.cardNo.setText(certItemBean.getCryptoDevInfo().getCardId());

        holder.tvContainerNum.setText(context.getString(R.string.cert_creation_config_container_num)
                + "："
                + String.valueOf(certItemBean.getCertConfig().getContainerNum()));

        holder.tvCertType.setText(certItemBean.getCertConfig().getCertType());

        if (info == null) {
            holder.normalLayout.setVisibility(GONE);
            holder.noCertLayout.setVisibility(VISIBLE);
            return;
        } else {
            holder.normalLayout.setVisibility(VISIBLE);
            holder.noCertLayout.setVisibility(GONE);
        }

        ModuleLog.e(info);

        holder.tvSN.setText(info.getSn());

        holder.tvUser.setText(getCertHolder(info.getSubjectCn()));

        holder.tvPeroid.setText(info.getIndate());


    }

    @Override
    public int getItemCount() {
        return certItemBeans == null ? 0 : certItemBeans.size();
    }

    public static class ViewHolder extends RecyclerView.ViewHolder {

        View noCertLayout;

        View normalLayout;

        View stateLayout;

        View item;

        TextView name;

        ImageView icon;

        TextView cardNo;

        TextView tvContainerNum;

        TextView tvCertState;
        TextView tvCertType;
        TextView tvSN;
        TextView tvUser;
        TextView tvPeroid;

        public ViewHolder(View itemView) {
            super(itemView);

            noCertLayout = itemView.findViewById(R.id.layout_no_cert);

            normalLayout = itemView.findViewById(R.id.layout_normal);

            stateLayout = itemView.findViewById(R.id.layout_container_num);

            item = itemView.findViewById(R.id.item);

            name = itemView.findViewById(R.id.name);

            icon = itemView.findViewById(R.id.icon);

            cardNo = (TextView) itemView.findViewById(R.id.card_num);

            tvContainerNum = itemView.findViewById(R.id.tv_container_num);

            tvCertState = (TextView) itemView.findViewById(R.id.tv_cert_state);
            tvCertType = itemView.findViewById(R.id.tv_cert_type);
            tvSN = (TextView) itemView.findViewById(R.id.tv_sn);
            tvUser = (TextView) itemView.findViewById(R.id.tv_user);
            tvPeroid = (TextView) itemView.findViewById(R.id.tv_peroid);
        }

    }

    public void addAll(List<CertItemBean> certItemBeans) {
        if (certItemBeans == null || certItemBeans.size() == 0) {
            return;
        }
        this.certItemBeans.clear();
        this.certItemBeans.addAll(certItemBeans);
        notifyDataSetChanged();
    }

    private String getCertHolder(String sn) {
        String[] split = sn.split(",");
        for (int i = 0; i < split.length; i++) {
            String cnStr = split[i];

            if (cnStr.contains("CN=")) {
                int beginIndex = 3;
                int length = cnStr.length();
                //int endIndex = length < 20 ? length : 20;
                return split[i].substring(beginIndex, length);
            }
        }
        return "";
    }

}
