package com.xdja.safeclient.certcreation.adapter;

import android.content.Context;
import android.content.Intent;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.aircert.util.ModuleLog;
import com.xdja.safeclient.certcreation.BuildConfig;
import com.xdja.safeclient.certcreation.FeatureConfig;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.ActivityParam;
import com.xdja.safeclient.certcreation.activity.BaseActivity;
import com.xdja.safeclient.certcreation.activity.CertDetailInfoActivity;
import com.xdja.safeclient.certcreation.bean.CertItemBean;
import com.xdja.safeclient.certcreation.view.CertItemView;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * Created by yangpeng on 2018/4/24.
 */

public class RecyclerViewAdapter extends RecyclerView.Adapter<RecyclerViewAdapter.ViewHold> implements Unregister, View.OnClickListener {
    private Context context;
    private List<CertItemBean> certItemBeans = new ArrayList<>();
    private ViewHold hold;

    private String object;

    private boolean isRefresh = true; //返回证书列表页，是否需要刷新

    public RecyclerViewAdapter(Context context, String object) {
        this.context = context;
        this.object = object;
    }


    @Override
    public ViewHold onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(context).inflate(R.layout.cert_list_layout, null);
        hold = new ViewHold(view);
        return hold;
    }

    private HashMap<String, Integer> cards = new HashMap<>();

    @Override
    public void onBindViewHolder(ViewHold holder, int position) {

        String cardType = certItemBeans.get(position).getCertConfig().getCardType();

        int current = certItemBeans.get(position).getCertConfig().getContainerNum();

        boolean isFirst;

        // 如果获取为空，代表这是这个卡设备中第一个容器
        if (cards.get(cardType) == null) {
            isFirst = true;
            cards.put(cardType, current);
        } else {
            // 同一张卡有多个容器，如果容器号不是最小的容器号，就隐藏设备类型
            int min = cards.get(cardType);
            isFirst = current == min;

            if (current < min) {
                cards.put(cardType, current);
            }

        }


        ModuleLog.e("");
        // 是否是同一设备类型中的第一个容器
        holder.certItemView.setData(context, this, certItemBeans.get(position), object, isFirst);

        holder.certItemView.setTag(position);
        holder.certItemView.setOnClickListener(this);


    }


    @Override
    public int getItemCount() {
        return certItemBeans == null ? 0 : certItemBeans.size();
    }


    @Override
    public void destroy() {
        if (hold != null) {
            hold.destroy();
        }
    }

    @Override
    public void onClick(View view) {

        // 如果只展示证书列表的话，不再跳转到下级页面
        if (FeatureConfig.getInstance().isDisableMakeNewCert()) {
            return;
        }

        CertItemView certItemView = (CertItemView) view;
        if (certItemView.isCertOK()) {
            setIsRefresh(false);  //跳转到其他页面，不需要刷新

            if (BuildConfig.isAAR || BaseActivity.DEBUG_AAR) {
                Intent intent = new Intent(context, CertDetailInfoActivity.class);
                intent.putExtra("chipBean", certItemView.getChipBean());
                intent.putExtra(ActivityParam.CONTAINER_NUM, certItemView.getContainerNum());
                intent.putExtra(ActivityParam.CERT_TYPE, certItemView.getCertType());

                intent.putExtra(ActivityParam.ALLOW_APPLY_CERT, certItemView.getAllowApplyCert());
                context.startActivity(intent);

            }

        }

    }

    public static class ViewHold extends RecyclerView.ViewHolder implements Unregister {

        CertItemView certItemView;

        public ViewHold(View itemView) {
            super(itemView);
            certItemView = (CertItemView) itemView.findViewById(R.id.cert_item_view);
        }

        @Override
        public void destroy() {
            certItemView.onDestory();
        }
    }


    public void setIsRefresh(boolean isRefresh) {
        this.isRefresh = isRefresh;
    }

    public boolean getIsRefresh() {
        return isRefresh;
    }

    public void addAll(List<CertItemBean> certItemBeans) {
        if (certItemBeans == null || certItemBeans.size() == 0) {
            return;
        }
        this.certItemBeans.clear();
        this.certItemBeans.addAll(certItemBeans);
        notifyDataSetChanged();
    }


    public void clear() {
        this.certItemBeans.clear();
        cards.clear();
        notifyDataSetChanged();
    }

    public void refresh() {
        cards.clear();
        notifyDataSetChanged();
    }

    public String getFirstCard() {
        return certItemBeans.get(0).getCertConfig().getCardType();
    }

}
