package com.xdja.safeclient.certcreation.adapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;

import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.bean.ServerAddress;
import com.xdja.safeclient.certcreation.util.AddressUtil;
import com.xdja.safeclient.certcreation.util.ModuleToast;

import java.util.HashMap;
import java.util.List;

/**
 * Created by Administrator on 2020/3/4 0004.
 */

public class ServerAddressAdapter extends RecyclerView.Adapter<ServerAddressAdapter.ViewHolder> {

    private Context context;

    private List<ServerAddress> list;

    private boolean unModified = true;

    HashMap<String, ServerAddress> map;

    public ServerAddressAdapter(Context context, List<ServerAddress> list) {
        this.context = context;
        this.list = list;
        map = new HashMap<>();
    }

    @Override
    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return new ServerAddressAdapter.ViewHolder(LayoutInflater.from(context).inflate(R.layout.item_server_address, null));
    }

    @Override
    public void onBindViewHolder(final ViewHolder holder, final int position) {

        ServerAddress address = list.get(position);

        holder.ip.setText(address.getIp());

        if (unModified) {
            holder.topLayout.setBackgroundResource(R.drawable.item_shape_server_address_normal);
        } else {
            if (validIP(address.getIp()) && validPort(address.getPort())) {
                holder.topLayout.setBackgroundResource(R.drawable.item_shape_server_address_normal);
            } else {
                holder.topLayout.setBackgroundResource(R.drawable.item_shape_server_address_error);
            }
        }

        holder.port.setText(address.getPort());

        // TODO: 2020/3/5 0005 禁止进入非法字符

        if (position == 0) {
            holder.deleteServerAddress.setVisibility(View.GONE);
        } else {
            holder.deleteServerAddress.setVisibility(View.VISIBLE);
        }



      /*  holder.ip.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

            }

            @Override
            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                list.set(position, new ServerAddress(charSequence.toString(),
                        list.get(position).getPort()));
            }

            @Override
            public void afterTextChanged(Editable editable) {
                unModified = false;
            }
        });

        holder.port.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

            }

            @Override
            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                list.set(position, new ServerAddress(list.get(position).getIp()
                        , charSequence.toString()));


            }

            @Override
            public void afterTextChanged(Editable editable) {
                unModified = false;
            }
        });*/


    }

    @Override
    public int getItemCount() {
        return list.size();
    }


    class ViewHolder extends RecyclerView.ViewHolder {

        ImageView deleteServerAddress;

        EditText ip;

        EditText port;

        LinearLayout topLayout;

        public ViewHolder(View itemView) {
            super(itemView);

            deleteServerAddress = itemView.findViewById(R.id.delete_server_address);

            ip = itemView.findViewById(R.id.ip);

            port = itemView.findViewById(R.id.port);

            topLayout = itemView.findViewById(R.id.top_layout);

        }
    }

    private boolean validIP(String ip) {

        if (TextUtils.isEmpty(ip)) {
            ModuleToast.show(context, R.string.cert_creation_config_empty_server_address);
            return false;
        }


        boolean success = AddressUtil.validIP(ip);

        if (!success) {
            ModuleToast.show(context, R.string.cert_creation_config_error_server_address);
        }

        return success;

    }

    /**
     * 不可为空，1-65535
     * <p>
     * 错误提示：【服务器端口错误】
     * <p>
     * 为空提示：【请输入服务器端口】
     *
     * @return
     */
    private boolean validPort(String port) {

        if (TextUtils.isEmpty(port)) {
            ModuleToast.show(context, R.string.cert_creation_config_please_input_server_port);
            return false;
        }

        boolean success = AddressUtil.validPort(port);

        if (!success) {
            ModuleToast.show(context, R.string.cert_creation_config_error_server_port);
        }

        return success;

    }

    public List<ServerAddress> getAddressList() {
        return list;
    }


}
