package com.xdja.safeclient.certcreation.bean;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;

public class CertDetailInfo implements Serializable {
    private String subjectCn = "";//拥有者CN
    private String issuerCn = "";//颁发者CN
    private String subjectOrg = "";//拥有者组织
    private String issuerOrg = ""; //颁发者组织
    private String sn = "";      //证书SN
    private String indate = "";    //证书有效期 2013-10-9 / 2013-10-10
    private final int ctnNo = 0;       //容器编号
    private String alg = "";
    private byte[] certId = new byte[2];//证书ID
    private int[] certLen = new int[1];//证书长度
    private int ver = 0;
    private Date notBefore = null;//起始时间
    private Date notAfter = null;//终止时间

    public String getSubjectCn() {
        return subjectCn;
    }

    public void setSubjectCn(String subjectCn) {
        this.subjectCn = subjectCn;
    }

    public String getIssuerCn() {
        return issuerCn;
    }

    public void setIssuerCn(String issuerCn) {
        this.issuerCn = issuerCn;
    }

    public String getSubjectOrg() {
        return subjectOrg;
    }

    public void setSubjectOrg(String subjectOrg) {
        this.subjectOrg = subjectOrg;
    }

    public String getIssuerOrg() {
        return issuerOrg;
    }

    public void setIssuerOrg(String issuerOrg) {
        this.issuerOrg = issuerOrg;
    }

    public String getSn() {
        return sn;
    }

    public void setSn(String sn) {
        this.sn = sn;
    }

    public String getIndate() {
        return indate;
    }

    public void setIndate(String indate) {
        this.indate = indate;
    }

    public int getCtnNo() {
        return ctnNo;
    }

    public String getAlg() {
        return alg;
    }

    public void setAlg(String alg) {
        this.alg = alg;
    }

    public byte[] getCertId() {
        return certId;
    }

    public void setCertId(byte[] certId) {
        this.certId = certId;
    }

    public int[] getCertLen() {
        return certLen;
    }

    public void setCertLen(int[] certLen) {
        this.certLen = certLen;
    }

    public int getVer() {
        return ver;
    }

    public void setVer(int ver) {
        this.ver = ver;
    }

    public void setNotBefore(Date notBefore) {
        this.notBefore = notBefore;
    }

    public void setNotAfter(Date notAfter) {
        this.notAfter = notAfter;
    }

    @Override
    public String toString() {
        return "{" +
                "subjectCn='" + subjectCn + '\'' +
                ",issuerCn='" + issuerCn + '\'' +
                ",subjectOrg='" + subjectOrg + '\'' +
                ",issuerOrg='" + issuerOrg + '\'' +
                ",sn='" + sn + '\'' +
                ",indate='" + indate + '\'' +
                ",notBefore='" + notBefore + '\'' +
                ",notAfter='" + notAfter + '\'' +
                ",ctnNo=" + ctnNo +
                ",alg='" + alg + '\'' +
                ",ver='" + ver + '\'' +
                ",certId=" + Arrays.toString(certId) +
                ",certLen=" + Arrays.toString(certLen) +
                '}';
    }

    public String getNotBefore() {
        SimpleDateFormat formatterValid = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        return formatterValid.format(notBefore);
    }

    public String getNotAfter() {
        SimpleDateFormat formatterValid = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        return formatterValid.format(notAfter);
    }

    public Date getNotBeforeData() {
        return notBefore;
    }

    public Date getNotAfterData() {
        return notAfter;
    }
}
