package com.xdja.safeclient.certcreation.bean;

/**
 * Created by gyx on 2018/9/26.
 */

public enum CertState {
    /**
     * 检查中
     */
    CHECKING,
    /**
     * 无证书
     */
    NO_CERT,
    /**
     * 申请等待审核
     */
    WAITING_VERIFY,
    /**
     * 申请失败
     */
    REGISTER_FAIL,
    /**
     * 下载失败
     */
    GET_FAIL,
    /**
     * 证书状态正常
     */
    SUCCESS,
    /**
     * 撤销申请等待中
     */
    WAITING_AGREE_REVOKE,
    /**
     * 撤销成功
     */
    AGREE_REVOKE,
    /**
     * 撤销被拒绝
     */
    REJECT_REVOKE,
    /**
     * 本地有证书，但服务器没有
     */
    SERVER_NOCERT,
    /**
     * 网络异常
     */
    NET_ERROR,

    /**
     * 网络超时
     */
    NET_TIMEOUT,

    /**
     * 证书更新成功
     */
    AGREE_UPDATE,

    /**
     * 13:更新申请被拒绝
     */
    UPDATE_REJECT_BY_SERVER,

    /**
     * 证书已删除
     */
    DELETE_SUCCESS,
    /**
     * 证书已过期
     */
    CERT_OUT_OF_DATE,
    /**
     * 解冻成功
     */
    RECOVERY_SUCCESS,
    /**
     * 解冻受理中
     */
    RECOVERY_PROGRESS,


    /**
     * 证书状态待确定-15
     */
    CERT_STATE_WAIT_VERIFY,

    /**
     * RA申请审核中-45
     * 查询证书状态结果是RA_APPLY_WAIT_52
     * 调用申请状态查询接口可能返回这个值
     */
    RA_REVOKE_WAIT_45,

    /**
     * 47：RA审核通过，等待签发
     */
    RA_WAIT_FOR_MAKE_47,

    /**
     * 48：RA签发证书失败
     */
    RA_MAKE_CERT_FAIL_48,

    /**
     * 52:RA证书申请审核中
     */
    RA_APPLY_WAIT_52,

    /**
     * 53：RA证书申请审核拒绝
     */
    RA_APPLY_REJECT_53,

    /**
     * 54：RA撤销申请审核中
     */
    RA_REVOKE_WAIT_54,

    /**
     * 55：RA撤销申请拒绝
     */
    RA_REVOKE_REJECT_55,

    /**
     * 56：RA更新审核中
     */
    RA_UPDATE_WAIT_56,

    /**
     * 57：RA更新审核拒绝
     */
    RA_UPDATE_REJECT_57,


}
