package com.xdja.safeclient.certcreation.bean.result;

import android.os.Parcel;

import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.bean.response.CompareResult;

import java.io.Serializable;

/**
 * 实体认证返回的结果，用于发送Otto，之后通知界面更新
 * Created by Administrator on 2018/6/22 0022.
 */

public class AuthResult implements Serializable {

    CryptoDevType type;

    CompareResult result;

    int containerNum;

    String object;

    private AuthResult() {

    }

    public AuthResult(CryptoDevType type, int containerNum, CompareResult result, String object) {
        this.type = type;
        this.result = result;
        this.object = object;
        this.containerNum = containerNum;
    }

    protected AuthResult(Parcel in) {
        type = (CryptoDevType) in.readValue(CryptoDevType.class.getClassLoader());
        result = (CompareResult) in.readValue(CompareResult.class.getClassLoader());
        containerNum = in.readInt();
        object = in.readString();
    }

    public CryptoDevType getType() {
        return type;
    }

    public void setType(CryptoDevType type) {
        this.type = type;
    }

    public CompareResult getResult() {
        return result;
    }

    public void setResult(CompareResult result) {
        this.result = result;
    }

    public String getObject() {
        return object;
    }

    public int getContainerNum() {
        return containerNum;
    }
}
