package com.xdja.safeclient.certcreation.cache;

import com.xdja.cryptodev.CryptoDevType;

import java.util.HashMap;

/**
 * Created by Administrator on 2018/12/11 0011.
 */

public class RequestCache {

    private HashMap<String, String> types = new HashMap();

    private long time;

    private static RequestCache cache;

    public static RequestCache getInstance() {
        if (cache == null) {
            cache = new RequestCache();
        }
        return cache;
    }

    private String object;

    public String getObject() {
        return object;
    }

    public void setObject(String object) {
        this.object = object;
    }

    public void putType(String cardNo, int cardType) {
        types.put(cardNo, formatType(cardType));
    }

    private static String formatType(int type) {

        if (type == CryptoDevType.DEV_TYPE_SdCard.getType()) {
            return "sd卡";
        } else if (type == CryptoDevType.DEV_TYPE_Chip.getType()) {
            return "芯片";
        } else if (type == CryptoDevType.DEV_TYPE_UsbKey.getType()) {
            return "USB Key";
        } else if (type == CryptoDevType.DEV_TYPE_SimKey.getType()) {
            return "贴膜卡";
        } else if (type == CryptoDevType.DEV_TYPE_BlueTooth.getType()) {
            return "蓝牙";
        } else if (type == CryptoDevType.DEV_TYPE_Soft.getType()) {
            return "软证书";
        } else {
            return "位置类型" + type;
        }
    }

    public String getType(String cardNo) {
        String result = types.get(cardNo);
        if (result == null) {
            result = "";
        }
        return result;
    }

    public long getTime() {
        return time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public void resetTime() {
        time = 0;
    }



}
