package com.xdja.safeclient.certcreation.config;

import android.text.TextUtils;
import android.util.Log;

import com.raizlabs.android.dbflow.sql.language.SQLite;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.bean.device.CardType;
import com.xdja.safeclient.certcreation.bean.device.ContainerNum;
import com.xdja.safeclient.certcreation.databases.TableCertConfig;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * Created by Administrator on 2019/9/5 0005.
 */

public class CertConfig {

    HashMap<String, List<TableCertConfig>> all = new HashMap<>();

    private void init() {

        List<TableCertConfig> data = SQLite.select().from(TableCertConfig.class).queryList();

        Log.e("jff", "26 CertConfig init : " + data);
        for (TableCertConfig config : data) {

            String type = config.cardType;

            List<TableCertConfig> list = all.get(type);

            if (list == null) {
                list = new ArrayList<>();
            }

            list.add(config);

            all.put(type, list);
        }
    }

    public CertConfig() {
        init();
    }

    public CertConfig(int m){

    }



    private String transAlgType(String algType) {
        return algType.equals(AlgType.RSA) ? XDJAAlgParams.CA_ALG_RSA : XDJAAlgParams.CA_ALG_SM2;
    }

    /**
     * 获取算法类型
     *
     * @param cardType     卡类型
     * @param containerNum 容器号
     * @return
     */
    public String getAlgType(CryptoDevType cardType, int containerNum) {

        String defaultAlgType = AlgType.getDefaule();

        List<TableCertConfig> list = all.get(CardType.toString(cardType));

        if (list == null) {
            return transAlgType(defaultAlgType);
        }

        for (TableCertConfig config : list) {
            if (containerNum == config.containerNum) {
                return transAlgType(config.algType);
            }
        }

        return transAlgType(defaultAlgType);
    }

    /**
     * 获取证书机制（单双证）
     *
     * @param cardType     卡类型
     * @param containerNum 容器号
     * @return
     */
    public String getCertRule(CryptoDevType cardType, int containerNum) {

        String defaultCertRule = CertRule.getDefault();

        List<TableCertConfig> list = all.get(CardType.toString(cardType));

        if (list == null) {
            return defaultCertRule;
        }

        for (TableCertConfig config : list) {
            if (containerNum == config.containerNum) {
                return config.certRule;
            }
        }

        return defaultCertRule;
    }

    /**
     * 获取证书类型
     *
     * @param cardType     卡类型
     * @param containerNum 容器号
     * @return
     */
    public String getCertType(CryptoDevType cardType, int containerNum) {

        String defaultCertType = CertType.getDefault();

        List<TableCertConfig> list = all.get(CardType.toString(cardType));

        if (list == null) {
            return defaultCertType;
        }

        for (TableCertConfig config : list) {
            if (containerNum == config.containerNum) {
                return config.certType;
            }
        }

        return defaultCertType;
    }


    public int getContainerNum(CryptoDevType cardType){
        int defaultConNum = ContainerNum.getDefault();

        List<TableCertConfig> list = all.get(CardType.toString(cardType));

        if (list == null) {
            return defaultConNum;
        }

        for (TableCertConfig config : list) {
            if (config.cardType.equals(cardType)) {
                return config.containerNum;
            }
        }

        return defaultConNum;
    }


    /**
     * 是否配置了软卡（VHSM）
     *
     * @return
     */
    public boolean hasVHSM() {
        return !TextUtils.isEmpty(getVHSMType());
    }


    public String getVHSMType() {
        List<TableCertConfig> list = all.get(CardType.ONLINE_VHSM);
        if (list != null && list.size() != 0) {
            return CardType.ONLINE_VHSM;
        } else {
            list = all.get(CardType.OFFLINE_VHSM);
            if (list != null && list.size() != 0) {
                return CardType.OFFLINE_VHSM;
            } else {
                return "";
            }
        }
    }


}
