package com.xdja.safeclient.certcreation.databases;

import com.aircert.util.ModuleLog;
import com.raizlabs.android.dbflow.annotation.Column;
import com.raizlabs.android.dbflow.annotation.PrimaryKey;
import com.raizlabs.android.dbflow.annotation.Table;
import com.raizlabs.android.dbflow.structure.BaseModel;
import com.xdja.safeclient.certcreation.bean.ServerAddress;
import com.xdja.safeclient.certcreation.config.IsTrue;

import java.io.Serializable;
import java.util.ArrayList;

/**
 * 数据库配置类<br>
 * 数据库字段默认值是-1，不是0的原因是<br>
 * 空包选择配置时，如果某一个配置项不选择的情况下<br>
 * 点击保存需要可以正常保存，并且下一次进到界面中依然是未选择的状态<br>
 * 如果默认值是0，那么下次进来就会显示选择了第0项，与要求不符<br>
 * Created by jff on 2018/6/22.<br>
 */
@Table(database = CertConfigDataBase.class)
public class ServerSettingConfig extends BaseModel implements Serializable {

    @PrimaryKey(autoincrement = true)
    public long id;

    /**
     * 活体检测
     */
    @Column
    public String liveCompany = "";

    /**
     * OCRCompany
     */
    @Column
    public String ocrCompany = "";

    /**
     * NFCCompany
     */
    @Column
    public String nfcCompany = "";

    /**
     * 服务器地址
     */
    @Column
    public String ip = null;

    /**
     * 服务器端口号
     */
    @Column
    public String port = null;

    private ArrayList<ServerAddress> serverAddressList;

    private ArrayList<ServerAddress> vhsmAddressList;


    @Column
    public boolean enableVHSM;

    /**
     * vhsm_服务器地址
     */
    @Column
    public String vhsm_ip = null;

    /**
     * vhsm_服务器端口地址
     */
    @Column
    public String vhsm_port = null;

    /**
     * NFC服务器地址
     */
    @Column
    public String nfcServerIP = null;

    /**
     * NFC服务器端口号
     */
    @Column
    public String nfcServerPort = null;

    /**
     * 是否使用警务统一ID
     */
    @Column
    public String allowUpdate = "";



    @Column
    public String allowIdentifer = "";

    /**
     * 证书流程
     */
    @Column
    public String procedure;

    @Column
    public String projectName;

//    -- 以下是弃用字段

    /**
     * 容器号
     */
    @Column
    public int containerNum = -1;

    /**
     * 显示证书类型
     */
    @Column
    public String certType = "";

    /**
     * 是否支持证书更新
     */
    @Column
    public String isSupportCertContentUpdate = "";

    /**
     * 证书密钥算法
     */
    @Column
    public String certAlg = "";

    @Column
    public String certRule = "";

    /**
     * 项目名称
     */
    @Column
    public int cityName = -1;

    @Column
    public String certContent;

    @Column
    public String certPath;

    /**
     * 混合云，默认0，非混合云；1，混合云
     */
    @Column
    public String hhy = IsTrue.NAY;

    /**
     * 撤销证书，默认0，不展示；1，展示
     */
    @Column
    public String revoke = IsTrue.AYE;

    public String getCertPath() {
        return certPath;
    }


    public String getCertContent() {
        return certContent;
    }



    public String getRevoke() {
        return revoke;
    }

    public void setRevoke(String revoke) {
        this.revoke = revoke;
    }


    public String getHhy() {
        return hhy;
    }

    public void setHhy(String hhy) {
        this.hhy = hhy;
    }


    public String getLiveCompany() {
        return liveCompany;
    }

    public void setLiveCompany(String liveCompany) {
        this.liveCompany = liveCompany;
    }

    public String getOcrCompany() {
        return ocrCompany;
    }

    public void setOcrCompany(String ocrCompany) {
        this.ocrCompany = ocrCompany;
    }

    public String getNfcCompany() {
        return nfcCompany;
    }

    public void setNfcCompany(String nfcCompany) {
        this.nfcCompany = nfcCompany;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getPort() {
        ModuleLog.e("port : " + port);
        return port;
    }

    public void setPort(String port) {
        this.port = port;
    }


    public String getVhsm_ip() {
        return vhsm_ip;
    }

    public void setVhsm_ip(String vhsm_ip) {
        this.vhsm_ip = vhsm_ip;
    }

    public String getVhsm_port() {
        return vhsm_port;
    }


    public void setVhsm_port(String vhsm_port) {
        this.vhsm_port = vhsm_port;
    }

    public String getNfcServerIP() {
        return nfcServerIP;
    }

    public void setNfcServerIP(String nfcServerIP) {
        this.nfcServerIP = nfcServerIP;
    }

    public String getNfcServerPort() {
        return nfcServerPort;
    }

    public void setNfcServerPort(String nfcServerPort) {
        this.nfcServerPort = nfcServerPort;
    }


    public String getAllowUpdate() {
        return allowUpdate;
    }

    public void setAllowUpdate(String allowUpdate) {
        this.allowUpdate = allowUpdate;
    }

    public String getProcedure() {
        return procedure;
    }

    public void setProcedure(String procedure) {
        this.procedure = procedure;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public ArrayList<ServerAddress> getServerAddressList() {
        return serverAddressList;
    }

    public void setServerAddressList(ArrayList<ServerAddress> serverAddressList) {
        this.serverAddressList = serverAddressList;
    }

    public ArrayList<ServerAddress> getVhsmAddressList() {
        return vhsmAddressList;
    }

    public void setVhsmAddressList(ArrayList<ServerAddress> vhsmAddressList) {
        this.vhsmAddressList = vhsmAddressList;
    }

    public boolean isEnableVHSM() {
        return enableVHSM;
    }

    public void setEnableVHSM(boolean enableVHSM) {
        this.enableVHSM = enableVHSM;
    }

    public String getAllowIdentifer() {
        return allowIdentifer;
    }

    public void setAllowIdentifer(String allowIdentifer) {
        this.allowIdentifer = allowIdentifer;
    }

    @Override
    public String toString() {
        return "ServerSettingConfig{" +
                "id=" + id +
                ", liveCompany='" + liveCompany + '\'' +
                ", ocrCompany='" + ocrCompany + '\'' +
                ", nfcCompany='" + nfcCompany + '\'' +
                ", ip='" + ip + '\'' +
                ", port='" + port + '\'' +
                 (serverAddressList == null ? "" : ", serverAddressList=" + serverAddressList.toString())
                            +
                ", vhsmAddressList=" + vhsmAddressList +
                ", enableVHSM=" + enableVHSM +
                ", vhsm_ip='" + vhsm_ip + '\'' +
                ", vhsm_port='" + vhsm_port + '\'' +
                ", nfcServerIP='" + nfcServerIP + '\'' +
                ", nfcServerPort='" + nfcServerPort + '\'' +
                ", allowUpdate='" + allowUpdate + '\'' +
                ", allowIdentifer='" + allowIdentifer + '\'' +
                ", procedure='" + procedure + '\'' +
                ", projectName='" + projectName + '\'' +
                ", containerNum=" + containerNum +
                ", certType='" + certType + '\'' +
                ", isSupportCertContentUpdate='" + isSupportCertContentUpdate + '\'' +
                ", certAlg='" + certAlg + '\'' +
                ", certRule='" + certRule + '\'' +
                ", cityName=" + cityName +
                ", certContent='" + certContent + '\'' +
                ", certPath='" + certPath + '\'' +
                ", hhy='" + hhy + '\'' +
                ", revoke='" + revoke + '\'' +
                '}';
    }

}
