package com.xdja.safeclient.certcreation.databases;

import com.raizlabs.android.dbflow.annotation.Column;
import com.raizlabs.android.dbflow.annotation.PrimaryKey;
import com.raizlabs.android.dbflow.annotation.Table;
import com.raizlabs.android.dbflow.structure.BaseModel;
import com.xdja.safeclient.certcreation.bean.device.CardType;
import com.xdja.safeclient.certcreation.bean.device.ContainerNum;
import com.xdja.safeclient.certcreation.config.AlgType;
import com.xdja.safeclient.certcreation.config.CertPermission;
import com.xdja.safeclient.certcreation.config.CertRule;
import com.xdja.safeclient.certcreation.config.CertType;

import java.io.Serializable;
import java.util.Objects;

/**
 * Created by Administrator on 2019/9/3 0003.
 */
@Table(database = CertConfigDataBase.class)
public class TableCertConfig extends BaseModel implements Serializable {

    @PrimaryKey(autoincrement = true)
    public long id;

    // 因为会引起Bug，所以启用此字段
    @Deprecated
    @Column
    public int position;

    @Column
    public String cardType = "";

    @Column
    public int containerNum;

    @Column
    public String algType = "";

    @Column
    public String certRule = "";

    @Column
    public String certType = "";

    @Column
    public String certPermission = "";

    @Override
    public String toString() {
        return "TableCertConfig{" +
                "position=" + position +
                ", cardType='" + cardType + '\'' +
                ", containerNum=" + containerNum +
                ", algType='" + algType + '\'' +
                ", certRule='" + certRule + '\'' +
                ", certType='" + certType + '\'' +
                ", certPermission='" + certPermission + '\'' +
                '}';
    }

    public String getCardType() {
        return cardType;
    }

    public int getContainerNum() {
        return containerNum;
    }

    public void setContainerNum(int containerNum) {
        this.containerNum = containerNum;
    }

    public String getAlgType() {
        return algType;
    }

    public String getCertRule() {
        return certRule;
    }

    public String getCertType() {
        return certType;
    }

    public void setCardType(String cardType) {
        this.cardType = cardType;
    }


    public void setAlgType(String algType) {
        this.algType = algType;
    }

    public void setCertRule(String certRule) {
        this.certRule = certRule;
    }

    public void setCertType(String certType) {
        this.certType = certType;
    }

    @Deprecated
    public int getPosition() {
        return position;
    }

    @Deprecated
    public void setPosition(int position) {
        this.position = position;
    }

    public String getCertPermission() {
        return certPermission;
    }

    public void setCertPermission(String certPermission) {
        this.certPermission = certPermission;
    }

    public static TableCertConfig initDefaultOne() {

        TableCertConfig config = new TableCertConfig();
        config.containerNum = ContainerNum.getDefault();
        config.algType = AlgType.getDefaule();
        config.certRule = CertRule.getDefault();
        config.certType = CertType.getDefault();
        config.certPermission = CertPermission.getDefault();
        return config;

    }

    @Override
    public boolean equals(Object obj) {

        if (this == obj) {
            return true;
        } else if (obj != null && obj instanceof TableCertConfig) {

            TableCertConfig config = (TableCertConfig) obj;

            // 联网版VHSM和离线版VHSM不能共存
            if (config.cardType.equals(CardType.ONLINE_VHSM)
                    && (this.cardType.equals(CardType.OFFLINE_VHSM))) {
                return true;
            } else if (config.cardType.equals(CardType.OFFLINE_VHSM)
                    && (this.cardType.equals(CardType.ONLINE_VHSM))
            ) {
                return true;
            } else if (config.cardType.equals(this.cardType)
                    && (config.containerNum == this.containerNum)) {
                // 同一个设备，同一个容器只能存在一个
                return true;
            } else if (config.cardType.equals(this.cardType)
                    && config.certPermission.equals(CertPermission.APPLY)
                    && this.certPermission.equals(CertPermission.APPLY)
            ) {
                // 同一个设备，只有一个容器可以申请证书
                return true;
            } else {
                return false;
            }

        } else {
            // 不同对象，直接返回false
            return false;
        }


    }

    @Override
    public int hashCode() {
        return Objects.hash(id, position, cardType, containerNum, algType, certRule, certType, certPermission);
    }
}
