package com.xdja.safeclient.certcreation.device;

import android.os.Build;
import android.text.TextUtils;


/**
 * Created by gyx on 2018/7/17.
 * 获取设备品牌、型号、运营商
 */

public class DeviceUtil {

    private static DeviceUtil deviceUtil = new DeviceUtil();

    public static DeviceUtil getInstance() {
        return deviceUtil;
    }

    /**
     * 获取手机型号
     *
     * @return
     */
    public String getModel() {
        return Build.MODEL;
    }

    /**
     * 获取手机品牌
     *
     * @return
     */
    public String getBrand() {
        return Build.BRAND;
    }

    /**
     * 获取运营商
     *
     * @return 1.中国移动 ; 2.中国联通; 3.中国电信; 0.代表未知; -1.没有权限获取
     */
    public int getOperator() {
        String imsi = DeviceWrapper.getInstance().getIMSI();
        if (TextUtils.isEmpty(imsi)) {
            return -1;
        }
        return getOperatorFromIMSI(imsi);
    }


    private int getOperatorFromIMSI(String imsi) {
        if (imsi.startsWith("46000") || imsi.startsWith("46002") || imsi.equals("46007")) {
            //移动
            return 1;
        } else if (imsi.startsWith("46001") || imsi.startsWith("46006")) {
            //联通
            return 2;
        } else if (imsi.startsWith("46003") || imsi.startsWith("46005")) {
            //电信
            return 3;
        } else {
            return 0;
        }

    }

}
