package com.xdja.safeclient.certcreation.device;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.util.Pair;

import com.aircert.ApplicationContext;
import com.aircert.util.ModuleLog;
import com.xdja.SafeKey.JNIAPI;
import com.xdja.SafeKey.XDJA_DEVINFO;
import com.xdja.initvhsm.net.NetRespository;
import com.xdja.initvhsm.utils.NetVhsmCardIdUtil;
import com.xdja.initvhsm.utils.NetVhsmDeviceIdUtils;
import com.xdja.multichip.jniapi.JarJniApiProxy;
import com.xdja.multichip.jniapi.JarMultiJniApiManager;
import com.xdja.multichip.jniapi.JarMultiJniApiVhsmManager;
import com.xdja.multichip.param.JniApiParam;
import com.xdja.multichip.param.VhsmInitParam;
import com.xdja.multichip.param.VhsmServerInfo;
import com.xdja.safeclient.certcreation.ApplicationInit;
import com.xdja.safeclient.certcreation.bean.device.CardType;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import com.xdja.safeclient.certcreation.util.SharePreferencesUtil;

import java.io.File;
import java.nio.charset.StandardCharsets;

/**
 * 联网卡VHSM相关操作
 * Created by jff on 2019/7/8.
 */
public class NetVHSMHandle {
    /**
     * vhsm初始化
     *
     * @param context
     * @param ip      联机版服务端的ip
     * @param port    联机版服务端的port
     * @return 初始化结果
     */
    public static void initVHSM(final Context context, final String ip, final int port) {

        new Thread(new Runnable() {
            @Override
            public void run() {
                NetRespository netRespository = NetRespository.create(context, ip, port);
                int initResult = netRespository.init(NetVhsmDeviceIdUtils.getDevId(context));
                ModuleLog.e("vhsm initResult =  " + initResult);
                if (initResult == 0) {//联网版VHSM初始化成功
                    ModuleLog.e("VHSM初始化成功");
                    int initFile = NetRespository.initVhsmlibFile(context, ip, port);
                    Message msg = new Message();
                    msg.obj = "success";
                    Bundle data = new Bundle();
                    data.putInt("value", initFile);
                    msg.setData(data);
                    handler.sendMessage(msg);
                } else {
                    Message msg = new Message();
                    msg.obj = "fail";
                    Bundle data = new Bundle();
                    data.putInt("value", initResult);
                    msg.setData(data);
                    handler.sendMessage(msg);
                }
            }
        }).start();

    }

    /**
     * 获取VHSM卡号
     *
     * @return VHSM卡号
     */
    private static String getNetVhsmCardId_1(Context context) {
        String netVhsmCardId = NetVhsmCardIdUtil.getCardId(NetVhsmDeviceIdUtils.getDevId(context));
        ModuleLog.i("NetVhsmCardId : " + netVhsmCardId);
        return netVhsmCardId;
    }


    /**
     * vhsm初始化
     *
     * @param context
     * @param ip      联机版服务端的ip
     * @param port    联机版服务端的port
     * @return 初始化结果
     */
    public static void initVHSM(final Context context, final String ip, final int port, final String phoneStr, final byte[] sig) {
        int ret = 0;

        ModuleLog.i("start initVHSM : ");
        VhsmServerInfo serverInfo = new VhsmServerInfo();

        /**
         * 设置私有目录
         */
        JarMultiJniApiVhsmManager.getInstance().setVhsmPriPath(context);


        ret = JarMultiJniApiVhsmManager.getInstance().initVhsm(context, JNIAPI.OP_CHECK, null);
        ModuleLog.e("initVHSM ret : " + ret);
        if (ret != JNIAPI.XKR_OK) {
            // 设置服务器信息
            serverInfo.setAddrType(JNIAPI.ADDR_IP);
            serverInfo.setIp(ip);
            serverInfo.setPort(port);
            serverInfo.setServerType(JNIAPI.SERVER_PRI);
            ret = JarMultiJniApiVhsmManager.getInstance().setVhsmServerInfo(context, serverInfo);
            ModuleLog.e("initVHSM ret: " + ret);
            if (ret != JNIAPI.XKR_OK) {
                ModuleLog.e("initVHSM : ");
                return;
            }

            byte[] nameB = new byte[]{};
            String name = SharePreferencesUtil.getName(context);
            if (name != null && name.length() > 0) {
                nameB = name.getBytes(StandardCharsets.UTF_8);
            }

            byte[] phone = phoneStr.getBytes(StandardCharsets.UTF_8);
            String deptStr = "暂无";
            byte[] deptB = deptStr.getBytes(StandardCharsets.UTF_8);

            // 对 [name]#[phone]#[dept] 签名
            byte[] signature = sig;

            VhsmInitParam param = new VhsmInitParam();
            System.arraycopy(nameB, 0, param.name, 0, nameB.length);
            System.arraycopy(phone, 0, param.phone, 0, phone.length);
            System.arraycopy(deptB, 0, param.dept, 0, deptB.length);
            System.arraycopy(signature, 0, param.signature, 0, signature.length);

            param.initType = JNIAPI.INIT_TRUST;
            ret = JarMultiJniApiVhsmManager.getInstance().initVhsm(context, JNIAPI.OP_INIT, param);
            ModuleLog.e("initVHSM ret : " + ret);
            if (ret != JNIAPI.XKR_OK) {
                Message msg = new Message();
                msg.obj = "fail";
                Bundle data = new Bundle();
                data.putInt("value", ret);
                msg.setData(data);
                handler.sendMessage(msg);
            } else {
                ModuleLog.e("VHSM初始化成功");
                //int initFile = NetRespository.initVhsmlibFile(context, ip, port);
                Message msg = new Message();
                msg.obj = "success";
                Bundle data = new Bundle();
                data.putInt("value", ret);
                msg.setData(data);
                handler.sendMessage(msg);
            }


            // 初始化并加载设备
            ret = JarMultiJniApiVhsmManager.getInstance().initVhsm(context, JNIAPI.OP_QUERY, param);
            System.out.println("VHSM_InitVHSM（VHSM_OP_QUERY） return " + ret);
            //param.state = VHSM_APPLY_STATE_NOTAPPLY;
            if (ret != JNIAPI.XKR_OK) {
                return;
            }

        }

    }

    /**
     * 获取VHSM卡号
     *
     * @return VHSM卡号
     */
    private static String getVhsmVirtuallyCardId(Context context) {
        return JarMultiJniApiVhsmManager.getInstance().getVhsmVirtuallyId(context);
    }

    public static String getNetVhsmCardId(Context context) {
        if (CardType.REQUEST_PARAM_ONLINE_VHSM.equals("1")) {
            return getNetVhsmCardId_1(context);
        } else {
            return getVhsmVirtuallyCardId(context);
        }
    }


    private static Handler handler = new Handler() {
        @Override
        public void handleMessage(Message msg) {
            int initFile = (int) msg.getData().get("value");
            OttoUtil.postNet_VHSMinitResult(initFile);
        }
    };


    /**
     * 判断VHSM是否可用
     * 融合版：通过调用多芯片的接口来判断
     * 独立版：是否需要兼容待分析？
     *
     * @return 1 芯片管家私有目录或者安全接入的外部根目录可用或者安全接入的内部私有目录可用
     * 2 不可用
     * 芯片管家默认make根目录
     */
    public static int isNetVHSMCanUse(Context context) {

        Pair<Integer, JarJniApiProxy> make = JarMultiJniApiManager.getInstance().make(context, JniApiParam.TYPE_VHSM_NET);
        if (make.first != 0) {
            return 2;
        } else {
            return 1;
        }
    }



}
