package com.xdja.safeclient.certcreation.dialog;

import android.content.Context;

import com.baidu.idl.face.platform.ui.dialog.BindIdentifyDialog;
import com.xdja.safeclient.certcreation.R;

/**
 * Created by Administrator on 2020/8/10 0010.
 */

public class DeleteCertDialog {

    BindIdentifyDialog dialog;

    DeleteCertDialog.OnClickListener listener;

    public interface OnClickListener {

        void onPositive();

    }

    public DeleteCertDialog setListener(DeleteCertDialog.OnClickListener listener) {
        this.listener = listener;
        return this;
    }

    public BindIdentifyDialog build(final Context context) {


        dialog = new BindIdentifyDialog(context);

        dialog.setTitle(com.xdja.aircert.common.R.string.verify_permission_title);

        // 理想状况下getPermissionMessage是不会返回0的
        dialog.setMessage(R.string.cc_delete_cert_message);
        dialog.setModel(BindIdentifyDialog.MID_MODEL);
        dialog.setNegativeButtonText(R.string.text_cancel);
        dialog.setPositiveButtonText(R.string.cc_continue);
        dialog.setCancelable(false);
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();
        dialog.setClickListener(new BindIdentifyDialog.ClickListenerInterface() {
            @Override
            public void doConfirm() {
                dialog.dismiss();
                if (listener != null) {
                    listener.onPositive();
                } else {

                }
            }

            @Override
            public void doCancel() {
                dialog.dismiss();
            }
        });

        return dialog;
    }

    public void show() {
        dialog.show();
    }

}
