package com.xdja.safeclient.certcreation.util;

import com.xdja.cryptodev.CryptoDevType;

/**
 * Created by Administrator on 2018/12/18 0018.
 * 密码模块类型转换的工具类
 */

public class CryptoDevTypeUtil {


    public static CryptoDevType formatType(int type) {

        if (type == CryptoDevType.DEV_TYPE_SdCard.getType()) {
            return CryptoDevType.DEV_TYPE_SdCard;
        } else if (type == CryptoDevType.DEV_TYPE_Chip.getType()) {
            return CryptoDevType.DEV_TYPE_Chip;
        } else if (type == CryptoDevType.DEV_TYPE_UsbKey.getType()) {
            return CryptoDevType.DEV_TYPE_UsbKey;
        } else if (type == CryptoDevType.DEV_TYPE_SimKey.getType()) {
            return CryptoDevType.DEV_TYPE_SimKey;
        } else if (type == CryptoDevType.DEV_TYPE_BlueTooth.getType()) {
            return CryptoDevType.DEV_TYPE_BlueTooth;
        } else if (type == CryptoDevType.DEV_TYPE_Soft.getType()) {
            return CryptoDevType.DEV_TYPE_Soft;
        } else {
            return null;
        }
    }


    /**
     * 由于服务端芯片类型对应的int值和客户端不一致，所以需要转换。
     * type 对应的是CryptoDevType的类型，返回的是接口文档对应的类型
     *
     * @return
     */
    public static int convertCardType(int type) {
        switch (type) {
            case 0:
                //tf
                return 3;
            case 1:
                //芯片
                return 2;
            case 3:
                return 6;
            case 5://
                return 7;
        }
        return -1;
    }

}
