package com.xdja.safeclient.certcreation.util;

import android.content.Intent;

import com.xdja.cryptodev.CryptoDevType;

/**
 * Created by zjc on 2018/6/7 0007.
 */

public class IntentUtil {

    public static Intent putInfo(Intent intent, CryptoDevType deviceType, String cardNo) {
        intent.putExtra("cardType", deviceType);
        intent.putExtra("cardId", cardNo);
        return intent;
    }

    public static Intent putPhone(Intent intent, String phone) {
        intent.putExtra("phone", phone);
        return intent;
    }

    public static Intent putName(Intent intent, String name) {
        intent.putExtra("name", name);
        return intent;
    }

    public static String getName(Intent intent) {
        return intent.getStringExtra("name");
    }

    public static Intent putSex(Intent intent, int sex) {
        intent.putExtra("sex", sex);
        return intent;
    }

    public static Intent putID(Intent intent, String id) {
        intent.putExtra("id", id);
        return intent;
    }

    public static String getID(Intent intent) {
        return intent.getStringExtra("id");
    }

    public static int getSex(Intent intent) {
        return intent.getIntExtra("sex", 1);
    }

    public static String getPhone(Intent intent) {
        return intent.getStringExtra("phone");
    }

    public static CryptoDevType getCardType(Intent intent) {
        return (CryptoDevType) intent.getSerializableExtra("cardType");
    }

    public static String getCardNum(Intent intent) {
        return intent.getStringExtra("cardId");
    }


}
