package ocr.activity;

import android.Manifest;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.baidu.idl.face.platform.ui.dialog.SinglePermissionDialog;
import com.squareup.otto.Subscribe;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.ActivityParam;
import com.xdja.safeclient.certcreation.activity.ActivityPath;
import com.xdja.safeclient.certcreation.activity.BaseActivity;
import com.xdja.safeclient.certcreation.activity.SelfieActivity;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.event.FinishActivity;
import com.xdja.safeclient.certcreation.util.CryptoDevTypeUtil;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.ScreenUtil;
import com.xdja.safeclient.certcreation.util.SharePreferencesUtil;

import static com.xdja.safeclient.certcreation.activity.ActivityParam.CARD_NUM;
import static com.xdja.safeclient.certcreation.activity.ActivityParam.CARD_TYPE;
import static com.xdja.safeclient.certcreation.activity.ActivityParam.PHOTO_TYPE;

/**
 * 拍照准备界面
 * 标题-持证拍照准备
 * Created by Administrator on 2019/3/23 0023.
 */

public class CameraReadyActivity extends BaseActivity {

    public int photoType;

    String cardNum;

    CryptoDevType cardType;

    String phone;

    public int containerNum;

    TextView tv_tips1;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_camera_ready);

        hideBG();

        cardType = CryptoDevTypeUtil.formatType(SharePreferencesUtil.getCurrentDevType(this));
        cardNum = DeviceWrapper.getInstance().getCardID(cardType);

        phone = SharePreferencesUtil.getPhoneNum(this);


        if (TextUtils.isEmpty(cardNum)) {
            ModuleToast.show(this, R.string.cert_creation_card_device_error);
            return;
        }

        Button bt_startdect = (Button) findViewById(R.id.start);

        bt_startdect.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {


                if (ContextCompat.checkSelfPermission(CameraReadyActivity.this, Manifest.permission.CAMERA) != PackageManager.PERMISSION_GRANTED) {
                    ActivityCompat.requestPermissions(CameraReadyActivity.this,
                            new String[]{Manifest.permission.CAMERA},
                            PERMISSION_CODE);
                } else {
                    route();
                }
            }

        });

        tv_tips1 = findViewById(R.id.hint1);

        if (ScreenUtil.isFullScreen(this)) {

            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(
                    RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);

            layoutParams.setMargins(0, ScreenUtil.dip2px(this, 50), 0, 0);
            layoutParams.addRule(RelativeLayout.CENTER_HORIZONTAL);
            tv_tips1.setLayoutParams(layoutParams);


        }


    }

    public static final int PERMISSION_CODE = 23;


    @Override
    public boolean valid() {
        return ContextCompat.checkSelfPermission(CameraReadyActivity.this, Manifest.permission.CAMERA) == PackageManager.PERMISSION_GRANTED;
    }

    @Override
    public String nextActivity() {
        return ActivityPath.ACTIVITY_SELFIE;
    }

    @Override
    public void route() {
        super.route();

            Intent intent = new Intent(this, SelfieActivity.class);
            intent.putExtra(PHOTO_TYPE, photoType);
            intent.putExtra(CARD_NUM, cardNum);
            intent.putExtra(CARD_TYPE, cardType);
            intent.putExtra(ActivityParam.PHONE, phone);
            intent.putExtra(ActivityParam.CONTAINER_NUM, containerNum);
            startActivity(intent);

    }

    @Override
    protected void onResume() {
        super.onResume();
        left_title_tv.setText(R.string.cert_creation_selfie_photo_ready_title);
    }

    @Override
    protected void onPause() {
        super.onPause();
        left_title_tv.setText("");
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);

        if (permissions[0].equals(Manifest.permission.CAMERA)
                && grantResults[0] == PackageManager.PERMISSION_GRANTED) {
            next();
        } else {
            SinglePermissionDialog dialog = new SinglePermissionDialog();
            dialog.build(this, SinglePermissionDialog.PERMISSION_TAKE_PHOTO);
            dialog.show();
        }

    }

    @Override
    protected int getTitleRes() {

        return R.string.cert_creation_selfie_photo_ready_title;

    }

    @Subscribe

    public void handleFinishActivity(FinishActivity activity) {
        finish();
    }

}
