package ocr.activity;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;

import com.aircert.util.ModuleLog;
import com.squareup.otto.Subscribe;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.HttpResponseCallBack;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.ActivityParam;
import com.xdja.safeclient.certcreation.activity.BaseActivity;
import com.xdja.safeclient.certcreation.bean.ChipInfo;
import com.xdja.safeclient.certcreation.bean.device.CardType;
import com.xdja.safeclient.certcreation.bean.request.CompareCardInfoAndFaceInfoRequest;
import com.xdja.safeclient.certcreation.bean.response.BaseErrorResponse;
import com.xdja.safeclient.certcreation.bean.response.CommonResponse;
import com.xdja.safeclient.certcreation.bean.response.CompareResult;
import com.xdja.safeclient.certcreation.bean.result.AuthResult;
import com.xdja.safeclient.certcreation.cache.RequestCache;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.event.FinishActivity;
import com.xdja.safeclient.certcreation.util.CryptoDevTypeUtil;
import com.xdja.safeclient.certcreation.util.EditTextUtil;
import com.xdja.safeclient.certcreation.util.KeyboardUtils;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import com.xdja.safeclient.certcreation.util.SharePreferencesUtil;
import com.xdja.safeclient.certcreation.util.ValidUtil;

import java.io.IOException;
import java.lang.ref.WeakReference;

import ocr.bean.IDCardInfo;
import okhttp3.Call;

import static com.xdja.safeclient.certcreation.activity.ActivityParam.CONTAINER_NUM;

/**
 * 信息核对
 * Created by Administrator on 2019/10/23 0023.
 */
public class XDJAOCRIDCardActivity extends BaseActivity {

    public int containerNum;

    public String name;

    public String gender;

    public String idNum;

    public String faceImg;

    private EditText etName;

    private TextView tvGender;

    private TextView tvID;

    private Button btnNext;

    private Button btnAgain;

    private IDCardInfo info = new IDCardInfo();

    private ExitHandler exitHandler = new ExitHandler(this);

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        setContentView(R.layout.activity_xdja_ocr_id_card);

        etName = findViewById(R.id.et_name);
        etName.setText(name);
        etName.setFilters(EditTextUtil.getHanziFilter(14));


        tvGender = findViewById(R.id.tv_gender);
        tvGender.setText(gender);

        tvID = findViewById(R.id.tv_id);
        tvID.setText(idNum);

        btnNext = findViewById(R.id.btn_next);
        btnNext.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                if (!ValidUtil.name(etName.getText().toString())) {
                    KeyboardUtils.hideKeyboard(XDJAOCRIDCardActivity.this);

                    ModuleToast.show(getContext(), R.string.cert_creation_invalid_name_length);

                    return;
                }

                request();
            }
        });

        btnAgain = findViewById(R.id.btn_again);
        btnAgain.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                KeyboardUtils.hideKeyboard(XDJAOCRIDCardActivity.this);
                finish();
            }
        });

    }


    @Override
    protected void getIntentData() {

        super.getIntentData();

        Intent intent = getIntent();

        name = intent.getStringExtra(ActivityParam.NAME);

        gender = intent.getStringExtra(ActivityParam.GENDER);

        idNum = intent.getStringExtra(ActivityParam.ID_NUM);

        containerNum = intent.getIntExtra(ActivityParam.CONTAINER_NUM, 0);

        faceImg = intent.getStringExtra(ActivityParam.FACE_IMG);

    }

    @Override
    protected int getTitleRes() {
        return R.string.cert_creation_identify_result_title;
    }

    @Subscribe
    public void handleFinishActivity(FinishActivity event) {
        finish();
    }

    /**
     * 开始上传数据进行比对
     */
    private void request() {

        final int devType = SharePreferencesUtil.getCurrentDevType(this);
        final CryptoDevType currentChipBeanType = CryptoDevTypeUtil.formatType(devType);
        String cardID = DeviceWrapper.getInstance().getCardID(currentChipBeanType);

        if (TextUtils.isEmpty(cardID)) {
            ModuleToast.show(getContext(), R.string.cert_creation_card_device_error);
            return;
        }

        final CompareResult compareResult = new CompareResult();
        CompareCardInfoAndFaceInfoRequest request = buildRequest();

        showLoading();

        service.entityAuthentication(request, cardID, new HttpResponseCallBack<CommonResponse>() {
            @Override
            public void onOtherException(Exception e) {
                e.printStackTrace();
                ModuleLog.e("other exception");
                compareResult.setResult("");
                compareResult.setMessage(getResources().getString(R.string.net_disconnected_text));
                compareResult.setSuccess(false);
                compareResult.setIdentity(idNum);
                verifyFailResultActivity(currentChipBeanType, compareResult);
                finish();
                OttoUtil.postFinishActivity();
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                ModuleLog.e("io exception");
                compareResult.setResult("");
                compareResult.setMessage(getResources().getString(R.string.net_disconnected_text));
                compareResult.setSuccess(false);
                compareResult.setIdentity(idNum);
                verifyFailResultActivity(currentChipBeanType, compareResult);
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                SharePreferencesUtil.saveIDCardNo(getContext(), devType, idNum);

                compareResult.setResult(commonResponse.getResult());
                compareResult.setMessage(commonResponse.getMessage());
                compareResult.setIdentity(idNum);
                compareResult.setSuccess(true);

                if (commonResponse.getResult().equals("2")) {
                    // 返回2的情况很少，只有现场的某些服务会有
                    verifyFailResultActivity(currentChipBeanType, compareResult);
                } else {
                    AuthResult auth = new AuthResult(currentChipBeanType, containerNum, compareResult, RequestCache.getInstance().getObject());
                    OttoUtil.postAuthResult(auth);
                }

                exitHandler.postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        OttoUtil.postFinishActivity();
                        OttoUtil.postFinishYishuNFC();
                        finish();
                    }
                }, 0);

            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
//                ModuleLog.e("认证失败");
                compareResult.setResult(baseErrorResponse.getErrCode());
                compareResult.setMessage(baseErrorResponse.getMessage());
                compareResult.setIdentity(idNum);
                compareResult.setSuccess(false);
                verifyFailResultActivity(currentChipBeanType, compareResult);
                finish();
            }

            @Override
            public void dismissDialog() {
                dismissLoading();
            }
        });

    }

    static class ExitHandler extends Handler {

        WeakReference<Activity> reference;

        ExitHandler(Activity activity) {
            reference = new WeakReference<Activity>(activity);
        }

        @Override
        public void handleMessage(Message msg) {
            super.handleMessage(msg);

            Activity activity = reference.get();

            if (activity == null) {
                return;
            } else {
                activity.finish();
            }
        }
    }


    private void verifyFailResultActivity(CryptoDevType type, CompareResult result) {

            Intent intent = new Intent(this, AuthenticationFailActivity.class);
            intent.putExtra("result", result);
            intent.putExtra("devType", type);
            intent.putExtra("identify_info", info);
            intent.putExtra("faceImg", faceImg);
            intent.putExtra(CONTAINER_NUM, containerNum);
            startActivity(intent);

    }

    private CompareCardInfoAndFaceInfoRequest buildRequest() {
        CompareCardInfoAndFaceInfoRequest request = new CompareCardInfoAndFaceInfoRequest();
        ChipInfo chipInfo = new ChipInfo();
        DeviceWrapper deviceWrapper = DeviceWrapper.getInstance();
        chipInfo.setCardType("" + CryptoDevTypeUtil.convertCardType(SharePreferencesUtil.getCurrentDevType(this)));


        String imsi = deviceWrapper.getIMSI();
        chipInfo.setImsi(imsi);
        chipInfo.setPhone(SharePreferencesUtil.getPhoneNum(this));

        if (AppConfig.getInstance().getCertConfig().getVHSMType()
                .equals(CardType.ONLINE_VHSM)
                ) {
            chipInfo.setVhsmType(CardType.REQUEST_PARAM_ONLINE_VHSM);
            chipInfo.setImei(DeviceWrapper.getInstance().getIMEI());
        } else {
            chipInfo.setImei(deviceWrapper.getIMEI());
        }

        info.setName(name);
        info.setSex(gender.equals("男") ? 1 : 2);
        info.setIdNum(idNum);


        request.setIdCardInfo(info);


        request.setChipInfo(chipInfo);
        request.setFaceImg(faceImg);

        final int type = SharePreferencesUtil.getCurrentDevType(this);
        final CryptoDevType cardType = CryptoDevTypeUtil.formatType(type);

        request.setCaAlg(AppConfig.getInstance().getCertConfig().getAlgType(cardType, containerNum));
        //        Log.e("jff","实体认证： " + request.toString());

        ModuleLog.e(request.toString());

        return request;

    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        exitHandler.removeCallbacksAndMessages(null);
    }
}
