package ocr.activity;

import android.content.Intent;
import android.os.Bundle;

import com.xdja.safeclient.certcreation.cache.ImageCache;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import com.xdja.safeclient.certcreation.util.SharePreferencesUtil;

/**
 * 云从NFC识别后的身份证界面
 * 信大捷安NFC识别后的身份证界面
 * Created by Administrator on 2018/7/30 0030.
 */
public class YuncongOCRIDCardActivity extends IDCardActivity {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Override
    public void initIDFace() {
        super.initIDFace();

        if (info != null) {
//            faceBitmap = ImgUtil.bytesToBimap(Base64Util.decode(info.getPhoto()));
            faceBitmap = ImageCache.getInstance().getNfcFaceImg();
        } else {
            finish();
        }

    }

    @Override
    public void next() {

        //拿到当前的芯片类型
        int type = SharePreferencesUtil.getCurrentDevType(this);
        //保存当前芯片对应的身份证号
        SharePreferencesUtil.saveIDCardNo(this, type, info.getIdNum());

        super.next();


    }

    @Override
    public void rescan() {
        super.rescan();
        OttoUtil.postFinishChooseBindWay();
        Intent intent = new Intent(this, ChooseBindWayActivity.class);
        Bundle bundle = new Bundle();
        bundle.putString(FACE_IMG, faceImg);
        intent.putExtras(bundle);
        startActivity(intent);
        finish();
    }
}
