package com.xdja.safeclient.certcreation;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.Application;
import android.content.ComponentName;
import android.content.Context;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.telephony.TelephonyManager;
import android.util.Log;
import android.util.Pair;

import com.aircert.ApplicationContext;
import com.aircert.util.ModuleLog;
import com.micro.MicroApi;
import com.raizlabs.android.dbflow.config.FlowConfig;
import com.raizlabs.android.dbflow.config.FlowLog;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.config.cert_creationGeneratedDatabaseHolder;
import com.raizlabs.android.dbflow.sql.language.SQLite;
import com.raizlabs.android.dbflow.structure.database.AndroidDatabase;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;
import com.xdja.cryptodev.CryptoDevManager;
import com.xdja.cryptodev.driver.chipmanager.ChipManagerDriver;
import com.xdja.cryptodev.driver.skf.SkfDataInitKt;
import com.xdja.cryptodev.driver.skf.SkfDriver;
import com.xdja.cryptodev.driver.skf.SkfDriverKt;
import com.xdja.log.LogModule;
import com.xdja.multichip.jniapi.JarJniApiProxy;
import com.xdja.multichip.jniapi.JarMultiJniApiManager;
import com.xdja.multichip.jniapi.JarMultiJniApiVhsmManager;
import com.xdja.multichip.param.JniApiParam;
import com.xdja.safeclient.certcreation.bean.ServerAddress;
import com.xdja.safeclient.certcreation.config.CertConfig;
import com.xdja.safeclient.certcreation.databases.CertConfigDataBase;
import com.xdja.safeclient.certcreation.databases.DatabaseManager;
import com.xdja.safeclient.certcreation.databases.ServerSettingConfig;
import com.xdja.safeclient.certcreation.receiver.FaceResultReceiver;
import com.xdja.safeclient.certcreation.service.HttpClientHelper;
import com.xdja.safeclient.certcreation.task.ChooseTask;
import com.xdja.safeclient.certcreation.util.SharePreferencesUtil;
import com.xdja.safeclient.certcreation.util.Util;
import com.zxy.tiny.Tiny;

import org.joor.Reflect;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

import kotlin.jvm.functions.Function0;


/**
 * Created by zjc on 2019/3/13 0013.
 */

public class ApplicationInit {

    public static final String TAG = "ApplicationInit";


    /**
     * @param context
     */
    public static void start(Application context) {

        //        if (!BuildConfig.isAAR) {
        initLog(context);
        //        }

        // 第三方肯定无法引用CertApplication，所以把初始化方法全部写在这个单独的类里

        //face sdk  使用，common模块，之后该module可去掉
        ApplicationContext.setContext(context);

        // 初始化图片压缩库
        Tiny.getInstance().init(context);


        // 初始化环境配置
        initConfig(context);

        // 初始化密码模块
        initCrytoDev(context);

        // 初始化云从人脸检测模块
        //initFaceSDK(context);

        // 初始化更新模块
        if (!BuildConfig.isAAR) {
            initUpdate(context);
        }

        // 初始化Http模块
        HttpClientHelper.initOkHttpClient();

        // crypto模块打印调试日志
        CryptoDevManager.getInstance().setLogDetail(true);

        if (isFirstInstall(context)) {
            //            SharePreferencesUtil.setRestartApp(context, true);
        }

        initReceiver(context);

        chooseServerAddress();

        chooseVHSMAddress();

    }

    private static void chooseServerAddress() {

        ArrayList<ServerAddress> list = AppConfig.getInstance().getServerSettingConfig().getServerAddressList();

        int timeout = 750;

        if (list != null && list.size() != 0 && list.size() != 1) {
            timeout = 3000 / list.size();
        }

        ChooseTask task = new ChooseTask(
                list
                , timeout
                , new ChooseTask.ChooseResult() {
            @Override
            public void success(ServerAddress address) {

                AppConfig.getInstance().getServerSettingConfig().setIp(address.getIp());
                AppConfig.getInstance().getServerSettingConfig().setPort(address.getPort());

            }

            @Override
            public void fail(long time) {

            }

        });

        task.execute();

    }

    private static void chooseVHSMAddress() {

        ArrayList<ServerAddress> list =
                AppConfig.getInstance()
                        .getServerSettingConfig()
                        .getVhsmAddressList();

        int timeout = 750;

        if (list != null && list.size() != 0 && list.size() != 1) {
            timeout = 3000 / list.size();
        }

        ChooseTask task = new ChooseTask(
                list
                , timeout
                , new ChooseTask.ChooseResult() {
            @Override
            public void success(ServerAddress address) {

                AppConfig.getInstance().getServerSettingConfig()
                        .setVhsm_ip(address.getIp());
                AppConfig.getInstance().getServerSettingConfig()
                        .setVhsm_port(address.getPort());

            }

            @Override
            public void fail(long time) {

            }

        });

        task.execute();

    }


    private static void initLog(Context context) {

        LogModule.initDefault(context);

    }

    public static String IS2String(InputStream in) throws IOException {
        StringBuffer out = new StringBuffer();
        byte[] b = new byte[4096];
        for (int n; (n = in.read(b)) != -1; ) {
            out.append(new String(b, 0, n));
        }
        return out.toString();
    }

    public static InputStream string2IS(String string) {
        InputStream in_nocode = new ByteArrayInputStream(string.getBytes());
        return in_nocode;
    }

    /**
     * 初始化芯片管家和加密模块
     *
     * @param context
     */
    private static void initCrytoDev(final Context context) {
        setNetVHSMPath(context);

        //独立模块使用卡模块需要注册，一个app只注册一次
        // 密码模块模块初始化
        final CryptoDevManager cryptoDevManager = CryptoDevManager.getInstance();
        cryptoDevManager.setContext(context);
        // 注册芯片管家设备
        try {
            cryptoDevManager.registerDriver(new ChipManagerDriver());
        } catch (Exception e) {
            e.printStackTrace();
        }
        SkfDriver skfDriver = new SkfDriver();
        SkfDataInitKt.addLibrary(skfDriver,"libMicroApi.so",new Function0<Boolean>(){
            @Override
            public Boolean invoke() {
                MicroApi microApi =new MicroApi();
                TelephonyManager telephonyManager =(TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
                microApi.initTelephonyManager((TelephonyManager)context.getSystemService(Context.TELEPHONY_SERVICE));
                return true;
            }
        });
        cryptoDevManager.registerDriver(skfDriver);

        Log.e("jff", "231 ApplicationInit initCrytoDev : ");
        String vhsmChangeIP = AppConfig.getInstance().getServerSettingConfig().getVhsm_change_ip();
        String vhsmChangePort = AppConfig.getInstance().getServerSettingConfig().getVhsm_change_port();

        String sp_vhsmChangeIP = SharePreferencesUtil.getVHSMChangeIp(context);
        String sp_vhsmChangePort = SharePreferencesUtil.getVHSMChangePort(context);
        Log.e("jff", "238 ApplicationInit initCrytoDev IP& port : " + vhsmChangeIP + " " + sp_vhsmChangeIP + " " + vhsmChangePort + "  " +sp_vhsmChangePort);
        if (!"".equals(vhsmChangeIP) && !"".equals(vhsmChangePort)
                && vhsmChangeIP != null
                && vhsmChangePort != null && !vhsmChangeIP.equals(sp_vhsmChangeIP)) {
            Log.e("jff", "234 ApplicationInit initCrytoDev MMM: ");

            int ret = JarMultiJniApiVhsmManager.getInstance().updateServerInfo(context, true, vhsmChangeIP, Integer.parseInt(vhsmChangePort));
            if (ret == 0) {
                SharePreferencesUtil.saveVHSMChangeIp(context, vhsmChangeIP);
                SharePreferencesUtil.saveVHSMChangePort(context, vhsmChangePort);
                Log.e("jff", "248 ApplicationInit initCrytoDev change success: ");
            }
        }

        //独立版本在此处设置，融合版本在CertViewAcitivity设置
        //        cryptoDevManager.setDisableSoft(true);
        //是否屏蔽软卡 true屏蔽    false不屏蔽
        if (FeatureConfig.getInstance().isDisableVHSM()
                || !AppConfig.getInstance().getCertConfig().hasVHSM()) {
            cryptoDevManager.setDisableSoft(true);
        } else {
            cryptoDevManager.setDisableSoft(false);
        }
    }

    /**
     * 初始化云从人脸识别SDK<br>
     * 在此初始化为之后使用节省一定时间
     *
     * @param context context
     */
    //private static void initFaceSDK(final Context context) {
    //
    //    //再次检查模型文件是否已拷贝到app运行目录
    //    final File installation = new File(context.getFilesDir(), MODULES);
    //    String storagePath = installation.getAbsolutePath();
    //    StringBuilder pFaceDetectFile = new StringBuilder(storagePath + File.separator + "faceDetector_2_4.mdl");
    //    StringBuilder pFaceKeyPtFile = new StringBuilder(storagePath + File.separator + "keypt_detect_model_sdm_9pts.bin");
    //    StringBuilder pFaceKeyPtTrackFile = new StringBuilder(storagePath + File.separator + "keypt_track_model_sdm_9pts.bin");
    //    StringBuilder pFaceQualityFile = new StringBuilder(storagePath + File.separator + "facequality_4_1.bin");
    //    StringBuilder pFaceLivenessFile = new StringBuilder(storagePath + File.separator + "liveness171120.bin");
    //    //检测每个模型文件是否存在
    //    boolean allModulesExist = false;
    //    if (installation.exists() && new File(pFaceDetectFile.toString()).exists()
    //            && new File(pFaceKeyPtFile.toString()).exists() && new File(pFaceKeyPtTrackFile.toString()).exists()
    //            && new File(pFaceQualityFile.toString()).exists() && new File(pFaceLivenessFile.toString()).exists()) {
    //        allModulesExist = true;
    //    }
    //
    //    if (!allModulesExist) {
    //
    //        AsyncTask.THREAD_POOL_EXECUTOR.execute(new Runnable() {
    //            @Override
    //            public void run() {
    //                //
    //                boolean initStage = false;
    //                String dataDirPath = context.getFilesDir().getAbsolutePath();//data/data/package_name/files/
    //                try {
    //                    //模型文件拷贝
    //                    assetsDataToDest(context, MODULES_ZIP, dataDirPath + File.separator + MODULES_ZIP);//拷贝模型文件
    //                    //接压缩模型文件
    //                    unZipFolder(dataDirPath + File.separator + MODULES_ZIP, dataDirPath);
    //                    //设置模型文         件路径
    //                    //                        String paht = dataDirPath + File.separator + MODULES;
    //                    CloudwalkSDK.getInstance().setModulePath(dataDirPath + File.separator + MODULES);
    //                    initStage = true;
    //                } catch (IOException ex) {
    //                    initStage = false;
    //                    //                        Log.e(TAG, "copy module IOException:" + ex.getMessage());
    //                } catch (RuntimeException e) {
    //                    initStage = false;
    //                    //                        Log.e(TAG, "copy module RuntimeException:" + e.getMessage());
    //                } catch (Exception e) {
    //                    initStage = false;
    //                    //                        Log.e(TAG, "copy module Exception:" + e.getMessage());
    //                } finally {
    //                    //删除模型文件压缩包
    //                    File modelsZip = new File(dataDirPath + File.separator + MODULES_ZIP);
    //                    if (modelsZip.exists()) {
    //                        FileUtil.deleteFile(modelsZip);
    //                    }
    //
    //                    if (initStage) {
    //
    //                    } else {
    //                        //删除解压后模型文件
    //                        File modelsDir = new File(dataDirPath + File.separator + MODULES);
    //                        if (modelsDir.exists()) {
    //                            FileUtil.deleteFile(modelsDir);
    //                        }
    //
    //                    }
    //
    //                }
    //
    //            }
    //        });
    //    } else {
    //        try {
    //            CloudwalkSDK.getInstance().setModulePath(context.getFilesDir().getAbsolutePath() + File.separator + MODULES);
    //        } catch (Exception e) {
    //            //                Log.e(TAG, "copy module Exception:" + e.getMessage());
    //
    //        }
    //
    //    }
    //
    //}

    /**
     * 初始化更新
     *
     * @param context
     */
    private static void initUpdate(Context context) {

        {
            //使用反射前
            //            XDJAUpdateManager.init(context);

        }


        {
            //使用反射后
            if (BuildConfig.compileUpdate) {
                Reflect.on("com.xdja.updatelibrary.XDJAUpdateManager")
                        .call("init", context);
            }
        }

    }

    private static void adapterDB() {
        // 解决Android9.0无法导出数据库的问题
        DatabaseWrapper wrapper = FlowManager.getDatabase(CertConfigDataBase.NAME).getHelper().getDelegate().getWritableDatabase();
        boolean isWAL = ((AndroidDatabase) wrapper).getDatabase().isWriteAheadLoggingEnabled();
        ((AndroidDatabase) wrapper).getDatabase().disableWriteAheadLogging();
    }

    private static void initConfig(Context context) {

        AppConfig module = AppConfig.getInstance();
        //全局context
        module.setContext(context);
        module.getDefaultConfig().setPin("111111");

        if (!FeatureConfig.getInstance().getDefaultPin().equals(module.getDefaultConfig().getPin())) {
            module.getDefaultConfig().setPin(FeatureConfig.getInstance().getDefaultPin());
        }
        module.getDefaultConfig().setBksVerifyCode("xdja1234");

        boolean success = context.deleteDatabase("certDataBase.db");
        ModuleLog.e("Update", "升级前删除数据库" + success);

        if (Util.assetFileIsExist(context, "certDataBase.db")) {
            ModuleLog.d(TAG, "执行数据库操作");

            DatabaseManager.getInstance().copyAssetDatabase2PriPath(context);

            // 初始化DBFlow
            FlowManager.init(new FlowConfig.Builder(context)
                    .addDatabaseHolder(cert_creationGeneratedDatabaseHolder.class).build());
            FlowLog.setMinimumLoggingLevel(FlowLog.Level.V);
            adapterDB();


            ServerSettingConfig config = SQLite.select().from(ServerSettingConfig.class).querySingle();
            ModuleLog.e("339 ApplicationInit initConfig : " + config);

            if (config == null) {
                // TODO: 2019/8/21 0022 加个判断，如果是有库，但是表空行，给个提示或者处理
                ModuleLog.e("340 ApplicationInit initConfig : config == null");
            }

            module.setServerSettingConfig(config);
            module.setCertConfig(new CertConfig());

            AppConfig.getInstance().getServerSettingConfig().setServerAddressList(
                    ChooseAddress.initList()
            );

            AppConfig.getInstance().getServerSettingConfig().setVhsmAddressList(
                    ChooseAddress.initVHSMList()
            );

            AppConfig.getInstance().getServerSettingConfig().setVhsm_change_ip(config.getVhsm_change_ip());
            AppConfig.getInstance().getServerSettingConfig().setVhsm_change_port(config.getVhsm_change_port());


        } else {
            if (!FeatureConfig.getInstance().isDisableMakeNewCert()) {
                //                ModuleToast.show(context, context.getResources().getString(R.string.cert_creation_no_db));
                return;
            }
            FlowManager.init(new FlowConfig.Builder(context).addDatabaseHolder(cert_creationGeneratedDatabaseHolder.class).build());
            FlowLog.setMinimumLoggingLevel(FlowLog.Level.V);
            adapterDB();
        }


    }

    public static boolean isFirstInstall(Context context) {
        return getPackageFirstInstallTime(context) == getPackageLastUpdateTime(context);
    }

    public static long getPackageFirstInstallTime(Context context) {
        String name = context.getPackageName();
        long time = 0;
        try {
            time = context.getPackageManager().getPackageInfo(name, 0).firstInstallTime;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return time;
    }

    public static long getPackageLastUpdateTime(Context context) {
        String name = context.getPackageName();
        long time = 0;
        try {
            time = context.getPackageManager().getPackageInfo(name, 0).lastUpdateTime;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return time;
    }

    public static void initReceiver(Context context) {

        IntentFilter filter = new IntentFilter(FaceResultReceiver.ACTION);

        FaceResultReceiver receiver = new FaceResultReceiver();

        context.registerReceiver(receiver, filter);

    }


    /**
     * 判断VHSM是否可用
     * 判断芯片管家是否存在，如果存在，VHSM路径设置在芯片管家的私有路径下
     * 如果芯片管家不存在，判断安全接入私有路径下的VHSM文件是否存在，如果存在，设置路径给多芯片服务
     * 如果安全接入内部私有路径不存在，设置外部私有路径给多芯片服务
     */
    private static int setNetVHSMPath(Context context) {

        Pair<Integer, JarJniApiProxy> make = JarMultiJniApiManager.getInstance().make(context, JniApiParam.TYPE_VHSM_NET);
        if (make.first != 0) {
            if (isSafeServiceExist(context)) {//芯片管家存在，设置芯片管家私有路径
                JarMultiJniApiVhsmManager.getInstance().setVhsmPriPath(context);
            } else {
                //芯片管家不存在，判断安全接入内部私有目录文件是否存在
                if (isFileExist(privatePath(), null)) {
                    //安全接入私有目录下VHSM文件正常可用
                    JarMultiJniApiVhsmManager.getInstance().setVhsmCustomPath(ApplicationContext.getContext(), privatePath());
                    return 1;
                } else {
                    JarMultiJniApiVhsmManager.getInstance().setVhsmPriPath(context);
                    return 2;
                }
            }
            return 2;
        } else {
            return 1;
        }
    }


    //判断芯片管家是否存在
    private static boolean isSafeServiceExist(Context context) {
        try {
            PackageManager pm = context.getPackageManager();
            pm.getPackageInfo("com.xdja.safekeyservice", 0);
            return true;
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return false;
    }


    private static String privatePath() {
        if (isSafeClientApp(ApplicationContext.getContext())) {
            Log.e("jff", "499 ApplicationInit privatePath : " + ApplicationContext.getContext().getFilesDir().getAbsolutePath() + "/vhsm");
            return ApplicationContext.getContext().getFilesDir().getAbsolutePath() + "/vhsm";
        } else {
            ModuleLog.i("rootPath");
            return "/xdja/vhsm/net";
        }
    }

    private static boolean isSafeClientApp(Context context) {

        try {
            ActivityManager am = (ActivityManager) context.getSystemService(Activity.ACTIVITY_SERVICE);
            ComponentName cn = am.getRunningTasks(1).get(0).topActivity;


            if ("com.xdja.safeclient".equals(cn.getPackageName())
                    || "com.xdja.uaac".equals(cn.getPackageName())) {
                return true;
            } else {
                return false;
            }
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }


    private static File getFile(File storageDir, String childPath) {
        File file;
        if (null == storageDir) {
            file = new File("", childPath);
        } else {
            file = new File(storageDir, childPath);
        }
        return file;
    }

    private static boolean isFileExist(final String file_Dir, File storageDir) {
        String randFilePath = file_Dir + "/rand.bin";
        String kdatFilePath = file_Dir + "/vhsm.dat";
        String wboxFilePath = file_Dir + "/wbox.lib";
        String vhsmLibFilePath = file_Dir + "/vhsm.lib";


        File randFile = getFile(storageDir, randFilePath);
        ModuleLog.e("randFilePath : " + randFilePath);
        if (!randFile.exists()) {
            ModuleLog.e("null ");
            return false;
        }

        File kdatFile = getFile(storageDir, kdatFilePath);
        if (!kdatFile.exists()) {
            return false;
        }
        File wboxFile = getFile(storageDir, wboxFilePath);
        if (!wboxFile.exists()) {
            return false;
        }
        File vhsmLibFile = getFile(storageDir, vhsmLibFilePath);
        if (!vhsmLibFile.exists()) {
            return false;
        }
        return true;
    }


}
