package com.xdja.safeclient.certcreation.activity;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.StringRes;

import com.aircert.BusProvider;
import com.aircert.CommonActivity.ToolBarActivity;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.service.CertService;
import com.xdja.safeclient.certcreation.task.AirActivityStackManager;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.view.LoadingDialog;

/**
 * Created by Administrator on 2018/7/17 0017.
 */

public abstract class BaseActivity extends ToolBarActivity {

    // FIXME: 2019/12/5 0005 默认值为false，只有当调试AAR时才是true
    public static final boolean DEBUG_AAR = true;

    protected LoadingDialog dialog;

    protected CertService service;

    private Context context;

    public Context getContext() {
        return context;
    }

    private int contentResID;

    protected LoadingDialog buildDialog() {
        LoadingDialog loadingDialog;

        loadingDialog = new LoadingDialog(this, setLoadingText());

        loadingDialog.setCancelable(setDialogCancelable());


        return loadingDialog;

    }

    protected LoadingDialog buildDialog(@StringRes int resId) {
        LoadingDialog loadingDialog;

        loadingDialog = new LoadingDialog(this, resId);

        loadingDialog.setCancelable(setDialogCancelable());
        return loadingDialog;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        AirActivityStackManager.getInstance().add(this);
        overridePendingTransition(R.anim.left_in, R.anim.left_out);
        context = this;
        BusProvider.getMainProvider().register(this);
        super.onCreate(savedInstanceState);

        dialog = buildDialog();
        service = new CertService();

        getData();

    }

    protected void getData() {

            // 融合版读取intent
            getIntentData();

    }

    protected void getIntentData() {

    }

    protected int setLoadingText() {
        return R.string.cert_creation_loading_tips;
    }

    protected boolean setDialogCancelable() {
        return true;
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        AirActivityStackManager.getInstance().remove(this);
        BusProvider.getMainProvider().unregister(this);
        dismissLoading();

//        FixHWLeak.fixLeak(context);

    }

    @Override
    public void onBackPressed() {
        super.onBackPressed();
        overridePendingTransition(R.anim.right_in, R.anim.right_out);
    }

    /**
     * 将网络请求的Loading统一封装展示
     */
    protected void showLoading() {
        if (dialog == null) {
            dialog = buildDialog();
        }
        dialog.showLoading();
    }

    protected void showLoading(int resId) {
        if (dialog == null ) {
            dialog = buildDialog(resId);
        }else {
            setLoadingContent(resId);
        }
        dialog.showLoading();
    }

    protected void setLoadingContent(int id) {
        dialog.setContent(id);
    }

    /**
     * 请求返回结果后取消Loading
     */
    protected void dismissLoading() {
        if (dialog != null) {
            dialog.dismissLoading();
            dialog = null;
        }
    }


    public void showRequestError() {
        ModuleToast.show(context, R.string.cert_creation_network_err);
        DeviceWrapper.getInstance().setApplyCertEnd(false);
    }

    protected CryptoDevType getCardType() {
        return (CryptoDevType) getIntent().getSerializableExtra("cardType");
    }

    public String getCardNum() {
        return getIntent().getStringExtra("cardId");
    }

    public void post(Object object) {
        BusProvider.getMainProvider().post(object);
    }

    public void requestSuccess() {
        ModuleToast.show(context, R.string.cert_creation_success);
    }

    public void requestFail() {
        ModuleToast.show(context, R.string.cert_creation_fail);
    }

    public void requestError() {
        ModuleToast.show(context, "IO");
    }

    public String nextActivity() {
        return null;
    }

    public void next() {
        if (valid()) {
            saveValue();
            route();
        }
    }

    /**
     * 该界面的校验规则，只有都校验通过时，才能跳转到下个界面
     *
     * @return
     */
    public boolean valid() {
        return true;
    }

    public void saveValue() {

    }

    public void route() {

    }


}
