package com.xdja.safeclient.certcreation.bean.result;

import com.aircert.util.ModuleLog;
import com.xdja.safeclient.certcreation.R;

/**
 * 2.14.【I-airIssue-api-015】用户注册返回结果<br><br>
 * <font color = "red">注意，文档中如果出现结果为int的情况，属于文档错误</font> <br><br>
 * Created by zjc on 2018/6/15 0015.
 */

public class RegisterResult extends CommonResult {

    /**
     * 手机号已存在
     */
    public static final String EXIST_CELL_PHONE = "1";

    /**
     * 警号已存在
     */
    public static final String EXIST_POLICE_NUM = "2";

    /**
     * 部门已存在
     */
    public static final String EXIST_DEPARTMENT = "3";

    /**
     * 身份证号已存在
     */
    public static final String EXIST_ID = "4";

    /**
     * 人员信息已经存在不在同步
     */
    public static final String ERROR_PERSON_INFO = "5";

    @Override
    public int getErrText(String errCode) {

        if (errCode.equals(EXIST_CELL_PHONE)) {
            return R.string.cert_creation_exist_cell_phone;
        } else if (errCode.equals(EXIST_POLICE_NUM)) {
            return R.string.cert_creation_exist_police_num;
        } else if (errCode.equals(EXIST_DEPARTMENT)) {
            return R.string.cert_creation_exist_department;
        } else if (errCode.equals(EXIST_ID)) {
            return R.string.cert_creation_exist_id;
        } else if (errCode.equals(ERROR_PERSON_INFO)) {
            return R.string.cert_creation_error_person_info;
        } else {
            ModuleLog.e("未知错误");
            return R.string.cert_creation_unknown_error;
        }

    }
}
