package com.xdja.safeclient.certcreation.util;

import android.content.Context;
import android.os.Build;
import android.support.annotation.StringRes;
import android.widget.Toast;

import com.aircert.util.ModuleLog;

import java.util.HashMap;

/**
 * Created by Administrator on 2018/7/17 0017.
 */

public class ModuleToast {

    private static HashMap<String, Long> lastTime = new HashMap<>();

    public static void show(Context context, String content) {
        Toast.makeText(context, content, Toast.LENGTH_SHORT).show();
    }

    public static void show(Context context, @StringRes int resId) {
        Toast.makeText(context, resId, Toast.LENGTH_SHORT).show();
    }

    public static void showNoRepeat(Context context, String content) {

        if (Build.VERSION.SDK_INT >= 28) {
//            Android 9.0是28，Android 8.1是27，Android 8.0是26
            Toast.makeText(context, content, Toast.LENGTH_SHORT).show();
        } else {

            long current = System.currentTimeMillis();

            // 如果之前没有在Map里存储过的话，这个地方会空指针的
            long last = lastTime.get(content) == null ? 0 : lastTime.get(content);

            if (current - last > 2000) {
                lastTime.put(content, System.currentTimeMillis());
                Toast.makeText(context, content, Toast.LENGTH_SHORT).show();
            } else {
                ModuleLog.d("Toast间隔时间太短:" + content);
            }
        }

    }

    public static void showNoRepeat(Context context, @StringRes int resId) {
        showNoRepeat(context, context.getResources().getString(resId));
    }


}
