/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation;

import android.app.ActivityManager;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.telephony.TelephonyManager;
import android.util.Log;
import android.util.Pair;
import com.aircert.ApplicationContext;
import com.aircert.util.ModuleLog;
import com.micro.MicroApi;
import com.raizlabs.android.dbflow.config.FlowConfig;
import com.raizlabs.android.dbflow.config.FlowLog;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.config.cert_creationGeneratedDatabaseHolder;
import com.raizlabs.android.dbflow.sql.language.SQLite;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import com.raizlabs.android.dbflow.structure.database.AndroidDatabase;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;
import com.xdja.cryptodev.CryptoDevManager;
import com.xdja.cryptodev.driver.IDevDriver;
import com.xdja.cryptodev.driver.chipmanager.ChipManagerDriver;
import com.xdja.cryptodev.driver.skf.SkfDataInitKt;
import com.xdja.cryptodev.driver.skf.SkfDriver;
import com.xdja.log.LogModule;
import com.xdja.multichip.jniapi.JarMultiJniApiManager;
import com.xdja.multichip.jniapi.JarMultiJniApiVhsmManager;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.ChooseAddress;
import com.xdja.safeclient.certcreation.FeatureConfig;
import com.xdja.safeclient.certcreation.bean.ServerAddress;
import com.xdja.safeclient.certcreation.config.CertConfig;
import com.xdja.safeclient.certcreation.databases.DatabaseManager;
import com.xdja.safeclient.certcreation.databases.ServerSettingConfig;
import com.xdja.safeclient.certcreation.receiver.FaceResultReceiver;
import com.xdja.safeclient.certcreation.service.HttpClientHelper;
import com.xdja.safeclient.certcreation.task.ChooseTask;
import com.xdja.safeclient.certcreation.util.SharePreferencesUtil;
import com.xdja.safeclient.certcreation.util.Util;
import com.zxy.tiny.Tiny;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import kotlin.jvm.functions.Function0;
import org.joor.Reflect;

public class ApplicationInit {
    public static final String TAG = "ApplicationInit";

    public static void start(Application context) {
        ApplicationInit.initLog((Context)context);
        ApplicationContext.setContext((Context)context);
        Tiny.getInstance().init(context);
        ApplicationInit.initConfig((Context)context);
        ApplicationInit.initCrytoDev((Context)context);
        HttpClientHelper.initOkHttpClient();
        CryptoDevManager.getInstance().setLogDetail(true);
        if (ApplicationInit.isFirstInstall((Context)context)) {
            // empty if block
        }
        ApplicationInit.initReceiver((Context)context);
        ApplicationInit.chooseServerAddress();
        ApplicationInit.chooseVHSMAddress();
    }

    private static void chooseServerAddress() {
        ArrayList<ServerAddress> list = AppConfig.getInstance().getServerSettingConfig().getServerAddressList();
        int timeout = 750;
        if (list != null && list.size() != 0 && list.size() != 1) {
            timeout = 3000 / list.size();
        }
        ChooseTask task = new ChooseTask(list, timeout, new ChooseTask.ChooseResult(){

            @Override
            public void success(ServerAddress address) {
                AppConfig.getInstance().getServerSettingConfig().setIp(address.getIp());
                AppConfig.getInstance().getServerSettingConfig().setPort(address.getPort());
            }

            @Override
            public void fail(long time) {
            }
        });
        task.execute(new Void[0]);
    }

    private static void chooseVHSMAddress() {
        ArrayList<ServerAddress> list = AppConfig.getInstance().getServerSettingConfig().getVhsmAddressList();
        int timeout = 750;
        if (list != null && list.size() != 0 && list.size() != 1) {
            timeout = 3000 / list.size();
        }
        ChooseTask task = new ChooseTask(list, timeout, new ChooseTask.ChooseResult(){

            @Override
            public void success(ServerAddress address) {
                AppConfig.getInstance().getServerSettingConfig().setVhsm_ip(address.getIp());
                AppConfig.getInstance().getServerSettingConfig().setVhsm_port(address.getPort());
            }

            @Override
            public void fail(long time) {
            }
        });
        task.execute(new Void[0]);
    }

    private static void initLog(Context context) {
        LogModule.initDefault((Context)context);
    }

    public static String IS2String(InputStream in) throws IOException {
        int n;
        StringBuffer out = new StringBuffer();
        byte[] b = new byte[4096];
        while ((n = in.read(b)) != -1) {
            out.append(new String(b, 0, n));
        }
        return out.toString();
    }

    public static InputStream string2IS(String string2) {
        ByteArrayInputStream in_nocode = new ByteArrayInputStream(string2.getBytes());
        return in_nocode;
    }

    private static void initCrytoDev(final Context context) {
        ApplicationInit.setNetVHSMPath(context);
        CryptoDevManager cryptoDevManager = CryptoDevManager.getInstance();
        cryptoDevManager.setContext(context);
        try {
            cryptoDevManager.registerDriver((IDevDriver)new ChipManagerDriver());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SkfDriver skfDriver = new SkfDriver();
        SkfDataInitKt.addLibrary((SkfDriver)skfDriver, (String)"libMicroApi.so", (Function0)new Function0<Boolean>(){

            public Boolean invoke() {
                MicroApi microApi = new MicroApi();
                TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
                microApi.initTelephonyManager((TelephonyManager)context.getSystemService("phone"));
                return true;
            }
        });
        cryptoDevManager.registerDriver((IDevDriver)skfDriver);
        Log.e((String)"jff", (String)"231 ApplicationInit initCrytoDev : ");
        String vhsmChangeIP = AppConfig.getInstance().getServerSettingConfig().getVhsm_change_ip();
        String vhsmChangePort = AppConfig.getInstance().getServerSettingConfig().getVhsm_change_port();
        String sp_vhsmChangeIP = SharePreferencesUtil.getVHSMChangeIp(context);
        String sp_vhsmChangePort = SharePreferencesUtil.getVHSMChangePort(context);
        Log.e((String)"jff", (String)("238 ApplicationInit initCrytoDev IP& port : " + vhsmChangeIP + " " + sp_vhsmChangeIP + " " + vhsmChangePort + "  " + sp_vhsmChangePort));
        if (!("".equals(vhsmChangeIP) || "".equals(vhsmChangePort) || vhsmChangeIP == null || vhsmChangePort == null || vhsmChangeIP.equals(sp_vhsmChangeIP))) {
            Log.e((String)"jff", (String)"234 ApplicationInit initCrytoDev MMM: ");
            int ret = JarMultiJniApiVhsmManager.getInstance().updateServerInfo(context, true, vhsmChangeIP, Integer.parseInt(vhsmChangePort));
            if (ret == 0) {
                SharePreferencesUtil.saveVHSMChangeIp(context, vhsmChangeIP);
                SharePreferencesUtil.saveVHSMChangePort(context, vhsmChangePort);
                Log.e((String)"jff", (String)"248 ApplicationInit initCrytoDev change success: ");
            }
        }
        if (FeatureConfig.getInstance().isDisableVHSM() || !AppConfig.getInstance().getCertConfig().hasVHSM()) {
            cryptoDevManager.setDisableSoft(true);
        } else {
            cryptoDevManager.setDisableSoft(false);
        }
    }

    private static void initUpdate(Context context) {
        Reflect.on((String)"com.xdja.updatelibrary.XDJAUpdateManager").call("init", new Object[]{context});
    }

    private static void adapterDB() {
        DatabaseWrapper wrapper = FlowManager.getDatabase((String)"certDataBase").getHelper().getDelegate().getWritableDatabase();
        boolean isWAL = ((AndroidDatabase)wrapper).getDatabase().isWriteAheadLoggingEnabled();
        ((AndroidDatabase)wrapper).getDatabase().disableWriteAheadLogging();
    }

    private static void initConfig(Context context) {
        AppConfig module = AppConfig.getInstance();
        module.setContext(context);
        module.getDefaultConfig().setPin("111111");
        if (!FeatureConfig.getInstance().getDefaultPin().equals(module.getDefaultConfig().getPin())) {
            module.getDefaultConfig().setPin(FeatureConfig.getInstance().getDefaultPin());
        }
        module.getDefaultConfig().setBksVerifyCode("xdja1234");
        boolean success = context.deleteDatabase("certDataBase.db");
        ModuleLog.e((String)"Update", (Object)("\u5347\u7ea7\u524d\u5220\u9664\u6570\u636e\u5e93" + success));
        if (Util.assetFileIsExist(context, "certDataBase.db")) {
            ModuleLog.d((String)TAG, (Object)"\u6267\u884c\u6570\u636e\u5e93\u64cd\u4f5c");
            DatabaseManager.getInstance().copyAssetDatabase2PriPath(context);
            FlowManager.init((FlowConfig)new FlowConfig.Builder(context).addDatabaseHolder(cert_creationGeneratedDatabaseHolder.class).build());
            FlowLog.setMinimumLoggingLevel((FlowLog.Level)FlowLog.Level.V);
            ApplicationInit.adapterDB();
            ServerSettingConfig config = (ServerSettingConfig)SQLite.select((IProperty[])new IProperty[0]).from(ServerSettingConfig.class).querySingle();
            ModuleLog.e((Object)("339 ApplicationInit initConfig : " + config));
            if (config == null) {
                ModuleLog.e((Object)"340 ApplicationInit initConfig : config == null");
            }
            module.setServerSettingConfig(config);
            module.setCertConfig(new CertConfig());
            AppConfig.getInstance().getServerSettingConfig().setServerAddressList(ChooseAddress.initList());
            AppConfig.getInstance().getServerSettingConfig().setVhsmAddressList(ChooseAddress.initVHSMList());
            AppConfig.getInstance().getServerSettingConfig().setVhsm_change_ip(config.getVhsm_change_ip());
            AppConfig.getInstance().getServerSettingConfig().setVhsm_change_port(config.getVhsm_change_port());
        } else {
            if (!FeatureConfig.getInstance().isDisableMakeNewCert()) {
                return;
            }
            FlowManager.init((FlowConfig)new FlowConfig.Builder(context).addDatabaseHolder(cert_creationGeneratedDatabaseHolder.class).build());
            FlowLog.setMinimumLoggingLevel((FlowLog.Level)FlowLog.Level.V);
            ApplicationInit.adapterDB();
        }
    }

    public static boolean isFirstInstall(Context context) {
        return ApplicationInit.getPackageFirstInstallTime(context) == ApplicationInit.getPackageLastUpdateTime(context);
    }

    public static long getPackageFirstInstallTime(Context context) {
        String name = context.getPackageName();
        long time = 0L;
        try {
            time = context.getPackageManager().getPackageInfo((String)name, (int)0).firstInstallTime;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return time;
    }

    public static long getPackageLastUpdateTime(Context context) {
        String name = context.getPackageName();
        long time = 0L;
        try {
            time = context.getPackageManager().getPackageInfo((String)name, (int)0).lastUpdateTime;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return time;
    }

    public static void initReceiver(Context context) {
        IntentFilter filter = new IntentFilter("com.xdja.face_result");
        FaceResultReceiver receiver = new FaceResultReceiver();
        context.registerReceiver((BroadcastReceiver)receiver, filter);
    }

    private static int setNetVHSMPath(Context context) {
        Pair make = JarMultiJniApiManager.getInstance().make(context, 32);
        if ((Integer)make.first != 0) {
            if (!ApplicationInit.isSafeServiceExist(context)) {
                if (ApplicationInit.isFileExist(ApplicationInit.privatePath(), null)) {
                    JarMultiJniApiVhsmManager.getInstance().setVhsmCustomPath(ApplicationContext.getContext(), ApplicationInit.privatePath());
                    return 1;
                }
                JarMultiJniApiVhsmManager.getInstance().setVhsmPriPath(context);
                return 2;
            }
            JarMultiJniApiVhsmManager.getInstance().setVhsmPriPath(context);
            return 2;
        }
        return 1;
    }

    private static boolean isSafeServiceExist(Context context) {
        try {
            PackageManager pm = context.getPackageManager();
            pm.getPackageInfo("com.xdja.safekeyservice", 0);
            return true;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static String privatePath() {
        if (ApplicationInit.isSafeClientApp(ApplicationContext.getContext())) {
            Log.e((String)"jff", (String)("499 ApplicationInit privatePath : " + ApplicationContext.getContext().getFilesDir().getAbsolutePath() + "/vhsm"));
            return ApplicationContext.getContext().getFilesDir().getAbsolutePath() + "/vhsm";
        }
        ModuleLog.i((Object)"rootPath");
        return "/xdja/vhsm/net";
    }

    private static boolean isSafeClientApp(Context context) {
        try {
            ActivityManager am = (ActivityManager)context.getSystemService("activity");
            ComponentName cn = ((ActivityManager.RunningTaskInfo)am.getRunningTasks((int)1).get((int)0)).topActivity;
            return "com.xdja.safeclient".equals(cn.getPackageName()) || "com.xdja.uaac".equals(cn.getPackageName());
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static File getFile(File storageDir, String childPath) {
        File file = null == storageDir ? new File("", childPath) : new File(storageDir, childPath);
        return file;
    }

    private static boolean isFileExist(String file_Dir, File storageDir) {
        String randFilePath = file_Dir + "/rand.bin";
        String kdatFilePath = file_Dir + "/vhsm.dat";
        String wboxFilePath = file_Dir + "/wbox.lib";
        String vhsmLibFilePath = file_Dir + "/vhsm.lib";
        File randFile = ApplicationInit.getFile(storageDir, randFilePath);
        ModuleLog.e((Object)("randFilePath : " + randFilePath));
        if (!randFile.exists()) {
            ModuleLog.e((Object)"null ");
            return false;
        }
        File kdatFile = ApplicationInit.getFile(storageDir, kdatFilePath);
        if (!kdatFile.exists()) {
            return false;
        }
        File wboxFile = ApplicationInit.getFile(storageDir, wboxFilePath);
        if (!wboxFile.exists()) {
            return false;
        }
        File vhsmLibFile = ApplicationInit.getFile(storageDir, vhsmLibFilePath);
        return vhsmLibFile.exists();
    }
}

