/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.LinearLayout;
import com.aircert.dialog.BindIdentifyDialog;
import com.aircert.util.CommonUtil;
import com.aircert.util.HTMLText;
import com.aircert.util.ModuleLog;
import com.raizlabs.android.dbflow.sql.language.SQLite;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import com.squareup.otto.Subscribe;
import com.xdja.aspectjmodule.annotation.XdjaPermission;
import com.xdja.cryptodev.CryptoDevInfo;
import com.xdja.cryptodev.CryptoDevManager;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.cryptodev.driver.xdja.XdjaDevExtraInfo;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.FeatureConfig;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.AboutActivity;
import com.xdja.safeclient.certcreation.activity.BaseActivity;
import com.xdja.safeclient.certcreation.activity.PhoneInputActivity;
import com.xdja.safeclient.certcreation.adapter.RecyclerViewAdapter;
import com.xdja.safeclient.certcreation.bean.CertItemBean;
import com.xdja.safeclient.certcreation.bean.ServerAddress;
import com.xdja.safeclient.certcreation.bean.device.CardType;
import com.xdja.safeclient.certcreation.databases.TableCertConfig;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.device.NetVHSMHandle;
import com.xdja.safeclient.certcreation.event.ChooseAddressEvent;
import com.xdja.safeclient.certcreation.event.PhonePermissionResult;
import com.xdja.safeclient.certcreation.event.QueryFinishEvent;
import com.xdja.safeclient.certcreation.event.RefreshListEvent;
import com.xdja.safeclient.certcreation.event.RequestPhonePermission;
import com.xdja.safeclient.certcreation.event.RevokeSuccessEvent;
import com.xdja.safeclient.certcreation.event.SwipeEnableEvent;
import com.xdja.safeclient.certcreation.task.ChooseTask;
import com.xdja.safeclient.certcreation.util.CryptoDevTypeUtil;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import com.xdja.safeclient.certcreation.util.SharePreferencesUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.joor.Reflect;

public class CertViewActivity
extends BaseActivity
implements View.OnClickListener {
    private RecyclerView recyclerView;
    private RecyclerViewAdapter recyclerViewAdapter;
    private RecyclerView.LayoutManager layoutManager;
    private LinearLayout noChip;
    private SwipeRefreshLayout swipe;
    private boolean isFirstStart = true;
    private int navigateType;
    private int titleRes;
    private int type = -1;
    private String cardID;
    private boolean isResumeExe = true;
    private List<CertItemBean> certItemBeans = null;
    private long lastClickTime;
    private String[] permissions = new String[]{"android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_PHONE_STATE"};
    public static final int PERMISSION_CODE = 23;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        this.initConfigView();
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_cert_view);
        this.setRightImage(R.drawable.settings, this);
        ModuleLog.e((Object)"");
        this.initView();
    }

    private void initConfigView() {
        this.navigateType = 0;
        this.titleRes = R.string.cert_creation_cert_view;
        if (FeatureConfig.getInstance().isDisableVHSM() || !AppConfig.getInstance().getCertConfig().hasVHSM()) {
            CryptoDevManager.getInstance().setDisableSoft(true);
        } else {
            CryptoDevManager.getInstance().setDisableSoft(false);
        }
    }

    private void updateApp() {
        Reflect.on((String)"com.xdja.updatelibrary.XDJAUpdateExecutor").call("getInstance").call("onForceShowUpdateDialog", new Object[]{this.getContext()});
    }

    protected int getToolbarType() {
        return this.navigateType;
    }

    protected int getTitleRes() {
        return this.titleRes;
    }

    protected void onResume() {
        super.onResume();
        if (!this.isResumeExe) {
            return;
        }
        if (this.isFirstStart) {
            this.isFirstStart = false;
            if (this.checkValidPermission(this.permissions)) {
                ModuleLog.e((Object)"");
                this.getCertAndShow();
            } else {
                this.showInvalidPermissionDialog();
            }
        }
    }

    private boolean checkValidPermission(String ... permissions) {
        for (String permission2 : permissions) {
            if (ContextCompat.checkSelfPermission((Context)this, (String)permission2) == 0) continue;
            return false;
        }
        return true;
    }

    private void getCertAndShow() {
        if (this.recyclerViewAdapter != null && !this.recyclerViewAdapter.getIsRefresh()) {
            this.recyclerViewAdapter.setIsRefresh(true);
            ModuleLog.e((Object)"\u4e0d\u518d\u5237\u65b0");
            return;
        }
        this.noChip = (LinearLayout)this.findViewById(R.id.no_chip);
        this.recyclerViewAdapter.clear();
        ModuleLog.e((Object)"");
        this.certItemBeans = this.initList(this.getCurrentCardTypeList());
        if (this.certItemBeans == null || this.certItemBeans.size() == 0) {
            this.swipe.setVisibility(8);
            this.noChip.setVisibility(0);
        } else {
            this.swipe.setVisibility(0);
            this.noChip.setVisibility(8);
            this.recyclerViewAdapter.addAll(this.certItemBeans);
        }
    }

    private void showInvalidPermissionDialog() {
        ArrayList<String> list = new ArrayList<String>();
        if (ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
            list.add(this.getString(R.string.verify_permission_content_item2));
        }
        if (ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.READ_PHONE_STATE") != 0) {
            list.add(this.getString(R.string.verify_permission_content_item3));
        }
        String permission2 = HTMLText.formatPermissionText((Context)this, list);
        final BindIdentifyDialog bindIdentifyDialog = new BindIdentifyDialog((Context)this);
        bindIdentifyDialog.setTitle(R.string.verify_permission_title);
        bindIdentifyDialog.setMessage(permission2);
        bindIdentifyDialog.setModel(2);
        bindIdentifyDialog.setNegativeButtonText(R.string.cert_creation_cancel);
        bindIdentifyDialog.setPositiveButtonText(R.string.cert_creation_ok);
        bindIdentifyDialog.setCancelable(false);
        bindIdentifyDialog.setCanceledOnTouchOutside(false);
        bindIdentifyDialog.show();
        bindIdentifyDialog.setClickListener(new BindIdentifyDialog.ClickListenerInterface(){

            public void doConfirm() {
                bindIdentifyDialog.dismiss();
                CertViewActivity.this.checkoutPermission();
            }

            public void doCancel() {
                bindIdentifyDialog.dismiss();
                CertViewActivity.this.finish();
            }
        });
    }

    @Subscribe
    public void requestPhonePermission(RequestPhonePermission requestPhonePermission) {
        ModuleLog.d((Object)("3\u6536\u5230\u8bf7\u6c42\u51c6\u5907\u7533\u8bf7\u7535\u8bdd\u6743\u9650\uff1a" + ((Object)((Object)this)).toString()));
        this.type = requestPhonePermission.getType();
        this.cardID = requestPhonePermission.getCardID();
        this.requestPhonePermission();
    }

    @XdjaPermission(permissions={"android.permission.READ_PHONE_STATE"})
    private void requestPhonePermission() {
        if (Build.VERSION.SDK_INT < 23) {
            this.sendPhonePermissionResult();
        }
    }

    private void sendPhonePermissionResult() {
        ModuleLog.d((Object)("5\u7535\u8bdd\u6743\u9650\u5141\u8bb8\u7ed3\u679c\u53d1\u9001\uff1a" + ((Object)((Object)this)).toString()));
        OttoUtil.postPhonePermissionResult(this.type);
        this.type = -1;
    }

    @Subscribe
    public void onPhonePermission(PhonePermissionResult phonePermissionResult) {
        this.applyCert(phonePermissionResult.getType());
    }

    private void applyCert(int cardType) {
        if (this.getTopActivity((Activity)this).contains("PhoneInputActivity")) {
            ModuleLog.d((Object)"\u754c\u9762\u5df2\u5b58\u5728\uff0c\u653e\u5f03");
            return;
        }
        ModuleLog.d((Object)("7\u53ef\u4ee5\u542f\u52a8\u65b0\u754c\u9762\uff1a" + ((Object)((Object)this)).toString()));
        SharePreferencesUtil.saveCurrentDevType((Context)this, cardType);
        SharePreferencesUtil.saveDevCardID((Context)this, this.cardID);
        if (this.recyclerViewAdapter != null) {
            this.recyclerViewAdapter.setIsRefresh(false);
        }
        this.routePhoneInput(cardType);
    }

    private void routePhoneInput(int cardType) {
        Intent intent = new Intent((Context)this, PhoneInputActivity.class);
        intent.putExtra("cardType", (Serializable)CryptoDevTypeUtil.formatType(cardType));
        intent.putExtra("cardNum", this.cardID);
        this.startActivity(intent);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (this.recyclerViewAdapter != null) {
            this.recyclerViewAdapter.destroy();
        }
    }

    private List<String> getCurrentCardTypeList() {
        ArrayList<String> cardTypeList = new ArrayList<String>();
        Map<Integer, CryptoDevInfo> devInfoMap = DeviceWrapper.getInstance().getDevInfo();
        if (devInfoMap != null) {
            for (Map.Entry<Integer, CryptoDevInfo> cryptoDevInfoEntry : devInfoMap.entrySet()) {
                if (cryptoDevInfoEntry == null) continue;
                cardTypeList.add(CardType.toString(cryptoDevInfoEntry.getValue().getType()));
            }
        }
        return cardTypeList;
    }

    private List<CertItemBean> initList(List<String> currentCardTypeList) {
        CertItemBean bean;
        Map<Integer, CryptoDevInfo> currentCardMaps = DeviceWrapper.getInstance().getDevInfo();
        ArrayList<CertItemBean> all = new ArrayList<CertItemBean>();
        List tableValue = new ArrayList();
        try {
            tableValue = SQLite.select((IProperty[])new IProperty[0]).from(TableCertConfig.class).queryList();
        }
        catch (Exception exception) {
            // empty catch block
        }
        HashSet<String> tableCardSet = new HashSet<String>();
        for (TableCertConfig config : tableValue) {
            String cardType = config.getCardType();
            tableCardSet.add(cardType);
            if (cardType.equals("\u79bb\u7ebfVHSM") || cardType.equals("VHSM")) {
                CryptoDevInfo netVhsm = new CryptoDevInfo();
                String cardId = NetVHSMHandle.getNetVhsmCardId((Context)this);
                netVhsm.setCardId(cardId == null ? "" : cardId);
                netVhsm.setDriver("ChipManagerDriver");
                netVhsm.setType(CryptoDevType.DEV_TYPE_Soft);
                XdjaDevExtraInfo extraInfo = new XdjaDevExtraInfo();
                netVhsm.setPrivateData((Object)extraInfo.setType(32));
                CertItemBean bean2 = new CertItemBean();
                bean2.setCertConfig(config);
                bean2.setCryptoDevInfo(netVhsm);
                all.add(bean2);
                continue;
            }
            if (!currentCardTypeList.contains(cardType)) continue;
            bean = new CertItemBean();
            bean.setCertConfig(config);
            bean.setCryptoDevInfo(currentCardMaps.get(CardType.toType(cardType).getType()));
            all.add(bean);
        }
        for (String currentCardType : currentCardTypeList) {
            if (tableCardSet.contains(currentCardType)) continue;
            TableCertConfig tableCertConfig = TableCertConfig.initDefaultOne();
            tableCertConfig.cardType = currentCardType;
            bean = new CertItemBean();
            bean.setCryptoDevInfo(currentCardMaps.get(CardType.toType(currentCardType).getType()));
            bean.setCertConfig(tableCertConfig);
            all.add(bean);
        }
        ModuleLog.d(all);
        Collections.sort(all);
        return all;
    }

    private void initView() {
        this.swipe = (SwipeRefreshLayout)this.findViewById(R.id.swipe);
        this.swipe.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener(){

            public void onRefresh() {
                CertViewActivity.this.pullToRefresh();
            }
        });
        this.swipe.setEnabled(!FeatureConfig.getInstance().isDisableMakeNewCert());
        this.layoutManager = new LinearLayoutManager((Context)this, 1, false);
        ModuleLog.e((Object)"");
        this.recyclerViewAdapter = new RecyclerViewAdapter((Context)this, ((Object)((Object)this)).toString());
        this.recyclerView = (RecyclerView)this.findViewById(R.id.recyclerview);
        this.recyclerView.setLayoutManager(this.layoutManager);
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.recyclerViewAdapter);
        this.rightBtn.setVisibility(8);
    }

    @Subscribe
    public void handSwipeEnable(SwipeEnableEvent event) {
        this.swipe.setEnabled(event.isSwipToPull());
    }

    private void pullToRefresh() {
        String ip = AppConfig.getInstance().getServerSettingConfig().getIp();
        if (ip == null) {
            this.swipe.setRefreshing(false);
            return;
        }
        if (ip.contains("|")) {
            this.swipe.setRefreshing(false);
            if (!CommonUtil.isNetworkConnected((Context)this)) {
                return;
            }
            this.showLoading(R.string.cert_creation_choose_address);
            final ArrayList<ServerAddress> serverAddressArrayList = AppConfig.getInstance().getServerSettingConfig().getServerAddressList();
            int singleTimeout = 2000;
            ChooseTask task = new ChooseTask(serverAddressArrayList, 2000, new ChooseTask.ChooseResult(){

                @Override
                public void success(ServerAddress address) {
                    CertViewActivity.this.dismissLoading();
                    AppConfig.getInstance().getServerSettingConfig().setIp(address.getIp());
                    AppConfig.getInstance().getServerSettingConfig().setPort(address.getPort());
                    CertViewActivity.this.recyclerViewAdapter.refresh();
                }

                @Override
                public void fail(long time) {
                    int totalTime = serverAddressArrayList.size() * 2000;
                    long rest = (long)totalTime - time;
                    new Handler().postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            CertViewActivity.this.dismissLoading();
                        }
                    }, rest > 0L ? rest : 0L);
                }
            });
            task.execute(new Void[0]);
        } else {
            this.recyclerViewAdapter.refresh();
        }
    }

    public void onClick(View view) {
        if (view.getId() == R.id.title_right_btn) {
            Intent intent = new Intent();
            intent.setClass((Context)this, AboutActivity.class);
            this.startActivity(intent);
        }
    }

    private void checkoutPermission() {
        ActivityCompat.requestPermissions((Activity)this, (String[])new String[]{"android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_PHONE_STATE"}, (int)23);
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        ModuleLog.d((Object)"\u6743\u9650\u56de\u8c03");
        boolean isGrant = false;
        for (int grantResult : grantResults) {
            if (grantResult != 0) {
                isGrant = false;
                break;
            }
            isGrant = true;
        }
        this.onRequestPermissionsResult(isGrant);
    }

    private void onRequestPermissionsResult(boolean isGrant) {
        this.isResumeExe = false;
        this.getWindow().getDecorView().postDelayed(new Runnable(){

            @Override
            public void run() {
                CertViewActivity.this.isResumeExe = true;
                CertViewActivity.this.getCertAndShow();
            }
        }, 10L);
    }

    public void finish() {
        super.finish();
    }

    @Override
    public void onBackPressed() {
        super.onBackPressed();
    }

    @Subscribe
    public void handleQueryFinished(QueryFinishEvent event) {
        this.swipe.setRefreshing(false);
    }

    @Subscribe
    public void handleRevokeSuccess(RevokeSuccessEvent event) {
        this.recyclerViewAdapter.notifyDataSetChanged();
        Intent intent = new Intent("com.xdja.aircert.revoke.success");
        this.sendBroadcast(intent);
    }

    @Subscribe
    public void handleChooseAddressEvent(ChooseAddressEvent event) {
        if (event.isShow()) {
            this.showLoading(R.string.cert_creation_choose_address);
        } else {
            this.dismissLoading();
        }
    }

    @Subscribe
    public void handleRefreshListEvent(RefreshListEvent event) {
        this.recyclerViewAdapter.refresh();
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
    }
}

