package com.xdja.safeclient.certcreation.activity;

import static com.aircert.CommonActivity.ToolBarActivity.ToolBarDef.NAVIGATE_BACK;
import static com.aircert.CommonActivity.ToolBarActivity.ToolBarDef.NAVIGATE_DEFAULT;

import android.Manifest;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.View;
import android.widget.LinearLayout;

import com.aircert.dialog.BindIdentifyDialog;
import com.aircert.util.CommonUtil;
import com.aircert.util.HTMLText;
import com.aircert.util.ModuleLog;
import com.raizlabs.android.dbflow.sql.language.SQLite;
import com.squareup.otto.Subscribe;
import com.xdja.aspectjmodule.annotation.XdjaPermission;
import com.xdja.cryptodev.CryptoDevInfo;
import com.xdja.cryptodev.CryptoDevManager;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.cryptodev.driver.chipmanager.ChipManagerDriver;
import com.xdja.cryptodev.driver.xdja.XdjaDevExtraInfo;
import com.xdja.multichip.param.JniApiParam;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.BuildConfig;
import com.xdja.safeclient.certcreation.FeatureConfig;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.adapter.RecyclerViewAdapter;
import com.xdja.safeclient.certcreation.bean.CertItemBean;
import com.xdja.safeclient.certcreation.bean.ServerAddress;
import com.xdja.safeclient.certcreation.bean.device.CardType;
import com.xdja.safeclient.certcreation.databases.TableCertConfig;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.device.NetVHSMHandle;
import com.xdja.safeclient.certcreation.event.ChooseAddressEvent;
import com.xdja.safeclient.certcreation.event.PhonePermissionResult;
import com.xdja.safeclient.certcreation.event.QueryFinishEvent;
import com.xdja.safeclient.certcreation.event.RefreshListEvent;
import com.xdja.safeclient.certcreation.event.RequestPhonePermission;
import com.xdja.safeclient.certcreation.event.RevokeSuccessEvent;
import com.xdja.safeclient.certcreation.event.SwipeEnableEvent;
import com.xdja.safeclient.certcreation.task.ChooseTask;
import com.xdja.safeclient.certcreation.util.CryptoDevTypeUtil;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import com.xdja.safeclient.certcreation.util.SharePreferencesUtil;

import org.joor.Reflect;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;


public class CertViewActivity extends BaseActivity implements View.OnClickListener {

    private RecyclerView recyclerView;
    private RecyclerViewAdapter recyclerViewAdapter;
    private RecyclerView.LayoutManager layoutManager;
    private LinearLayout noChip;

    public SwipeRefreshLayout swipe;

    private boolean isFirstStart = true;//是否是第一次启动

    private int navigateType;
    private int titleRes;

    private int type = -1;  //申请权限的芯片类型

    private String cardID;
    private boolean isResumeExe = true;  // onResume 中的方法是否执行

    private List<CertItemBean> certItemBeans = null;

    private long lastClickTime;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        initConfigView();
        super.onCreate(savedInstanceState);
        Log.d("jff", "96 CertViewActivity onCreate : ");

        setContentView(R.layout.activity_cert_view);
        setRightImage(R.drawable.settings, this);
        ModuleLog.e("");
        initView();
        if (!BuildConfig.isAAR) {
            // TODO: 2019/7/20 独立版进入详情页如果需要检测升级怎么处理
            updateApp();
        }

    }

    private void initConfigView() {
        // AAR显示左上角的返回列表，独立版隐藏
        if (BuildConfig.isAAR) {
            navigateType = NAVIGATE_BACK;
            titleRes = R.string.cert_creation_cert_view;
        } else {
            navigateType = NAVIGATE_DEFAULT;
            titleRes = R.string.cert_creation_air_cert;
        }


        //是否屏蔽软卡 true屏蔽    false不屏蔽
        if (FeatureConfig.getInstance().isDisableVHSM() ||
                !AppConfig.getInstance().getCertConfig().hasVHSM()) {
            CryptoDevManager.getInstance().setDisableSoft(true);
        } else {
            CryptoDevManager.getInstance().setDisableSoft(false);
        }


    }

    @Override
    protected void onStart() {
        super.onStart();
    }

    /**
     * 检测升级
     */
    private void updateApp() {
        {
            //使用反射前
            //XDJAUpdateExecutor.getInstance().onForceShowUpdateDialog(context);
        }

        {
            //使用反射后
            if (BuildConfig.compileUpdate) {
                Reflect.on("com.xdja.updatelibrary.XDJAUpdateExecutor")
                        .call("getInstance")
                        .call("onForceShowUpdateDialog", getContext());
            }
        }
    }


    @Override
    protected int getToolbarType() {
        return navigateType;
    }

    @Override
    protected int getTitleRes() {
        return titleRes;
    }


    private String[] permissions = new String[]{
            Manifest.permission.WRITE_EXTERNAL_STORAGE,
            Manifest.permission.READ_PHONE_STATE,};

    @Override
    protected void onResume() {

        super.onResume();
        Log.d("jff", "171 CertViewActivity onResume : ");

        if (!isResumeExe) {
            return;
        }

        if (isFirstStart) {
            isFirstStart = false;
            //第一次启动时，如果所有权限都可以获取，则直接展示证书列表；否则弹框提示用户申请权限
            if (checkValidPermission(permissions)) {
                ModuleLog.e("");
                getCertAndShow();
            } else {
                showInvalidPermissionDialog();
            }
        } else {
            //            getCertAndShow();
        }


    }


    /**
     * 判断是否所有权限都开启
     *
     * @param permissions
     * @return
     */
    private boolean checkValidPermission(String... permissions) {
        Log.d("jff", "201 CertViewActivity checkValidPermission 1: ");
        for (String permission : permissions) {
            if (ContextCompat.checkSelfPermission(this, permission) != PackageManager.PERMISSION_GRANTED) {
                Log.e("jff", "204 CertViewActivity checkValidPermission 2: ");
                return false;
            }
        }
        return true;
    }


    /**
     * 获取证书并展示
     */
    private void getCertAndShow() {
        Log.d("jff", "216 CertViewActivity getCertAndShow : ");
        //是否需要刷新
        if (this.recyclerViewAdapter != null && !this.recyclerViewAdapter.getIsRefresh()) {
            this.recyclerViewAdapter.setIsRefresh(true);
            ModuleLog.e("不再刷新");
            return;
        }
        noChip = (LinearLayout) findViewById(R.id.no_chip);
        recyclerViewAdapter.clear();

        ModuleLog.e("");
        this.certItemBeans = initList(getCurrentCardTypeList());

        if (this.certItemBeans == null || this.certItemBeans.size() == 0) {
            swipe.setVisibility(View.GONE);
            noChip.setVisibility(View.VISIBLE);
        } else {
            swipe.setVisibility(View.VISIBLE);
            noChip.setVisibility(View.GONE);

            recyclerViewAdapter.addAll(this.certItemBeans);
        }

    }


    /**
     * 弹窗提示用户用户开启权限
     */
    private void showInvalidPermissionDialog() {
        Log.e("jff", "246 CertViewActivity showInvalidPermissionDialog : 提示用户打开权限");

        ArrayList<String> list = new ArrayList<>();
        //
        //if (ContextCompat.checkSelfPermission(this, Manifest.permission.CAMERA)
        //        != PackageManager.PERMISSION_GRANTED) {
        //    list.add(getString(R.string.verify_permission_content_item1));
        //}

        if (ContextCompat.checkSelfPermission(this, Manifest.permission.WRITE_EXTERNAL_STORAGE)
                != PackageManager.PERMISSION_GRANTED) {
            list.add(getString(R.string.verify_permission_content_item2));
        }


        if (ContextCompat.checkSelfPermission(this, Manifest.permission.READ_PHONE_STATE)
                != PackageManager.PERMISSION_GRANTED) {
            list.add(getString(R.string.verify_permission_content_item3));
        }

        String permission = HTMLText.formatPermissionText(this, list);

        final BindIdentifyDialog bindIdentifyDialog = new BindIdentifyDialog(this);

        bindIdentifyDialog.setTitle(R.string.verify_permission_title);
        bindIdentifyDialog.setMessage(permission);
        bindIdentifyDialog.setModel(BindIdentifyDialog.MID_MODEL);
        bindIdentifyDialog.setNegativeButtonText(R.string.cert_creation_cancel);
        bindIdentifyDialog.setPositiveButtonText(R.string.cert_creation_ok);
        bindIdentifyDialog.setCancelable(false);
        bindIdentifyDialog.setCanceledOnTouchOutside(false);
        bindIdentifyDialog.show();
        bindIdentifyDialog.setClickListener(new BindIdentifyDialog.ClickListenerInterface() {
            @Override
            public void doConfirm() {
                bindIdentifyDialog.dismiss();
                // TODO: 2020/6/18 0018 需要增加权限处理
                // TODO: 2020/6/18 0018 需要增加其他页面的权限处理 主要是摄像头权限

                checkoutPermission();
                //                getCertAndShow();
            }

            @Override
            public void doCancel() {
                bindIdentifyDialog.dismiss();
                CertViewActivity.this.finish();
            }
        });
    }

    /**
     * 申请证书之前先进行权限检测
     *
     * @param requestPhonePermission
     */
    @Subscribe
    public void requestPhonePermission(RequestPhonePermission requestPhonePermission) {
        ModuleLog.d("3收到请求准备申请电话权限：" + this.toString());
        this.type = requestPhonePermission.getType();
        this.cardID = requestPhonePermission.getCardID();
        requestPhonePermission();
    }


    @XdjaPermission(permissions = {
            Manifest.permission.READ_PHONE_STATE
    })
    private void requestPhonePermission() {

        Log.d("jff", "316 CertViewActivity requestPhonePermission : ");
        //android版本低于23时，不进行权限检测，执行当前方法 gyx 2018.8.29
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.M) {
            sendPhonePermissionResult();
        }


    }

    private void sendPhonePermissionResult() {
        Log.e("jff", "326 CertViewActivity sendPhonePermissionResult : ");
        ModuleLog.d("5电话权限允许结果发送：" + this.toString());
        OttoUtil.postPhonePermissionResult(CertViewActivity.this.type);
        CertViewActivity.this.type = -1;


    }

    @Subscribe
    public void onPhonePermission(PhonePermissionResult phonePermissionResult) {
        applyCert(phonePermissionResult.getType());
    }

    private void applyCert(int cardType) {
        //为了防止PhoneInputActivity出现多次，进行以下操作
        // 1.两次启动时间在1秒内不再启动
        // 2.是判断下栈顶Activity，如果是则不再启动
        // getTopActivity(context)值如下
        //ComponentInfo {com.xdja.aircert/com.xdja.safeclient.certcreation.activity.PhoneInputActivity}
        //3.进入手机号输入界面再次查询对应的证书是否存在
        if (getTopActivity(this).contains("PhoneInputActivity")) {
            ModuleLog.d("界面已存在，放弃");
            return;
        } else {
            ModuleLog.d("7可以启动新界面：" + this.toString());
        }

        SharePreferencesUtil.saveCurrentDevType(this, cardType);
        SharePreferencesUtil.saveDevCardID(this, cardID);
        if (recyclerViewAdapter != null) {
            recyclerViewAdapter.setIsRefresh(false);
        }

        // 注意applyCert方法中用的都是cardType，不是type

        routePhoneInput(cardType);
    }

    /**
     * @param cardType
     */
    private void routePhoneInput(int cardType) {
        Intent intent = new Intent(this, PhoneInputActivity.class);
        intent.putExtra("cardType", CryptoDevTypeUtil.formatType(cardType));
        intent.putExtra("cardNum", cardID);
        startActivity(intent);
    }


    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (recyclerViewAdapter != null) {
            recyclerViewAdapter.destroy();
        }
    }

    /**
     * 读取当前设备实际上存在的设备类型
     *
     * @return
     */
    private List<String> getCurrentCardTypeList() {

        List<String> cardTypeList = new ArrayList<>();

        Map<Integer, CryptoDevInfo> devInfoMap = DeviceWrapper.getInstance().getDevInfo();

        if (devInfoMap != null) {
            for (Map.Entry<Integer, CryptoDevInfo> cryptoDevInfoEntry : devInfoMap.entrySet()) {

                if (cryptoDevInfoEntry != null) {
                    cardTypeList.add(CardType.toString(cryptoDevInfoEntry.getValue().getType()));
                }

            }
        }

        return cardTypeList;
    }


    private List<CertItemBean> initList(List<String> currentCardTypeList) {
        // 已有设备
        Map<Integer, CryptoDevInfo> currentCardMaps = DeviceWrapper.getInstance().getDevInfo();

        List<CertItemBean> all = new ArrayList<>();

        // 先读配置好的数据库中所有的数据
        List<TableCertConfig> tableValue = new ArrayList<>();

        try {
            tableValue = SQLite.select().from(TableCertConfig.class).queryList();
        } catch (Exception e) {
            // 这个try-catch是融合版空包可能会走到异常里
        }

        HashSet<String> tableCardSet = new HashSet();

        // 如果当前设备列表中的设备在数据库中存在，则加入该条（配置）数据
        for (TableCertConfig config : tableValue) {

            String cardType = config.getCardType();

            tableCardSet.add(cardType);

            // 在线VHSM和离线VHSM，也就是软卡，不属于硬件设备（卡），都要展示的
            if (cardType.equals(CardType.OFFLINE_VHSM)
                    || cardType.equals(CardType.ONLINE_VHSM)
                    //添加该机型限制是因为郑州社治委VHSM做了限制，只有该型号的手机可以使用VHSM
                    //&& SystemUtil.getSystemModel().equals("CMA-AN00")
            ) {

                CryptoDevInfo netVhsm = new CryptoDevInfo();
                String cardId = NetVHSMHandle.getNetVhsmCardId(this);
                netVhsm.setCardId(cardId == null ? "" : cardId);
                netVhsm.setDriver(ChipManagerDriver.driverName);
                netVhsm.setType(CryptoDevType.DEV_TYPE_Soft);

                XdjaDevExtraInfo extraInfo = new XdjaDevExtraInfo();
                netVhsm.setPrivateData((Object) extraInfo.setType(JniApiParam.TYPE_VHSM_NET));

                CertItemBean bean = new CertItemBean();
                bean.setCertConfig(config);
                bean.setCryptoDevInfo(netVhsm);
                all.add(bean);

            } else {
                if (currentCardTypeList.contains(cardType)) {

                    CertItemBean bean = new CertItemBean();
                    bean.setCertConfig(config);
                    bean.setCryptoDevInfo(currentCardMaps.get(CardType.toType(cardType).getType()));

                    all.add(bean);

                }
            }

        }

        // 如果当前已获取的设备未在数据库中配置，
        // 则用默认容器号、证书类型、算法类型、证书机制加入该条（配置）数据
        for (String currentCardType : currentCardTypeList) {
            if (!tableCardSet.contains(currentCardType)) {

                TableCertConfig tableCertConfig = TableCertConfig.initDefaultOne();

                tableCertConfig.cardType = currentCardType;


                CertItemBean bean = new CertItemBean();
                bean.setCryptoDevInfo(
                        currentCardMaps.get(CardType.toType(currentCardType).getType()));
                bean.setCertConfig(tableCertConfig);
                all.add(bean);

            }
        }

        ModuleLog.d(all);
        Collections.sort(all);
        return all;
    }


    private void initView() {
        swipe = findViewById(R.id.swipe);
        swipe.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener() {
            @Override
            public void onRefresh() {
                pullToRefresh();
            }
        });

        //下拉刷新的判断以是否有发证功能为依据，有发证可下拉刷新，无法证功能不可下拉刷新
        swipe.setEnabled(FeatureConfig.getInstance().isDisableMakeNewCert() ? false : true);

        layoutManager = new LinearLayoutManager(this, LinearLayoutManager.VERTICAL, false);
        ModuleLog.e("");
        recyclerViewAdapter = new RecyclerViewAdapter(this, this.toString());
        recyclerView = findViewById(R.id.recyclerview);
        recyclerView.setLayoutManager(layoutManager);
        recyclerView.setAdapter(recyclerViewAdapter);

        if (BuildConfig.isAAR) {
            rightBtn.setVisibility(View.GONE);
        } else {
            rightBtn.setVisibility(View.VISIBLE);
        }
    }


    @Subscribe
    public void handSwipeEnable(SwipeEnableEvent event) {
        swipe.setEnabled(event.isSwipToPull());
    }

    private void pullToRefresh() {

        String ip = AppConfig.getInstance().getServerSettingConfig().getIp();

        // 融合版空包的ip是null，此时下拉刷新直接return，不做后续操作
        if (ip == null) {
            swipe.setRefreshing(false);
            return;
        }

        if (ip.contains("|")) {

            swipe.setRefreshing(false);

            if (!CommonUtil.isNetworkConnected(this)) {
                return;
            }

            showLoading(R.string.cert_creation_choose_address);

            final ArrayList<ServerAddress> serverAddressArrayList
                    = AppConfig.getInstance().getServerSettingConfig().getServerAddressList();

            final int singleTimeout = 2000;

            ChooseTask task = new ChooseTask(
                    serverAddressArrayList
                    , singleTimeout
                    , new ChooseTask.ChooseResult() {
                @Override
                public void success(ServerAddress address) {

                    dismissLoading();

                    AppConfig.getInstance().getServerSettingConfig().setIp(address.getIp());
                    AppConfig.getInstance().getServerSettingConfig().setPort(address.getPort());

                    recyclerViewAdapter.refresh();


                }

                @Override
                public void fail(long time) {

                    int totalTime = serverAddressArrayList.size() * singleTimeout;

                    long rest = totalTime - time;

                    new Handler().postDelayed(new Runnable() {
                        @Override
                        public void run() {
                            dismissLoading();
                        }
                    }, rest > 0 ? rest : 0);

                }

            });

            task.execute();

        } else {
            recyclerViewAdapter.refresh();
        }

    }


    @Override
    public void onClick(View view) {

        if (view.getId() == R.id.title_right_btn) {
            Intent intent = new Intent();
            intent.setClass(this, AboutActivity.class);
            startActivity(intent);
        }
    }

    public static final int PERMISSION_CODE = 23;

    private void checkoutPermission() {
        Log.d("jff", "606 CertViewActivity checkoutPermission : ");
        ActivityCompat.requestPermissions(this,
                new String[]{Manifest.permission.WRITE_EXTERNAL_STORAGE,
                        Manifest.permission.READ_PHONE_STATE,
                },
                PERMISSION_CODE);
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);

        Log.d("jff", "618 CertViewActivity onRequestPermissionsResult : ");

        ModuleLog.d("权限回调");


        boolean isGrant = false;

        for (int grantResult : grantResults) {
            if (grantResult != 0) {
                isGrant = false;
                break;
            } else {
                isGrant = true;
            }
        }
        onRequestPermissionsResult(isGrant);
    }

    private void onRequestPermissionsResult(final boolean isGrant) {
        Log.d("jff", "637 CertViewActivity onRequestPermissionsResult : ");
        isResumeExe = false;
        //使用延时的原因是为了先执行onResume方法，再发送权限申请结果。
        CertViewActivity.this.getWindow().getDecorView().postDelayed(new Runnable() {
            @Override
            public void run() {
                isResumeExe = true;

                getCertAndShow();
            }
        }, 10);

    }


    @Override
    public void finish() {
        super.finish();
    }

    @Override
    public void onBackPressed() {

        if (BuildConfig.isAAR) {
            super.onBackPressed();
        } else {
            if (lastClickTime == 0) {
                lastClickTime = System.currentTimeMillis();
                ModuleToast.show(this, R.string.cert_creation_click_one_more);
            } else {
                long current = System.currentTimeMillis();
                if (current - lastClickTime < 1000) {
                    super.onBackPressed();
                } else {
                    ModuleToast.show(this, R.string.cert_creation_click_one_more);
                }
                lastClickTime = current;
            }
        }
    }

    @Subscribe
    public void handleQueryFinished(QueryFinishEvent event) {
        //ModuleToast.show(this, "刷新结束");
        swipe.setRefreshing(false);
    }

    @Subscribe
    public void handleRevokeSuccess(RevokeSuccessEvent event) {
        recyclerViewAdapter.notifyDataSetChanged();
        //撤销成功之后发送广播，融合版安全接入断开网关 jff-2020.11.18
        Intent intent = new Intent("com.xdja.aircert.revoke.success");
        sendBroadcast(intent);
    }

    @Subscribe
    public void handleChooseAddressEvent(ChooseAddressEvent event) {
        if (event.isShow()) {
            showLoading(R.string.cert_creation_choose_address);
        } else {
            dismissLoading();
        }

    }

    @Subscribe
    public void handleRefreshListEvent(RefreshListEvent event) {
        recyclerViewAdapter.refresh();
    }

    @Override
    protected void showLoading() {
        super.showLoading();
    }

    @Override
    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
    }

}
