package com.xdja.safeclient.certcreation.activity;

import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.RadioButton;

import com.raizlabs.android.dbflow.sql.language.SQLite;
import com.xdja.safeclient.certcreation.BuildConfig;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.bean.ServerAddress;
import com.xdja.safeclient.certcreation.config.Procedure;
import com.xdja.safeclient.certcreation.databases.ServerSettingConfig;

import java.util.ArrayList;

/**
 * Created by zjc on 2019/5/21 0021.
 */
public class ConfigStep2Activity extends BaseActivity implements View.OnClickListener {

    private View layoutStandard;
    private RadioButton standard;
    private View layoutStdNoOCR;
    private RadioButton stdNoOCR;
    private View layoutStdNoNFC;
    private RadioButton stdNoNFC;
    private View layoutSimplified;
    private RadioButton simplified;
    private View layoutPhone;
    private RadioButton phone;
    private View layoutPhoneUpgrade;
    private RadioButton phoneUpgrade;

    private View layoutPhoneSms;
    private RadioButton phoneSms;


    private Button next;

    public String projectName;

    public ArrayList<ServerAddress> serverAddressesList = new ArrayList<>();

    public ArrayList<ServerAddress> vhsmAddressList = new ArrayList<>();

    public ServerAddress vhsmChangeip = new ServerAddress();

    public boolean enableVHSM;

    public String certPath;

    public String enableHHY;

    public String enableRevoke;

    @Override
    protected void getIntentData() {
        super.getIntentData();

        projectName = getIntent().getStringExtra("projectName");

        serverAddressesList = getIntent().getParcelableArrayListExtra("serverAddressesList");

        vhsmAddressList = getIntent().getParcelableArrayListExtra("vhsmAddressList");
        vhsmChangeip = getIntent().getParcelableExtra("vhsmChangeip");

        enableVHSM = getIntent().getBooleanExtra("enableVHSM", false);
        enableHHY = getIntent().getStringExtra("enableHHY");
        enableRevoke = getIntent().getStringExtra("enableRevoke");

        certPath = getIntent().getStringExtra("certPath");

    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_config_step2);


        initView();

        initViewByData();
    }

    private void initView() {

        layoutStandard = findViewById(R.id.layout_standard);
        layoutStandard.setOnClickListener(this);

        standard = findViewById(R.id.standard);
        standard.setClickable(false);

        layoutStdNoOCR = findViewById(R.id.layout_std_no_ocr);
        layoutStdNoOCR.setOnClickListener(this);

        stdNoOCR = findViewById(R.id.std_no_ocr);
        stdNoOCR.setClickable(false);

        layoutStdNoNFC = findViewById(R.id.layout_std_no_nfc);
        layoutStdNoNFC.setOnClickListener(this);

        stdNoNFC = findViewById(R.id.std_no_nfc);
        stdNoNFC.setClickable(false);

        layoutSimplified = findViewById(R.id.layout_simplified);
        layoutSimplified.setOnClickListener(this);

        simplified = findViewById(R.id.simplified);
        simplified.setClickable(false);

        layoutPhone = findViewById(R.id.layout_phone);
        layoutPhone.setOnClickListener(this);

        phone = findViewById(R.id.phone);
        phone.setClickable(false);

        layoutPhoneUpgrade = findViewById(R.id.layout_phone_upgrade);
        layoutPhoneUpgrade.setOnClickListener(this);

        phoneUpgrade = findViewById(R.id.phone_upgrade);
        phoneUpgrade.setClickable(false);


        layoutPhoneSms = findViewById(R.id.layout_phone_sms);
        layoutPhoneSms.setOnClickListener(this);

        phoneSms = findViewById(R.id.phone_sms);
        phoneSms.setClickable(false);


        next = findViewById(R.id.next);
        next.setOnClickListener(this);
        next.setClickable(false);

    }

    private void initViewByData() {

        ServerSettingConfig serverSettingConfig = SQLite.select().from(ServerSettingConfig.class).querySingle();

        if (serverSettingConfig == null) {
            next.setBackgroundResource(R.drawable.green_disable);
            return;
        }

        String procedure = serverSettingConfig.getProcedure();

        if (!TextUtils.isEmpty(procedure)) {

            if (procedure.equals(Procedure.STANDARD)) {
                standard.setChecked(true);
            } else if (procedure.equals(Procedure.SIMPLIFIED)) {
                simplified.setChecked(true);
            } else if (procedure.equals(Procedure.STD_NO_NFC)) {
                stdNoNFC.setChecked(true);
            } else if (procedure.equals(Procedure.STD_NO_OCR)) {
                stdNoOCR.setChecked(true);
            } else if (procedure.equals(Procedure.PHONE)) {
                phone.setChecked(true);
            } else if (procedure.equals(Procedure.PHONE_UPGRADE)) {
                phoneUpgrade.setChecked(true);
            } else if (procedure.equals(Procedure.PHONE_SMS)){
                phoneSms.setChecked(true);
            }
            next.setClickable(true);
            next.setBackgroundResource(R.drawable.green);
        } else {
            next.setBackgroundResource(R.drawable.green_disable);
        }

    }

    @Override
    public void onClick(View view) {

        int id = view.getId();
        if (id != R.id.next) {
            next.setBackgroundResource(R.drawable.green);
        }

        if (id == R.id.layout_standard) {
            setProduceStatus();
            standard.setChecked(true);
        } else if (id == R.id.layout_simplified) {
            setProduceStatus();
            simplified.setChecked(true);
        } else if (id == R.id.layout_std_no_ocr) {
            setProduceStatus();
            stdNoOCR.setChecked(true);
        } else if (id == R.id.layout_std_no_nfc) {
            setProduceStatus();
            stdNoNFC.setChecked(true);
        } else if (id == R.id.layout_phone) {
            setProduceStatus();
            phone.setChecked(true);
        } else if (id == R.id.layout_phone_upgrade) {
            setProduceStatus();
            phoneUpgrade.setChecked(true);
        } else if (id == R.id.layout_phone_sms){
            setProduceStatus();
            phoneSms.setChecked(true);
        }

        if (id == R.id.next) {
            next();
        }
    }

    private void setProduceStatus() {
        standard.setChecked(false);
        stdNoOCR.setChecked(false);
        stdNoNFC.setChecked(false);
        simplified.setChecked(false);
        phone.setChecked(false);
        phoneUpgrade.setChecked(false);
        phoneSms.setChecked(false);
        next.setClickable(true);
    }

    @Override
    public boolean valid() {
        return standard.isChecked() || stdNoOCR.isChecked() || stdNoNFC.isChecked() || phone.isChecked() || simplified.isChecked() || phoneUpgrade.isChecked() || phoneSms.isChecked();
    }

    @Override
    public String nextActivity() {
        return ActivityPath.ACTIVITY_CONFIG_STEP3;
    }

    @Override
    public void route() {
        super.route();

        if (BuildConfig.isAAR || DEBUG_AAR) {

            Intent intent = new Intent(this, ConfigStep3Activity.class);

            intent.putExtra("projectName", projectName);
            intent.putExtra("serverAddressesList", serverAddressesList);
            intent.putExtra("vhsmAddressList", vhsmAddressList);
            intent.putExtra("vhsmChangeip",vhsmChangeip);
            intent.putExtra(ConfigParam.PROCEDURE, getProcedure());
            intent.putExtra("enableVHSM", enableVHSM);
            intent.putExtra("certPath", certPath);
            intent.putExtra("enableHHY", enableHHY);
            intent.putExtra("enableRevoke", enableRevoke);
            startActivity(intent);

        }

    }

    private String getProcedure() {

        if (standard.isChecked()) {
            return Procedure.STANDARD;
        } else if (simplified.isChecked()) {
            return Procedure.SIMPLIFIED;
        } else if (stdNoOCR.isChecked()) {
            return Procedure.STD_NO_OCR;
        } else if (phone.isChecked()) {
            return Procedure.PHONE;
        } else if (stdNoNFC.isChecked()) {
            return Procedure.STD_NO_NFC;
        } else if (phoneUpgrade.isChecked()) {
            return Procedure.PHONE_UPGRADE;
        } else if (phoneSms.isChecked()){
            return Procedure.PHONE_SMS;
        }else {
            //不会走到这
            return "";
        }

    }

    @Override
    protected int getTitleRes() {
        return R.string.cert_creation_setting;
    }

}
