package com.xdja.safeclient.certcreation.activity;

import android.app.Activity;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.Toast;

import com.aircert.CommonActivity.ToolBarActivity;
import com.aircert.util.ModuleLog;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.HttpResponseCallBack;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.bean.OkNetError;
import com.xdja.safeclient.certcreation.bean.request.BaseRequest;
import com.xdja.safeclient.certcreation.bean.request.CertStateRequest;
import com.xdja.safeclient.certcreation.bean.request.RequestSMSCodeRequest;
import com.xdja.safeclient.certcreation.bean.request.VerifyPhoneRequest;
import com.xdja.safeclient.certcreation.bean.request.VerifySMSCodeRequest;
import com.xdja.safeclient.certcreation.bean.response.BaseErrorResponse;
import com.xdja.safeclient.certcreation.bean.response.CommonResponse;
import com.xdja.safeclient.certcreation.bean.response.CompareResult;
import com.xdja.safeclient.certcreation.bean.result.AuthResult;
import com.xdja.safeclient.certcreation.bean.result.CertStatusResult;
import com.xdja.safeclient.certcreation.bean.result.PhoneAuthResult;
import com.xdja.safeclient.certcreation.bean.result.PhoneResult;
import com.xdja.safeclient.certcreation.bean.result.VerifyPhoneResult;
import com.xdja.safeclient.certcreation.config.Procedure;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.device.NetVHSMHandle;
import com.xdja.safeclient.certcreation.service.CertService;
import com.xdja.safeclient.certcreation.util.ApplyCertUtil;
import com.xdja.safeclient.certcreation.util.CryptoDevTypeUtil;
import com.xdja.safeclient.certcreation.util.EditTextUtil;
import com.xdja.safeclient.certcreation.util.KeyboardUtils;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import com.xdja.safeclient.certcreation.util.SharePreferencesUtil;
import com.xdja.safeclient.certcreation.view.NoDoubleClickListener;
import com.xdja.safeclient.certcreation.view.PinDialog;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Timer;
import java.util.TimerTask;

import okhttp3.Call;

/**
 * Created by Administrator on 2019/12/10 0010.
 */
public class PhoneApplyActivity extends BaseActivity {

    private EditText etPhone;

    private LinearLayout idcard_layout;
    private EditText idCard;

    private PinDialog pinDialog;

    public CryptoDevType cardType;

    public int containerNum;

    public String cardNum;

    public String certType;

    private EditText etSMSCode;

    private Button requestSMSCode;
    ExitHandler exitHandler = new ExitHandler(this);

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        setContentView(R.layout.cert_creation_activity_phone_apply_cert);

        verifyPin();

        initView();

    }

    @Override
    protected int getTitleRes() {
        return -1;
    }

    @Override
    protected void getIntentData() {
        super.getIntentData();
        cardType = (CryptoDevType) getIntent().getSerializableExtra("cardType");
        cardNum = getIntent().getStringExtra("cardNum");
        containerNum = getIntent().getIntExtra(ActivityParam.CONTAINER_NUM, 0);
        certType = getIntent().getStringExtra(ActivityParam.CERT_TYPE);
    }

    private void initView() {

        etPhone = (EditText) findViewById(R.id.et_phone);
        etPhone.setFilters(EditTextUtil.getDisableEmojFilter());
        InputFilter[] inputFilter = new InputFilter[1];
        inputFilter[0] = new InputFilter.LengthFilter(11);
        etPhone.setFilters(inputFilter);
        etPhone.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {

            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
                if (count < 11){
                    requestSMSCode.setEnabled(false);
                }
            }

            @Override
            public void afterTextChanged(Editable s) {
                if (s.length() == 11){
                    requestSMSCode.setEnabled(true);
                }
            }
        });

        if (AppConfig.getInstance().getServerSettingConfig().getProcedure().equals(Procedure.PHONE_UPGRADE)) {
            idcard_layout = findViewById(R.id.idcard_layout);
            idcard_layout.setVisibility(View.VISIBLE);
            idCard = (EditText) findViewById(R.id.et_id);
            idCard.setFilters(EditTextUtil.getDisableEmojFilter(18));
        }


        Button btn_submit = (Button) findViewById(R.id.btn_submit);
        btn_submit.setOnClickListener(new NoDoubleClickListener() {
            @Override
            public void onNoDoubleClick(View v) {
                ModuleLog.d("提交");
                if (AppConfig.getInstance().getServerSettingConfig().getProcedure().equals(Procedure.PHONE_SMS)) {
                    ModuleLog.d("短信提交");
                    if (verifyPhoneNum() && verifySMSCodeNum()) {
                        verifySMSCode();
                    }
                }else{
                    submit();
                    ModuleLog.d("--------非短信提交");
                }

            }
        });



        LinearLayout sms = findViewById(R.id.code_layout);
        requestSMSCode = (Button) findViewById(R.id.request_sms_code);
        if (AppConfig.getInstance().getServerSettingConfig().getProcedure().equals(Procedure.PHONE_SMS)) {
            sms.setVisibility(View.VISIBLE);
            requestSMSCode.setVisibility(View.VISIBLE);
            etSMSCode = (EditText) findViewById(R.id.et_sms_code);
            requestSMSCode.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {

                    Log.e("jff", "128 PhoneApplyActivity onClick : SMS");
                    etSMSCode.requestFocus();
                    if (verifyPhoneNum()) {
                        requestSMSCode(etPhone.getText().toString());
                    }
                }

            });
        }
    }

    private boolean verifyPhoneNum() {
        if ("".equals(etPhone.getText().toString()) || (etPhone.getText().toString()).length() < 11) {
            ModuleToast.show(PhoneApplyActivity.this, R.string.cert_creation_err_length);
            return false;
        }

        return true;
    }

    private boolean verifySMSCodeNum() {
        if (("".equals(etSMSCode.getText().toString()))) {
            ModuleToast.show(PhoneApplyActivity.this, R.string.cert_creation_verify_code_verify_null);
            return false;
        }
        return true;
    }


    /**
     * 向手机发送验证码
     */
    private void requestSMSCode(String phone) {

        RequestSMSCodeRequest request = new RequestSMSCodeRequest(phone);
        service.requestSMSCode(request, cardNum, new HttpResponseCallBack<CommonResponse>() {
            @Override
            public void onOtherException(Exception e) {
                e.printStackTrace();
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                showRequestError();
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                countDown();
                ModuleToast.show(PhoneApplyActivity.this, R.string.cert_creation_verify_code_send_success);
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                handleRequestSMSError(baseErrorResponse);
            }

            @Override
            public void dismissDialog() {
                dismissLoading();
            }
        });

    }


    /**
     * 验证验证码是否通过
     */
    private void verifySMSCode() {
        final VerifySMSCodeRequest request = new VerifySMSCodeRequest(etPhone.getText().toString(), etSMSCode.getText().toString());

        service.verifySMSCode(request, cardNum, new HttpResponseCallBack<CommonResponse>() {

            @Override
            public void onOtherException(Exception e) {
                e.printStackTrace();
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                ModuleLog.d(e);
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse response) {
                submit();
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                handleRequestSMSError(baseErrorResponse);            }

            @Override
            public void dismissDialog() {
                dismissLoading();
            }
        });

    }


    private Timer timer;
    private final int COUNT_DOWN = 120;
    /**
     * 验证码倒计时
     * 单位秒
     */
    private int count = COUNT_DOWN;

    /**
     * 倒计时
     */
    private void countDown() {
        timer = new Timer();
        timer.schedule(new TimerTask() {
            @Override
            public void run() {
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        requestSMSCode.setText(count + "秒");
                        requestSMSCode.setClickable(false);
                        requestSMSCode.setEnabled(false);
                        count--;
                        if (count < 0) {
                            count = COUNT_DOWN;
                            requestSMSCode.setText(R.string.cert_creation_request_sms_code);
                            requestSMSCode.setClickable(true);
                            requestSMSCode.setEnabled(true);
                            timer.cancel();
                        }
                    }
                });
            }
        }, 0, 1000);
    }

    private void handleRequestSMSError(BaseErrorResponse baseErrorResponse) {
        String message = baseErrorResponse.getMessage();
        // TODO: 2018/6/8 0008 以后再优化
        if (message.equals("transcend_sms_send_times")) {
            ModuleToast.show(this, R.string.cert_creation_verify_code_freq);
        } else if (message.equals("fail_send_message")) {
            ModuleToast.show(this, R.string.cert_creation_verify_code_send_fail);
        } else if(message.equals("phone_code_send_frequently_error")){
            ModuleToast.show(this,R.string.cert_creation_phone_sms_send_frequently);
        } else if(message.equals("phone_code_expire_error")){
            ModuleToast.show(this,R.string.cert_creation_verify_code_phone_code_expire_error);
        } else if(message.equals("phone_code_incorrect_error")){
            ModuleToast.show(PhoneApplyActivity.this, R.string.cert_creation_verify_code_verify_io);
        }else if(message.equals("phone_code_send_limit_error")){
            ModuleToast.show(PhoneApplyActivity.this, R.string.cert_creation_verify_code_fail_limit_error);
        } else if (message.equals("phone_code_verify_fail_limit_error")){
            ModuleToast.show(PhoneApplyActivity.this, R.string.cert_creation_verify_code_verifyfail_limit_error);
        } else if(message.equals("phone_not_exist_error")){
            ModuleToast.show(PhoneApplyActivity.this, R.string.cert_creation_not_null_phone);

        }

    }


    private void verifyPin() {
        if (cardType == CryptoDevType.DEV_TYPE_Soft && 2 == NetVHSMHandle.isNetVHSMCanUse(new ToolBarActivity().getContext())) {
            //软卡证书未初始化不进行pin码校验

        } else {
            int pinResult = DeviceWrapper.getInstance().verifyPin(cardType, containerNum,
                    AppConfig.getInstance().getDefaultConfig().getPin());

            if (pinResult != 0) {
                pinDialog = new PinDialog(this, cardType);
                pinDialog.show();
            }
        }
    }

    private void submit() {

        KeyboardUtils.hideKeyboard(etPhone);
        if (!DeviceWrapper.getInstance().isApplyCertEnd()) {

            final String phone = etPhone.getText().toString();
            if (TextUtils.isEmpty(phone)) {
                ModuleToast.showNoRepeat(getContext(), R.string.cert_creation_not_null_phone_num);
                DeviceWrapper.getInstance().setApplyCertEnd(false);
                return;
            }

            if (AppConfig.getInstance().getServerSettingConfig().getProcedure().equals(Procedure.PHONE_UPGRADE)) {
                final String cardNum = idCard.getText().toString();
                if (TextUtils.isEmpty(cardNum)) {
                    ModuleToast.showNoRepeat(getContext(), R.string.cert_creation_not_null_id_num);
                    DeviceWrapper.getInstance().setApplyCertEnd(false);
                    return;
                }
                if (!cardNum.isEmpty() && cardNum.length() < 18) {
                    ModuleToast.show(getContext(), getResources().getString(R.string.cert_creation_error_id_size));
                    DeviceWrapper.getInstance().setApplyCertEnd(false);
                    return;
                }
                String idNo = idCard.getText().toString();
                SharePreferencesUtil.saveIDCardNo(getContext(), cardType.getType(), idNo);
            }


            DeviceWrapper.getInstance().setApplyCertEnd(true);

            // TODO: 2023/8/29 jff 再次查一次证书状态，如果本次还是查询无证书，则继续申请证书的业务，如果本次查询服务端有证书，则结束当前业务回到主界面
            showLoading();
            CertStateRequest certStateRequest = buildRequest();
            // TODO: 2023/8/29 jff 查询证书状态
            query(certStateRequest, phone);

        }
    }

    private CertStateRequest buildRequest() {
        final CertStateRequest certStateRequest = new CertStateRequest();
        certStateRequest.setSn(SharePreferencesUtil.getCertSn(this));

        certStateRequest.setCardType("" + CryptoDevTypeUtil.convertCardType(cardType.getType()));

        return certStateRequest;
    }


    private void query(BaseRequest certStateRequest, final String phone) {

        ModuleLog.d("开始查询证书状态");
        final CertService certService = new CertService();
        certService.certStateQuery(certStateRequest, cardNum, new HttpResponseCallBack<CommonResponse>() {
            @Override
            public void onOtherException(Exception e) {
                DeviceWrapper.getInstance().setApplyCertEnd(false);
                e.printStackTrace();
                dismissLoading();
            }


            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                //网络异常，请重试
                DeviceWrapper.getInstance().setApplyCertEnd(false);
                showRequestError();
                dismissLoading();
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                dismissDialog();
                //0表示等待撤销审核，1-证书已经被注销，2，证书注销申请被拒绝，3-证书状态正常，4-证书不存在
                String result = commonResponse.getResult();
                ModuleLog.d(" 查询结果" + result + "\n");
                if (result.equals("2") || result.equals("3")) {//3服务端证书状态正常或者2还处于可用状态，返回首页，不再继续申请证书

                    //如果非正常情况，需要界面给出用户提示等待一会重试或者联系管理员，2023年8月29日jff
                    CertStatusResult certStatusResult = new CertStatusResult();
                    certStatusResult.setContainerNum(containerNum);
                    certStatusResult.setResult("-1");

                    OttoUtil.postCertStatusResult(certStatusResult);
                    finish();

                } else {
                    verifyPhoneNum(phone);
                }
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                ModuleLog.d(" baseErrorResponse.getErrCode()" + baseErrorResponse.getErrCode() + "\n");
                if (OkNetError.NOT_EXIST_INFO_CODE.equals(baseErrorResponse.getErrCode())) {
                    verifyPhoneNum(phone);
                } else {
                    DeviceWrapper.getInstance().setApplyCertEnd(false);
                    ModuleToast.show(PhoneApplyActivity.this, OkNetError.userError(getContext(), baseErrorResponse.getErrCode()));
                    finish();
                }
            }

            @Override
            public void dismissDialog() {

            }
        });

    }

    /**
     * 验证手机号是否合法
     */
    private void verifyPhoneNum(final String phone) {

        VerifyPhoneRequest request = new VerifyPhoneRequest(phone);

        showLoading();

        service.verifyPhoneNum(request, cardNum, new HttpResponseCallBack<CommonResponse>() {
            @Override
            public void onOtherException(Exception e) {
                DeviceWrapper.getInstance().setApplyCertEnd(false);
                e.printStackTrace();
                dismissLoading();
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                DeviceWrapper.getInstance().setApplyCertEnd(false);
                showRequestError();
                dismissLoading();
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                String resultCode = commonResponse.getResult();
                if (resultCode.equals(VerifyPhoneResult.RESULT_OK)) {
                    //直接进行实体认证
                    startVerify();
                } else {

                    PhoneResult phoneResult
                            = buildPhoneResult(getCardType(), getCardNum(), commonResponse, null);

                    PhoneAuthResult authResult = new PhoneAuthResult();
                    authResult.setContainerNum(containerNum);
                    authResult.setPhoneResult(phoneResult);

                    OttoUtil.postPhoneAuthResult(authResult);
                    finish();
                }
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                DeviceWrapper.getInstance().setApplyCertEnd(false);
                //                ModuleLog.d("手机号验证失败：" + baseErrorResponse.toString());
            }

            @Override
            public void dismissDialog() {
                dismissLoading();
            }
        });
    }

    private PhoneResult buildPhoneResult(CryptoDevType type,
                                         String cardNum,
                                         CommonResponse response,
                                         BaseErrorResponse errorResponse) {

        CompareResult result = new CompareResult();

        // TODO: 2018/11/8 0008 三种情况的处理需要重写

        //IO异常的处理
        if (response == null && errorResponse == null) {
            result.setResult("");
            result.setMessage("");
            result.setErrCode("");
            result.setSuccess(false);
        } else if (errorResponse != null) {
            //错误的处理
            result.setResult(errorResponse.getErrCode());
            result.setErrCode(errorResponse.getErrCode());
            if (!TextUtils.isEmpty(errorResponse.getMessage())) {
                result.setMessage(errorResponse.getMessage());
            }
            result.setSuccess(false);
        } else {
            //正确的处理
            result.setResult(response.getResult());
            result.setMessage(response.getMessage());
            //注意，成功的时候是没有errCode的
            result.setSuccess(true);
        }

        result.setIdentity(cardNum);


        PhoneResult phoneResult = new PhoneResult(type, result);
        return phoneResult;
    }

    /**
     * 进行实体认证
     */
    private void startVerify() {

        if (cardType == null || TextUtils.isEmpty(cardNum)) {
            return;
        }
        showLoading();
        String phoneNum = etPhone.getText().toString();
        SharePreferencesUtil.savePhone(this, phoneNum);

        ApplyCertUtil.start(this, containerNum, new ApplyCertUtil.WhatHappen() {
            @Override
            public void showDialog() {
                // 现在在验证手机号前已经showLoading了，所以这里可以不加
            }

            @Override
            public void cancelDialog() {
                //                dismissLoading();
            }

            @Override
            public void IOError() {
                Log.e("jff", "289 PhoneApplyActivity IOError : ");
                DeviceWrapper.getInstance().setApplyCertEnd(false);
                dismissLoading();
                showRequestError();
            }

            @Override
            public void handleResult(CommonResponse response) {
                dismissLoading();
                Toast.makeText(PhoneApplyActivity.this,"请求成功",Toast.LENGTH_SHORT).show();
                finish();
            }

            @Override
            public void handleError(BaseErrorResponse baseErrorResponse) {
                Log.e("jff", "302 PhoneApplyActivity handleError : ");
                dismissLoading();
                PhoneApplyActivity.this.handleError(baseErrorResponse);
            }
        });

    }

    static class ExitHandler extends Handler {

        WeakReference<Activity> reference;

        ExitHandler(Activity activity) {
            reference = new WeakReference<Activity>(activity);
        }

        @Override
        public void handleMessage(Message msg) {
            super.handleMessage(msg);

            Activity activity = reference.get();

            if (activity == null) {
                return;
            } else {
                activity.finish();
            }
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (exitHandler != null) {
            exitHandler.removeCallbacksAndMessages(null);
        }
    }

    private void handleError(BaseErrorResponse baseErrorResponse) {

        Log.e("jff", "342 PhoneApplyActivity handleError : ");
        AuthResult result = ApplyCertUtil.buildAuthResult(getCardType(), containerNum, getCardNum(), null, baseErrorResponse);

        //一人一卡一证，跳转到认证失败的界面
        if (OkNetError.ONE_CARD_TYPE_ONE_CERT_CODE.equals(baseErrorResponse.getErrCode())) {
            //Intent intent = new Intent(this, AuthenticationFailActivity.class);
            //intent.putExtra(CONTAINER_NUM, containerNum);
            //intent.putExtra("result", result.getResult());
            //intent.putExtra("photoType", cardType);
            //startActivity(intent);
        }

        OttoUtil.postAuthResult(result);
        finish();

    }

}
