package com.xdja.safeclient.certcreation.event;

/**
 * Created by jff on 2019/5/21 0021.
 */

import com.xdja.cryptodev.CryptoDevType;

/**
 * 写更新证书的接口
 * 证书延期和用户信息更新调用此方法，对应写入证书的接口是DviceWrapper.writeUpdateCert()
 * 说明：DviceWrapper.importCert()是写入申请证书和更新密钥时的证书，因为多了密钥结构体
 */
public class WriteUpdateCertEvent {

    CryptoDevType type;

    int containerNum;

    String cert;

    boolean isUpdateKeyPair;

    public WriteUpdateCertEvent(CryptoDevType type, int containerNum, String cert, boolean isUpdateKeyPair) {
        this.type = type;
        this.containerNum = containerNum;
        this.cert = cert;
        this.isUpdateKeyPair = isUpdateKeyPair;
    }

    public CryptoDevType getType() {
        return type;
    }

    public int getContainerNum() {
        return containerNum;
    }

    public String getCert() {
        return cert;
    }

    public boolean isUpdateKeyPair() {
        return isUpdateKeyPair;
    }
}
