package com.xdja.safeclient.certcreation.service;

import android.os.Message;
import android.util.Log;

import com.aircert.util.WeakReferenceHandler;
import com.alibaba.fastjson.JSON;
import com.xdja.https.module.bean.HttpsParam;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.bean.request.BaseRequest;
import com.xdja.safeclient.certcreation.exception.CardNotExistException;

import java.io.IOException;

import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

/**
 * Created by gyx on 2018/9/10.
 */

public class CertRequest {

    private String url, cardNo;
    private BaseRequest body;
    private RequestCallback certCallback;

    public CertRequest(String url, String cardNo, BaseRequest body, RequestCallback callback) {
        this.url = url;
        this.cardNo = cardNo;
        this.body = body;
        this.certCallback = callback;
    }

    private Request initRequest(String url, String cardNo, BaseRequest body) {
        // 当密码模块为空时，builder.addHeader会引起崩溃

        if (cardNo == null) {
            return null;
        }

        Request.Builder builder = new Request.Builder();
        builder.addHeader("Content-Type", "application/json")
                .addHeader("cardNo", cardNo)
                .addHeader("clientTime", String.valueOf(System.currentTimeMillis()))
                .url(url);

        if (body != null) {
            MediaType mediaType = MediaType.parse("application/json; charset=UTF-8");
            String jsonStr = JSON.toJSONString(body);

            RequestBody requestBody = RequestBody.create(mediaType, jsonStr);
            builder.post(requestBody);
        }

        return builder.build();
    }

    public void request() {
        Runnable runnable = new Runnable() {
            @Override
            public void run() {

                // 如果在准备请求过程中，设备不存在（一般是TF卡或者贴膜卡）被拔出
                // 此时获取到的卡号cardNo为空，这时的处理是生成的request为空
                // 此时在上层调用的地方自行处理如何提示用户
                Request request = initRequest(CertRequest.this.url, CertRequest.this.cardNo, CertRequest.this.body);
                if (request == null) {
                    chipExecutorService.sendMessage(myHandler, CARD_EXCEPTION, null);
                    return;
                }

                final OkHttpClient client = HttpClientHelper.getOkHttpClient();
                Log.e("hyh",  request.toString());
                final Call call = client.newCall(request);
                try {
                    Response response = call.execute();
                    ResponseInner responseInner = new ResponseInner();
                    responseInner.call = call;
                    responseInner.isSuccessful = response.isSuccessful();
                    responseInner.response = response.body().string();
                    chipExecutorService.sendMessage(myHandler, RESPONSE_OK, responseInner);
                } catch (IOException e) {
                    Log.e("hyh","request error="+e.getMessage());
                    e.printStackTrace();
                    e.printStackTrace();
                    Failure failure = new Failure();
                    failure.call = call;
                    failure.e = e;
                    chipExecutorService.sendMessage(myHandler, IOE_EXCEPTION, failure);
                }
            }
        };
        chipExecutorService.exe(runnable);
    }


    /**
     * 请求网络
     *
     * @throws Exception
     */
    private void doRequest(final Request request, final HttpsParam httpsParam) {
        Runnable runnable = new Runnable() {
            @Override
            public void run() {


            }
        };
        chipExecutorService.exe(runnable);
    }


    private HttpsParam generateHttpsParam() {
        HttpsParam httpsParam = new HttpsParam();
        httpsParam.setSupportHttps(true);
        httpsParam.setServerCertAccessPwd(AppConfig.getInstance().getDefaultConfig().getBksVerifyCode().toCharArray());
        httpsParam.setServerCertInputStream(AppConfig.getInstance().getContext().getResources().openRawResource(R.raw.truststore));
        return httpsParam;
    }

    private static class MyHandler extends WeakReferenceHandler<CertRequest> {
        public MyHandler(CertRequest reference) {
            super(reference);
        }

        @Override
        protected void handleMessage(CertRequest reference, Message msg) {
            int what = msg.what;
            if (what == RESPONSE_OK) {
                ResponseInner responseInner = (ResponseInner) msg.obj;
                reference.certCallback.onResponse(responseInner.call, responseInner.isSuccessful, responseInner.response);
            } else if (what == IOE_EXCEPTION) {
                Failure failure = (Failure) msg.obj;
                reference.certCallback.onFailure(failure.call, failure.e);
            } else if (what == CARD_EXCEPTION) {
                // 卡设备不存在
                reference.certCallback.onException(new CardNotExistException());
            } else {
                Exception e = (Exception) msg.obj;
                reference.certCallback.onException(e);
            }
        }
    }

    private static final int CARD_EXCEPTION = -3; // 卡设备不存在
    private static final int OTHER_EXCEPTION = -2; //其他类型异常
    private static final int IOE_EXCEPTION = -1;  //网络IOException
    private static final int RESPONSE_OK = 0;   //服务器正常放回
    private static final int SEND_HTTPSPARAM = 1;  //发送参数HttpsParam


    private MyHandler myHandler = new MyHandler(this);
    private ChipExecutorService chipExecutorService = new ChipExecutorService();


    private class Failure {
        Call call;
        IOException e;
    }


    private class ResponseInner {
        Call call;
        String response;
        boolean isSuccessful;
    }


}
