package com.xdja.safeclient.certcreation.util;

import android.app.AlertDialog;
import android.content.Context;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.Gravity;
import android.view.Window;
import android.view.WindowManager;

import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.adapter.ConfigListAdapter;
import com.xdja.safeclient.certcreation.config.ConfigBean;

import java.util.List;

/**
 * Created by Administrator on 2019/5/21 0021.
 */

public class ConfigDialog {

    public static void show(Context context, int position, final List<ConfigBean> all) {

        AlertDialog.Builder builder = new AlertDialog.Builder(context,R.style.Dialog_pro);

        builder.setView(R.layout.common_dialog_list);

        final AlertDialog dialog = builder.create();

        dialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
        dialog.show();

        Window window = dialog.getWindow();

        window.setGravity(Gravity.CENTER);

        WindowManager.LayoutParams lp = window.getAttributes();
        lp.width = WindowManager.LayoutParams.MATCH_PARENT;
        lp.height = WindowManager.LayoutParams.WRAP_CONTENT;

        window.setAttributes(lp);
        RecyclerView recyclerView = (RecyclerView) window.findViewById(R.id.gateway_list);
        RecyclerView.LayoutManager layoutManager = new LinearLayoutManager(context);
//        layoutManager.setAutoMeasureEnabled(true);
        recyclerView.setLayoutManager(layoutManager);

        //添加分割线
        AirCertItemDecoration divider = new AirCertItemDecoration(context,AirCertItemDecoration.VERTICAL);
        divider.setDrawable(ContextCompat.getDrawable(context,R.drawable.divider));
        recyclerView.addItemDecoration(divider);

        final ConfigListAdapter adapter = new ConfigListAdapter(context, position);
        adapter.setDataSource(all);
        adapter.setOnItemClickListener(new ConfigListAdapter.OnItemClickListener() {
            @Override
            public void onItemSelected(int position) {
                OttoUtil.postChooseResult(adapter.getPosition(), adapter.getSelectedItem());
                dialog.cancel();
            }
        });

        recyclerView.setAdapter(adapter);
        dialog.setCancelable(false);
        dialog.setCanceledOnTouchOutside(true);
    }


}
