package com.xdja.safeclient.certcreation.util;

import com.aircert.BusProvider;
import com.aircert.util.ModuleLog;
import com.squareup.otto.Produce;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.bean.ChipBean;
import com.xdja.safeclient.certcreation.bean.ProfessionBean;
import com.xdja.safeclient.certcreation.bean.result.AuthResult;
import com.xdja.safeclient.certcreation.bean.result.CertStatusResult;
import com.xdja.safeclient.certcreation.bean.result.KuangshiResult;
import com.xdja.safeclient.certcreation.bean.result.NET_VHSMInitResult;
import com.xdja.safeclient.certcreation.bean.result.PhoneAuthResult;
import com.xdja.safeclient.certcreation.config.ConfigBean;
import com.xdja.safeclient.certcreation.event.CertOperateEvent;
import com.xdja.safeclient.certcreation.event.ChooseAddressEvent;
import com.xdja.safeclient.certcreation.event.ChooseBindwayEvent;
import com.xdja.safeclient.certcreation.event.ChooseConfigEvent;
import com.xdja.safeclient.certcreation.event.ClearIDEvent;
import com.xdja.safeclient.certcreation.event.DeleteCertConfigEvent;
import com.xdja.safeclient.certcreation.event.DepartmentEvent;
import com.xdja.safeclient.certcreation.event.FinishActivity;
import com.xdja.safeclient.certcreation.event.FinishChooseEvent;
import com.xdja.safeclient.certcreation.event.FinishYishuNFC;
import com.xdja.safeclient.certcreation.event.InvokeXDJAOCREvent;
import com.xdja.safeclient.certcreation.event.PhonePermissionResult;
import com.xdja.safeclient.certcreation.event.ProfessionDepartment;
import com.xdja.safeclient.certcreation.event.QueryFinishEvent;
import com.xdja.safeclient.certcreation.event.RefreshListEvent;
import com.xdja.safeclient.certcreation.event.RevokeResultEvent;
import com.xdja.safeclient.certcreation.event.RevokeSuccessEvent;
import com.xdja.safeclient.certcreation.event.SpecificActivity;
import com.xdja.safeclient.certcreation.event.SwipeEnableEvent;
import com.xdja.safeclient.certcreation.event.UpdateCertStateEvent;
import com.xdja.safeclient.certcreation.event.UpdateKeyPairEvent;
import com.xdja.safeclient.certcreation.event.WriteUpdateCertEvent;
import com.xdja.safeclient.certcreation.receiver.BaiduFaceEvent;

import java.util.List;

/**
 * Created by zjc on 2018/6/8 0008.
 */

public class OttoUtil extends BusProvider {

    @Produce
    public static void postAuthResult(AuthResult result) {
        post(result);
    }

    @Produce
    public static void postPhoneAuthResult(PhoneAuthResult result) {
        post(result);
    }

    public static void postCertStatusResult(CertStatusResult result){
        post(result);
    }

    /**
     * 发送NET-VHSM初始化结果
     *
     * @param initResult 初始化结果
     */
    public static void postNet_VHSMinitResult(int initResult) {
        ModuleLog.e("OttoUtil postNet_VHSMinitResult : ");
        post(new NET_VHSMInitResult(initResult));
    }


    /**
     * 选择警种、职务信息、级别和人员类别
     *
     * @param bean bean
     */
    public static void chooseProfession(ProfessionBean bean) {
        post(bean);
    }

    /**
     * 选择部门
     *
     * @param current 当前部门
     * @param rest    剩余部门
     */
    @Produce
    public static void chooseDepartment(ProfessionDepartment current, List<ProfessionDepartment> rest) {
        DepartmentEvent event = new DepartmentEvent();
        event.setCurrent(current);
        event.setRest(rest);
        post(event);
    }

    /**
     * 统一结束Activity
     */
    @Produce
    public static void postFinishActivity() {
        post(new FinishActivity());
    }

    public static void postFinishSpecificActivity(String tag) {
        ModuleLog.d("关闭" + tag);
        post(new SpecificActivity(tag));
    }

    /**
     * 发送旷世活体识别结果
     *
     * @param success 是否成功
     */
    public static void postKuangshiResult(boolean success) {
        post(new KuangshiResult(success));
    }

    /**
     * 结束Yishu NFC扫描Activity
     */
    public static void postFinishYishuNFC() {
        post(new FinishYishuNFC());
    }

    /**
     * 结束选择NFC和OCR的界面
     */
    public static void postFinishChoose() {
        post(new FinishChooseEvent());
    }

    /**
     * 清空已经读到的身份证信息
     */
    public static void postClearID() {
        post(new ClearIDEvent());
    }

    /**
     * 电话权限申请通过
     *
     * @param type
     */
    public static void postPhonePermissionResult(int type) {
        PhonePermissionResult phonePermissionResult = new PhonePermissionResult();
        phonePermissionResult.setType(type);
        post(phonePermissionResult);
    }

    /**
     * 关闭选择身份证识别方式Activity
     */
    public static void postFinishChooseBindWay() {
        post(new ChooseBindwayEvent());
    }

    /**
     * 查询完成
     */
    public static void postQueryFishied() {
        post(new QueryFinishEvent());
    }

    /**
     * 证书撤销结果
     *
     * @param chipBean
     * @param reason
     */
    public static void postRevokeResult(int containerNum, ChipBean chipBean, String reason) {
        post(new RevokeResultEvent(containerNum, chipBean, reason));
    }

    /**
     * 百度人脸识别结果
     *
     * @param success
     * @param photo
     */
    public static void postBaiduResult(boolean success, String photo) {
        post(new BaiduFaceEvent(success, photo));
    }

    /**
     * 配置选择点击触发
     * <p>
     * 选择的是身份认证服务（活体检测、OCRCompany、NFC）中的一个
     * <p>
     * 选择的是证书设备信息（签发设备、签发容器号、密钥算法、证书机制、展示证书类型）中的一个
     *
     * @param position 如果是活体检测、OCR、NFC的话，position就是对应类里的POSITION常亮
     *                 <p>
     *                 如果是其余的话，
     *                 position就是点击的Item项在List中所处的绝对位置，例如是第二个证书设备，那position就是1
     * @param config
     */
    public static void postChooseResult(int position, ConfigBean config) {
        post(new ChooseConfigEvent(position, config));
    }

    /**
     * 删除设备信息
     *
     * @param position 设备信息item的绝对位置
     */
    public static void postDeleteCertDetail(int position) {
        post(new DeleteCertConfigEvent(position));
    }

    /**
     * 证书详情页面证书操作，如删除、撤销等
     *
     * @param containerNum 容器号
     * @param bean
     */
    public static void postCertOperate(int containerNum, ChipBean bean) {
        post(new CertOperateEvent(containerNum, bean));
    }

    /**
     * 发送是否开启下拉刷新功能
     *
     * @param success 是否成功
     */
    public static void postSwipPullResult(boolean success) {
        post(new SwipeEnableEvent(success));
    }

    /**
     * 证书撤销成功，通知列表页更新状态
     */
    public static void postRevokeSuccess(RevokeSuccessEvent event) {
        post(event);
    }

    /**
     * 调用信大捷安OCR
     */
    public static void postInvokeXDJAOCR() {
        post(new InvokeXDJAOCREvent());
    }

    public static void postShowChooseAddressLoading() {
        post(new ChooseAddressEvent(true));
    }

    public static void postCancelChooseAddressLoading() {
        post(new ChooseAddressEvent(false));
    }


    /**
     * 写更新的证书，这里只写3.9接口证书用户信息更新/延期更新的证书
     * 原因是，这个接口返回的证书密钥结构体为null，单独写入每个部分
     * 申请证书和更新密钥时发送的证书内容四个部门完整
     * 2020.3.28-jff
     *
     * @param cert 未分割前的字符
     */
    public static void postWritUpdateCert(CryptoDevType type, int containerNum, String cert,
                                          boolean isUpdateKeyPair) {
        post(new WriteUpdateCertEvent(type, containerNum, cert, isUpdateKeyPair));
    }

    /**
     * 发送证书更新结果
     *
     * @param str 界面提示语
     */
    public static void postCertUpdateResult(int str, int containerNum, CryptoDevType type) {
        post(new UpdateCertStateEvent(str, type, containerNum));
    }

    public static void postUpdateKeyPairEvent(CryptoDevType type, int containerNum, int messageRes) {
        post(new UpdateKeyPairEvent(type, containerNum, messageRes));
    }

    public static void postRefreshListEvent() {
        post(new RefreshListEvent());
    }

}
