package com.xdja.safeclient.certcreation.util;

import android.content.Context;
import android.content.res.AssetManager;
import android.os.Environment;

import com.aircert.util.ModuleLog;
import com.xdja.safeclient.certcreation.bean.CertDetailInfo;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;

/**
 * Created by yangpeng on 2018/5/3.
 */

public class Util {

    /**
     * 查询asset 下是否包含此文件
     *
     * @param fileName
     * @return
     */
    public static boolean assetFileIsExist(Context context, String fileName) {
        InputStream inputStream = null;
        AssetManager manager = context.getAssets();
        try {
            inputStream = manager.open(fileName);
            if (inputStream != null) {
                return true;
            }
        } catch (IOException e) {
            return false;
        } finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    /**
     * 获取缓存地址
     *
     * @param context
     * @return
     */
    public static String getDiskCacheDir(Context context) {
        String cachePath = null;
        if (Environment.MEDIA_MOUNTED.equals(Environment.getExternalStorageState())
                || !Environment.isExternalStorageRemovable()) {
            cachePath = context.getExternalCacheDir().getPath();
        }
        if (cachePath == null)
            cachePath = context.getCacheDir().getPath();

        return cachePath;
    }






    /**
     * 数组转换成十六进制字符串
     *
     * @return
     */
    public static String bytesToHexString(byte[] bArray) {
        StringBuilder sb = new StringBuilder(bArray.length);
        for (byte b : bArray) {
            String sTemp = Integer.toHexString(0xFF & b);
            if (sTemp.length() < 2) {
                sb.append(0);
            }
            sb.append(sTemp.toUpperCase());
        }

        return sb.toString();
    }

    public static byte[] hexStr2byteArr(String hex) {
        if (hex.length() % 2 != 0) {
            hex = "0" + hex;
        }

        int len = hex.length() / 2;
        byte[] result = new byte[len];
        char[] achar = hex.toCharArray();

        for(int i = 0; i < len; ++i) {
            String item = new String(achar, i * 2, 2);
            result[i] = (byte)Integer.parseInt(item, 16);
        }

        return result;
    }




    /**
     * 判断证书是否在有效期内
     *
     * @param info CertDetailInfo 用来读取证书起止时间
     * @return true 有效; false 过期
     */
    public static boolean certIsValid(CertDetailInfo info) {


        Date dataStart = info.getNotBeforeData();
        Date dataEnd = info.getNotAfterData();

        Date currentDate = new Date();

        return (currentDate.getTime() - dataStart.getTime() <= 5 * 60 * 1000 || dataStart.getTime() - currentDate.getTime() <= 5 * 60 * 1000) &&
                currentDate.before(dataEnd);

    }


    /**
     * 证书有效期将至（距离失效小于15天）
     *
     * @param info CertDetailInfo 用来读取证书起止时间
     */
    public static boolean certValidIsExpire(CertDetailInfo info) {

        Date dataEnd = info.getNotAfterData();

        Date currentDate = new Date();

        ModuleLog.e("currentDate = " + currentDate.toString());
        ModuleLog.e("currentDate.getTime() = " + currentDate.getTime());
        ModuleLog.e("dataEnd.getTime() = " + dataEnd.getTime());

        return certIsValid(info) && (dataEnd.getTime() - currentDate.getTime() < 15 * 24 * 60 * 60 * 1000);
    }


}
