package com.xdja.safeclient.certcreation.view;

import static com.xdja.safeclient.certcreation.bean.OkNetError.handleErrorCodeToMsg;

import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.support.annotation.StringRes;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.aircert.BusProvider;
import com.aircert.util.CommonUtil;
import com.aircert.util.ModuleLog;
import com.aircert.util.WeakReferenceHandler;
import com.squareup.otto.Subscribe;
import com.xdja.cryptodev.CryptoDevManager;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.BuildConfig;
import com.xdja.safeclient.certcreation.FeatureConfig;
import com.xdja.safeclient.certcreation.HttpResponseCallBack;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.ActivityParam;
import com.xdja.safeclient.certcreation.activity.CertViewActivity;
import com.xdja.safeclient.certcreation.activity.PhoneApplyActivity;
import com.xdja.safeclient.certcreation.activity.PhoneInputActivity;
import com.xdja.safeclient.certcreation.adapter.RecyclerViewAdapter;
import com.xdja.safeclient.certcreation.bean.CertDetailInfo;
import com.xdja.safeclient.certcreation.bean.CertItemBean;
import com.xdja.safeclient.certcreation.bean.CertState;
import com.xdja.safeclient.certcreation.bean.ChipBean;
import com.xdja.safeclient.certcreation.bean.ChipInfo;
import com.xdja.safeclient.certcreation.bean.MobileInfo;
import com.xdja.safeclient.certcreation.bean.OkNetError;
import com.xdja.safeclient.certcreation.bean.ServerAddress;
import com.xdja.safeclient.certcreation.bean.device.CardType;
import com.xdja.safeclient.certcreation.bean.request.BaseRequest;
import com.xdja.safeclient.certcreation.bean.request.CertApplyRequest;
import com.xdja.safeclient.certcreation.bean.request.CertStateRequest;
import com.xdja.safeclient.certcreation.bean.request.Info;
import com.xdja.safeclient.certcreation.bean.request.RevokeOwnOldCertRequest;
import com.xdja.safeclient.certcreation.bean.request.RevokedCertRequest;
import com.xdja.safeclient.certcreation.bean.request.WriteFailInfo;
import com.xdja.safeclient.certcreation.bean.request.WriteFailRequest;
import com.xdja.safeclient.certcreation.bean.response.BaseErrorResponse;
import com.xdja.safeclient.certcreation.bean.response.CertApplyRAStatusResponse;
import com.xdja.safeclient.certcreation.bean.response.CertApplyResponse;
import com.xdja.safeclient.certcreation.bean.response.CommonResponse;
import com.xdja.safeclient.certcreation.bean.response.CompareResult;
import com.xdja.safeclient.certcreation.bean.response.LastAuthRecordResponse;
import com.xdja.safeclient.certcreation.bean.response.SigResultResponse;
import com.xdja.safeclient.certcreation.bean.result.AuthResult;
import com.xdja.safeclient.certcreation.bean.result.CertStatusResult;
import com.xdja.safeclient.certcreation.bean.result.NET_VHSMInitResult;
import com.xdja.safeclient.certcreation.bean.result.PhoneAuthResult;
import com.xdja.safeclient.certcreation.bean.result.PhoneResult;
import com.xdja.safeclient.certcreation.cache.RequestCache;
import com.xdja.safeclient.certcreation.config.CertPermission;
import com.xdja.safeclient.certcreation.config.CertRule;
import com.xdja.safeclient.certcreation.config.CertType;
import com.xdja.safeclient.certcreation.config.Procedure;
import com.xdja.safeclient.certcreation.device.DeviceUtil;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.device.NetVHSMHandle;
import com.xdja.safeclient.certcreation.device.PKCS10Utils;
import com.xdja.safeclient.certcreation.event.UpdateCertStateEvent;
import com.xdja.safeclient.certcreation.event.WriteUpdateCertEvent;
import com.xdja.safeclient.certcreation.exception.CardNotExistException;
import com.xdja.safeclient.certcreation.service.CertService;
import com.xdja.safeclient.certcreation.service.ChipExecutorService;
import com.xdja.safeclient.certcreation.task.ChooseTask;
import com.xdja.safeclient.certcreation.util.AnimUtil;
import com.xdja.safeclient.certcreation.util.CertUtil;
import com.xdja.safeclient.certcreation.util.CryptoDevTypeUtil;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import com.xdja.safeclient.certcreation.util.SharePreferencesUtil;
import com.xdja.safeclient.certcreation.util.Util;

import java.io.IOException;
import java.util.ArrayList;

import okhttp3.Call;

/**
 * Created  on 2018/4/20.
 */

public class CertItemView extends RelativeLayout {
    private final CertService certService = new CertService();

    private FrameLayout container_child;
    private View marginView;
    private ImageView inUse;
    private ChipBean chipBean;
    private int containerNum;
    private Context context;

    /**
     * 写入证书失败的原因
     */
    private static int importCertErrorCode = 0;

    // REFACTOR: 2019/8/8 jff  此处定义需明确
    private static final int QUERY_CERT_INFO_FROM_SERVER = 0;
    /**
     * 实体认证结果查询通过
     */
    private static final int APPLY_CERT_REQUEST = 1;
    /**
     * 实体认证结果查询失败
     */
    private static final int QUERY_AUTHENTICATION_RESULT = 2;
    /**
     * 证书写卡失败
     */
    private static final int IMPORT_CERT_FAIL = 3;

    /**
     * 客户端服务端证书机制不一致
     */
    private static final int CLIENT_SERVER_CERT_RULE_DIFFERENT = 4;

    private static final int CERT_STATE_RA_APPLY_REJECT = 53;


    // REFACTOR: 2019/8/8 jff  object具体内容
    private String object;

    public void setDeviceID(String deviceID) {
        this.deviceID = deviceID;
    }

    /**
     * 密码模块ID
     */
    private String deviceID;

    /**
     * 密码模块类型
     */
    private String cardNum;
    private CryptoDevType chipBeanType;

    // REFACTOR: 2019/8/8 jff  CertItemBean  实际可以用CryptoDevInfo代替，这里重新定义一个是否有必要
    private CertItemBean certItemBean;


    private String certRule;

    private String certType;

    private RecyclerViewAdapter recyclerViewAdapter;

    private boolean isCertOK = false; //证书是否处于正常状态

    private boolean allowApplyCert;

    /**
     * 实体认证结果msg
     */
    private String authResultMsg;

    private MyHandler myHandler;

    private final String procedure = AppConfig.getInstance().getServerSettingConfig().getProcedure();

    private final boolean isOnlineVHSM = AppConfig.getInstance().getCertConfig().getVHSMType()
            .equals(CardType.ONLINE_VHSM);

    /**
     * 本地读取证书
     */
    private static final int TAG_QUERY_CERT_STATE = 0;

    /**
     *
     */
    public static final int TAG_QUERY_CERT_STATE_WITH_POLL = 1;

    /**
     * 是否是同一设备的第一个容器
     */
    private boolean isFirst;

    public CertItemView(Context context, AttributeSet attrs) {
        super(context, attrs);
        LayoutInflater.from(context).inflate(R.layout.cert_item_layout_new, this);

        BusProvider.register(this);

    }


    /**
     * 本地是否有证书，在RecyclerViewAdapter判断是否跳转到详情页
     *
     * @return true 本地有证书  false 本地无证书
     */
    public boolean isCertOK() {
        return isCertOK;
    }

    public void setData(Context context, RecyclerViewAdapter recyclerViewAdapter,
                        CertItemBean certItemBean, String object, boolean isFirst) {

        this.object = object;

        this.context = context;
        this.certItemBean = certItemBean;
        this.isCertOK = false;

        this.isFirst = isFirst;

        chipBeanType = this.certItemBean.getCryptoDevInfo().getType();

        initView();
        setDeviceID(DeviceWrapper.getInstance().getCardID(chipBeanType));
        if (AppConfig.getInstance().getCertConfig().getVHSMType()
                .equals(CardType.ONLINE_VHSM) && chipBeanType == CryptoDevType.DEV_TYPE_Soft) {
            setDeviceID(NetVHSMHandle.getNetVhsmCardId(context));
        }


        if (TextUtils.isEmpty(deviceID)) {
            showErrorResponseLayout(context.getString(R.string.cert_creation_card_not_exist));
            return;
        } else {
            RequestCache.getInstance().putType(deviceID, chipBeanType.getType());
        }

        containerNum = this.certItemBean.getCertConfig().getContainerNum();

        certRule = this.certItemBean.getCertConfig().getCertRule();

        certType = this.certItemBean.getCertConfig().getCertType();

        allowApplyCert
                = this.certItemBean.getCertConfig().getCertPermission().equals(CertPermission.APPLY);

        cardNum = DeviceWrapper.getInstance().getCardID(chipBeanType);
        myHandler = new MyHandler(this, allowApplyCert);


        if (isOnlineVHSM
                && chipBeanType == CryptoDevType.DEV_TYPE_Soft) {
            cardNum = NetVHSMHandle.getNetVhsmCardId(context);
        }
        this.recyclerViewAdapter = recyclerViewAdapter;

        initView();
        if (TextUtils.isEmpty(cardNum)) {
            showErrorResponseLayout(context.getString(R.string.cert_creation_card_not_exist));
            return;
        } else {
            RequestCache.getInstance().putType(cardNum, chipBeanType.getType());
        }


        ModuleLog.e("");
        queryCertInfo(false);


    }

    private final ChipExecutorService chipExecutorService = new ChipExecutorService();

    /**
     * 本地读取证书
     */
    private void queryCertInfo(final boolean pollAddress) {

        // 融合版空包IP为null，直接展示网络异常
        if (getIPState() == IP_NULL && !FeatureConfig.getInstance().isDisableMakeNewCert()) {
            showNoCertDatabaseErrorLayout();
            return;
        }

        showChecking();
        Runnable runnable = new Runnable() {
            @Override
            public void run() {
                int type = CertItemView.this.chipBeanType.getType();
                ChipBean bean = new ChipBean();
                bean.setType(type);

                CertDetailInfo info = DeviceWrapper.getInstance().readCertFromContainer(
                        CertItemView.this.chipBeanType, containerNum,
                        certType);

                if (info != null) {
                    ModuleLog.d(info);
                }
                bean.setCertDetailInfo(info);

                if (info == null) {
                    bean.setState(CertState.NO_CERT);
                    ModuleLog.e("结果无证书");
                } else {

                    if (!Util.certIsValid(bean.getCertBean())) {
                        // 证书已过期
                        bean.setState(CertState.CERT_OUT_OF_DATE);
                    } else {
                        bean.setState(CertState.SUCCESS);
                    }


                    if (!BuildConfig.isAAR || !FeatureConfig.getInstance().isDisableMakeNewCert()) {
                        boolean isVerify = DeviceWrapper.getInstance().verifyCertByRoot(
                                context, chipBeanType, containerNum);
                        bean.setIsVerify(isVerify);
                    }
                }

                ModuleLog.e("pollAddress =  " + pollAddress);
                if (pollAddress) {
                    chipExecutorService.sendMessage(myHandler, TAG_QUERY_CERT_STATE_WITH_POLL, bean);
                } else {
                    chipExecutorService.sendMessage(myHandler, TAG_QUERY_CERT_STATE, bean);
                }

            }
        };
        chipExecutorService.exe(runnable);
    }

    /**
     * 获取ChipBean
     *
     * @return 芯片类型
     */
    public ChipBean getChipBean() {
        return chipBean;
    }

    public static final int IP_SUCCESS = 0;

    public static final int IP_NULL = -1;

    public static final int IP_POLL_FAIL = -2;

    private int getIPState() {

        String ip = AppConfig.getInstance().getServerSettingConfig()
                .getIp();

        if (TextUtils.isEmpty(ip)) {
            return IP_NULL;
        } else if (ip.contains("|")) {
            return IP_POLL_FAIL;
        } else {
            return IP_SUCCESS;
        }

    }


    private static class MyHandler extends WeakReferenceHandler<CertItemView> {

        boolean allowApply;

        boolean pollAddress;

        public MyHandler(CertItemView reference, boolean allowApply) {
            super(reference);
            this.allowApply = allowApply;
        }

        @Override
        protected void handleMessage(CertItemView reference, Message msg) {
            reference.chipBean = (ChipBean) msg.obj;

            if (msg.what == TAG_QUERY_CERT_STATE_WITH_POLL) {
                pollAddress = true;
            } else {
                pollAddress = false;
            }

            if (msg.what == TAG_QUERY_CERT_STATE
                    || msg.what == TAG_QUERY_CERT_STATE_WITH_POLL) {

                if (reference.chipBean.getState() == CertState.SUCCESS
                        && !reference.chipBean.getIsVerify()) {
                    //有证书但验签不通过，只展示证书信息，不再获取证书状态
                    reference.showCertDetail(R.string.cert_creation_cert_not_in_system, reference.chipBean);
                    //关闭下拉刷新动画
                    OttoUtil.postQueryFishied();
                } else {
                    // 展示证书的情况下，无证书直接显示无证书，有证书直接显示本地证书
                    // 不再去服务端查询状态
                    if (!allowApply) {
                        if (reference.chipBean.getState() == CertState.NO_CERT) {

                            // 如果是多运营商，直接展示网络异常
                            if (reference.isIPFail()) {
                                reference.showOtherFailLayout(QUERY_CERT_INFO_FROM_SERVER, null);
                            } else {
                                // 否则，直接展示无证书
                                //reference.showNoCert();
                                ModuleLog.e("");
                                reference.queryCertStateFromServer(pollAddress);
                            }

                        } else {
                            reference.showCertDetail(R.string.cert_creation_normal_state_item, reference.chipBean);
                        }
                        return;
                    } else if (BuildConfig.isAAR && FeatureConfig.getInstance().isDisableMakeNewCert()) {

                        //融合版如果没证书不再继续查找去服务端查找证书

                        if (reference.chipBean.getState() == CertState.NO_CERT) {
                            reference.showNoCert();
                        } else {
                            reference.showCertDetail(R.string.cert_creation_normal_state_item, reference.chipBean);
                        }
                        return;
                    } else {
                        ModuleLog.e("");
                        reference.queryCertStateFromServer(pollAddress);
                    }
                }

            } else {
                if (reference.chipBean.getState() == CertState.NO_CERT) {
                    reference.showNoCert();
                } else {
                    reference.showCertDetail(R.string.cert_creation_normal_state_item, reference.chipBean);
                }
            }
        }
    }


    private void initView() {
        TextView name = (TextView) findViewById(R.id.name);
        ImageView icon = findViewById(R.id.icon);
        marginView = findViewById(R.id.margin);
        container_child = (FrameLayout) findViewById(R.id.container_child);
        if (chipBeanType == CryptoDevType.DEV_TYPE_SdCard) {
            name.setText(R.string.cert_creation_tf_cert);
            icon.setBackgroundResource(R.drawable.tf_card);
        } else if (chipBeanType == CryptoDevType.DEV_TYPE_Chip) {
            name.setText(R.string.cert_creation_chip_cert);
            icon.setBackgroundResource(R.drawable.chip);
        } else if (chipBeanType == CryptoDevType.DEV_TYPE_SimKey) {
            name.setText(R.string.cert_creation_tiemo_cert);
            icon.setBackgroundResource(R.drawable.sim_card);
        } else if (chipBeanType == CryptoDevType.DEV_TYPE_Soft) {
            name.setText(R.string.cert_creation_soft_cert);
            icon.setBackgroundResource(R.drawable.vhsm);
        }

        // 同一个设备有多个容器时，非第一个容器的卡类型所在的布局都隐藏
        View item = findViewById(R.id.item);


        if (isFirst) {
            item.setVisibility(VISIBLE);
        } else {
            item.setVisibility(GONE);
        }


        TextView cardNo = (TextView) findViewById(R.id.card_num);
        cardNo.setText(certItemBean.getCryptoDevInfo().getCardId());

        TextView tvContainerNum = findViewById(R.id.tv_container_num);
        tvContainerNum.setText(context.getString(R.string.cert_creation_config_container_num)
                + String.valueOf(containerNum));

        inUse = (ImageView) findViewById(R.id.in_use);

        // TODO: 2019/3/27 0027 加一个正在使用判断显示隐藏的接口
        if (chipBean == null || DeviceWrapper.getInstance().getInUse() != null) {
            inUse.setVisibility(GONE);
        } else {
            if (chipBean.getCertBean() != null) {
                if (DeviceWrapper.getInstance().getInUse().equals(chipBean.getCertBean().getSn())) {
                    //是否正在使用当前证书，根据证书编号判断
                    inUse.setVisibility(VISIBLE);
                } else {
                    inUse.setVisibility(GONE);
                }
            } else {
                inUse.setVisibility(GONE);
            }
        }

        container_child.setVisibility(View.VISIBLE);
    }

    public boolean inUse() {
        return inUse.getVisibility() == VISIBLE;
    }

    private void showChecking() {
        showChecking(-1);
    }

    /**
     * 显示Loading
     */
    private void showChecking(int strId) {
        View view = LayoutInflater.from(context).inflate(R.layout.cert_item_layout_loading, null, true);
        ImageView imageView = (ImageView) view.findViewById(R.id.iv_icon);
        AnimUtil.rotate(context, imageView);
        showView(view);

        if (strId != -1) {
            TextView textView = view.findViewById(R.id.checking_text);
            textView.setText(getResources().getText(strId));
        }
        marginView.setVisibility(View.VISIBLE);
    }

    /**
     * netVHSM初始化失败
     */
    private void showInitNetVHSMFailLayout() {

        View view = LayoutInflater.from(context).inflate(R.layout.cert_item_layout_error, null);
        TextView fail_reason = (TextView) view.findViewById(R.id.fail_reason);
        View bottom_button_layout = view.findViewById(R.id.bottom_button_layout);
        Button tv_apply = (Button) view.findViewById(R.id.tv_apply);
        fail_reason.setText("VHSM初始化失败，请重试");
        bottom_button_layout.setVisibility(VISIBLE);
        tv_apply.setText(R.string.cert_creation_reinit);
        bottom_button_layout.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View view) {
                showChecking(R.string.cert_creation_vhsm_init);
                if (CardType.REQUEST_PARAM_ONLINE_VHSM.equals("1")) {
                    NetVHSMHandle.initVHSM(context, AppConfig.getInstance().getServerSettingConfig().getVhsm_ip(), Integer.valueOf(AppConfig.getInstance().getServerSettingConfig().getVhsm_port()));
                } else {
                    NetVHSMHandle.initVHSM(context, AppConfig.getInstance().getServerSettingConfig().getVhsm_ip(), Integer.valueOf(AppConfig.getInstance().getServerSettingConfig().getVhsm_port()), SharePreferencesUtil.getPhoneNum(context),
                            vhsmSign);
                }
                //初始化的结果在handleNetVhsmInitResult里处理
            }
        });
        showView(view);

    }

    @Subscribe
    public void handleNetVhsmInitResult(NET_VHSMInitResult initResult) {
        ModuleLog.e(chipBeanType.getType());
        if (chipBeanType.getType() == CryptoDevType.DEV_TYPE_Soft.getType()) {
            int initResultInt = initResult.getNet_VHSMinitResult();
            ModuleLog.e("481 CertItemView handleNetVhsmInitResult" + this.object.toString());
            if (initResultInt == 0) {//初始化成功获取p10
                //切换到主线程，申请证书
                showChecking(R.string.cert_creation_is_applying_cert);

                new Thread(new Runnable() {
                    @Override
                    public String toString() {
                        return super.toString();
                    }

                    @Override
                    public void run() {
                        ModuleLog.e("start p10");
                        CryptoDevManager.getInstance().refresh();

                        //CertViewActivity certViewActivity = (CertViewActivity)context;
                        //certViewActivity.swipe.setEnabled(false);
                        SystemClock.sleep(100);
                        DeviceWrapper.getInstance().getDevInfo();
                        ModuleLog.e("end enum dev");
                        getP10RequestBCAndApplyCert(authResultMsg);


                    }
                }).start();
                // TODO: 2022/2/23 jff
                //                OttoUtil.postSwipPullResult(false);

            } else {//初始化失败展示当前界面
                showInitNetVHSMFailLayout();
            }
        }
    }


    /**
     * 展示服务端返回的异常对应的界面
     *
     * @param message
     */
    private void showErrorResponseLayout(String title, String message, boolean isReapply) {

        View view = LayoutInflater.from(context).inflate(R.layout.cert_item_layout_error, null);
        TextView fail_reason = (TextView) view.findViewById(R.id.fail_reason);
        View bottom_button_layout = view.findViewById(R.id.bottom_button_layout);
        Button tv_apply = (Button) view.findViewById(R.id.tv_apply);


        fail_reason.setText(message);

        if (isReapply) {

            bottom_button_layout.setVisibility(VISIBLE);
            tv_apply.setText(R.string.cert_creation_reapply);
            bottom_button_layout.setOnClickListener(new OnClickListener() {
                @Override
                public void onClick(View view) {
                    ModuleLog.d("0showErrorResponseLayout,请求权限");
                    requestPhonePermission();
                }
            });
        } else {
            bottom_button_layout.setVisibility(GONE);
        }

        // 禁止申请证书，隐藏申请证书按钮
        if (FeatureConfig.getInstance().isDisableMakeNewCert()) {
            bottom_button_layout.setVisibility(GONE);
        }

        //错误码是一人一卡一证书
        //todo 2018-08-15 jff 手机号流程一人一卡一证及一人一证文案需要进一步修改
        if (message.contains(context.getString(R.string.cert_creation_one_person_one_cert))
                || message.contains(context.getString(R.string.cert_creation_one_person_one_cardType_one_cert))) {
            tv_apply.setText(R.string.cert_creation_revoke_old_cert);
            tv_apply.setOnClickListener(new OnClickListener() {
                @Override
                public void onClick(View v) {
                    //todo 撤销非当前设备的证书并申请证书
                    revokeOwnOldCert();
                }
            });
        }

        //vhsm同步人员失败，重新初始化
        if (message.contains(context.getString(R.string.cert_creation_vhsm_import_person_fail))) {
            tv_apply.setText(R.string.cert_creation_reinit);
            tv_apply.setOnClickListener(new OnClickListener() {
                @Override
                public void onClick(View view) {
                    //重新进行实体认证
                    applyCert(chipBeanType.getType());
                }
            });
        }


        // TODO: 2018/11/2 0002 文字变成刷新之后，点击事件也要随之变化
        if (message.contains(context.getString(R.string.cert_creation_server_error_short))) {
            tv_apply.setText(R.string.cert_creation_retry);
            tv_apply.setOnClickListener(new OnClickListener() {
                @Override
                public void onClick(View view) {
                    queryCertStateFromServer(true);
                }
            });
        }


        //jff 如果是VHSM，本地证书没有，服务端证书正常，为便于现场运维，客户端申请撤销老卡证书
        if (message.contains(context.getString(R.string.cert_creation_cert_not_incard_revoke))) {
            tv_apply.setText(R.string.cert_creation_revoke);
            tv_apply.setOnClickListener(new OnClickListener() {
                @Override
                public void onClick(View view) {
                    if (!"".equals(revokeOldCertSn)) {
                        revoke(revokeOldCertSn);
                    }
                }
            });
        }
        showView(view);
    }

    /**
     * 展示服务端返回的异常对应的界面
     *
     * @param message
     */
    private void showErrorResponseLayout(String message) {
        View view = LayoutInflater.from(context).inflate(R.layout.cert_item_layout_error, null);
        view.findViewById(R.id.fail_reason).setVisibility(VISIBLE);

        Button button = (Button) view.findViewById(R.id.tv_apply);
        button.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View view) {
                ModuleLog.d("请求权限");
                requestPhonePermission();
            }
        });

        // TODO: 2018/11/2 0002 文字变成刷新之后，点击事件也要随之变化
        if (message.contains(context.getString(R.string.cert_creation_server_error_short))
                || message.contains(context.getString(R.string.cert_creation_app_time_exception_user))) {
            button.setText(R.string.cert_creation_retry);
            button.setOnClickListener(new OnClickListener() {
                @Override
                public void onClick(View view) {
                    queryCertStateFromServer(true);
                }
            });
        }

        if (message.contains("安全设备失败")) {
            button.setText(R.string.cert_creation_retry);
            button.setOnClickListener(new OnClickListener() {
                @Override
                public void onClick(View view) {
                    cardNum = DeviceWrapper.getInstance().getCardID(chipBeanType);
                    if (TextUtils.isEmpty(cardNum)) {
                        showErrorResponseLayout(context.getString(R.string.cert_creation_card_not_exist));
                        return;
                    } else {
                        queryCertStateFromServer(true);
                    }
                }
            });
        }


        TextView content = (TextView) view.findViewById(R.id.fail_reason);
        content.setText(message);

        showView(view);
    }


    /**
     * 设备未激活
     */
    private void showDevNOActivation() {
        View view = LayoutInflater.from(context).inflate(R.layout.cert_item_layout_dev_no_activition, null);
        showView(view);
    }

    /**
     * 展示没有证书，去申请
     */
    private void showNoCert() {
        final View view = LayoutInflater.from(context).inflate(R.layout.cert_item_layout_no_cert, null);

        View layoutApplyCert = view.findViewById(R.id.apply_cert_layout);

        if (FeatureConfig.getInstance().isDisableMakeNewCert()) {
            layoutApplyCert.setVisibility(GONE);
        } else if (!AppConfig.getInstance().isHasDB()) {
            layoutApplyCert.setVisibility(GONE);
        } else if (!allowApplyCert) {
            layoutApplyCert.setVisibility(GONE);
        } else {
            layoutApplyCert.setVisibility(VISIBLE);
        }


        Button appBtn = view.findViewById(R.id.apply_cert_btn);
        if (certItemBean.getCryptoDevInfo().getType() == CryptoDevType.DEV_TYPE_Soft
                && 2 == NetVHSMHandle.isNetVHSMCanUse(context)) {
            ((TextView) view.findViewById(R.id.cert_item_top_one_content)).setText(R.string.cert_creation_no_init);
            appBtn.setText(R.string.cert_creation_vhsm_init_apply_cert1);
        }

        view.findViewById(R.id.apply_cert_btn).setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                ModuleLog.d("0showNoCert, 请求权限");

                String vhsmIP = AppConfig.getInstance().getServerSettingConfig().getVhsm_ip();

                if (certItemBean.getCryptoDevInfo().getType() == CryptoDevType.DEV_TYPE_Soft
                        && (2 == NetVHSMHandle.isNetVHSMCanUse(context))
                        && vhsmIP.contains("|")
                ) {

                    showChecking(R.string.cert_creation_choose_address);

                    ArrayList<ServerAddress> list =
                            AppConfig.getInstance()
                                    .getServerSettingConfig()
                                    .getVhsmAddressList();

                    int timeout = 2000;

                    ChooseTask task = new ChooseTask(
                            list
                            , timeout
                            , new ChooseTask.ChooseResult() {
                        @Override
                        public void success(ServerAddress address) {

                            showNoCert();

                            AppConfig.getInstance().getServerSettingConfig()
                                    .setVhsm_ip(address.getIp());
                            AppConfig.getInstance().getServerSettingConfig()
                                    .setVhsm_port(address.getPort());

                            requestPhonePermission();
                        }

                        @Override
                        public void fail(long time) {

                            OttoUtil.postCancelChooseAddressLoading();

                            showErrorVHSMAddressLayout();

                        }


                    });

                    task.execute();

                } else {
                    requestPhonePermission();
                }

            }
        });
        showView(view);
    }

    private void showErrorVHSMAddressLayout() {

        View view = LayoutInflater.from(context).inflate(R.layout.cert_item_layout_error, null);
        view.findViewById(R.id.fail_reason).setVisibility(VISIBLE);

        String message;

        if (!CommonUtil.isNetworkConnected(context)) {
            message = context.getString(R.string.net_disconnected_text);
            chipBean.setState(CertState.NET_ERROR);
        } else {
            message = context.getString(R.string.net_timeout);
            chipBean.setState(CertState.NET_TIMEOUT);
        }

        Button button = (Button) view.findViewById(R.id.tv_apply);
        button.setText(R.string.cert_creation_vhsm_init_apply_cert1);
        button.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View view) {

                ModuleLog.d("0showNoCert, 请求权限");

                String vhsmIP = AppConfig.getInstance().getServerSettingConfig().getVhsm_ip();

                if (certItemBean.getCryptoDevInfo().getType() == CryptoDevType.DEV_TYPE_Soft
                        && vhsmIP.contains("|")
                ) {

                    showChecking(R.string.cert_creation_choose_address);

                    ArrayList<ServerAddress> list =
                            AppConfig.getInstance()
                                    .getServerSettingConfig()
                                    .getVhsmAddressList();

                    int timeout = 2000;

                    ChooseTask task = new ChooseTask(
                            list
                            , timeout
                            , new ChooseTask.ChooseResult() {
                        @Override
                        public void success(ServerAddress address) {

                            OttoUtil.postCancelChooseAddressLoading();

                            AppConfig.getInstance().getServerSettingConfig()
                                    .setVhsm_ip(address.getIp());
                            AppConfig.getInstance().getServerSettingConfig()
                                    .setVhsm_port(address.getPort());

                            requestPhonePermission();
                        }

                        @Override
                        public void fail(long time) {

                            OttoUtil.postCancelChooseAddressLoading();

                            showErrorVHSMAddressLayout();

                        }

                    });

                    task.execute();

                } else {
                    requestPhonePermission();
                }

            }
        });

        TextView content = (TextView) view.findViewById(R.id.fail_reason);
        content.setText(message);

        showView(view);

    }

    private void requestPhonePermission() {
        ModuleLog.d("1点击准备申请证书");
        applyCert(chipBeanType.getType());
    }

    private void applyCert(int cardType) {
        SharePreferencesUtil.saveCurrentDevType(context, cardType);
        SharePreferencesUtil.saveDevCardID(context, cardNum);
        if (recyclerViewAdapter != null) {
            recyclerViewAdapter.setIsRefresh(false);
        }
        DeviceWrapper.getInstance().setApplyCertEnd(false);
        SharePreferencesUtil.saveActivityObjectName(context, object);

        RequestCache.getInstance().setObject(object);

        if (procedure.equals(Procedure.PHONE) || procedure.equals(Procedure.PHONE_UPGRADE)
                || procedure.equals(Procedure.PHONE_SMS)) {
            // 手机号发证流程
            Intent intent = new Intent(context, PhoneApplyActivity.class);
            intent.putExtra(ActivityParam.CARD_TYPE,
                    CryptoDevTypeUtil.formatType(cardType));
            intent.putExtra(ActivityParam.CARD_NUM, cardNum);
            intent.putExtra(ActivityParam.CONTAINER_NUM, containerNum);
            intent.putExtra(ActivityParam.CERT_TYPE, certType);
            context.startActivity(intent);
        } else {
            // 持证拍照流程
            // 注意applyCert方法中用的都是cardType，不是type
            Intent intent = new Intent(context, PhoneInputActivity.class);
            intent.putExtra(ActivityParam.CARD_TYPE,
                    CryptoDevTypeUtil.formatType(cardType));
            intent.putExtra(ActivityParam.CARD_NUM, cardNum);
            intent.putExtra(ActivityParam.CONTAINER_NUM, containerNum);
            intent.putExtra(ActivityParam.CERT_TYPE, certType);
            context.startActivity(intent);
        }


    }

    /**
     * 展示无配置时的界面
     * <p>
     * 此场景仅出现在融合版，安全接入空包没有配置，在点击证书查看时进入
     * <p>
     * 因为数据库是空，不能获取到服务端IP，所以直接展示网络异常
     */
    private void showNoCertDatabaseErrorLayout() {
        View view = LayoutInflater.from(context).inflate(R.layout.cert_item_layout_error, null);
        TextView reason = (TextView) view.findViewById(R.id.fail_reason);
        Button tv_apply = (Button) view.findViewById(R.id.tv_apply);

        //处理网络问题，没网/请求超时
        int netRes = -1;
        if (!CommonUtil.isNetworkConnected(context)) {
            netRes = R.string.net_disconnected_text;
        } else {
            netRes = R.string.net_timeout;
        }

        reason.setText(netRes);
        tv_apply.setText(R.string.cert_creation_retry);

        showView(view);
    }

    /**
     * 展示申请失败view
     */
    private void showOtherFailLayout(final int requestType, final String p10) {
        View view = LayoutInflater.from(context).inflate(R.layout.cert_item_layout_error, null);
        TextView reason = (TextView) view.findViewById(R.id.fail_reason);

        RelativeLayout reApply = (RelativeLayout) view.findViewById(R.id.bottom_button_layout);
        Button tv_apply = (Button) view.findViewById(R.id.tv_apply);

        //处理网络问题，没网/请求超时
        int netRes = -1;
        if (!CommonUtil.isNetworkConnected(context)) {
            netRes = R.string.net_disconnected_text;
            chipBean.setState(CertState.NET_ERROR);
        } else {
            netRes = R.string.net_timeout;
            chipBean.setState(CertState.NET_TIMEOUT);
        }
        switch (requestType) {
            case QUERY_CERT_INFO_FROM_SERVER:
                if (chipBean.getCertBean() != null) {
                    showCertDetail(netRes, chipBean);

                    view.setVisibility(GONE);
                    return;
                } else {
                    if (netRes == -1) {
                        netRes = R.string.cert_creation_cert_state_query_fail;
                    }
                }
                break;
            case APPLY_CERT_REQUEST:
                netRes = R.string.cert_creation_register_fail_reapply;
                break;
            case QUERY_AUTHENTICATION_RESULT:
                netRes = R.string.cert_creation_authentiation_result_fail;
                break;
            case IMPORT_CERT_FAIL:
                netRes = R.string.cert_creation_write_authentiation_fail;

                if (importCertErrorCode == CLIENT_SERVER_CERT_RULE_DIFFERENT) {
                    chipBean.setState(CertState.NO_CERT);
                    netRes = R.string.cert_creation_client_sercer_certrule_different;
                }
                break;

            case CERT_STATE_RA_APPLY_REJECT:
                ModuleLog.e("showOtherFailLayout");
                netRes = R.string.cert_creation_ra_reject;
                break;
        }
        reason.setText(netRes);
        tv_apply.setText(R.string.cert_creation_retry);
        reApply.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                boolean isNetOK = CommonUtil.isNetworkConnected(context);
                switch (requestType) {
                    case QUERY_CERT_INFO_FROM_SERVER:
                        if (isNetOK) {
                            queryCertInfo(true);
                        } else {
                            ModuleToast.show(context, R.string.net_disconnected_text);
                        }
                        break;
                    case APPLY_CERT_REQUEST:
                        if (isNetOK) {
                            showChecking();
                            applyCertRequest(p10);
                            ModuleLog.e("申请证书 CertItemView showOtherFailLayout line 409");
                        } else {
                            ModuleToast.show(context, R.string.net_disconnected_text);
                        }
                        break;
                    case QUERY_AUTHENTICATION_RESULT:
                        if (isNetOK) {
                            showChecking();
                            queryAuthenticationResult();
                        } else {
                            ModuleToast.show(context, R.string.net_disconnected_text);
                        }
                        break;
                    case IMPORT_CERT_FAIL://
                        if (importCertErrorCode ==
                                CLIENT_SERVER_CERT_RULE_DIFFERENT) {
                            queryCertStateFromServer(true);
                        } else {
                            requestPhonePermission();
                        }
                        break;
                }
            }
        });
        showView(view);
    }

    /**
     * 展示申请失败view
     */
    private void showRegisterFail() {
        View view = LayoutInflater.from(context).inflate(R.layout.cert_item_layout_no_cert, null);
        TextView cert_item_top_one_content = (TextView) view.findViewById(R.id.cert_item_top_one_content);
        View reApply = view.findViewById(R.id.apply_cert_layout);
        cert_item_top_one_content.setText(R.string.cert_creation_register_fail_reapply);

        reApply.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                ModuleLog.d("0showRegisterFail, 请求权限");
                requestPhonePermission();
            }
        });
        showView(view);
    }

    /**
     * 服务端审核通过
     * RA正在审核的界面
     * 错误码 - 45
     *
     * @param p10
     */
    private void showRAWaitLayout(final String p10) {

        View view = LayoutInflater.from(context).inflate(R.layout.cert_item_layout_wait, null);

        TextView textView = view.findViewById(R.id.cert_item_top_two_content);
        textView.setText(R.string.cert_creation_cert_status_ra_apply_wait);

        view.findViewById(R.id.refresh).setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View view) {
                ModuleLog.e("CertItemView onClick");
                applyRAstatus(p10);
            }
        });

        showView(view);

    }

    /**
     * RA申请证书失败的界面
     * 错误码 - 48
     */
    private void showRAApplyFailLayout() {

        View view = LayoutInflater.from(context).inflate(R.layout.cert_item_layout_error, null);
        TextView reason = (TextView) view.findViewById(R.id.fail_reason);

        RelativeLayout reApply = (RelativeLayout) view.findViewById(R.id.bottom_button_layout);
        Button tv_apply = (Button) view.findViewById(R.id.tv_apply);

        reason.setText(R.string.cc_ra_apply_fail);

        tv_apply.setText(R.string.cert_creation_apply_again);
        reApply.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                requestPhonePermission();
            }
        });
        showView(view);

    }


    /**
     * RA人工拒绝
     * 错误码 - 状态查询结果是53,55,57界面处理
     */
    private void showRARequestLayout(String detailReason) {

        ModuleLog.e("RA");
        View view = LayoutInflater.from(context).inflate(R.layout.cert_item_layout_request, null);
        TextView reason = (TextView) view.findViewById(R.id.fail_reason);
        TextView detail_reason = (TextView) view.findViewById(R.id.detail_fail_reason);


        RelativeLayout reApply = (RelativeLayout) view.findViewById(R.id.bottom_button_layout);
        Button tv_refresh = (Button) view.findViewById(R.id.tv_refresh);

        reason.setText(R.string.cert_creation_ra_reject);
        ModuleLog.e("detailReason : " + detailReason);
        detail_reason.setText(getResources().getString(R.string.cert_creation_reason) + detailReason);

        tv_refresh.setText(R.string.cert_creation_retry);
        reApply.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                CertStateRequest certStateRequest = buildRequest();
                query(certStateRequest);
            }
        });
        showView(view);

    }


    /**
     * 信息已提交，请等待审核
     */
    private void showWaiteVerity() {

        View view = LayoutInflater.from(context).inflate(R.layout.cert_item_layout_wait, null);

        view.findViewById(R.id.refresh).setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View view) {
                showChecking(R.string.cert_creation_identity_result_checking);
                queryAuthenticationResult();
            }
        });

        showView(view);
    }


    /**
     * 芯片详情  by gyx 2018.6.27
     *
     * @param chipBean
     */
    private void showCertDetail(@StringRes final int strRes, final ChipBean chipBean) {


        this.chipBean = chipBean;
        this.isCertOK = true;

        final View view =
                LayoutInflater.from(context).inflate(R.layout.cert_item_layout_detail_new, null);
        ModuleLog.e("");
        myHandler.postDelayed(new Runnable() {
            @Override
            public void run() {

                TextView tvCertState = (TextView) view.findViewById(R.id.tv_cert_state);
                TextView tvCertType = view.findViewById(R.id.tv_cert_type);
                TextView tvSN = (TextView) view.findViewById(R.id.tv_sn);
                final TextView tvUser = (TextView) view.findViewById(R.id.tv_user);
                TextView tvPeroid = (TextView) view.findViewById(R.id.tv_peroid);


                if (strRes == R.string.cert_creation_normal_state_item) {
                    tvCertState.setTextColor(getResources().getColor(R.color.cert_normal_success));
                } else if (strRes == R.string.cert_creation_be_frozen ||
                        strRes == R.string.cert_creation_thaw_reject ||
                        strRes == R.string.cert_creation_update_reject ||
                        strRes == R.string.cert_creation_update_check_reject ||
                        strRes == R.string.cert_creation_server_nocert ||
                        strRes == R.string.cert_creation_cert_out_of_date ||
                        strRes == R.string.cert_creation_revoke_success ||
                        strRes == R.string.cert_creation_revoke_reject ||
                        strRes == R.string.cert_creation_revoke_check_reject ||
                        strRes == R.string.cert_creation_cert_not_in_system ||
                        strRes == R.string.net_disconnected_text ||
                        strRes == R.string.net_timeout ||
                        strRes == R.string.cert_creation_detail_revoke_success ||
                        strRes == R.string.cert_creation_cert_status_ra_apply_reject
                ) {
                    tvCertState.setTextColor(getResources().getColor(R.color.cert_fail_error));
                } else if (
                        strRes == R.string.cert_creation_revoke_ing ||
                                strRes == R.string.cert_creation_thaw_ing ||
                                strRes == R.string.cert_creation_update_ing ||
                                strRes == R.string.cert_creation_cert_status_wait_verify
                ) {
                    tvCertState.setTextColor(getResources().getColor(R.color.cert_ing));
                }

                tvCertState.setText(strRes);
                //chipBean status == 56,certDetailInfo 为null,此时界面提示用户审核等待中

                CertDetailInfo certDetailInfo = chipBean.getCertBean();

                ModuleLog.e("run certDetailInfo : " + certDetailInfo);
                // TODO: 2019/4/4 0004 这个地方是有可能为空崩溃的
                if (certDetailInfo == null) {
                    return;
                }

                tvCertType.setText(certType);

                String sn = certDetailInfo.getSn();
                tvSN.setText(sn);

                String owner = getCertHolder(certDetailInfo.getSubjectCn());
                tvUser.setText(owner);

                String peroid = certDetailInfo.getIndate();
                //                这有一个系统Bug，如果使用者的内容长度较长，大于单行的长度时
                //                在xml设置android:
                //                ellipsize = "end" 时，会导致左间距发生变化
                //                并且在不同手机上的显示略有不同，例如Mate10向右偏移2dp左右
                //                为了解决这个问题，我们大致计算一下宽度，如果大于某个宽度，手动修改一下内容
                //                经过测试，width在mate10上是1036，在P30上是1067，二者同为宽为1080分辨率的手机

                int w = View.MeasureSpec.makeMeasureSpec(0, View.MeasureSpec.UNSPECIFIED);
                int h = View.MeasureSpec.makeMeasureSpec(0, View.MeasureSpec.UNSPECIFIED);
                tvUser.measure(w, h);
                int height = tvUser.getMeasuredHeight();
                int width = tvUser.getMeasuredWidth();

                if (width > 1000) {
                    String text = tvUser.getText().toString();
                    String newText = text.substring(0, text.length() > 23 ? 20 : text.length());
                    tvUser.setText(newText + "...");
                }

                ModuleLog.d("使用者的宽度：" + width);

                tvPeroid.setText(peroid);

                showView(view);
                marginView.setVisibility(View.VISIBLE);
            }
        }, 10);

    }

    private void showView(View view) {
        marginView.setVisibility(View.GONE);
        container_child.removeAllViews();
        container_child.addView(view);
    }


    /**
     * 获取证书持有人字符串
     *
     * @param sn
     * @return
     */
    private String getCertHolder(String sn) {
        String[] split = sn.split(",");
        for (int i = 0; i < split.length; i++) {
            String cnStr = split[i];

            if (cnStr.contains("CN=")) {
                int beginIndex = 3;
                int length = cnStr.length();
                //int endIndex = length < 20 ? length : 20;
                return split[i].substring(beginIndex, length);
            }
        }
        return "";
    }

    private CertStateRequest buildRequest() {
        final CertStateRequest certStateRequest = new CertStateRequest();
        if (chipBean.getCertBean() != null) {
            String sn;
            //本地有证书，用本地证书的sn查询证书状态
            //双证并且显示证书配置成交换证书，那么查询证书状态用签名证书的sn去查询，
            // 是因为pams和空中发证服务端之前约定双证情况下查询证书状态时通过签名证书的sn查询的，
            // 故这里用签名证书sn去查询，单证情况不影响  2019.6.14  jff
            if (certType.equals(CertType.ENCRYPT)
                    && this.certRule.equals(CertRule.DOUBLE_CERT)) {
                CertDetailInfo info =
                        DeviceWrapper.getInstance().readCertFromContainer(CertItemView.this.chipBeanType, containerNum,
                                CertType.SIGNING);

                if (info != null) {
                    sn = info.getSn();
                } else {
                    sn = SharePreferencesUtil.getCertSn(context);

                }
            } else {
                sn = chipBean.getCertBean().getSn();
            }

            certStateRequest.setSn(sn);
        } else {
            certStateRequest.setSn(SharePreferencesUtil.getCertSn(context));
        }

        certStateRequest.setCardType("" + CryptoDevTypeUtil.convertCardType(chipBeanType.getType()));

        return certStateRequest;
    }


    /**
     * 2.6【I-airIssue-api-007】查询证书状态
     * 查询证书状态
     */
    private void queryCertStateFromServer(boolean pollAddress) {

        /**先判断网络是否正常，如果异常，则提示网络异常，直接return**/
        if (!CommonUtil.isNetworkConnected(context)) {
            showOtherFailLayout(QUERY_CERT_INFO_FROM_SERVER, null);
            OttoUtil.postQueryFishied();
            return;
        }

        if (isIPFail()) {
            if (pollAddress) {

                showChecking(R.string.cert_creation_choose_address);

                ChooseTask task = new ChooseTask(
                        AppConfig.getInstance().getServerSettingConfig().getServerAddressList()
                        , 2000
                        , new ChooseTask.ChooseResult() {
                    @Override
                    public void success(ServerAddress address) {

                        AppConfig.getInstance().getServerSettingConfig().setIp(address.getIp());
                        AppConfig.getInstance().getServerSettingConfig().setPort(address.getPort());

                        CertStateRequest certStateRequest = buildRequest();
                        query(certStateRequest);
                    }

                    @Override
                    public void fail(long time) {

                        OttoUtil.postCancelChooseAddressLoading();

                        // TODO: 2020/3/10 0010 这个是把上面网络异常的 处理给搬过来用了
                        showOtherFailLayout(QUERY_CERT_INFO_FROM_SERVER, null);
                        OttoUtil.postQueryFishied();
                    }

                });

                task.execute();
            } else {
                showOtherFailLayout(QUERY_CERT_INFO_FROM_SERVER, null);
                OttoUtil.postQueryFishied();
            }
        } else {
            CertStateRequest certStateRequest = buildRequest();
            ModuleLog.e("");
            query(certStateRequest);
        }

    }

    private String revokeOldCertSn;

    private void query(BaseRequest certStateRequest) {
        ModuleLog.e("");
        showChecking();

        final CertDetailInfo info =
                DeviceWrapper.getInstance().readCertFromContainer(CertItemView.this.chipBeanType,
                        containerNum,
                        certType);

        if (info == null) {
            chipBean.setState(CertState.NO_CERT);
        } else {
            chipBean.setCertDetailInfo(info);
        }

        final CertService certService = new CertService();
        certService.certStateQuery(certStateRequest, cardNum, new HttpResponseCallBack<CommonResponse>() {
            @Override
            public void onOtherException(Exception e) {
                showOtherFailLayout(QUERY_CERT_INFO_FROM_SERVER, null);
            }


            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                //网络异常，请重试
                showOtherFailLayout(QUERY_CERT_INFO_FROM_SERVER, null);
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                //0表示等待撤销审核，1-证书已经被注销，2，证书注销申请被拒绝，3-证书状态正常，4-证书不存在
                String result = commonResponse.getResult();
                ModuleLog.d(" 查询结果" + result + "\n");
                if (result.equals("0")) {
                    //0表示等待撤销审核，显示撤销信息已提交，等待审核
                    showCertDetail(R.string.cert_creation_revoke_ing, chipBean);
                    isCertOK = true;
                    chipBean.setState(CertState.WAITING_AGREE_REVOKE);
                } else if (result.equals("1")) {
                    //1-证书已经被注销
                    showCertDetail(R.string.cert_creation_revoke_success, chipBean);
                    chipBean.setState(CertState.AGREE_REVOKE);
                    isCertOK = true;
                } else if (result.equals("2")) {
                    //2，证书注销申请被拒绝，正常显示
                    showCertDetail(R.string.cert_creation_revoke_check_reject, chipBean);
                    chipBean.setState(CertState.REJECT_REVOKE);
                    chipBean.setReason(commonResponse.getMessage());
                    isCertOK = true;
                } else if (result.equals("3")) {
                    //3-证书状态正常,本地没有找到证书，则提示联系管理员撤销
                    if (isChipBeanSizeIsZero()) {
                        ModuleLog.e("");
                        //if (AppConfig.getInstance().getCertConfig().getVHSMType().equals(CardType.ONLINE_VHSM)) {//此处判断用配置文件里的，避免应用刚启动没找到设备，走撤销流程不需要获取设备句柄
                        //
                        //    revoke(commonResponse.getMessage());
                        //} else {
                        revokeOldCertSn = commonResponse.getMessage();
                        showErrorResponseLayout(context.getString(R.string.cert_creation_cert_query_fail), context.getString(R.string.cert_creation_cert_not_incard_revoke), true);
                        //}
                    } else {
                        isCertOK = true;

                        if (chipBean.getState() == CertState.CERT_OUT_OF_DATE) {
                            chipBean.setState(CertState.CERT_OUT_OF_DATE);
                            showCertDetail(R.string.cert_creation_cert_out_of_date, chipBean);
                        } else {
                            chipBean.setState(CertState.SUCCESS);
                            showCertDetail(R.string.cert_creation_normal_state_item, chipBean);
                        }
                    }

                } else if (result.equals("4")) {

                    //4-服务端证书不存在，若本地有证书，此时展示证书；若本地无证书，则查询身份认证结果
                    if (isChipBeanSizeIsZero()) {
                        queryAuthenticationResult();
                    } else {
                        showCertDetail(R.string.cert_creation_detail_revoke_success, CertItemView.this.chipBean);
                        chipBean.setState(CertState.SERVER_NOCERT);
                    }

                } else if (result.equals("5")) {
                    //5-证书被冻结
                    showCertDetail(R.string.cert_creation_be_frozen, chipBean);
                } else if (result.equals("6")) {
                    //6-证书处于解冻申请中
                    showCertDetail(R.string.cert_creation_thaw_ing, chipBean);
                } else if (result.equals("7")) {
                    //7-证书解冻申请被拒绝
                    showCertDetail(R.string.cert_creation_thaw_reject, chipBean);
                } else if (result.equals("8")) {
                    //8-证书处于延期申请中
                    showCertDetail(R.string.cert_creation_delay_ing, chipBean);
                } else if (result.equals("9")) {
                    //9-证书延期申请成功
                    showCertDetail(R.string.cert_creation_normal_state_item, chipBean);
                } else if (result.equals("10")) {
                    //10-证书延期申请被拒绝
                    showCertDetail(R.string.cert_creation_delay_reject, chipBean);
                } else if (result.equals("11")) {
                    // 11-证书处于更新申请中
                    chipBean.setState(CertState.WAITING_VERIFY);
                    //    showCertDetail(R.string.cert_creation_update_ing, chipBean);
                    if (TextUtils.isEmpty(commonResponse.getMessage())) {
                        showKeyPairWaitForUpdate(context.getString(R.string.cert_creation_update_ing));
                    } else {
                        showKeyPairWaitForUpdate(commonResponse.getMessage());
                    }

                } else if (result.equals("12")) {
                    //12-证书更新成功
                    chipBean.setState(CertState.AGREE_UPDATE);
                    showCertDetail(R.string.cert_creation_normal_state_item, chipBean);
                } else if (result.equals("13")) {
                    //13 –证书更新申请被拒绝
                    chipBean.setState(CertState.UPDATE_REJECT_BY_SERVER);
                    chipBean.setReason(commonResponse.getMessage());
                    showCertDetail(R.string.cert_creation_update_check_reject, chipBean);
                } else if (result.equals("14")) {
                    //14-证书已过期
                    chipBean.setState(CertState.CERT_OUT_OF_DATE);
                    showCertDetail(R.string.cert_creation_cert_out_of_date, chipBean);
                } else if (result.equals("15")) { //15的界面展示和47界面展示一致
                    //15-证书状态待确认（RA证书已经签发，等待确认签发接口正常签发）
                    //                    chipBean.setState(CertState.CERT_STATE_WAIT_VERIFY);
                    //界面文案提示等待

                    showCertDetail(R.string.cert_creation_cert_status_wait_verify, chipBean);
                } else if (result.equals("47")) {

                    ModuleLog.e(commonResponse.getMessage());

                    //47-RA审核通过，等待签发
                    //                    chipBean.setState(CertState.RA_WAIT_FOR_MAKE_47);
                    //界面文案提示等待
                    //  showCertDetail(R.string.cert_creation_cert_status_wait_verify, chipBean);

                    if (info != null) {
                        applyRAstatus(PKCS10Utils.getInstance(chipBeanType, containerNum).getP10RequestBC(
                                chipBeanType, containerNum, info.getSubjectCn(), false));
                    } else {
                        getLastAuthRecord(true);
                    }


                } else if (result.equals("48")) {
                    //48-RA签发证书失败
                    // chipBean.setState(CertState.RA_MAKE_CERT_FAIL_48);
                    //文案提示证书签发失败

                    //                    showCertDetail(R.string.cert_creation_ra_sign_cert_fail, chipBean);
                    //                    showOtherFailLayout(CERT_STATE_RA_APPLY_FAIL, );

                    showRAApplyFailLayout();

                } else if (result.equals("52")) {

                    ModuleLog.e(commonResponse.getMessage());

                    if (info != null) {
                        //52-RA证书申请审核中
                        //                    chipBean.setState(CertState.RA_APPLY_WAIT_52);
                        //文案提示正在审核
                        String p10 = PKCS10Utils.getInstance(chipBeanType, containerNum).getP10RequestBC(chipBeanType, containerNum, info.getSubjectCn(), true);
                        //                        showOtherFailLayout(APPLY_CERT_STATUS_RA, p10);
                        showRAWaitLayout(p10);
                    } else {
                        getLastAuthRecord(false);

                    }


                } else if (result.equals("53")) {
                    //53-RA证书申请审核拒绝
                    //                    chipBean.setState(CertState.RA_APPLY_REJECT_53);
                    //证书申请被拒绝
                    //
                    //                    showErrorResponseLayout(context.getString(R.string.cert_creation_register_fail_reapply)
                    //                            , context.getString(R.string.cert_creation_ra_reject), true);


                    //此处设置为false是为了解决RA审核拒绝后，客户端在列表页下拉刷新至无证书页面后用手机号流程申请证书，在手机号页面点击提交按钮无响应的问题——jff 2020.10.09
                    DeviceWrapper.getInstance().setApplyCertEnd(false);
                    ModuleLog.e("onSuccessfulResponse : ");
                    showRARequestLayout(commonResponse.getMessage());
                } else if (result.equals("54")) {
                    //54-RA撤销申请审核中
                    chipBean.setState(CertState.RA_REVOKE_WAIT_54);
                    showCertDetail(R.string.cert_creation_revoke_ing, chipBean);
                    isCertOK = true;
                    //等待RA审核中
                } else if (result.equals("55")) {
                    //55-RA撤销申请拒绝
                    //RA拒绝了撤销申请
                    chipBean.setState(CertState.RA_REVOKE_REJECT_55);
                    chipBean.setReason(commonResponse.getMessage());
                    //                    showCertDetail(R.string.cert_creation_revoke_reject, chipBean);
                    showRARequestLayout(commonResponse.getMessage());
                    isCertOK = true;

                } else if (result.equals("56")) {

                    ModuleLog.e(commonResponse.getMessage());

                    //56-RA更新审核中
                    chipBean.setState(CertState.RA_UPDATE_WAIT_56);

                    String msg = commonResponse.getMessage();
                    String updateType = msg.substring(15, 16);
                    if (updateType.equals("1") || updateType.equals("3")) {//证书信息或者有效期更新
                        getLastAuthRecord(false);
                        isCertOK = true;
                    } else if (updateType.equals("2")) {//证书密钥更新
                        isCertOK = false;
                        getLastAuthRecord(true);
                    }

                } else if (result.equals("57")) {
                    //57：RA更新审核拒绝
                    chipBean.setState(CertState.RA_UPDATE_REJECT_57);
                    chipBean.setReason(commonResponse.getMessage());
                    //RA拒绝了更新请求
                    //                    showCertDetail(R.string.cert_creation_update_reject, chipBean);
                    //                    showErrorResponseLayout("",getResources().getString(R.string.cert_creation_update_reject)+ "\n" + commonResponse.getMessage(),false);

                    showRARequestLayout(commonResponse.getMessage());
                    isCertOK = true;
                }
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                //404	0x10a4	cert_status_other 	证书状态异常
                //400	0x10a3	cert_revoke_fail	证书注销失败
                String errorCode = baseErrorResponse.getErrCode();
                handleErrorResponse(errorCode);
            }

            @Override
            public void dismissDialog() {

            }
        });

    }


    /**
     * VHSM文件删除后，本地无证书，服务端有证书，撤销服务端证书，以便减少运维手动操作
     * <p>
     * 本方法因为是为了VHSM所写，所以里边的卡类型用固定的，不通过本类中的参数传递，因为有可能是VHSM被删除的情况下进行的此操作撤销的是服务端的证书
     */
    private void revoke(String sn) {
        RevokedCertRequest revokeRequest = new RevokedCertRequest();
        Info info = new Info();
        info.setSn(sn);
        info.setReason("");
        info.setTime(System.currentTimeMillis());
        revokeRequest.setInfo(info);
        String sign = DeviceWrapper.getInstance().signData(CryptoDevType.DEV_TYPE_Soft, 0, info.toString());

        if (sign != null) {
            if (sign.startsWith("errorCode")) {//签名时验证默认PIN码失败
                revokeRequest.setSign("111111111111111"); //本地公私钥删除时，默认签名值为15个1
            } else {
                revokeRequest.setSign(sign);
                ModuleLog.e("revoke sign " + sign + " 原文： " + info.toString());
            }
        } else {
            revokeRequest.setSign("111111111111111"); //本地公私钥删除时，默认签名值为15个1,VHSM文件删除后sign为null
        }

        revokeRequest.setCardType("" + CryptoDevType.DEV_TYPE_Soft.getType());

        new CertService().revokedCert(revokeRequest, cardNum, new HttpResponseCallBack<CommonResponse>() {
            @Override
            public void onOtherException(Exception e) {

                if (e instanceof CardNotExistException) {
                    // 提示卡设备不存在
                    ModuleToast.show(context, R.string.cert_creation_device_not_exist);
                } else {
                    e.printStackTrace();
                }
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                //                ModuleLog.e("注销异常： " + e.getMessage());
                //网络异常，请重试
                ModuleToast.show(context, R.string.net_disconnected_text);
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                String result = commonResponse.getResult();
                ModuleToast.show(context, R.string.cert_creation_detail_revoke_success);
                showNoCert();
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                ModuleLog.e("撤销失败： " + baseErrorResponse.getErrCode());
                ModuleToast.show(context, OkNetError.userError(getContext(), baseErrorResponse.getErrCode()));
            }

            @Override
            public void dismissDialog() {
            }
        });
    }


    private void getLastAuthRecord(final boolean isApplyCert) {
        certService.getLastAuthRecord(cardNum, new HttpResponseCallBack<LastAuthRecordResponse>() {
            @Override
            public void onOtherException(Exception e) {
                ModuleLog.e("other");
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                ModuleLog.e("io");
            }

            @Override
            public void onSuccessfulResponse(Call call, LastAuthRecordResponse lastAuthRecordResponse) {
                ModuleLog.e(lastAuthRecordResponse.toString());

                if (lastAuthRecordResponse != null) {
                    phone = lastAuthRecordResponse.getMessage().getPhone();
                    idNum = lastAuthRecordResponse.getMessage().getIdNum();
                    dn = lastAuthRecordResponse.getMessage().getDn();
                }

                //文案提示正在审核
                String p10 = PKCS10Utils.getInstance(chipBeanType, containerNum).getP10RequestBC(chipBeanType, containerNum, dn, isApplyCert);

                applyRAstatus(p10);

            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                ModuleLog.e(baseErrorResponse.toString());

            }

            @Override
            public void dismissDialog() {

            }
        });
    }


    private void showKeyPairWaitForUpdate(String tips) {
        // TODO: 2020/9/10 jff 此处需要测试一下界面点击是否有异常
        final View view = LayoutInflater.from(context).inflate(R.layout.cert_item_layout_update_key_pair_waiting, null);

        TextView tvMessage = view.findViewById(R.id.cert_item_top_one_content);
        tvMessage.setText(tips);

        RelativeLayout reApply = (RelativeLayout) view.findViewById(R.id.bottom_button_layout);
        reApply.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                CertStateRequest certStateRequest = buildRequest();
                query(certStateRequest);
            }
        });

        showView(view);
    }


    /**
     * 拿到服务器返回的cert，开始写卡，并展示
     *
     * @param cert
     */
    private void writeCert(final String cert, final boolean isWriteKeyPair) {

        ModuleLog.e("写入卡类型：" + chipBeanType);

        if (TextUtils.isEmpty(cert)) {
            DeviceWrapper.getInstance().setApplyCertEnd(false);
            return;
        }

        Runnable runnable = new Runnable() {
            @Override
            public void run() {

                final int result;
                if (isWriteKeyPair) {
                    result = DeviceWrapper.getInstance().importCert(chipBeanType, containerNum, cert);
                } else {
                    result = DeviceWrapper.getInstance().writeUpdateCert(chipBeanType, containerNum, cert);
                }

                ModuleLog.e("");
                myHandler.postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        if (result == 0) {
                            ModuleLog.e("证书已写入成功");
                            showCertDetail();

                        } else {
                            if (result == -4) {
                                importCertErrorCode = CLIENT_SERVER_CERT_RULE_DIFFERENT;
                            }
                            writeCertToServer(cert, "1");

                        }
                        DeviceWrapper.getInstance().setApplyCertEnd(false);
                        OttoUtil.postSwipPullResult(true);
                    }
                }, 10);

            }
        };
        chipExecutorService.exe(runnable);
    }

    /**
     * 发证成功后广播通知安全（接入）客户端
     */
    private void notifySafeAccess(Context context) {
        Intent intent = new Intent("com.xdja.aircert.write.success");
        context.sendBroadcast(intent);
    }

    private void showCertDetail() {
        Runnable runnable = new Runnable() {
            @Override
            public void run() {
                final CertDetailInfo certDetailInfo = DeviceWrapper.getInstance().readCertFromContainer(chipBeanType, containerNum,
                        certType);
                SharePreferencesUtil.saveCertSn(context, certDetailInfo.getSn());
                ModuleLog.e("");
                //读取证书后，切换到主线程展示证书详情
                myHandler.postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        ChipBean chipBean = new ChipBean();
                        chipBean.setType(CertItemView.this.chipBean.getType());
                        chipBean.setCertDetailInfo(certDetailInfo);
                        if (!BuildConfig.isAAR) {
                            //TODO JFF 在融合版签发证书功能未启用前不校验根证书，当启用时还需要继续验证
                            boolean isVerify = DeviceWrapper.getInstance().verifyCertByRoot(context, chipBeanType, containerNum);
                            chipBean.setIsVerify(isVerify);
                        }

                        // 证书已过期
                        if (!Util.certIsValid(chipBean.getCertBean())) {
                            chipBean.setState(CertState.CERT_OUT_OF_DATE);
                            showCertDetail(R.string.cert_creation_cert_out_of_date, chipBean);
                        } else {
                            chipBean.setState(CertState.SUCCESS);
                            if (chipBean.getState() == CertState.SUCCESS && !chipBean.getIsVerify()) {
                                showCertDetail(R.string.cert_creation_cert_not_in_system, chipBean);
                            } else {
                                showCertDetail(R.string.cert_creation_normal_state_item, chipBean);
                            }
                        }
                        chipBean.setName(getBeanName(chipBeanType));
                        //写卡成功后，将适配器中的申请流程设为false，这样其他状态再次进入证书列表页时可以刷新最新状态
                        notifySafeAccess(context);

                    }
                }, 10);
            }
        };

        chipExecutorService.exe(runnable);

    }

    //写卡状态上报
    private void writeCertToServer(final String cert, final String status) {
        Runnable runnable = new Runnable() {
            @Override
            public void run() {
                String sn = DeviceWrapper.getInstance().getSn(chipBeanType, containerNum, cert);
                //ModuleLog.e("待上报sn： " + sn);
                //                Looper.prepare();
                //                ModuleToast.show(context, R.string.cert_creation_import_cert_fail);
                final WriteFailRequest request = new WriteFailRequest();

                WriteFailInfo info = new WriteFailInfo();

                info.setSn(sn);
                info.setStatus(status);
                info.setTime(System.currentTimeMillis());
                request.setInfo(info);
                //ModuleLog.e("上报发送的request： " + request.toString());
                final String sign = DeviceWrapper.getInstance().signData(chipBeanType, containerNum, info.toString());


                myHandler.post(new Runnable() {
                    @Override
                    public void run() {

                        if (sign != null && sign.length() > 0) {
                            if (sign.startsWith("errorCode")) {
                                showErrorResponseLayout(sign.substring(9));
                            } else {
                                if (importCertErrorCode == CLIENT_SERVER_CERT_RULE_DIFFERENT) {
                                    showOtherFailLayout(IMPORT_CERT_FAIL, "");
                                }
                                request.setSign(sign);
                                request.setCardType("" + CryptoDevTypeUtil.convertCardType(chipBeanType.getType()));
                                uploadWriteCertResult(request);
                            }
                        } else {
                            showErrorResponseLayout(context.getString(R.string.cert_creation_signFail));
                        }

                    }
                });
            }
        };

        chipExecutorService.exe(runnable);
    }


    private void uploadWriteCertResult(BaseRequest request) {
        certService.uploadWriteCertResult(request, cardNum, new HttpResponseCallBack<CommonResponse>() {
                    @Override
                    public void onOtherException(Exception e) {
                        e.printStackTrace();
                    }

                    @Override
                    public void onIoExceptionFailure(Call call, IOException e) {
                        //网络异常，请重试
                        showOtherFailLayout(QUERY_CERT_INFO_FROM_SERVER, null);
                    }

                    @Override
                    public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {

                        if (commonResponse.getResult().equals("0")) {
                            ModuleLog.e("写卡上报失败成功");
                            //写卡失败

                        } else if (commonResponse.getResult().equals("1")) {
                            ModuleLog.e("写卡上报失败");
                            showOtherFailLayout(IMPORT_CERT_FAIL, "");
                        } else if (commonResponse.getResult().equals("45")) {
                            ModuleToast.show(context, "ra撤销审核中");
                            //写卡失败
                            showOtherFailLayout(IMPORT_CERT_FAIL, "");
                        }

                    }

                    @Override
                    public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                        //404	0x10a4	cert_status_other 	证书状态异常
                        //400	0x10a3	cert_revoke_fail	证书注销失败
                        String errorCode = baseErrorResponse.getErrCode();
                        handleErrorResponse(errorCode);
                    }

                    @Override
                    public void dismissDialog() {

                    }
                }
        );
    }


    /**
     * 目前只支持者四种芯片
     *
     * @param type
     * @return
     */
    private int getBeanName(CryptoDevType type) {
        switch (type) {
            case DEV_TYPE_SdCard:
                return R.string.cert_creation_tf_cert;
            case DEV_TYPE_Chip:
                return R.string.cert_creation_chip_cert;
            case DEV_TYPE_SimKey:
                return R.string.cert_creation_tiemo_cert;
            case DEV_TYPE_Soft:
                return R.string.cert_creation_soft_cert;
        }
        return R.string.cert_creation_chip_cert;

    }


    /**
     * 判断本地是否查找到证书
     *
     * @return
     */
    private boolean isChipBeanSizeIsZero() {
        return chipBean.getState() == CertState.NO_CERT;
    }

    /**
     * 2.3.【I-airIssue-api-003】实体认证结果查询
     */
    private void queryAuthenticationResult() {
        if (procedure.equals(Procedure.PHONE)) {
            showNoCert();
            return;
        }

        /**先判断网络是否正常，如果异常，则提示网络异常，直接return**/
        if (!CommonUtil.isNetworkConnected(context)) {
            showOtherFailLayout(QUERY_AUTHENTICATION_RESULT, null);
            return;
        }

        // 如果实体认证结果不是等待中，则不继续执行
        int checkResult = SharePreferencesUtil.getCheckResult(context, chipBeanType.getType());
        if (checkResult != 0) {
            showNoCert();
            return;
        }


        String identityNum = SharePreferencesUtil.getIDCardNo(context, chipBean.getType());
        if (TextUtils.isEmpty(identityNum)) {
            // TODO: 2019/1/24 0024
            // 这个地方一定要判断身份证号是否为空，否则网络请求处理会崩溃
            // 理想状态下此处读到的身份证不可能为空
            // 但是，如果真的为空了，我们改怎么处理？
            return;
        }
        certService.queryAuthenticationResult(identityNum, cardNum, new HttpResponseCallBack<SigResultResponse>() {
            @Override
            public void onOtherException(Exception e) {
                if (e instanceof CardNotExistException) {
                    // 提示卡设备不存在
                    // ModuleToast.show(CertDetailInfoActivity.this, R.string.device_not_exist);
                    // 上面提示卡设备不存在
                    showErrorResponseLayout("设备不存在", "请重新申请", true);
                    // 下面显示申请证书

                } else {
                    e.printStackTrace();
                }
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                showOtherFailLayout(QUERY_AUTHENTICATION_RESULT, null);
            }

            @Override
            public void onSuccessfulResponse(Call call, SigResultResponse commonResponse) {
                handleAuthResult(commonResponse);
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                String errorCode = baseErrorResponse.getErrCode();
                handleErrorResponse(errorCode);
            }

            @Override
            public void dismissDialog() {

            }
        });
    }


    /**
     * 处理服务器返回的错误码
     *
     * @param errorCode
     */
    private void handleErrorResponse(String errorCode) {
        ModuleLog.d("errorCode : " + errorCode);
        if (OkNetError.NOT_FOUND_CHECK_INFO_CODE.equals(errorCode)) {
            DeviceWrapper.getInstance().setApplyCertEnd(true);
            showNoCert();
        } else if (OkNetError.NOT_EXIST_INFO_CODE.equals(errorCode)) {
            //证书信息不存在，若本地有证书，则直接展示；若不存在，则查询实体认证结果
            if (isChipBeanSizeIsZero()) {
                queryAuthenticationResult();

            } else {
                CertItemView.this.chipBean.setState(CertState.SERVER_NOCERT);
                showCertDetail(R.string.cert_creation_detail_revoke_success, CertItemView.this.chipBean);
            }
        } else if (OkNetError.DEVICE_NO_ACTIVATION_CODE.equals(errorCode)) {
            showDevNOActivation();
        } else {
            String msg = OkNetError.handleErrorCodeToMsg(this.context, errorCode);
            showErrorResponseLayout(msg);
        }
    }

    String phone;

    String idNum;

    String dn;

    private CertApplyRequest getCertApplyReq(final String p10) {

        if (TextUtils.isEmpty(p10)) {
            return null;
        }
        //如果申请p10失败，则直接展示申请证书失败页面。
        if (p10.startsWith("errorCode")) {
            ModuleLog.e(" p10.startsWith(\"errorCode\") " + p10);

            if (p10.contains("^[0-6]*$")) {
                // TODO: jff 2018-12-15 该出需要分析具体该怎么处理 第六迭代
                // dialog.show();
            }
            ModuleLog.e(" : " + Thread.currentThread().getName());
            ModuleLog.e(" : " + Looper.myLooper());
            handleErrorResponse(p10.substring(9));


            DeviceWrapper.getInstance().setApplyCertEnd(false);
            OttoUtil.postSwipPullResult(true);
            return null;
        } else if (p10.isEmpty()) {
            //TODO JFF 18.7.24展示错误信息
            DeviceWrapper.getInstance().setApplyCertEnd(false);

            ModuleLog.e("p10.isEmpty()");
        }

        CertApplyRequest certApplyRequest = new CertApplyRequest();

        ChipInfo chipInfo = new ChipInfo();
        DeviceWrapper deviceWrapper = DeviceWrapper.getInstance();
        chipInfo.setCardType("" + CryptoDevTypeUtil.convertCardType(chipBean.getType()));
        chipInfo.setImei(deviceWrapper.getIMEI());
        String imsi = deviceWrapper.getIMSI();
        chipInfo.setImsi(imsi);

        String result = SharePreferencesUtil.getPhoneNum(context);
        if (TextUtils.isEmpty(result)) {
            result = phone;
        }

        chipInfo.setPhone(result);
        certApplyRequest.setChipInfo(chipInfo);

        MobileInfo mobileInfo = new MobileInfo();
        mobileInfo.setCommType(DeviceUtil.getInstance().getOperator() + "");
        mobileInfo.setTerminalBand(DeviceUtil.getInstance().getBrand());
        mobileInfo.setTerminalType("1");
        certApplyRequest.setMobileInfo(mobileInfo);

        String id = SharePreferencesUtil.getIDCardNo(context, chipBean.getType());
        if (TextUtils.isEmpty(id)) {
            id = idNum;
        }

        if (!procedure.equals(Procedure.PHONE)) {
            certApplyRequest.setIdentityNo(id);
        } else {
            certApplyRequest.setIdentityNo(result);
        }
        certApplyRequest.setP10(p10);
        return certApplyRequest;
    }


    /**
     * 2.4.【I-airIssue-api-004】证书申请
     *
     * @param p10
     */
    private void applyCertRequest(final String p10) {
        if (!CommonUtil.isNetworkConnected(context)) {
            ModuleToast.show(context, R.string.net_disconnected_text);
            return;
        }
        ModuleLog.e(" ");
        CertApplyRequest certApplyRequest = getCertApplyReq(p10);

        if (certApplyRequest == null) {
            return;
        }

        certService.applyCert(certApplyRequest, cardNum, new HttpResponseCallBack<CertApplyResponse>() {
            @Override
            public void onOtherException(Exception e) {
                e.printStackTrace();
                DeviceWrapper.getInstance().setApplyCertEnd(false);
                ModuleLog.e(" ");
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                ModuleLog.e("1");
                DeviceWrapper.getInstance().setApplyCertEnd(false);
                //TODO jff 2018-6-2 证书申请失败为什么要继续申请证书
                showOtherFailLayout(APPLY_CERT_REQUEST, p10);
                OttoUtil.postSwipPullResult(true);
            }

            @Override
            public void onSuccessfulResponse(Call call, CertApplyResponse certApplyResponse) {
                String result = certApplyResponse.getResult();
                ModuleLog.e(" result : " + result);
                if (result.equals("1")) {//1签发证书成功
                    String cert = certApplyResponse.getCert();
                    //                    cert = cert.substring(9,cert.length()-2);
                    writeCert(cert, true);
                } else if (result.equals("52")) {//45-RA审核中
                    //                    showOtherFailLayout(APPLY_CERT_STATUS_RA, p10);

                    //暂时屏蔽是尝试解决点击刷新按钮会出现两次拒绝理由页面的问题 jff 2020.10.10
                    showRAWaitLayout(p10);

                    OttoUtil.postSwipPullResult(true);
                } else if (result.equals("53")) {//46-RA审核拒绝
                    showCertDetail(R.string.cert_creation_revoke_reject, chipBean);
                }
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                ModuleLog.e("申请证书失败");
                DeviceWrapper.getInstance().setApplyCertEnd(false);
                String errorCode = baseErrorResponse.getErrCode();
                handleErrorResponse(errorCode);
                OttoUtil.postSwipPullResult(true);
            }

            @Override
            public void dismissDialog() {

            }
        });
    }


    /**
     * 2.27.【I-airIssue-api-0027】证书申请状态查询
     *
     * @param p10
     */
    private void applyRAstatus(final String p10) {

        showChecking();

        if (!CommonUtil.isNetworkConnected(context)) {
            ModuleToast.show(context, R.string.net_disconnected_text);
            return;
        }

        CertApplyRequest certApplyRequest = getCertApplyReq(p10);

        if (certApplyRequest == null) {
            return;
        }

        certService.applyRAStatus(certApplyRequest, cardNum, new HttpResponseCallBack<CertApplyRAStatusResponse>() {
            @Override
            public void onOtherException(Exception e) {
                e.printStackTrace();
                DeviceWrapper.getInstance().setApplyCertEnd(false);
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                DeviceWrapper.getInstance().setApplyCertEnd(false);
                showOtherFailLayout(APPLY_CERT_REQUEST, p10);
                OttoUtil.postSwipPullResult(true);
            }

            @Override
            public void onSuccessfulResponse(Call call, CertApplyRAStatusResponse certApplyResponse) {
                String result = certApplyResponse.getResult();
                Log.e("jff", "2370 CertItemView onSuccessfulResponse result : " + result);
                if (result.equals("1")) {//1签发证书成功
                    String cert = certApplyResponse.getMessage();
                    Log.e("jff", "2085 CertItemView onSuccessfulResponse cert : " + cert);

                    cert = cert.substring(9, cert.length() - 2);

                    // TODO: 2020/8/10 0010 这段代码在对接完更新密钥流程后再测试
                    int length = CertUtil.Companion.getLength(cert);

                    if (length == 2) {
                        // 2代表单证
                        writeCert(cert, true);
                    } else if (length == 4) {
                        // 4代表双证（对接RA时只有SM2有双证）
                        // 如果双证的第三段为null，证明是更新证书的更新用户信息/使用日期，写卡无需更新密钥对
                        boolean isWriteKeyPair = !CertUtil.Companion.updateDoubleCertNoKeyPair(cert);
                        writeCert(cert, isWriteKeyPair);
                    }


                } else if (result.equals("52")) {//45-RA审核中
                    //                    showOtherFailLayout(APPLY_CERT_STATUS_RA, p10);
                    showRAWaitLayout(p10);
                } else if (result.equals("53")) {//46-RA审核拒绝

                    showRARequestLayout(certApplyResponse.getMessage());
                    //                    showErrorResponseLayout(context.getString(R.string.cert_creation_register_fail_reapply)
                    //                            , context.getString(R.string.cert_creation_ra_reject), true);
                    DeviceWrapper.getInstance().setApplyCertEnd(false);
                }
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                DeviceWrapper.getInstance().setApplyCertEnd(false);
                String errorCode = baseErrorResponse.getErrCode();
                handleErrorResponse(errorCode);
                OttoUtil.postSwipPullResult(true);
            }

            @Override
            public void dismissDialog() {

            }
        });
    }


    /**
     * 处理实体认证的结果，并申请发证
     * <p>
     * 或处理注册成功后的结果，并申请发证
     *
     * @param result
     */
    @Subscribe
    public void onPhoneResult(PhoneAuthResult result) {
        if (result != null) {
            handlePhoneResult(result);
        }
    }


    @Subscribe
    public void onCertStatusResult(CertStatusResult result) {
        if (result != null) {
            handleCertStatus(result);
        }
    }


    @Subscribe
    public void handleWriteUpdateCertEvent(WriteUpdateCertEvent certEvent) {

        ModuleLog.e("更新证书");

        if (certEvent.getType() != chipBeanType) {
            return;
        }

        if (certEvent.getContainerNum() != containerNum) {
            return;
        }

        ModuleLog.e("需要更新证书的卡类型 " + certEvent.getType() + "\n"
                + "容器号 " + certEvent.getContainerNum()
        );

        if (TextUtils.isEmpty(certEvent.getCert())) {
            return;
        }

        showChecking(R.string.cert_creation_is_update_cert);

        String cert = certEvent.getCert();
        cert = cert.substring(9, cert.length() - 2);
        writeCert(cert, certEvent.isUpdateKeyPair());

    }

    /**
     * RA人工审核结果，3.27接口的处理
     *
     * @param updateCertStateEvent
     */
    @Subscribe
    public void onUpdateCertState(UpdateCertStateEvent updateCertStateEvent) {
        Log.e("jff", "2028 CertItemView onUpdateCertState : 证书更新结果 失败或者审核中 ");
        /**
         * 列表页每个Item都能收到事件，需要先校验卡类型
         */
        if (updateCertStateEvent.getType().getType() != chipBeanType.getType()) {
            return;
        }
        if (updateCertStateEvent.getContainerNum() != containerNum) {
            return;
        }
        int result = updateCertStateEvent.getResult();

        // TODO: 2020/7/27 0027 这个地方地方需要重构掉
        // RA审核时，列表页和详情页的文字都要变更
        // 由于只有“空中发证管理员已审核通过，CA系统正在审核。”这一个提示
        // 但列表页需要展示“更新审核中”，所以手动改下这个值
        if (result == R.string.cert_creation_cert_update_ra_wait) {
            result = R.string.cert_creation_update_ing;
        }
        // 2020/7/27 0027

        if (result != 0) {
            showCertDetail(result, CertItemView.this.chipBean);
        }
        chipBean.setState(CertState.RA_UPDATE_WAIT_56);

    }

    private void handlePhoneResult(PhoneAuthResult phoneAuthResult) {

        PhoneResult auth = phoneAuthResult.getPhoneResult();


        CryptoDevType type = auth.getType();
        CompareResult result = auth.getResult();
        //因为我们是在Item中注册的Otto，所以一条结果所有的Item都能收到
        //为了避免因此导致的界面更新混乱，现采用卡类型作为标志位（现假设一个手机上同一种卡设备只可能有一个）
        if (chipBeanType == null || type == null) {
            return;
        }

        if (type.getType() != chipBeanType.getType()) {
            return;
        }

        if (phoneAuthResult.getContainerNum() != containerNum) {
            return;
        }

        //        ModuleLog.e("手机号校验结果= " + result.toString());
        if (result.isSuccess()) {
            String ret = result.getResult();
            SharePreferencesUtil.saveCheckResult(context, chipBeanType.getType(), Integer.parseInt(ret));
            switch (ret) {
                case "0"://手机号格式正确
                    break;
                case "1"://手机号格式不正确
                case "2"://手机号长度不正确
                    DeviceWrapper.getInstance().setApplyCertEnd(false);
                    showErrorResponseLayout(context.getString(R.string.cert_creation_register_fail_reapply),
                            context.getString(R.string.cert_creation_phone_number_wrong), true);
                    break;
            }
        }

    }

    private void handleCertStatus(CertStatusResult cert) {

        String result = cert.getResult();

        switch (result) {
            case "-1":
                DeviceWrapper.getInstance().setApplyCertEnd(false);
                showErrorResponseLayout("",
                        context.getString(R.string.cert_creation_device_occupied_delay), true);
                ModuleLog.e("异常处理");
                break;
        }

    }


    /**
     * 处理实体认证的结果，并申请发证
     * <p>
     * 或处理注册成功后的结果，并申请发证
     *
     * @param authResult
     */
    @Subscribe
    public void onAuthResult(AuthResult authResult) {

        boolean success = validAuth(authResult);

        if (!success) {
            return;
        }
        CompareResult compareResult = authResult.getResult();
        if (compareResult.isSuccess()) {
            Log.e("jff", "2498 CertItemView onAuthResult 实体认证成功: ");
            handleAuthResult(compareResult);
        } else {
            DeviceWrapper.getInstance().setApplyCertEnd(false);
            String message = compareResult.getMessage();
            if (TextUtils.isEmpty(message)) {
                showRegisterFail();
            } else {
                showErrorResponseLayout(context.getString(R.string.cert_creation_register_fail_reapply), handleErrorCodeToMsg(context, compareResult.getErrCode()), true);
            }
        }


    }

    /**
     * 验证是否是当前设备、当前容器的界面更新
     *
     * @param authResult
     * @return
     */
    private boolean validAuth(final AuthResult authResult) {

        if (authResult == null) {
            return false;
        }

        if (authResult.getObject() == null) {
            return false;
        }

        if (!authResult.getObject().equals(object)) {
            ModuleLog.e("当前可能有内存泄露，存在多个列表页界面");
            return false;
        }

        //因为我们是在Item中注册的Otto，所以一条结果所有的Item都能收到
        //为了避免因此导致的界面更新混乱，现采用卡类型作为标志位（现假设一个手机上同一种卡设备只可能有一个）
        if (chipBeanType == null || authResult.getType() == null) {
            DeviceWrapper.getInstance().setApplyCertEnd(false);
            return false;
        }

        if (authResult.getType().getType() != chipBeanType.getType()) {
            ModuleLog.d("非当前设备，\n需要更新的设备：" + authResult.getType()
                    + "\n当前设备：" + chipBeanType
            );
            DeviceWrapper.getInstance().setApplyCertEnd(false);
            return false;
        }

        if (authResult.getContainerNum() != containerNum) {
            ModuleLog.d("非当前容器号，\n需要更新的容器号" + authResult.getContainerNum()
                    + "\n当前容器号：" + containerNum
            );
            DeviceWrapper.getInstance().setApplyCertEnd(false);
            return false;
        }

        return true;

    }

    private byte[] vhsmSign;

    /**
     * 处理实体认证结果
     *
     * @param result
     */
    private void handleAuthResult(CommonResponse result) {
        String ret = result.getResult();
        SharePreferencesUtil.saveCheckResult(context, chipBeanType.getType(), Integer.parseInt(ret));
        switch (ret) {
            case "0"://等待审核
                showWaiteVerity();
                break;
            case "1"://审核通过
                //2021.12.27 jff ver2.3接口文档，3.3接口返回值变更
                String sig = null;
                if (result instanceof CompareResult) {
                    sig = ((CompareResult) result).getSig();
                    authResultMsg = ((CompareResult) result).getDn();
                } else if (result instanceof SigResultResponse) {
                    sig = ((SigResultResponse) result).getSig();
                    authResultMsg = ((SigResultResponse) result).getDn();
                }

                //如果目前展示的是netVHSM且VHSM没有进行初始化，需要对NetVHSM进行初始化
                if (isOnlineVHSM
                        && certItemBean.getCryptoDevInfo().getType() == CryptoDevType.DEV_TYPE_Soft
                        && 2 == NetVHSMHandle.isNetVHSMCanUse(context)
                ) {
                    showChecking(R.string.cert_creation_vhsm_init);
                    Log.e("jff", "2587 CertItemView handleAuthResult 界面应该显示VHSM初始化loading: ");
                    vhsmSign = Util.hexStr2byteArr(sig);
                    new Thread(new Runnable() {
                        @Override
                        public void run() {
                            if (CardType.REQUEST_PARAM_ONLINE_VHSM.equals("1")) {
                                NetVHSMHandle.initVHSM(context, AppConfig.getInstance().getServerSettingConfig().getVhsm_ip(),
                                        Integer.valueOf(AppConfig.getInstance().getServerSettingConfig().getVhsm_port()));
                            } else {
                                NetVHSMHandle.initVHSM(context,
                                        AppConfig.getInstance().getServerSettingConfig().getVhsm_ip(),
                                        Integer.valueOf(AppConfig.getInstance().getServerSettingConfig().getVhsm_port()),
                                        SharePreferencesUtil.getPhoneNum(context),
                                        vhsmSign);
                            }
                        }
                    }).start();

                    //初始化结果在handleNetVhsmInitResult里处理
                } else {
                    applyCertTask();
                }
                break;
            case "2"://审核拒绝
                DeviceWrapper.getInstance().setApplyCertEnd(false);
                authResultMsg = result.getMessage();
                if (TextUtils.isEmpty(authResultMsg)) {
                    showRegisterFail();
                } else {
                    showErrorResponseLayout(context.getString(R.string.cert_creation_register_fail_reapply), authResultMsg, true);
                }
                break;
        }

    }


    private void applyCertTask() {
        //组装p10，获取证书
        synchronized (this) {
            GenP10Task task = new GenP10Task();
            task.execute();
        }
    }


    class GenP10Task extends AsyncTask<Void, Void, Integer> {

        private String p10;

        private int P10_Error = -1;

        private int SUCCESS = 0;

        @Override
        protected void onPreExecute() {
            super.onPreExecute();
            ModuleLog.d("准备封装P10");
            showChecking(R.string.cert_creation_is_applying_cert);
            OttoUtil.postSwipPullResult(false);
        }

        @Override
        protected Integer doInBackground(Void... voids) {


            p10 = PKCS10Utils.getInstance(chipBeanType, containerNum).getP10RequestBC(chipBeanType, containerNum, authResultMsg, true);

            Log.e("jff", "2685 GenP10Task doInBackground : ");
            if (TextUtils.isEmpty(p10)) {
                return P10_Error;
            } else {
                return SUCCESS;
            }


        }

        @Override
        protected void onPostExecute(Integer result) {
            super.onPostExecute(result);

            if (result == P10_Error) {
                showErrorResponseLayout(context.getString(R.string.cert_creation_register_fail_reapply)
                        , context.getString(R.string.cert_creation_device_not_exist), true);
                DeviceWrapper.getInstance().setApplyCertEnd(false);
                ModuleLog.e("P10_Error : " + result);
                OttoUtil.postSwipPullResult(true);
            } else if (result == SUCCESS) {

                Message message = new Message();
                message.what = SUCCESS;
                message.obj = p10;

                new GenP10Handler().sendMessage(message);
            }

        }
    }

    class GenP10Handler extends Handler {
        @Override
        public void handleMessage(Message msg) {
            super.handleMessage(msg);

            if (msg.what == 0) {

                String p10 = (String) msg.obj;
                ModuleLog.e("p10生成完毕");

                ApplyTask task = new ApplyTask(p10);
                task.execute();

            }

        }
    }

    class ApplyTask extends AsyncTask<Void, Void, Integer> {

        private String p10;

        private int NET_ERR = -1;

        private int GEN_REQUEST_PARAM_ERROR = -2;

        private int SUCCESS = 0;

        CertApplyRequest certApplyRequest;

        public ApplyTask(String p10) {
            this.p10 = p10;
        }

        @Override
        protected void onPreExecute() {
            super.onPreExecute();
        }

        @Override
        protected Integer doInBackground(Void... voids) {
            return SUCCESS;

        }

        @Override
        protected void onPostExecute(Integer integer) {
            super.onPostExecute(integer);
            int result = SUCCESS;
            if (!CommonUtil.isNetworkConnected(context)) {
                result = NET_ERR;
            } else {
                certApplyRequest = getCertApplyReq(p10);
                if (certApplyRequest == null) {
                    ModuleLog.e("certApplyRequest == null");
                    result = GEN_REQUEST_PARAM_ERROR;
                } else {
                    result = SUCCESS;
                }

            }
            if (result == NET_ERR) {
                ModuleToast.show(context, R.string.net_disconnected_text);
                ModuleLog.e("申请证书网络异常，此处本地如果之前有证书，应该撤销原来证书，当前未处理");
            } else if (result == GEN_REQUEST_PARAM_ERROR) {
                ModuleLog.e("生成请求异常 GEN_REQUEST_PARAM_ERROR，此处本地如果之前有证书，应该撤销原来证书，当前未处理");
            } else if (result == SUCCESS) {
                ModuleLog.e("开始申请证书");

                certService.applyCert(certApplyRequest, cardNum, new HttpResponseCallBack<CertApplyResponse>() {
                    @Override
                    public void onOtherException(Exception e) {
                        e.printStackTrace();
                        DeviceWrapper.getInstance().setApplyCertEnd(false);
                        ModuleLog.e("申请证书网络请求异常，此处本地如果之前有证书，应该撤销原来证书，当前未处理");
                    }

                    @Override
                    public void onIoExceptionFailure(Call call, IOException e) {
                        DeviceWrapper.getInstance().setApplyCertEnd(false);
                        //TODO jff 2018-6-2 证书申请失败为什么要继续申请证书
                        new Handler().post(new Runnable() {
                            @Override
                            public void run() {
                                showOtherFailLayout(APPLY_CERT_REQUEST, p10);
                            }
                        });
                        OttoUtil.postSwipPullResult(true);
                        ModuleLog.e("申请证书网络请求返回IO异常，此处本地如果之前有证书，应该撤销原来证书，当前未处理");
                    }

                    @Override
                    public void onSuccessfulResponse(Call call, CertApplyResponse certApplyResponse) {

                        String result = certApplyResponse.getResult();

                        if (result.equals("1")) {//1签发证书成功
                            String cert = certApplyResponse.getCert();
                            //                    cert = cert.substring(9,cert.length()-2);
                            writeCert(cert, true);
                        } else if (result.equals("52")) {//45-RA审核中
                            //                    showOtherFailLayout(APPLY_CERT_STATUS_RA, p10);
                            new Handler().post(new Runnable() {
                                @Override
                                public void run() {
                                    showRAWaitLayout(p10);
                                }
                            });

                            OttoUtil.postSwipPullResult(true);
                        } else if (result.equals("53")) {//46-RA审核拒绝
                            new Handler().post(new Runnable() {
                                @Override
                                public void run() {
                                    showCertDetail(R.string.cert_creation_revoke_reject, chipBean);
                                }
                            });

                        }
                    }

                    @Override
                    public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                        DeviceWrapper.getInstance().setApplyCertEnd(false);
                        final String errorCode = baseErrorResponse.getErrCode();
                        new Handler().post(new Runnable() {
                            @Override
                            public void run() {
                                handleErrorResponse(errorCode);
                            }
                        });

                        OttoUtil.postSwipPullResult(true);
                        ModuleLog.e("申请证书网络请求返回失败，此处本地如果之前有证书，应该撤销原来证书，当前未处理");
                    }

                    @Override
                    public void dismissDialog() {

                    }
                });
            }
        }
    }

    private void revokeOwnOldCert() {
        RevokeOwnOldCertRequest revokeOwnOldCertRequest = new RevokeOwnOldCertRequest();
        revokeOwnOldCertRequest.setCardType("" + CryptoDevTypeUtil.convertCardType(chipBean.getType()));
        certService.revokeOwnOldCert(revokeOwnOldCertRequest, deviceID, new HttpResponseCallBack<SigResultResponse>() {
            @Override
            public void onOtherException(Exception e) {

            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {

            }

            @Override
            public void onSuccessfulResponse(Call call, SigResultResponse commonResponse) {
                if (commonResponse.getResult().equals("1")) {//撤销非当前设备的证书成功
                    //后台已经进行实体认证，可直接进行对实体认证结果进行处理，commonResponse包含dn信息
                    handleAuthResult(commonResponse);
                } else if (commonResponse.getResult().equals("0")) {//实体认证等待审核
                    showWaiteVerity();
                }
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                handleErrorResponse(baseErrorResponse.getErrCode());
            }

            @Override
            public void dismissDialog() {

            }
        });
    }


    /**
     * 获取p10，然后申请证书
     */
    String p10RequestBC;

    @Override
    public boolean showContextMenuForChild(View originalView) {
        return super.showContextMenuForChild(originalView);
    }

    private void getP10RequestBCAndApplyCert(final String dn) {
        ModuleLog.e(" ");

        //切换到主线程，申请证书

        p10RequestBC = PKCS10Utils.getInstance(chipBeanType, containerNum).getP10RequestBC(chipBeanType, containerNum, dn, true);
        ModuleLog.e("end getP10RequestBC");
        if (TextUtils.isEmpty(p10RequestBC)) {
            myHandler.postDelayed(new Runnable() {
                @Override
                public void run() {
                    showErrorResponseLayout(context.getString(R.string.cert_creation_register_fail_reapply)
                            , context.getString(R.string.cert_creation_device_not_exist), true);
                    DeviceWrapper.getInstance().setApplyCertEnd(false);
                    OttoUtil.postSwipPullResult(true);
                }
            }, 10);

            return;
        }


        myHandler.postDelayed(new Runnable() {
            @Override
            public void run() {
                ModuleLog.e("start  applyCertRequest");
                applyCertRequest(p10RequestBC);
            }
        }, 10);

    }


    public void onDestroy() {
        BusProvider.unRegister(this);
    }

    public int getContainerNum() {
        return containerNum;
    }

    public String getCertType() {
        return certType;
    }

    public boolean getAllowApplyCert() {
        return allowApplyCert;
    }

    private boolean isIPFail() {
        return AppConfig.getInstance().getServerSettingConfig()
                .getIp().contains("|");
    }
}
