package com.xdja.safeclient.certcreation.view;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.os.Message;
import android.support.annotation.StringRes;
import android.text.TextUtils;
import android.widget.ImageView;
import android.widget.TextView;

import com.aircert.util.WeakReferenceHandler;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.util.AnimUtil;


/**
 * loading 对话框
 * 从芯片管家项目中移植过来
 * Created by guoyaxin on 2016/9/2.
 */
public class LoadingDialog extends Dialog {

    private Context context;
    private TextView tv_content;
    private ImageView progressBar;

    int contentResID;

    public LoadingDialog(Context context) {
        super(context, R.style.Theme_AppCompat_Dialog);
        this.context = context;
    }

    public LoadingDialog(Context context, @StringRes int contentResID) {
        super(context, R.style.Theme_AppCompat_Dialog);
        this.context = context;
        this.contentResID = contentResID;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.loading_dialog);
        tv_content = (TextView) findViewById(R.id.tv_content);
        progressBar = (ImageView) findViewById(R.id.progressBar2);
        AnimUtil.rotate(context, progressBar);

        setContent(this.content);

        if (contentResID != 0) {
            tv_content.setText(contentResID);
        }

        setCanceledOnTouchOutside(false);
    }


    public void setContent(String content) {
        if (TextUtils.isEmpty(content))
            return;
        this.content = content;
        if (tv_content == null) {
            return;
        }
        tv_content.setText(this.content);
    }


    private String content;

    public void setContent(@StringRes int strRes) {
        if (strRes == 0)
            return;
        this.content = getContext().getString(strRes);
        if (tv_content == null) {
            return;
        }
        tv_content.setText(this.content);
    }


    public void showLoading() {
        if (isShowing()) {
            return;
        }
        show();
    }


    public void dismissLoading() {
        if (isShowing()) {
            dismiss();

        }


    }

    private MyHandler myHandler = new MyHandler(this);
    private static final int MSG_DISMISS = 0;

    static class MyHandler extends WeakReferenceHandler<LoadingDialog> {

        public MyHandler(LoadingDialog reference) {
            super(reference);
        }

        @Override
        protected void handleMessage(LoadingDialog reference, Message msg) {
//            Log.d("loadingDialog", "handleMessage");
            //modify 2017年8月28日14:59:29 weizg  关闭对话框前，做非空和现在显示判断
            if (reference != null && reference.isShowing()) {

                //add 2018年3月26日19:24:15 weizg
                //monkey测试发现，该dialog dismiss时其所依赖的activity已经销毁，
                //然后执行dismiss方法时会出现IllegalArgumentException，not attached to window manager
                try {
                    reference.dismiss();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }


}
