package com.xdja.safeclient.certcreation.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.StringRes;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.xdja.safeclient.certcreation.R;

/**
 * Created by Administrator on 2018/6/27 0027.
 */

public class ProChooseView extends RelativeLayout {

    private TextView leftText;

    private TextView rightText;

    public ProChooseView(Context context) {
        super(context);
    }

    public ProChooseView(Context context, AttributeSet attrs) {
        super(context, attrs);
        LayoutInflater.from(context).inflate(R.layout.edittext_profession, this);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.ProChooseView);
        initView(ta);
        ta.recycle();
    }

    private void initView(TypedArray ta) {
        leftText = (TextView) findViewById(R.id.tag);

        int keyId = ta.getResourceId(R.styleable.ProChooseView_left, 0);

        if (keyId != 0) {
            String text = getContext().getString(keyId);
            leftText.setText(TextUtils.isEmpty(text) ? "" : text);
        }

        rightText = (TextView) findViewById(R.id.value);
        rightText.setText(ta.getString(R.styleable.ProChooseView_right));

        int hintId = ta.getResourceId(R.styleable.ProEditView_hint, 0);
        if (hintId != 0) {
            String text = getContext().getString(hintId);
            rightText.setHint(TextUtils.isEmpty(text) ? "" : text);
        } else {
            String hintText = ta.getString(R.styleable.ProChooseView_hint);
            if (!TextUtils.isEmpty(hintText)) {
                setHint(hintText);
            }
        }

    }

    public void setLeftText(@StringRes int resId) {
        leftText.setText(resId);
    }

    public void setRightText(CharSequence text) {
        rightText.setText(text);
    }

    public void setHint(CharSequence hint) {
        rightText.setHint(hint);
    }

    public void setHint(@StringRes int resId) {
        rightText.setHint(resId);
    }


}
