/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.activity;

import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.StringRes;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.aircert.util.CommonUtil;
import com.aircert.util.ModuleLog;
import com.squareup.otto.Subscribe;
import com.xdja.cryptodev.CryptoDevManager;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.HttpResponseCallBack;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.BaseActivity;
import com.xdja.safeclient.certcreation.activity.ReasonActivity;
import com.xdja.safeclient.certcreation.activity.UpdateCertActivity;
import com.xdja.safeclient.certcreation.bean.CertDetailInfo;
import com.xdja.safeclient.certcreation.bean.CertState;
import com.xdja.safeclient.certcreation.bean.ChipBean;
import com.xdja.safeclient.certcreation.bean.ChipInfo;
import com.xdja.safeclient.certcreation.bean.MobileInfo;
import com.xdja.safeclient.certcreation.bean.OkNetError;
import com.xdja.safeclient.certcreation.bean.request.CertApplyRequest;
import com.xdja.safeclient.certcreation.bean.request.CertStateRequest;
import com.xdja.safeclient.certcreation.bean.request.Info;
import com.xdja.safeclient.certcreation.bean.request.RevokedCertRequest;
import com.xdja.safeclient.certcreation.bean.request.WriteFailInfo;
import com.xdja.safeclient.certcreation.bean.request.WriteFailRequest;
import com.xdja.safeclient.certcreation.bean.response.BaseErrorResponse;
import com.xdja.safeclient.certcreation.bean.response.CertApplyRAStatusResponse;
import com.xdja.safeclient.certcreation.bean.response.CommonResponse;
import com.xdja.safeclient.certcreation.device.DeviceUtil;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.device.PKCS10Utils;
import com.xdja.safeclient.certcreation.event.RevokeResultEvent;
import com.xdja.safeclient.certcreation.event.RevokeSuccessEvent;
import com.xdja.safeclient.certcreation.event.SpecificActivity;
import com.xdja.safeclient.certcreation.event.UpdateCertStateEvent;
import com.xdja.safeclient.certcreation.exception.CardNotExistException;
import com.xdja.safeclient.certcreation.service.CertService;
import com.xdja.safeclient.certcreation.util.CryptoDevTypeUtil;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import com.xdja.safeclient.certcreation.util.SharePreferencesUtil;
import com.xdja.safeclient.certcreation.util.Util;
import com.xdja.safeclient.certcreation.view.PinDialog;
import java.io.IOException;
import java.io.Serializable;
import okhttp3.Call;

public class CertDetailInfoActivity
extends BaseActivity
implements View.OnClickListener {
    private TextView sn;
    private TextView ver;
    private TextView signAlg;
    private TextView user;
    private TextView issuer;
    private TextView notBefore;
    private TextView notAfter;
    private RelativeLayout rlSignCert;
    private RelativeLayout rlEncryptCert;
    private RelativeLayout rlCertRule;
    private View vSignDivider;
    private View vEncryptDivider;
    private CertDetailInfo signCertData;
    private CertDetailInfo encryptCertData;
    private String currentSelect = "\u7b7e\u540d\u8bc1\u4e66";
    public ChipBean bean;
    public int containerNum;
    public String certType;
    public boolean inUse;
    public boolean allowApplyCert;
    private FrameLayout certStatus;
    private CertService certService = new CertService();
    private Context context;
    private CryptoDevType chipBeanType;
    private String cardID;
    private PinDialog pinDialog;
    private final int REVOKE_CERT = 1;
    private final int DELETE_CERT = 2;
    private final int UPDATE_CERT_INFO = 3;
    private int operate_type = -1;
    private boolean isShowUpdate = true;
    private static Handler myHandler = new Handler();
    Button revoke;
    Button revoke_full;
    Button delete;
    Button update;
    Button refresh;
    RelativeLayout bottomButton;

    @Override
    protected void getIntentData() {
        super.getIntentData();
        this.bean = (ChipBean)this.getIntent().getSerializableExtra("chipBean");
        this.containerNum = this.getIntent().getIntExtra("containerNum", 0);
        this.certType = this.getIntent().getStringExtra("certType");
        this.inUse = this.getIntent().getBooleanExtra("inUse", false);
        this.allowApplyCert = this.getIntent().getBooleanExtra("allowApplyCert", false);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_cert_detail);
        this.context = this;
        this.initPrimaryView();
        this.initDataAndShow();
        this.showCertState();
    }

    private void initDataAndShow() {
        ModuleLog.e((Object)this.bean.getType());
        this.chipBeanType = CryptoDevTypeUtil.formatType(this.bean.getType());
        this.currentSelect = this.certType;
        String rest = this.updateCertValue(this.bean.getCertBean());
        if (this.isDoubleCert()) {
            CertDetailInfo another = DeviceWrapper.getInstance().readCertFromContainer(this.chipBeanType, this.containerNum, rest);
            if (another == null) {
                this.rlCertRule.setVisibility(8);
            }
            if (rest.equals("\u7b7e\u540d\u8bc1\u4e66")) {
                this.signCertData = another;
            } else {
                this.encryptCertData = another;
            }
        } else {
            this.rlCertRule.setVisibility(8);
        }
        this.selectShow();
        this.cardID = DeviceWrapper.getInstance().getCardID(this.chipBeanType);
        ModuleLog.e((Object)this.chipBeanType);
    }

    private void selectShow() {
        if (this.isDoubleCert()) {
            this.showData(this.currentSelect.equals("\u7b7e\u540d\u8bc1\u4e66") ? this.signCertData : this.encryptCertData);
            this.updateDivider();
        } else {
            this.showOnlySingleCert();
        }
    }

    private void showOnlySingleCert() {
        if (this.signCertData != null) {
            this.showData(this.signCertData);
            this.rlEncryptCert.setVisibility(8);
        } else {
            this.showData(this.encryptCertData);
            this.rlSignCert.setVisibility(8);
        }
    }

    private void updateDivider() {
        if (this.currentSelect.equals("\u7b7e\u540d\u8bc1\u4e66")) {
            this.vSignDivider.setVisibility(0);
            this.vEncryptDivider.setVisibility(8);
        } else {
            this.vSignDivider.setVisibility(8);
            this.vEncryptDivider.setVisibility(0);
        }
    }

    private String updateCertValue(CertDetailInfo info) {
        if (this.certType.equals("\u7b7e\u540d\u8bc1\u4e66")) {
            this.signCertData = info;
            return this.isDoubleCert() ? "\u52a0\u5bc6\u8bc1\u4e66" : "";
        }
        this.encryptCertData = info;
        return this.isDoubleCert() ? "\u7b7e\u540d\u8bc1\u4e66" : "";
    }

    private boolean isDoubleCert() {
        return AppConfig.getInstance().getCertConfig().getCertRule(this.chipBeanType, this.containerNum).equals("\u53cc\u8bc1");
    }

    @Override
    public void onBackPressed() {
        super.onBackPressed();
    }

    private void initPrimaryView() {
        this.certStatus = (FrameLayout)this.findViewById(R.id.cert_detail_status);
        this.sn = (TextView)this.findViewById(R.id.sn_text);
        this.ver = (TextView)this.findViewById(R.id.ver_text);
        this.signAlg = (TextView)this.findViewById(R.id.signAlg_text);
        this.user = (TextView)this.findViewById(R.id.user_text);
        this.issuer = (TextView)this.findViewById(R.id.issuer_text);
        this.notBefore = (TextView)this.findViewById(R.id.indate_start);
        this.notAfter = (TextView)this.findViewById(R.id.indate_end);
        this.revoke = (Button)this.findViewById(R.id.revoked_btn);
        this.delete = (Button)this.findViewById(R.id.delete_cert_btn);
        this.update = (Button)this.findViewById(R.id.update_cert_btn);
        this.refresh = (Button)this.findViewById(R.id.refresh_cert_btn);
        this.revoke_full = (Button)this.findViewById(R.id.revoked_full_btn);
        this.bottomButton = (RelativeLayout)this.findViewById(R.id.bottom_button);
        this.rlEncryptCert = (RelativeLayout)this.findViewById(R.id.rl_encrypt_cert);
        this.rlEncryptCert.setOnClickListener((View.OnClickListener)this);
        this.rlSignCert = (RelativeLayout)this.findViewById(R.id.rl_sign_cert);
        this.rlSignCert.setOnClickListener((View.OnClickListener)this);
        this.vSignDivider = this.findViewById(R.id.v_sign_divider);
        this.vEncryptDivider = this.findViewById(R.id.v_encrypt_divider);
        this.rlCertRule = (RelativeLayout)this.findViewById(R.id.rl_cert_rule);
    }

    private void showBtn(Button btn) {
        this.revoke.setVisibility(8);
        this.delete.setVisibility(8);
        this.update.setVisibility(8);
        this.refresh.setVisibility(8);
        this.revoke_full.setVisibility(8);
        boolean allowUpdate = AppConfig.getInstance().getServerSettingConfig().getAllowUpdate().equals("\u662f");
        if (!this.allowApplyCert) {
            this.bottomButton.setVisibility(8);
        }
        if (btn == this.revoke) {
            if (AppConfig.getInstance().getServerSettingConfig().getRevoke().equals("\u5426")) {
                this.bottomButton.setVisibility(8);
            } else if (allowUpdate) {
                this.revoke.setVisibility(0);
            } else {
                this.revoke_full.setVisibility(0);
            }
        }
        if (btn == this.delete) {
            this.delete.setVisibility(0);
        }
        if (btn == this.update) {
            this.update.setVisibility(0);
        }
        if (btn == this.refresh) {
            this.refresh.setVisibility(0);
        }
    }

    private void showData(CertDetailInfo certDetailInfo) {
        this.sn.setText((CharSequence)certDetailInfo.getSn());
        this.ver.setText((CharSequence)("" + certDetailInfo.getVer()));
        String algStr = "";
        if (certDetailInfo.getAlg() != null && certDetailInfo.getAlg().length() > 0) {
            if (certDetailInfo.getAlg().contains("1.2.156.10197.1")) {
                algStr = "SM3WithSM2";
            }
        } else if (AppConfig.getInstance().getCertConfig().getAlgType(this.chipBeanType, this.containerNum).equals("SM2")) {
            algStr = "SM3WithSM2";
        }
        if (algStr.length() > 0) {
            this.signAlg.setText((CharSequence)algStr);
        } else {
            this.signAlg.setText((CharSequence)certDetailInfo.getAlg());
        }
        String userStr = certDetailInfo.getSubjectCn();
        String userContent = userStr.replaceAll(",", "\n");
        this.user.setText((CharSequence)userContent);
        String issuerStr = certDetailInfo.getIssuerCn();
        String issuerContent = issuerStr.replaceAll(",", "\n");
        this.issuer.setText((CharSequence)issuerContent);
        this.notBefore.setText((CharSequence)certDetailInfo.getNotBefore());
        this.notAfter.setText((CharSequence)certDetailInfo.getNotAfter());
    }

    private CertDetailInfo getCertDetailInfo() {
        return this.signCertData != null ? this.signCertData : this.encryptCertData;
    }

    private void showCertNormal() {
        View view = LayoutInflater.from((Context)this.getApplicationContext()).inflate(R.layout.cert_detail_normal, null);
        this.certStatus.removeAllViews();
        this.certStatus.addView(view);
        if (AppConfig.getInstance().getServerSettingConfig().getAllowUpdate().equals("\u662f") && Util.certValidIsExpire(this.getCertDetailInfo()) && this.isShowUpdate) {
            this.showNotifyDialog();
        }
        this.showBtn(this.revoke);
        if (!AppConfig.getInstance().getServerSettingConfig().getAllowUpdate().equals("\u662f")) {
            this.update.setVisibility(8);
        } else {
            this.update.setVisibility(0);
        }
        this.update.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                CertDetailInfoActivity.this.operate_type = 3;
                CertDetailInfoActivity.this.showPinDialog();
            }
        });
        this.revoke.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CertDetailInfoActivity.this.operate_type = 1;
                CertDetailInfoActivity.this.showPinDialog();
            }
        });
        this.revoke_full.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CertDetailInfoActivity.this.operate_type = 1;
                CertDetailInfoActivity.this.showPinDialog();
            }
        });
    }

    private void showRARevokeReject(@StringRes int strId, String msg) {
        View view = LayoutInflater.from((Context)this).inflate(R.layout.cert_detail_reject_revoke, null);
        this.certStatus.removeAllViews();
        this.certStatus.addView(view);
        TextView revokeText = (TextView)view.findViewById(R.id.revoked);
        revokeText.setText(strId);
        TextView reason = (TextView)view.findViewById(R.id.reason);
        String text = this.getResources().getString(R.string.cert_creation_reason) + msg;
        reason.setText((CharSequence)text);
        if (AppConfig.getInstance().getServerSettingConfig().getAllowUpdate().equals("\u662f") && Util.certValidIsExpire(this.getCertDetailInfo()) && this.isShowUpdate) {
            this.showNotifyDialog();
        }
        this.showBtn(this.revoke);
        if (!AppConfig.getInstance().getServerSettingConfig().getAllowUpdate().equals("\u662f")) {
            this.update.setVisibility(8);
        } else {
            this.update.setVisibility(0);
        }
        this.update.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                CertDetailInfoActivity.this.operate_type = 3;
                CertDetailInfoActivity.this.showPinDialog();
            }
        });
        this.revoke.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CertDetailInfoActivity.this.operate_type = 1;
                CertDetailInfoActivity.this.showPinDialog();
            }
        });
        this.revoke_full.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CertDetailInfoActivity.this.operate_type = 1;
                CertDetailInfoActivity.this.showPinDialog();
            }
        });
    }

    private void showUpdateWait(CertState state) {
        View view = LayoutInflater.from((Context)this.getApplicationContext()).inflate(R.layout.cert_detail_update_wait, null);
        int strId = 0;
        if (state == CertState.RA_UPDATE_WAIT_56) {
            strId = R.string.cert_creation_cert_update_ra_wait;
        } else if (state == CertState.CERT_STATE_WAIT_VERIFY) {
            strId = R.string.cert_creation_data_need_verify_please_wait_1;
        }
        TextView tvWaitProgress = (TextView)view.findViewById(R.id.tv_wait_progress);
        if (strId != 0) {
            tvWaitProgress.setText(strId);
        }
        this.certStatus.removeAllViews();
        this.certStatus.addView(view);
        this.showBtn(this.refresh);
        this.refresh.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CertDetailInfoActivity.this.queryCertStateFromServer();
            }
        });
    }

    private void showWaitRevoke(@StringRes int strId) {
        View view = LayoutInflater.from((Context)this.getApplicationContext()).inflate(R.layout.cert_detail_wait_agree_revoke, null);
        TextView message = (TextView)view.findViewById(R.id.revokeInfo2);
        message.setText(strId);
        this.certStatus.removeAllViews();
        this.certStatus.addView(view);
        this.showBtn(this.refresh);
        this.refresh.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CertDetailInfoActivity.this.queryCertStateFromServer();
            }
        });
    }

    private void showNoCurrentPki(int strID) {
        View view = LayoutInflater.from((Context)this.getApplicationContext()).inflate(R.layout.cert_detail_verify_fail, null);
        TextView revokeInfo1 = (TextView)view.findViewById(R.id.revokeInfo1);
        revokeInfo1.setText(strID);
        this.certStatus.removeAllViews();
        this.certStatus.addView(view);
        this.showBtn(this.delete);
        this.delete.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CertDetailInfoActivity.this.operate_type = 2;
                CertDetailInfoActivity.this.showPinDialog();
            }
        });
    }

    private void showServerNoCert() {
        View view = LayoutInflater.from((Context)this.getApplicationContext()).inflate(R.layout.cert_detail_server_nocert, null);
        this.certStatus.removeAllViews();
        this.certStatus.addView(view);
        this.showBtn(this.delete);
        this.delete.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CertDetailInfoActivity.this.operate_type = 2;
                CertDetailInfoActivity.this.showPinDialog();
            }
        });
    }

    private void showAgreeRevoke(boolean notify) {
        View view = LayoutInflater.from((Context)this.getApplicationContext()).inflate(R.layout.cert_detail_agree_revoke, null);
        TextView status = (TextView)view.findViewById(R.id.revoked);
        status.setText((CharSequence)this.getResources().getString(R.string.cert_creation_detail_revoke_success));
        this.showBtn(this.delete);
        this.delete.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CertDetailInfoActivity.this.operate_type = 2;
                CertDetailInfoActivity.this.showPinDialog();
            }
        });
        this.certStatus.removeAllViews();
        this.certStatus.addView(view);
        if (notify) {
            OttoUtil.postRevokeSuccess(new RevokeSuccessEvent(this.chipBeanType, this.containerNum));
        }
    }

    private void showException(String message) {
        View view = LayoutInflater.from((Context)this.getApplicationContext()).inflate(R.layout.cert_detail_error, null);
        TextView reason = (TextView)view.findViewById(R.id.reason);
        reason.setText((CharSequence)message);
        this.showBtn(this.refresh);
        this.refresh.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!CertDetailInfoActivity.this.bean.getIsVerify()) {
                    CertDetailInfoActivity.this.showNoCurrentPki();
                } else {
                    CertDetailInfoActivity.this.queryCertStateFromServer();
                }
            }
        });
        this.certStatus.removeAllViews();
        this.certStatus.addView(view);
    }

    private void showNoCurrentPki() {
        this.showNoCurrentPki(R.string.cert_creation_cert_not_in_system);
    }

    private void showNotifyDialog() {
    }

    private void showPinDialog() {
        if (this.pinDialog == null) {
            this.pinDialog = new PinDialog(this.context, this.chipBeanType, this.containerNum, new PinDialog.HandlePinResult(){

                @Override
                public void onSuccess() {
                    if (CertDetailInfoActivity.this.operate_type == 1) {
                        CertDetailInfoActivity.this.startReasonActivity();
                    } else if (CertDetailInfoActivity.this.operate_type == 2) {
                        new ClearContainerTask().execute(new Object[0]);
                    } else {
                        Intent intent = new Intent(CertDetailInfoActivity.this.context, UpdateCertActivity.class);
                        intent.putExtra("cardNum", CertDetailInfoActivity.this.cardID);
                        intent.putExtra("chipBean", (Serializable)CertDetailInfoActivity.this.bean);
                        intent.putExtra("certType", CertDetailInfoActivity.this.certType);
                        CertDetailInfoActivity.this.startActivity(intent);
                    }
                    CertDetailInfoActivity.this.operate_type = -1;
                    CertDetailInfoActivity.this.pinDialog = null;
                }

                @Override
                public void onFail(int pinResult) {
                    if (pinResult == 2131) {
                        CertDetailInfoActivity.this.bean.setState(CertState.NET_TIMEOUT);
                        CertDetailInfoActivity.this.showCertState();
                    } else {
                        CertDetailInfoActivity.this.handleErrorResponse(CryptoDevManager.getInstance().getErrorText(pinResult));
                    }
                }
            });
        }
        this.pinDialog.show();
    }

    private void showCertState() {
        if (!this.bean.getIsVerify()) {
            this.showNoCurrentPki();
        } else {
            switch (this.bean.getState()) {
                case NET_ERROR: {
                    this.showException(this.getResources().getString(R.string.net_disconnected_text));
                    break;
                }
                case NET_TIMEOUT: {
                    this.showException(this.getResources().getString(R.string.net_timeout));
                    break;
                }
                case SUCCESS: {
                    this.showCertNormal();
                    break;
                }
                case WAITING_AGREE_REVOKE: {
                    this.showWaitRevoke(R.string.cert_creation_data_need_verify_please_wait_1);
                    break;
                }
                case AGREE_REVOKE: {
                    this.showAgreeRevoke(false);
                    break;
                }
                case REJECT_REVOKE: {
                    this.showRejectRevoke(R.string.cert_creation_revoke_check_reject, this.bean.getReason());
                    break;
                }
                case SERVER_NOCERT: {
                    this.showNoCurrentPki(R.string.cert_creation_server_no_cert_local_has_cert);
                    break;
                }
                case CERT_OUT_OF_DATE: {
                    this.showNoCurrentPki(R.string.cert_creation_cert_out_of_date);
                    break;
                }
                case RA_REVOKE_WAIT_54: {
                    this.showWaitRevoke(R.string.cc_cert_pass_ra_wait);
                    break;
                }
                case RA_REVOKE_WAIT_45: {
                    this.showWaitRevoke(R.string.cert_creation_data_need_verify_please_wait_1);
                    break;
                }
                case RA_REVOKE_REJECT_55: {
                    this.showRejectRevoke(R.string.cert_creation_revoke_reject, this.bean.getReason());
                    break;
                }
                case RA_UPDATE_WAIT_56: {
                    this.showUpdateWait(CertState.RA_UPDATE_WAIT_56);
                    break;
                }
                case WAITING_VERIFY: {
                    this.showUpdateWait(CertState.WAITING_VERIFY);
                    break;
                }
                case RA_UPDATE_REJECT_57: {
                    this.showRejectRevoke(R.string.cert_creation_update_check_reject, this.bean.getReason());
                    break;
                }
                case UPDATE_REJECT_BY_SERVER: {
                    this.showRejectRevoke(R.string.cert_creation_update_check_reject, this.bean.getReason());
                }
            }
        }
    }

    private void startReasonActivity() {
        Intent intent = new Intent(this.context, ReasonActivity.class);
        intent.putExtra("type", 2);
        intent.putExtra("chipBean", (Serializable)this.bean);
        intent.putExtra("cardId", this.cardID);
        intent.putExtra("certType", this.certType);
        intent.putExtra("containerNum", this.containerNum);
        ModuleLog.e((Object)this.cardID);
        this.startActivity(intent);
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (id2 == R.id.rl_encrypt_cert) {
            this.currentSelect = "\u52a0\u5bc6\u8bc1\u4e66";
            this.updateDivider();
            this.selectShow();
        } else if (id2 == R.id.rl_sign_cert) {
            this.currentSelect = "\u7b7e\u540d\u8bc1\u4e66";
            this.updateDivider();
            this.selectShow();
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == 1) {
            String reason = data.getStringExtra("reason");
            this.recoveryCert(reason);
        }
    }

    @Subscribe
    public void handleRevokeResult(RevokeResultEvent event) {
        CertState state = event.getChipBean().getState();
        if (state == CertState.WAITING_AGREE_REVOKE) {
            this.showWaitRevoke(R.string.cert_creation_data_need_verify_please_wait_1);
        } else if (state == CertState.AGREE_REVOKE) {
            this.showAgreeRevoke(true);
        } else if (state == CertState.REJECT_REVOKE) {
            this.showRejectRevoke(R.string.cert_creation_revoke_reject, event.getReason());
        } else if (state == CertState.RA_REVOKE_WAIT_45) {
            this.showWaitRevoke(R.string.cert_creation_ra_wait);
        }
        OttoUtil.postCertOperate(event.getContainerNum(), event.getChipBean());
    }

    private void showRejectRevoke(@StringRes int strId, String msg) {
        View view = LayoutInflater.from((Context)this).inflate(R.layout.cert_detail_reject_revoke, null);
        this.certStatus.removeAllViews();
        this.certStatus.addView(view);
        TextView revoke = (TextView)view.findViewById(R.id.revoked);
        revoke.setText(strId);
        TextView reason = (TextView)view.findViewById(R.id.reason);
        String text = this.getResources().getString(R.string.cert_creation_reason) + msg;
        reason.setText((CharSequence)text);
        this.refresh.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CertDetailInfoActivity.this.queryCertStateFromServer();
            }
        });
        this.refresh.setVisibility(0);
        this.delete.setVisibility(8);
    }

    protected int getTitleRes() {
        return R.string.cert_creation_cert_detail;
    }

    private void recoveryCert(String revokeReason) {
        this.showLoading(R.string.cert_creation_is_recoverying_cert);
        if (!CommonUtil.isNetworkConnected((Context)this.context)) {
            myHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    CertDetailInfoActivity.this.showException(CertDetailInfoActivity.this.getResources().getString(R.string.net_disconnected_text));
                }
            }, 1000L);
            return;
        }
        this.showException(this.getResources().getString(R.string.net_timeout));
        RevokedCertRequest revokeRequest = new RevokedCertRequest();
        Info info = new Info();
        if (this.getCertDetailInfo() == null) {
            ModuleLog.e((Object)"sn\u4e3a\u7a7a");
            return;
        }
        String sn = this.getCertDetailInfo().getSn();
        info.setSn(sn);
        info.setReason(revokeReason);
        info.setTime(System.currentTimeMillis());
        revokeRequest.setInfo(info);
        String sign = DeviceWrapper.getInstance().signData(this.chipBeanType, this.containerNum, info.toString());
        if (sign.startsWith("errorCode")) {
            this.showPinDialog();
            return;
        }
        revokeRequest.setSign(sign);
        revokeRequest.setCardType("" + CryptoDevTypeUtil.convertCardType(this.chipBeanType.getType()));
        this.certService.thawingCert(revokeRequest, this.cardID, new HttpResponseCallBack<CommonResponse>(){

            @Override
            public void onOtherException(Exception e) {
                e.printStackTrace();
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                CertDetailInfoActivity.this.showException(CertDetailInfoActivity.this.getResources().getString(R.string.net_disconnected_text));
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                String result = commonResponse.getResult();
                if (result.equals("0")) {
                    CertDetailInfoActivity.this.bean.setState(CertState.RECOVERY_PROGRESS);
                    CertDetailInfoActivity.this.showWaitRevoke(R.string.cert_creation_data_need_verify_please_wait_1);
                    OttoUtil.postCertOperate(CertDetailInfoActivity.this.containerNum, CertDetailInfoActivity.this.bean);
                } else if (result.equals("1")) {
                    CertDetailInfoActivity.this.bean.setState(CertState.RECOVERY_SUCCESS);
                    OttoUtil.postCertOperate(CertDetailInfoActivity.this.containerNum, CertDetailInfoActivity.this.bean);
                } else if (result.equals("2")) {
                    CertDetailInfoActivity.this.showRejectRevoke(R.string.cert_creation_recovery_fail, commonResponse.getMessage());
                }
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                CertDetailInfoActivity.this.handleErrorResponse(baseErrorResponse.getErrCode());
            }

            @Override
            public void dismissDialog() {
            }
        });
    }

    private void queryCertStateFromServer() {
        if (!CommonUtil.isNetworkConnected((Context)this.context)) {
            ModuleToast.show(this.context, R.string.net_disconnected_text);
            myHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    CertDetailInfoActivity.this.showException(CertDetailInfoActivity.this.getResources().getString(R.string.net_disconnected_text));
                    CertDetailInfoActivity.this.dismissLoading();
                }
            }, 1000L);
            return;
        }
        myHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                CertDetailInfoActivity.this.dismissLoading();
            }
        }, 1000L);
        this.showLoading(R.string.cert_creation_is_checking_cert);
        CertStateRequest certStateRequest = new CertStateRequest();
        if (this.getCertDetailInfo() != null) {
            certStateRequest.setSn(this.getCertDetailInfo().getSn());
        } else {
            certStateRequest.setSn("");
        }
        certStateRequest.setCardType("" + CryptoDevTypeUtil.convertCardType(this.chipBeanType.getType()));
        ModuleLog.e((Object)"");
        this.certService.certStateQuery(certStateRequest, this.cardID, new HttpResponseCallBack<CommonResponse>(){

            @Override
            public void onOtherException(Exception e) {
                if (e instanceof CardNotExistException) {
                    CertDetailInfoActivity.this.showException(CertDetailInfoActivity.this.getResources().getString(R.string.cert_creation_device_not_exist));
                } else {
                    e.printStackTrace();
                }
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                CertDetailInfoActivity.this.showException(CertDetailInfoActivity.this.getResources().getString(R.string.net_disconnected_text));
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                String result = commonResponse.getResult();
                if (result.equals("0")) {
                    CertDetailInfoActivity.this.bean.setState(CertState.WAITING_AGREE_REVOKE);
                    CertDetailInfoActivity.this.showWaitRevoke(R.string.cert_creation_data_need_verify_please_wait_1);
                } else if (result.equals("1")) {
                    CertDetailInfoActivity.this.bean.setState(CertState.AGREE_REVOKE);
                    CertDetailInfoActivity.this.showAgreeRevoke(true);
                } else if (result.equals("2")) {
                    CertDetailInfoActivity.this.bean.setState(CertState.REJECT_REVOKE);
                    CertDetailInfoActivity.this.bean.setReason(commonResponse.getMessage());
                    CertDetailInfoActivity.this.showRejectRevoke(R.string.cert_creation_revoke_check_reject, commonResponse.getMessage());
                } else if (result.equals("3")) {
                    CertDetailInfoActivity.this.bean.setState(CertState.AGREE_UPDATE);
                    CertDetailInfoActivity.this.showCertNormal();
                } else if (result.equals("4")) {
                    CertDetailInfoActivity.this.showServerNoCert();
                } else if (!(result.equals("5") || result.equals("6") || result.equals("7") || result.equals("8") || result.equals("9") || result.equals("10") || result.equals("11") || result.equals("12"))) {
                    if (result.equals("13")) {
                        CertDetailInfoActivity.this.bean.setState(CertState.UPDATE_REJECT_BY_SERVER);
                        CertDetailInfoActivity.this.bean.setReason(commonResponse.getMessage());
                        CertDetailInfoActivity.this.showRejectRevoke(R.string.cert_creation_update_check_reject, CertDetailInfoActivity.this.bean.getReason());
                    } else if (!result.equals("14")) {
                        if (result.equals("55")) {
                            CertDetailInfoActivity.this.bean.setState(CertState.RA_REVOKE_REJECT_55);
                            CertDetailInfoActivity.this.bean.setReason(commonResponse.getMessage());
                            CertDetailInfoActivity.this.showRejectRevoke(R.string.cert_creation_revoke_check_reject, CertDetailInfoActivity.this.bean.getReason());
                        } else if (result.equals("56")) {
                            CertDetailInfoActivity.this.bean.setState(CertState.RA_UPDATE_WAIT_56);
                            CertDetailInfoActivity.this.showUpdateWait(CertState.RA_UPDATE_WAIT_56);
                        } else if (result.equals("47")) {
                            CertDetailInfoActivity.this.applyRAstatus(PKCS10Utils.getInstance(CertDetailInfoActivity.this.chipBeanType, CertDetailInfoActivity.this.containerNum).getP10RequestBC(CertDetailInfoActivity.this.chipBeanType, CertDetailInfoActivity.this.containerNum, CertDetailInfoActivity.this.getCertDetailInfo().getSubjectCn(), false));
                        } else if (result.equals("57")) {
                            CertDetailInfoActivity.this.bean.setState(CertState.RA_UPDATE_REJECT_57);
                            CertDetailInfoActivity.this.bean.setReason(commonResponse.getMessage());
                            CertDetailInfoActivity.this.showRejectRevoke(R.string.cert_creation_update_check_reject, commonResponse.getMessage());
                        } else if (result.equals("54")) {
                            CertDetailInfoActivity.this.bean.setState(CertState.RA_REVOKE_WAIT_54);
                            CertDetailInfoActivity.this.showWaitRevoke(R.string.cc_cert_pass_ra_wait);
                        }
                    }
                }
                OttoUtil.postCertOperate(CertDetailInfoActivity.this.containerNum, CertDetailInfoActivity.this.bean);
                CertDetailInfoActivity.this.dismissLoading();
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                CertDetailInfoActivity.this.handleErrorResponse(baseErrorResponse.getErrCode());
                CertDetailInfoActivity.this.dismissLoading();
            }

            @Override
            public void dismissDialog() {
            }
        });
    }

    private void applyRAstatus(String p10) {
        if (!CommonUtil.isNetworkConnected((Context)this.context)) {
            ModuleToast.show(this.context, R.string.net_disconnected_text);
            return;
        }
        CertApplyRequest certApplyRequest = this.getCertApplyReq(p10);
        if (certApplyRequest == null) {
            return;
        }
        this.certService.applyRAStatus(certApplyRequest, this.cardID, new HttpResponseCallBack<CertApplyRAStatusResponse>(){

            @Override
            public void onOtherException(Exception e) {
                e.printStackTrace();
                DeviceWrapper.getInstance().setApplyCertEnd(false);
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                DeviceWrapper.getInstance().setApplyCertEnd(false);
                OttoUtil.postSwipPullResult(true);
            }

            @Override
            public void onSuccessfulResponse(Call call, CertApplyRAStatusResponse certApplyResponse) {
                String result = certApplyResponse.getResult();
                if (result.equals("1")) {
                    String cert2 = certApplyResponse.getMessage();
                    cert2 = cert2.substring(9, cert2.length() - 2);
                    WriteCertTask task = new WriteCertTask(cert2);
                    task.execute(new Void[0]);
                } else if (result.equals("52")) {
                    CertDetailInfoActivity.this.showWaitRevoke(R.string.cert_creation_cert_update_ra_wait);
                } else if (result.equals("53")) {
                    // empty if block
                }
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                DeviceWrapper.getInstance().setApplyCertEnd(false);
                String errorCode = baseErrorResponse.getErrCode();
                CertDetailInfoActivity.this.handleErrorResponse(errorCode);
                OttoUtil.postSwipPullResult(true);
            }

            @Override
            public void dismissDialog() {
            }
        });
    }

    private void writeCertToServer(CryptoDevType type, String sn, String status) {
        WriteFailRequest request = new WriteFailRequest();
        WriteFailInfo info = new WriteFailInfo();
        info.setSn(sn);
        info.setStatus(status);
        info.setTime(System.currentTimeMillis());
        request.setInfo(info);
        String sign = DeviceWrapper.getInstance().signData(type, this.containerNum, info.toString());
        if (sign.startsWith("errorCode")) {
            this.showException(sign.substring(9));
            return;
        }
        request.setSign(sign);
        request.setCardType("" + CryptoDevTypeUtil.convertCardType(type.getType()));
        this.certService.uploadWriteCertResult(request, this.cardID, new HttpResponseCallBack<CommonResponse>(){

            @Override
            public void onOtherException(Exception e) {
                e.printStackTrace();
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                int netRes = !CommonUtil.isNetworkConnected((Context)CertDetailInfoActivity.this.context) ? R.string.net_disconnected_text : R.string.net_timeout;
                CertDetailInfoActivity.this.showException(CertDetailInfoActivity.this.getResources().getString(netRes));
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                CertDetailInfoActivity.this.showException(CertDetailInfoActivity.this.getResources().getString(R.string.cert_creation_write_authentiation_fail));
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                CertDetailInfoActivity.this.handleErrorResponse(baseErrorResponse.getErrCode());
            }

            @Override
            public void dismissDialog() {
            }
        });
    }

    private void handleErrorResponse(String errorCode) {
        if (errorCode.equals(OkNetError.NOT_EXIST_INFO_CODE)) {
            this.showNoCurrentPki(R.string.cert_creation_server_no_cert_local_has_cert);
            this.bean.setState(CertState.AGREE_REVOKE);
            OttoUtil.postCertOperate(this.containerNum, this.bean);
        } else {
            String msg = OkNetError.handleErrorCodeToMsg((Context)this, errorCode);
            this.showException(msg);
        }
    }

    @Subscribe
    public void handleUpdateCertStateEvent(UpdateCertStateEvent event) {
        ModuleLog.e((Object)"handleUpdate");
        this.showWaitRevoke(event.getResult());
    }

    private CertApplyRequest getCertApplyReq(String p10) {
        if (TextUtils.isEmpty((CharSequence)p10)) {
            return null;
        }
        if (p10.startsWith("errorCode")) {
            if (p10.contains("^[0-6]*$")) {
                // empty if block
            }
            this.handleErrorResponse(p10.substring(9));
            DeviceWrapper.getInstance().setApplyCertEnd(false);
            OttoUtil.postSwipPullResult(true);
            return null;
        }
        if (p10.isEmpty()) {
            DeviceWrapper.getInstance().setApplyCertEnd(false);
        }
        CertApplyRequest certApplyRequest = new CertApplyRequest();
        ChipInfo chipInfo = new ChipInfo();
        DeviceWrapper deviceWrapper = DeviceWrapper.getInstance();
        chipInfo.setCardType("" + CryptoDevTypeUtil.convertCardType(this.chipBeanType.getType()));
        chipInfo.setImei(deviceWrapper.getIMEI());
        String imsi = deviceWrapper.getIMSI();
        chipInfo.setImsi(imsi);
        chipInfo.setPhone(SharePreferencesUtil.getPhoneNum(this.context));
        certApplyRequest.setChipInfo(chipInfo);
        MobileInfo mobileInfo = new MobileInfo();
        mobileInfo.setCommType(DeviceUtil.getInstance().getOperator() + "");
        mobileInfo.setTerminalBand(DeviceUtil.getInstance().getBrand());
        mobileInfo.setTerminalType("1");
        certApplyRequest.setMobileInfo(mobileInfo);
        if (!AppConfig.getInstance().getServerSettingConfig().getProcedure().equals("\u624b\u673a\u53f7\u8ba4\u8bc1\u6d41\u7a0b")) {
            certApplyRequest.setIdentityNo(SharePreferencesUtil.getIDCardNo(this.context, this.chipBeanType.getType()));
        } else {
            certApplyRequest.setIdentityNo(SharePreferencesUtil.getPhoneNum(this.context));
        }
        certApplyRequest.setP10(p10);
        return certApplyRequest;
    }

    @Subscribe
    public void handleSpecificActivity(SpecificActivity activity) {
        if (((Object)((Object)this)).getClass().getName().equals(activity.getTag())) {
            this.finish();
            this.overridePendingTransition(0, 0);
        }
    }

    protected void onPause() {
        super.onPause();
        ModuleLog.e((Object)"");
    }

    class WriteCertTask
    extends AsyncTask<Void, Void, Integer> {
        private String cert;

        public WriteCertTask(String cert2) {
            this.cert = cert2;
        }

        protected void onPreExecute() {
            super.onPreExecute();
            CertDetailInfoActivity.this.showLoading(R.string.cert_creation_is_update_cert);
        }

        protected Integer doInBackground(Void ... voids) {
            int result = DeviceWrapper.getInstance().writeUpdateCert(CertDetailInfoActivity.this.chipBeanType, CertDetailInfoActivity.this.containerNum, this.cert);
            return result;
        }

        protected void onPostExecute(Integer integer) {
            super.onPostExecute((Object)integer);
            if (integer == 0) {
                CertDetailInfo afterUpdate = DeviceWrapper.getInstance().readCertFromContainer(CertDetailInfoActivity.this.chipBeanType, CertDetailInfoActivity.this.containerNum, CertDetailInfoActivity.this.certType);
                String rest = CertDetailInfoActivity.this.updateCertValue(afterUpdate);
                if (!TextUtils.isEmpty((CharSequence)rest)) {
                    CertDetailInfo another = DeviceWrapper.getInstance().readCertFromContainer(CertDetailInfoActivity.this.chipBeanType, CertDetailInfoActivity.this.containerNum, CertDetailInfoActivity.this.certType);
                    CertDetailInfoActivity.this.updateCertValue(another);
                }
                CertDetailInfoActivity.this.selectShow();
                CertDetailInfoActivity.this.showCertNormal();
                CertDetailInfoActivity.this.bean.setState(CertState.AGREE_UPDATE);
                CertDetailInfoActivity.this.bean.setCertDetailInfo(CertDetailInfoActivity.this.certType.equals("\u7b7e\u540d\u8bc1\u4e66") ? CertDetailInfoActivity.this.signCertData : CertDetailInfoActivity.this.encryptCertData);
                OttoUtil.postCertOperate(CertDetailInfoActivity.this.containerNum, CertDetailInfoActivity.this.bean);
                CertDetailInfoActivity.this.dismissLoading();
            } else {
                CertDetailInfoActivity.this.writeCertToServer(CertDetailInfoActivity.this.chipBeanType, DeviceWrapper.getInstance().getSn(CertDetailInfoActivity.this.chipBeanType, CertDetailInfoActivity.this.containerNum, this.cert), "1");
            }
        }
    }

    private class ClearContainerTask
    extends AsyncTask {
        int result;

        private ClearContainerTask() {
        }

        protected Object doInBackground(Object[] objects) {
            this.result = DeviceWrapper.getInstance().clearContainer(CertDetailInfoActivity.this.chipBeanType, CertDetailInfoActivity.this.containerNum);
            return this.result;
        }

        protected void onPreExecute() {
            super.onPreExecute();
            CertDetailInfoActivity.this.showLoading(R.string.cert_creation_is_deleting_cert);
        }

        protected void onPostExecute(Object o) {
            super.onPostExecute(o);
            if (this.result == 0) {
                CertDetailInfoActivity.this.bean.setState(CertState.DELETE_SUCCESS);
                OttoUtil.postCertOperate(CertDetailInfoActivity.this.containerNum, CertDetailInfoActivity.this.bean);
                Intent intent = new Intent("com.xdja.aircert.revoke.success");
                CertDetailInfoActivity.this.context.sendBroadcast(intent);
                CertDetailInfoActivity.this.dismissLoading();
                DeviceWrapper.getInstance().setApplyCertEnd(false);
                CertDetailInfoActivity.this.finish();
            } else {
                ModuleToast.show(CertDetailInfoActivity.this.context, CertDetailInfoActivity.this.getResources().getString(R.string.cert_creation_delete_cert_fail));
                CertDetailInfoActivity.this.dismissLoading();
            }
        }
    }
}

