/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.activity;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.Toast;
import com.aircert.CommonActivity.ToolBarActivity;
import com.aircert.util.ModuleLog;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.HttpResponseCallBack;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.BaseActivity;
import com.xdja.safeclient.certcreation.bean.OkNetError;
import com.xdja.safeclient.certcreation.bean.request.BaseRequest;
import com.xdja.safeclient.certcreation.bean.request.CertStateRequest;
import com.xdja.safeclient.certcreation.bean.request.RequestSMSCodeRequest;
import com.xdja.safeclient.certcreation.bean.request.VerifyPhoneRequest;
import com.xdja.safeclient.certcreation.bean.request.VerifySMSCodeRequest;
import com.xdja.safeclient.certcreation.bean.response.BaseErrorResponse;
import com.xdja.safeclient.certcreation.bean.response.CommonResponse;
import com.xdja.safeclient.certcreation.bean.response.CompareResult;
import com.xdja.safeclient.certcreation.bean.result.AuthResult;
import com.xdja.safeclient.certcreation.bean.result.CertStatusResult;
import com.xdja.safeclient.certcreation.bean.result.PhoneAuthResult;
import com.xdja.safeclient.certcreation.bean.result.PhoneResult;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.device.NetVHSMHandle;
import com.xdja.safeclient.certcreation.service.CertService;
import com.xdja.safeclient.certcreation.util.ApplyCertUtil;
import com.xdja.safeclient.certcreation.util.CryptoDevTypeUtil;
import com.xdja.safeclient.certcreation.util.EditTextUtil;
import com.xdja.safeclient.certcreation.util.KeyboardUtils;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import com.xdja.safeclient.certcreation.util.SharePreferencesUtil;
import com.xdja.safeclient.certcreation.view.NoDoubleClickListener;
import com.xdja.safeclient.certcreation.view.PinDialog;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Timer;
import java.util.TimerTask;
import okhttp3.Call;

public class PhoneApplyActivity
extends BaseActivity {
    private EditText etPhone;
    private LinearLayout idcard_layout;
    private EditText idCard;
    private PinDialog pinDialog;
    public CryptoDevType cardType;
    public int containerNum;
    public String cardNum;
    public String certType;
    private EditText etSMSCode;
    private Button requestSMSCode;
    ExitHandler exitHandler = new ExitHandler((Activity)this);
    private Timer timer;
    private final int COUNT_DOWN = 120;
    private int count = 120;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.cert_creation_activity_phone_apply_cert);
        this.verifyPin();
        this.initView();
    }

    protected int getTitleRes() {
        return -1;
    }

    @Override
    protected void getIntentData() {
        super.getIntentData();
        this.cardType = (CryptoDevType)this.getIntent().getSerializableExtra("cardType");
        this.cardNum = this.getIntent().getStringExtra("cardNum");
        this.containerNum = this.getIntent().getIntExtra("containerNum", 0);
        this.certType = this.getIntent().getStringExtra("certType");
    }

    private void initView() {
        this.etPhone = (EditText)this.findViewById(R.id.et_phone);
        this.etPhone.setFilters(EditTextUtil.getDisableEmojFilter());
        InputFilter[] inputFilter = new InputFilter[]{new InputFilter.LengthFilter(11)};
        this.etPhone.setFilters(inputFilter);
        this.etPhone.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                if (count < 11) {
                    PhoneApplyActivity.this.requestSMSCode.setEnabled(false);
                }
            }

            public void afterTextChanged(Editable s) {
                if (s.length() == 11) {
                    PhoneApplyActivity.this.requestSMSCode.setEnabled(true);
                }
            }
        });
        if (AppConfig.getInstance().getServerSettingConfig().getProcedure().equals("\u624b\u673a\u53f7\u5347\u7ea7\u7248\u8ba4\u8bc1\u6d41\u7a0b")) {
            this.idcard_layout = (LinearLayout)this.findViewById(R.id.idcard_layout);
            this.idcard_layout.setVisibility(0);
            this.idCard = (EditText)this.findViewById(R.id.et_id);
            this.idCard.setFilters(EditTextUtil.getDisableEmojFilter(18));
        }
        Button btn_submit = (Button)this.findViewById(R.id.btn_submit);
        btn_submit.setOnClickListener((View.OnClickListener)new NoDoubleClickListener(){

            @Override
            public void onNoDoubleClick(View v) {
                ModuleLog.d((Object)"\u63d0\u4ea4");
                if (AppConfig.getInstance().getServerSettingConfig().getProcedure().equals("\u624b\u673a\u53f7\u77ed\u4fe1\u9a8c\u8bc1\u7801\u6d41\u7a0b")) {
                    ModuleLog.d((Object)"\u77ed\u4fe1\u63d0\u4ea4");
                    if (PhoneApplyActivity.this.verifyPhoneNum() && PhoneApplyActivity.this.verifySMSCodeNum()) {
                        PhoneApplyActivity.this.verifySMSCode();
                    }
                } else {
                    PhoneApplyActivity.this.submit();
                    ModuleLog.d((Object)"--------\u975e\u77ed\u4fe1\u63d0\u4ea4");
                }
            }
        });
        LinearLayout sms = (LinearLayout)this.findViewById(R.id.code_layout);
        this.requestSMSCode = (Button)this.findViewById(R.id.request_sms_code);
        if (AppConfig.getInstance().getServerSettingConfig().getProcedure().equals("\u624b\u673a\u53f7\u77ed\u4fe1\u9a8c\u8bc1\u7801\u6d41\u7a0b")) {
            sms.setVisibility(0);
            this.requestSMSCode.setVisibility(0);
            this.etSMSCode = (EditText)this.findViewById(R.id.et_sms_code);
            this.requestSMSCode.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    Log.e((String)"jff", (String)"128 PhoneApplyActivity onClick : SMS");
                    PhoneApplyActivity.this.etSMSCode.requestFocus();
                    if (PhoneApplyActivity.this.verifyPhoneNum()) {
                        PhoneApplyActivity.this.requestSMSCode(PhoneApplyActivity.this.etPhone.getText().toString());
                    }
                }
            });
        }
    }

    private boolean verifyPhoneNum() {
        if ("".equals(this.etPhone.getText().toString()) || this.etPhone.getText().toString().length() < 11) {
            ModuleToast.show((Context)this, R.string.cert_creation_err_length);
            return false;
        }
        return true;
    }

    private boolean verifySMSCodeNum() {
        if ("".equals(this.etSMSCode.getText().toString())) {
            ModuleToast.show((Context)this, R.string.cert_creation_verify_code_verify_null);
            return false;
        }
        return true;
    }

    private void requestSMSCode(String phone) {
        RequestSMSCodeRequest request = new RequestSMSCodeRequest(phone);
        this.service.requestSMSCode(request, this.cardNum, new HttpResponseCallBack<CommonResponse>(){

            @Override
            public void onOtherException(Exception e) {
                e.printStackTrace();
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                PhoneApplyActivity.this.showRequestError();
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                PhoneApplyActivity.this.countDown();
                ModuleToast.show((Context)PhoneApplyActivity.this, R.string.cert_creation_verify_code_send_success);
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                PhoneApplyActivity.this.handleRequestSMSError(baseErrorResponse);
            }

            @Override
            public void dismissDialog() {
                PhoneApplyActivity.this.dismissLoading();
            }
        });
    }

    private void verifySMSCode() {
        VerifySMSCodeRequest request = new VerifySMSCodeRequest(this.etPhone.getText().toString(), this.etSMSCode.getText().toString());
        this.service.verifySMSCode(request, this.cardNum, new HttpResponseCallBack<CommonResponse>(){

            @Override
            public void onOtherException(Exception e) {
                e.printStackTrace();
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                ModuleLog.d((Object)e);
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse response) {
                PhoneApplyActivity.this.submit();
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                PhoneApplyActivity.this.handleRequestSMSError(baseErrorResponse);
            }

            @Override
            public void dismissDialog() {
                PhoneApplyActivity.this.dismissLoading();
            }
        });
    }

    private void countDown() {
        this.timer = new Timer();
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                PhoneApplyActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        PhoneApplyActivity.this.requestSMSCode.setText((CharSequence)(PhoneApplyActivity.this.count + "\u79d2"));
                        PhoneApplyActivity.this.requestSMSCode.setClickable(false);
                        PhoneApplyActivity.this.requestSMSCode.setEnabled(false);
                        PhoneApplyActivity.this.count--;
                        if (PhoneApplyActivity.this.count < 0) {
                            PhoneApplyActivity.this.count = 120;
                            PhoneApplyActivity.this.requestSMSCode.setText(R.string.cert_creation_request_sms_code);
                            PhoneApplyActivity.this.requestSMSCode.setClickable(true);
                            PhoneApplyActivity.this.requestSMSCode.setEnabled(true);
                            PhoneApplyActivity.this.timer.cancel();
                        }
                    }
                });
            }
        }, 0L, 1000L);
    }

    private void handleRequestSMSError(BaseErrorResponse baseErrorResponse) {
        String message = baseErrorResponse.getMessage();
        if (message.equals("transcend_sms_send_times")) {
            ModuleToast.show((Context)this, R.string.cert_creation_verify_code_freq);
        } else if (message.equals("fail_send_message")) {
            ModuleToast.show((Context)this, R.string.cert_creation_verify_code_send_fail);
        } else if (message.equals("phone_code_send_frequently_error")) {
            ModuleToast.show((Context)this, R.string.cert_creation_phone_sms_send_frequently);
        } else if (message.equals("phone_code_expire_error")) {
            ModuleToast.show((Context)this, R.string.cert_creation_verify_code_phone_code_expire_error);
        } else if (message.equals("phone_code_incorrect_error")) {
            ModuleToast.show((Context)this, R.string.cert_creation_verify_code_verify_io);
        } else if (message.equals("phone_code_send_limit_error")) {
            ModuleToast.show((Context)this, R.string.cert_creation_verify_code_fail_limit_error);
        } else if (message.equals("phone_code_verify_fail_limit_error")) {
            ModuleToast.show((Context)this, R.string.cert_creation_verify_code_verifyfail_limit_error);
        } else if (message.equals("phone_not_exist_error")) {
            ModuleToast.show((Context)this, R.string.cert_creation_not_null_phone);
        }
    }

    private void verifyPin() {
        if (this.cardType != CryptoDevType.DEV_TYPE_Soft || 2 != NetVHSMHandle.isNetVHSMCanUse(new ToolBarActivity().getContext())) {
            DeviceWrapper.getInstance();
            int pinResult = DeviceWrapper.verifyPin(this.cardType, this.containerNum, AppConfig.getInstance().getDefaultConfig().getPin());
            if (pinResult != 0) {
                this.pinDialog = new PinDialog((Context)this, this.cardType);
                this.pinDialog.show();
            }
        }
    }

    private void submit() {
        KeyboardUtils.hideKeyboard((View)this.etPhone);
        if (!DeviceWrapper.getInstance().isApplyCertEnd()) {
            String phone = this.etPhone.getText().toString();
            if (TextUtils.isEmpty((CharSequence)phone)) {
                ModuleToast.showNoRepeat(this.getContext(), R.string.cert_creation_not_null_phone_num);
                DeviceWrapper.getInstance().setApplyCertEnd(false);
                return;
            }
            if (AppConfig.getInstance().getServerSettingConfig().getProcedure().equals("\u624b\u673a\u53f7\u5347\u7ea7\u7248\u8ba4\u8bc1\u6d41\u7a0b")) {
                String cardNum = this.idCard.getText().toString();
                if (TextUtils.isEmpty((CharSequence)cardNum)) {
                    ModuleToast.showNoRepeat(this.getContext(), R.string.cert_creation_not_null_id_num);
                    DeviceWrapper.getInstance().setApplyCertEnd(false);
                    return;
                }
                if (!cardNum.isEmpty() && cardNum.length() < 18) {
                    ModuleToast.show(this.getContext(), this.getResources().getString(R.string.cert_creation_error_id_size));
                    DeviceWrapper.getInstance().setApplyCertEnd(false);
                    return;
                }
                String idNo = this.idCard.getText().toString();
                SharePreferencesUtil.saveIDCardNo(this.getContext(), this.cardType.getType(), idNo);
            }
            DeviceWrapper.getInstance().setApplyCertEnd(true);
            this.showLoading();
            CertStateRequest certStateRequest = this.buildRequest();
            this.query(certStateRequest, phone);
        }
    }

    private CertStateRequest buildRequest() {
        CertStateRequest certStateRequest = new CertStateRequest();
        certStateRequest.setSn(SharePreferencesUtil.getCertSn((Context)this));
        certStateRequest.setCardType("" + CryptoDevTypeUtil.convertCardType(this.cardType.getType()));
        return certStateRequest;
    }

    private void query(BaseRequest certStateRequest, final String phone) {
        ModuleLog.d((Object)"\u5f00\u59cb\u67e5\u8be2\u8bc1\u4e66\u72b6\u6001");
        CertService certService = new CertService();
        certService.certStateQuery(certStateRequest, this.cardNum, new HttpResponseCallBack<CommonResponse>(){

            @Override
            public void onOtherException(Exception e) {
                DeviceWrapper.getInstance().setApplyCertEnd(false);
                e.printStackTrace();
                PhoneApplyActivity.this.dismissLoading();
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                DeviceWrapper.getInstance().setApplyCertEnd(false);
                PhoneApplyActivity.this.showRequestError();
                PhoneApplyActivity.this.dismissLoading();
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                this.dismissDialog();
                String result = commonResponse.getResult();
                ModuleLog.d((Object)(" \u67e5\u8be2\u7ed3\u679c" + result + "\n"));
                if (result.equals("2") || result.equals("3")) {
                    CertStatusResult certStatusResult = new CertStatusResult();
                    certStatusResult.setContainerNum(PhoneApplyActivity.this.containerNum);
                    certStatusResult.setResult("-1");
                    OttoUtil.postCertStatusResult(certStatusResult);
                    PhoneApplyActivity.this.finish();
                } else {
                    PhoneApplyActivity.this.verifyPhoneNum(phone);
                }
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                ModuleLog.d((Object)(" baseErrorResponse.getErrCode()" + baseErrorResponse.getErrCode() + "\n"));
                if (OkNetError.NOT_EXIST_INFO_CODE.equals(baseErrorResponse.getErrCode())) {
                    PhoneApplyActivity.this.verifyPhoneNum(phone);
                } else {
                    DeviceWrapper.getInstance().setApplyCertEnd(false);
                    ModuleToast.show((Context)PhoneApplyActivity.this, OkNetError.userError(PhoneApplyActivity.this.getContext(), baseErrorResponse.getErrCode()));
                    PhoneApplyActivity.this.finish();
                }
            }

            @Override
            public void dismissDialog() {
            }
        });
    }

    private void verifyPhoneNum(String phone) {
        VerifyPhoneRequest request = new VerifyPhoneRequest(phone);
        this.showLoading();
        this.service.verifyPhoneNum(request, this.cardNum, new HttpResponseCallBack<CommonResponse>(){

            @Override
            public void onOtherException(Exception e) {
                DeviceWrapper.getInstance().setApplyCertEnd(false);
                e.printStackTrace();
                PhoneApplyActivity.this.dismissLoading();
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                DeviceWrapper.getInstance().setApplyCertEnd(false);
                PhoneApplyActivity.this.showRequestError();
                PhoneApplyActivity.this.dismissLoading();
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                String resultCode = commonResponse.getResult();
                if (resultCode.equals("0")) {
                    PhoneApplyActivity.this.startVerify();
                } else {
                    PhoneResult phoneResult = PhoneApplyActivity.this.buildPhoneResult(PhoneApplyActivity.this.getCardType(), PhoneApplyActivity.this.getCardNum(), commonResponse, null);
                    PhoneAuthResult authResult = new PhoneAuthResult();
                    authResult.setContainerNum(PhoneApplyActivity.this.containerNum);
                    authResult.setPhoneResult(phoneResult);
                    OttoUtil.postPhoneAuthResult(authResult);
                    PhoneApplyActivity.this.finish();
                }
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                DeviceWrapper.getInstance().setApplyCertEnd(false);
            }

            @Override
            public void dismissDialog() {
                PhoneApplyActivity.this.dismissLoading();
            }
        });
    }

    private PhoneResult buildPhoneResult(CryptoDevType type, String cardNum, CommonResponse response, BaseErrorResponse errorResponse) {
        CompareResult result = new CompareResult();
        if (response == null && errorResponse == null) {
            result.setResult("");
            result.setMessage("");
            result.setErrCode("");
            result.setSuccess(false);
        } else if (errorResponse != null) {
            result.setResult(errorResponse.getErrCode());
            result.setErrCode(errorResponse.getErrCode());
            if (!TextUtils.isEmpty((CharSequence)errorResponse.getMessage())) {
                result.setMessage(errorResponse.getMessage());
            }
            result.setSuccess(false);
        } else {
            result.setResult(response.getResult());
            result.setMessage(response.getMessage());
            result.setSuccess(true);
        }
        result.setIdentity(cardNum);
        PhoneResult phoneResult = new PhoneResult(type, result);
        return phoneResult;
    }

    private void startVerify() {
        if (this.cardType == null || TextUtils.isEmpty((CharSequence)this.cardNum)) {
            return;
        }
        this.showLoading();
        String phoneNum = this.etPhone.getText().toString();
        SharePreferencesUtil.savePhone((Context)this, phoneNum);
        ApplyCertUtil.start((Context)this, this.containerNum, new ApplyCertUtil.WhatHappen(){

            @Override
            public void showDialog() {
            }

            @Override
            public void cancelDialog() {
            }

            @Override
            public void IOError() {
                Log.e((String)"jff", (String)"289 PhoneApplyActivity IOError : ");
                DeviceWrapper.getInstance().setApplyCertEnd(false);
                PhoneApplyActivity.this.dismissLoading();
                PhoneApplyActivity.this.showRequestError();
            }

            @Override
            public void handleResult(CommonResponse response) {
                PhoneApplyActivity.this.dismissLoading();
                Toast.makeText((Context)PhoneApplyActivity.this, (CharSequence)"\u8bf7\u6c42\u6210\u529f", (int)0).show();
                PhoneApplyActivity.this.finish();
            }

            @Override
            public void handleError(BaseErrorResponse baseErrorResponse) {
                Log.e((String)"jff", (String)"302 PhoneApplyActivity handleError : ");
                PhoneApplyActivity.this.dismissLoading();
                PhoneApplyActivity.this.handleError(baseErrorResponse);
            }
        });
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (this.exitHandler != null) {
            this.exitHandler.removeCallbacksAndMessages(null);
        }
    }

    private void handleError(BaseErrorResponse baseErrorResponse) {
        Log.e((String)"jff", (String)"342 PhoneApplyActivity handleError : ");
        AuthResult result = ApplyCertUtil.buildAuthResult(this.getCardType(), this.containerNum, this.getCardNum(), null, baseErrorResponse);
        if (OkNetError.ONE_CARD_TYPE_ONE_CERT_CODE.equals(baseErrorResponse.getErrCode())) {
            // empty if block
        }
        OttoUtil.postAuthResult(result);
        this.finish();
    }

    static class ExitHandler
    extends Handler {
        WeakReference<Activity> reference;

        ExitHandler(Activity activity) {
            this.reference = new WeakReference<Activity>(activity);
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            Activity activity = (Activity)this.reference.get();
            if (activity == null) {
                return;
            }
            activity.finish();
        }
    }
}

