/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import com.aircert.dialog.SinglePermissionDialog;
import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.squareup.otto.Subscribe;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.BaseActivity;
import com.xdja.safeclient.certcreation.activity.IDReadyActivity;
import com.xdja.safeclient.certcreation.bean.response.BaseErrorResponse;
import com.xdja.safeclient.certcreation.bean.response.CommonResponse;
import com.xdja.safeclient.certcreation.bean.result.AuthResult;
import com.xdja.safeclient.certcreation.cache.ImageCache;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.event.FinishActivity;
import com.xdja.safeclient.certcreation.event.SpecificActivity;
import com.xdja.safeclient.certcreation.util.ApplyCertUtil;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import com.xdja.safeclient.certcreation.util.SharePreferencesUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;

@Route(path="/cert/selfie", name="\u81ea\u62cd\u7167")
public class SelfieActivity
extends BaseActivity {
    Button confirm;
    Button retake;
    ImageView selfie;
    @Autowired(name="cardNum")
    public String cardNum;
    @Autowired(name="cardType")
    public CryptoDevType cardType;
    @Autowired(name="phone")
    public String phone;
    @Autowired(name="containerNum")
    public int containerNum = -1;
    private int photoType = -1;
    public static final int TYPE_SELFIE = 0;
    public static final int TYPE_ID_IMG = 1;
    private boolean init = false;
    SinglePermissionDialog dialog;
    Bitmap bitmap = null;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (TextUtils.isEmpty((CharSequence)this.cardNum)) {
            this.cardNum = DeviceWrapper.getInstance().getCardID(this.cardType);
            if (TextUtils.isEmpty((CharSequence)this.cardNum)) {
                ModuleToast.show((Context)this, R.string.cert_creation_card_device_error);
                this.finish();
                return;
            }
        }
        this.photoType = SharePreferencesUtil.getSelfieStep((Context)this);
        this.requestCameraPermission();
        if (this.containerNum == -1) {
            this.containerNum = SharePreferencesUtil.getContainerNum((Context)this, this.cardNum);
        }
    }

    @Override
    protected void getIntentData() {
        super.getIntentData();
        this.photoType = this.getIntent().getIntExtra("photoType", 0);
        this.cardNum = this.getIntent().getStringExtra("cardNum");
        this.cardType = (CryptoDevType)this.getIntent().getSerializableExtra("cardType");
        this.phone = this.getIntent().getStringExtra("phone");
        this.containerNum = this.getIntent().getIntExtra("containerNum", 0);
    }

    protected void onResume() {
        super.onResume();
        if (this.photoType == 0) {
            this.setTitleRes(R.string.cert_creation_selfie_photo_ready_title);
        } else {
            this.setTitleRes(R.string.cert_creation_selfie_photo_title);
        }
        if (this.bitmap != null) {
            this.setTitleRes(R.string.cert_creation_photo_confirm);
        }
    }

    protected void onPause() {
        super.onPause();
        this.left_title_tv.setText((CharSequence)"");
    }

    private void initView() {
        this.hideBG();
        this.initPhoto();
        this.setLeftBtnListener(new View.OnClickListener(){

            public void onClick(View view) {
                SelfieActivity.this.onBack();
            }
        });
    }

    private void initPhoto() {
        this.setTitleRes(R.string.cert_creation_photo_confirm);
        this.selfie = (ImageView)this.findViewById(R.id.selfie);
        this.confirm = (Button)this.findViewById(R.id.confirm);
        this.confirm.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                SelfieActivity.this.next();
            }
        });
        this.retake = (Button)this.findViewById(R.id.retake);
        this.retake.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                SelfieActivity.this.requestCameraPermission();
            }
        });
    }

    private void showPhoto() {
        this.overridePendingTransition(R.anim.left_in, R.anim.left_out);
        try {
            Uri uri;
            Uri uri2 = uri = this.photoType == 0 ? ImageCache.getSelfieURI() : ImageCache.getIDImageURI();
            if (Build.VERSION.SDK_INT >= 24) {
                String photoName = this.photoType == 0 ? "img.jpg" : "id.jpg";
                File file = new File(this.getExternalCacheDir(), photoName);
                this.bitmap = ImageCache.compressFile(file);
            } else {
                FileInputStream fis = new FileInputStream(uri.getPath());
                this.bitmap = BitmapFactory.decodeStream((InputStream)fis);
            }
            if (this.bitmap != null) {
                if (this.photoType == 0) {
                    ImageCache.compressSelfie(0, this.bitmap);
                } else {
                    ImageCache.compressIDImage(1, this.bitmap);
                }
            }
            this.selfie.setImageBitmap(this.bitmap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void requestCameraPermission() {
        if (Build.VERSION.SDK_INT < 23) {
            this.takePhotoFromSystem();
        } else {
            ActivityCompat.requestPermissions((Activity)this, (String[])new String[]{"android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.CAMERA"}, (int)23);
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        boolean isGrant = false;
        for (int grantResult : grantResults) {
            if (grantResult != 0) {
                isGrant = false;
                break;
            }
            isGrant = true;
        }
        if (isGrant) {
            this.takePhotoFromSystem();
        } else {
            this.showNoPermissionDialog();
        }
    }

    private void takePhotoFromSystem() {
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        intent.putExtra("android.intent.extras.CAMERA_FACING", 1);
        intent.addCategory("android.intent.category.DEFAULT");
        intent.putExtra("output", (Parcelable)(this.photoType == 0 ? ImageCache.getSelfieURI() : ImageCache.getIDImageURI()));
        this.startActivityForResult(intent, 1);
        this.overridePendingTransition(R.anim.left_in, R.anim.left_out);
    }

    public void showNoPermissionDialog() {
        if (this.dialog == null) {
            this.initNoPermissionDialog();
        }
        this.dialog.show();
    }

    private void initNoPermissionDialog() {
        this.dialog = new SinglePermissionDialog();
        this.dialog.build((Context)this, 1);
    }

    @Override
    public void route() {
        super.route();
        if (this.photoType == 0) {
            SharePreferencesUtil.saveSelfieStep((Context)this, 1);
            SharePreferencesUtil.saveContainerNum((Context)this, this.cardNum, this.containerNum);
            Intent intent = new Intent((Context)this, IDReadyActivity.class);
            intent.putExtra("photoType", 1);
            intent.putExtra("cardNum", this.cardNum);
            intent.putExtra("cardType", (Serializable)this.cardType);
            intent.putExtra("phone", this.phone);
            this.startActivity(intent);
        } else if (this.photoType == 1) {
            this.start();
        }
    }

    @Override
    public String nextActivity() {
        return "/cert/id_ready";
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (!this.init) {
            this.setContentView(R.layout.selfie_photo);
            this.initView();
            this.init = true;
        }
        if (resultCode == 0) {
            if (this.bitmap == null) {
                this.overridePendingTransition(R.anim.right_in, R.anim.right_out);
                this.finish();
            }
        } else if (resultCode == -1) {
            this.showPhoto();
        }
    }

    protected int getTitleRes() {
        return R.string.cert_creation_selfie_photo_title;
    }

    protected boolean isOCRActivity() {
        return true;
    }

    @Override
    public void onBackPressed() {
        this.onBack();
    }

    private void onBack() {
        this.overridePendingTransition(R.anim.right_in, R.anim.right_out);
        if (this.photoType == 1) {
            OttoUtil.post((Object)new SpecificActivity(SelfieActivity.class));
        }
        this.finish();
    }

    @Subscribe
    public void handleSpecificActivity(SpecificActivity activity) {
        if (((Object)((Object)this)).getClass().getName().equals(activity.getTag())) {
            this.finish();
        }
    }

    private void start() {
        if (this.containerNum == -1) {
            this.containerNum = SharePreferencesUtil.getContainerNum((Context)this, this.cardNum);
        }
        ApplyCertUtil.start((Context)this, this.containerNum, new ApplyCertUtil.WhatHappen(){

            @Override
            public void showDialog() {
                SelfieActivity.this.showLoading();
            }

            @Override
            public void cancelDialog() {
                SelfieActivity.this.dismissLoading();
            }

            @Override
            public void IOError() {
                SelfieActivity.this.dismissLoading();
                SelfieActivity.this.showRequestError();
            }

            @Override
            public void handleResult(CommonResponse response) {
                ApplyCertUtil.handleSuccessResult((Context)SelfieActivity.this, response);
            }

            @Override
            public void handleError(BaseErrorResponse baseErrorResponse) {
                SelfieActivity.this.handleError(baseErrorResponse);
            }
        });
    }

    private void handleError(BaseErrorResponse baseErrorResponse) {
        AuthResult result = ApplyCertUtil.buildAuthResult(this.cardType, this.containerNum, this.cardNum, null, baseErrorResponse);
    }

    @Subscribe
    public void handleFinishActivity(FinishActivity event) {
        this.finish();
    }
}

