/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.activity;

import android.content.Context;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Looper;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.RadioGroup;
import com.aircert.util.CommonUtil;
import com.aircert.util.ModuleLog;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.HttpResponseCallBack;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.BaseActivity;
import com.xdja.safeclient.certcreation.activity.CertDetailInfoActivity;
import com.xdja.safeclient.certcreation.bean.CertDetailInfo;
import com.xdja.safeclient.certcreation.bean.CertState;
import com.xdja.safeclient.certcreation.bean.ChipBean;
import com.xdja.safeclient.certcreation.bean.OkNetError;
import com.xdja.safeclient.certcreation.bean.UpdateEventCode;
import com.xdja.safeclient.certcreation.bean.request.CertInfoUpdateRequest;
import com.xdja.safeclient.certcreation.bean.request.UpdateCertPwd;
import com.xdja.safeclient.certcreation.bean.request.UpdateCertPwdReq;
import com.xdja.safeclient.certcreation.bean.request.UpdateInfo;
import com.xdja.safeclient.certcreation.bean.response.BaseErrorResponse;
import com.xdja.safeclient.certcreation.bean.response.CertApplyRAStatusResponse;
import com.xdja.safeclient.certcreation.bean.response.CommonResponse;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.device.PKCS10Utils;
import com.xdja.safeclient.certcreation.dialog.DeleteCertDialog;
import com.xdja.safeclient.certcreation.event.UpdateEvent;
import com.xdja.safeclient.certcreation.util.CryptoDevTypeUtil;
import com.xdja.safeclient.certcreation.util.EditTextUtil;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import com.xdja.safeclient.certcreation.util.ThreadUtil;
import com.xdja.safeclient.certcreation.view.NoDoubleClickListener;
import java.io.IOException;
import okhttp3.Call;

public class UpdateCertActivity
extends BaseActivity {
    private RadioGroup updateRadioGroup;
    private EditText updateReasonText;
    public ChipBean chipBean;
    private int containerNum;
    private CertDetailInfo certDetailInfo;
    private CryptoDevType chipBeanType;
    public String cardNum;
    UpdateCertPwd updateCertPwd = new UpdateCertPwd();
    UpdateCertPwdReq updateCertPwdReq = new UpdateCertPwdReq();
    private TextWatcher textWatcher = new TextWatcher(){
        private CharSequence temp;
        private int selectionStart;
        private int selectionEnd;

        public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
        }

        public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            String str;
            this.temp = charSequence;
            String editable = UpdateCertActivity.this.updateReasonText.getText().toString();
            if (!editable.equals(str = EditTextUtil.stringFilter(editable))) {
                ModuleToast.show((Context)UpdateCertActivity.this, R.string.cert_creation_reason_text_correct);
                UpdateCertActivity.this.updateReasonText.setText((CharSequence)str);
                UpdateCertActivity.this.updateReasonText.setSelection(str.length());
            }
        }

        public void afterTextChanged(Editable editable) {
            this.selectionStart = UpdateCertActivity.this.updateReasonText.getSelectionStart();
            this.selectionEnd = UpdateCertActivity.this.updateReasonText.getSelectionEnd();
            if (this.temp.length() > 40) {
                ModuleToast.show((Context)UpdateCertActivity.this, R.string.cert_creation_reason_text_length);
                editable.delete(this.selectionStart - 1, this.selectionEnd);
                int tempSelection = this.selectionEnd;
                UpdateCertActivity.this.updateReasonText.setText((CharSequence)editable);
                UpdateCertActivity.this.updateReasonText.setSelection(tempSelection);
            }
        }
    };

    @Override
    protected void getIntentData() {
        super.getIntentData();
        this.cardNum = this.getIntent().getStringExtra("cardNum");
        this.chipBean = (ChipBean)this.getIntent().getSerializableExtra("chipBean");
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_update_cert);
        this.init();
        this.certDetailInfo = this.chipBean.getCertBean();
        this.chipBeanType = CryptoDevTypeUtil.formatType(this.chipBean.getType());
        this.containerNum = AppConfig.getInstance().getCertConfig().getContainerNum(this.chipBeanType);
    }

    protected int getTitleRes() {
        return R.string.cert_creation_updateCert_title;
    }

    private void init() {
        this.updateRadioGroup = (RadioGroup)this.findViewById(R.id.update_choose);
        this.updateReasonText = (EditText)this.findViewById(R.id.update_reason_text);
        this.updateReasonText.setFilters(EditTextUtil.getDisableEmojFilter());
        this.updateReasonText.addTextChangedListener(this.textWatcher);
        Button updateSubmitBtn = (Button)this.findViewById(R.id.update_submit_btn);
        updateSubmitBtn.setOnClickListener((View.OnClickListener)new NoDoubleClickListener(){

            @Override
            public void onNoDoubleClick(View v) {
                int updateChoose = UpdateCertActivity.this.updateRadioGroup.getCheckedRadioButtonId();
                UpdateEvent updateEvent = new UpdateEvent();
                if (TextUtils.isEmpty((CharSequence)UpdateCertActivity.this.updateReasonText.getText().toString())) {
                    ModuleToast.show(UpdateCertActivity.this.getContext(), R.string.cert_creation_update_reason_input);
                    return;
                }
                if (updateChoose == R.id.delayRadio) {
                    updateEvent.setUpdateType(UpdateEventCode.DELAY_CERT.getType());
                    updateEvent.setReasonStr(UpdateCertActivity.this.updateReasonText.getText().toString());
                    UpdateCertActivity.this.reasonIsTemp(updateEvent);
                    ModuleLog.e((Object)"\u5ef6\u671f\u66f4\u65b0");
                }
                if (updateChoose == R.id.updateUserInfoRadio) {
                    updateEvent.setUpdateType(UpdateEventCode.USERINFO_UPDATE.getType());
                    updateEvent.setReasonStr(UpdateCertActivity.this.updateReasonText.getText().toString());
                    UpdateCertActivity.this.reasonIsTemp(updateEvent);
                    ModuleLog.e((Object)"\u7528\u6237\u4fe1\u606f\u66f4\u65b0");
                }
                if (updateChoose == R.id.updateCertPwdRadio) {
                    UpdateCertActivity.this.deleteCertBeforeUpdate();
                }
            }
        });
    }

    private void deleteCertBeforeUpdate() {
        DeleteCertDialog dialog = new DeleteCertDialog();
        dialog.setListener(new DeleteCertDialog.OnClickListener(){

            @Override
            public void onPositive() {
                UpdateCertActivity.this.showLoading(R.string.cc_delete_cert);
                ClearContainerTask task = new ClearContainerTask();
                task.execute(new Object[0]);
            }
        });
        dialog.build(this.getContext());
        dialog.show();
    }

    private void updateKeyPair() {
        UpdateEvent updateEvent = new UpdateEvent();
        updateEvent.setUpdateType(UpdateEventCode.UPDATE_PWD.getType());
        updateEvent.setReasonStr(this.updateReasonText.getText().toString());
        this.reasonIsTemp(updateEvent);
    }

    private void update(UpdateEvent updateEvent) {
        CertInfoUpdateRequest certInfoUpdateRequest;
        this.showLoading(R.string.cert_creation_is_update_cert);
        int type = updateEvent.getUpdateType();
        String updateType = String.valueOf(type);
        String reason = updateEvent.getReasonStr();
        ModuleLog.e((Object)("\u66f4\u65b0\u8bc1\u4e66\uff0c\u5f53\u524d\u7ebf\u7a0b\uff1a" + ThreadUtil.Companion.isMainThread()));
        if (type == UpdateEventCode.USERINFO_UPDATE.getType()) {
            certInfoUpdateRequest = this.getCertInfoUpdateRequest(updateType, reason);
            this.updateUserInfoOrDelay(certInfoUpdateRequest);
        }
        if (type == UpdateEventCode.DELAY_CERT.getType()) {
            certInfoUpdateRequest = this.getCertInfoUpdateRequest(updateType, reason);
            this.updateUserInfoOrDelay(certInfoUpdateRequest);
        }
        if (type == UpdateEventCode.UPDATE_PWD.getType()) {
            this.updateCertPwd(reason);
        }
    }

    private void updateUserInfoOrDelay(CertInfoUpdateRequest certUpdateRequest) {
        ModuleLog.e((Object)("\u66f4\u65b0\u7528\u6237\u4fe1\u606f " + certUpdateRequest.toString()));
        if (this.cardNum == null) {
            ModuleToast.show(this.getContext(), "\u66f4\u65b0\u5931\u8d25\uff0c\u8bf7\u9000\u51fa\u5e94\u7528\u540e\u91cd\u8bd5");
            this.dismissLoading();
            return;
        }
        this.service.updateOrDelayCert(certUpdateRequest, this.cardNum, new HttpResponseCallBack<CommonResponse>(){

            @Override
            public void onOtherException(Exception e) {
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                int netRes = !CommonUtil.isNetworkConnected((Context)UpdateCertActivity.this.getContext()) ? R.string.net_disconnected_text : R.string.net_timeout;
                ModuleLog.e((Object)("onIoExceptionFailure " + e.getMessage()));
                UpdateCertActivity.this.showException(UpdateCertActivity.this.getResources().getString(netRes));
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                String result = commonResponse.getResult();
                ModuleLog.e((Object)("\u66f4\u65b0\u7528\u6237\u4fe1\u606f result = " + result));
                switch (result) {
                    case "0": {
                        ModuleLog.d((Object)"\u66f4\u65b0\u7528\u6237\u4fe1\u606f/\u6709\u6548\u671f\uff0c\u670d\u52a1\u7aef\u5ba1\u6838\u4e2d");
                        OttoUtil.postCertUpdateResult(R.string.cert_creation_update_ing, UpdateCertActivity.this.containerNum, UpdateCertActivity.this.chipBeanType);
                        UpdateCertActivity.this.chipBean.setState(CertState.WAITING_VERIFY);
                        OttoUtil.postCertOperate(UpdateCertActivity.this.containerNum, UpdateCertActivity.this.chipBean);
                        OttoUtil.postFinishSpecificActivity(CertDetailInfoActivity.class.getName());
                        UpdateCertActivity.this.finish();
                        break;
                    }
                    case "1": {
                        ModuleLog.d((Object)"\u66f4\u65b0\u7528\u6237\u4fe1\u606f/\u6709\u6548\u671f\uff0c\u6210\u529f");
                        String certStr = commonResponse.getMessage();
                        ModuleToast.show(UpdateCertActivity.this.getContext(), "\u8bc1\u4e66\u66f4\u65b0\u6210\u529f");
                        OttoUtil.postFinishSpecificActivity(CertDetailInfoActivity.class.getName());
                        OttoUtil.postWritUpdateCert(UpdateCertActivity.this.chipBeanType, UpdateCertActivity.this.containerNum, certStr, false);
                        UpdateCertActivity.this.finish();
                        break;
                    }
                    case "2": {
                        ModuleLog.d((Object)"\u66f4\u65b0\u7528\u6237\u4fe1\u606f/\u6709\u6548\u671f\uff0c\u62d2\u7edd");
                        String msg = commonResponse.getMessage();
                        ModuleToast.show(UpdateCertActivity.this.getContext(), msg);
                        OttoUtil.postCertUpdateResult(R.string.cert_creation_cert_update_ra_reject, UpdateCertActivity.this.containerNum, UpdateCertActivity.this.chipBeanType);
                        UpdateCertActivity.this.finish();
                        break;
                    }
                    case "45": {
                        ModuleLog.d((Object)"\u66f4\u65b0\u7528\u6237\u4fe1\u606f/\u6709\u6548\u671f\uff0cRA\u5ba1\u6838\u4e2d");
                        OttoUtil.postFinishSpecificActivity(CertDetailInfoActivity.class.getName());
                        OttoUtil.postCertUpdateResult(R.string.cert_creation_cert_update_ra_wait, UpdateCertActivity.this.containerNum, UpdateCertActivity.this.chipBeanType);
                        UpdateCertActivity.this.finish();
                    }
                }
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                String errorCode = baseErrorResponse.getErrCode();
                ModuleLog.e((Object)"405 UpdateCertActivity onFailResponse : ");
                UpdateCertActivity.this.handleErrorResponse(errorCode);
            }

            @Override
            public void dismissDialog() {
            }
        });
    }

    private void initUpdatePairRequest(String reason) {
        this.updateCertPwd.setSn(this.certDetailInfo.getSn());
        this.updateCertPwd.setTime(System.currentTimeMillis());
        this.updateCertPwd.setReason(reason);
        String sign = DeviceWrapper.getInstance().signData(this.chipBeanType, this.containerNum, this.updateCertPwd.toString());
        String p10 = PKCS10Utils.getInstance(this.chipBeanType, this.containerNum).getP10RequestBC(this.chipBeanType, this.containerNum, this.certDetailInfo.getSubjectCn(), false);
        this.updateCertPwdReq.setInfo(this.updateCertPwd);
        this.updateCertPwdReq.setP10(p10);
        this.updateCertPwdReq.setSign(sign);
        this.updateCertPwdReq.setCardType(this.chipBeanType.getType());
    }

    public boolean isMainThread() {
        return Looper.getMainLooper().getThread() == Thread.currentThread();
    }

    private void updateCertPwd(String reason) {
        String p10 = PKCS10Utils.getInstance(this.chipBeanType, this.containerNum).getP10RequestBC(this.chipBeanType, this.containerNum, this.certDetailInfo.getSubjectCn(), true);
        this.updateCertPwdReq.setP10(p10);
        ModuleLog.e((Object)("\u66f4\u65b0\u5bc6\u94a5\u5bf9 " + this.updateCertPwdReq.toString()));
        ModuleLog.e((Object)("\u5f53\u524d\u7ebf\u7a0b" + this.isMainThread()));
        this.showLoading(R.string.cert_creation_is_update_cert);
        this.service.updateCertPwd(this.updateCertPwdReq, this.cardNum, new HttpResponseCallBack<CertApplyRAStatusResponse>(){

            @Override
            public void onOtherException(Exception e) {
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                int netRes = !CommonUtil.isNetworkConnected((Context)UpdateCertActivity.this.getContext()) ? R.string.net_disconnected_text : R.string.net_timeout;
                UpdateCertActivity.this.showException(UpdateCertActivity.this.getResources().getString(netRes));
            }

            @Override
            public void onSuccessfulResponse(Call call, CertApplyRAStatusResponse certApplyResponse) {
                String result = certApplyResponse.getResult();
                if (result.equals("0")) {
                    ModuleLog.d((Object)"\u66f4\u65b0\u5bc6\u94a5\u5bf9\uff0c\u670d\u52a1\u7aef\u5ba1\u6838\u4e2d");
                    OttoUtil.postUpdateKeyPairEvent(UpdateCertActivity.this.chipBeanType, UpdateCertActivity.this.containerNum, R.string.cert_creation_update_ing);
                } else if (result.equals("1")) {
                    String certStr = certApplyResponse.getMessage();
                    ModuleLog.d((Object)"\u66f4\u65b0\u5bc6\u94a5\u5bf9\uff0c\u6210\u529f");
                    OttoUtil.postWritUpdateCert(UpdateCertActivity.this.chipBeanType, UpdateCertActivity.this.containerNum, certStr, true);
                } else if (result.equals("2")) {
                    ModuleLog.d((Object)"\u5bc6\u94a5\u66f4\u65b0\uff0c\u88ab\u62d2\u7edd");
                    OttoUtil.postCertUpdateResult(R.string.cert_creation_cert_update_ra_reject, UpdateCertActivity.this.containerNum, UpdateCertActivity.this.chipBeanType);
                } else if (result.equals("45")) {
                    ModuleLog.d((Object)"\u5bc6\u94a5\u66f4\u65b0\uff0cRA\u5ba1\u6838\u4e2d");
                    OttoUtil.postUpdateKeyPairEvent(UpdateCertActivity.this.chipBeanType, UpdateCertActivity.this.containerNum, R.string.cc_cert_pass_ra_wait);
                }
                OttoUtil.postFinishSpecificActivity(CertDetailInfoActivity.class.getName());
                UpdateCertActivity.this.finish();
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                String errorCode = baseErrorResponse.getErrCode();
                UpdateCertActivity.this.handleErrorResponse(errorCode);
            }

            @Override
            public void dismissDialog() {
                UpdateCertActivity.this.dismissLoading();
            }
        });
    }

    private void showException(String message) {
        ModuleToast.show((Context)this, message);
    }

    private void handleErrorResponse(String errorCode) {
        String msg = OkNetError.handleErrorCodeToMsg((Context)this, errorCode);
        this.showException(msg);
        Log.e((String)"jff", (String)"533 UpdateCertActivity handleErrorResponse : ");
        OttoUtil.postRefreshListEvent();
        this.finish();
    }

    private CertInfoUpdateRequest getCertInfoUpdateRequest(String type, String reason) {
        UpdateInfo updateInfo = new UpdateInfo();
        updateInfo.setSn(this.certDetailInfo.getSn());
        updateInfo.setTime(System.currentTimeMillis());
        updateInfo.setType(type);
        updateInfo.setReason(reason);
        String p10 = PKCS10Utils.getInstance(this.chipBeanType, this.containerNum).getP10RequestBC(this.chipBeanType, this.containerNum, this.certDetailInfo.getSubjectCn(), false);
        updateInfo.setP10(p10);
        String sign = DeviceWrapper.getInstance().signData(this.chipBeanType, this.containerNum, updateInfo.toString());
        CertInfoUpdateRequest certUpdateRequest = new CertInfoUpdateRequest();
        certUpdateRequest.setSign(sign);
        certUpdateRequest.setInfo(updateInfo);
        certUpdateRequest.setCardType(this.chipBeanType.getType());
        return certUpdateRequest;
    }

    public void reasonIsTemp(UpdateEvent updateEvent) {
        this.update(updateEvent);
    }

    private class ClearContainerTask
    extends AsyncTask {
        int result;

        protected void onPreExecute() {
            super.onPreExecute();
            UpdateCertActivity.this.initUpdatePairRequest(UpdateCertActivity.this.updateReasonText.getText().toString());
        }

        protected Object doInBackground(Object[] objects) {
            this.result = DeviceWrapper.getInstance().clearContainer(UpdateCertActivity.this.chipBeanType, UpdateCertActivity.this.containerNum);
            return this.result;
        }

        protected void onPostExecute(Object o) {
            super.onPostExecute(o);
            if (this.result == 0) {
                UpdateCertActivity.this.updateKeyPair();
            } else {
                ModuleToast.show(UpdateCertActivity.this.getContext(), "\u5220\u9664\u5931\u8d25" + this.result);
                UpdateCertActivity.this.dismissLoading();
            }
        }
    }
}

