/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.device;

import com.aircert.util.ModuleLog;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.cryptodev.devapi.CryptoInstance;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;

public class AlgSignUtils {
    private static AlgSignUtils algSignUtils;

    public static AlgSignUtils getAlgSignUtils() {
        if (algSignUtils == null) {
            algSignUtils = new AlgSignUtils();
        }
        return algSignUtils;
    }

    public int verifySM2Sign(CryptoDevType type, String sourceData, byte[] signData) {
        if (sourceData == null || sourceData.equals("")) {
            return -1;
        }
        try {
            byte[] bs = sourceData.getBytes();
            byte[] pubFid = new byte[]{0, 45};
            CryptoInstance cryptoInstance = DeviceWrapper.getCryptoInstance(type);
            if (cryptoInstance != null) {
                return cryptoInstance.SM2SignVerify(pubFid, 1, null, bs, bs.length, signData);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return -1;
    }

    public int verifyRSASign(CryptoDevType type, String sourceData, byte[] signData) {
        if (sourceData == null || sourceData.equals("")) {
            return -1;
        }
        try {
            byte[] bs = sourceData.getBytes();
            byte[] pubFid = new byte[]{0, 45};
            CryptoInstance cryptoInstance = DeviceWrapper.getCryptoInstance(type);
            int ret = -1;
            if (cryptoInstance != null) {
                ret = cryptoInstance.RSASignVerify(2048, pubFid, null, 1, bs, bs.length, signData);
            }
            ModuleLog.d((Object)("\u9a8c\u7b7e\u7ed3\u679c\uff1a = " + ret));
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }
}

