/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.device;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.provider.Settings;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Pair;
import com.aircert.util.ModuleLog;
import com.google.common.base.Stopwatch;
import com.xdja.SafeKey.XDJA_FILE;
import com.xdja.cryptodev.CryptoDevInfo;
import com.xdja.cryptodev.CryptoDevManager;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.cryptodev.devapi.CryptoInstance;
import com.xdja.identifiers.grantidentifiers.IdentiferGrantUtils;
import com.xdja.identifiers.library.IdentiferBean;
import com.xdja.multi.unitepin.jar.MultiChipUnitePinManager;
import com.xdja.multichip.param.CertBean;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.ApplicationInit;
import com.xdja.safeclient.certcreation.bean.CertDetailInfo;
import com.xdja.safeclient.certcreation.bean.CertSKF;
import com.xdja.safeclient.certcreation.bean.device.CardType;
import com.xdja.safeclient.certcreation.device.NetVHSMHandle;
import com.xdja.safeclient.certcreation.util.FidUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.Provider;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;

public class DeviceWrapper {
    private static DeviceWrapper DEVICE_WRAPPER = new DeviceWrapper();
    private String certNo = "";
    private boolean applyCertEnd = false;

    public static DeviceWrapper getInstance() {
        if (DEVICE_WRAPPER == null) {
            DEVICE_WRAPPER = new DeviceWrapper();
        }
        return DEVICE_WRAPPER;
    }

    private DeviceWrapper() {
    }

    public void setInUse(String cardNo) {
        this.certNo = cardNo;
    }

    public String getInUse() {
        return this.certNo;
    }

    public boolean isApplyCertEnd() {
        return this.applyCertEnd;
    }

    public void setApplyCertEnd(boolean applyCertEnd) {
        this.applyCertEnd = applyCertEnd;
    }

    public String getCardID(CryptoDevType type) {
        String cardId;
        if (type == CryptoDevType.DEV_TYPE_Soft && AppConfig.getInstance().getCertConfig().getVHSMType().equals("VHSM")) {
            cardId = NetVHSMHandle.getNetVhsmCardId(AppConfig.getInstance().getContext());
        } else {
            CryptoInstance cryptoInstance = DeviceWrapper.getCryptoInstance(type);
            if (cryptoInstance == null) {
                ModuleLog.e((Object)"cryptoInstance == null");
                return null;
            }
            cardId = cryptoInstance.getCardId();
            cryptoInstance.close();
        }
        return cardId;
    }

    public String getIMEI() {
        Context context = AppConfig.getInstance().getContext();
        String imei = "";
        if (ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE") == 0) {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            imei = Build.VERSION.SDK_INT >= 26 ? telephonyManager.getImei() : telephonyManager.getDeviceId();
        }
        if ("\u662f".equals(AppConfig.getInstance().getServerSettingConfig().allowIdentifer)) {
            ModuleLog.e((Object)"identifer:");
            IdentiferBean identiferBean = IdentiferGrantUtils.grantIdentiferSync((Context)context);
            if (identiferBean != null) {
                imei = identiferBean.getIdentifer();
            }
            return imei;
        }
        if (imei == null) {
            imei = Settings.System.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
            ModuleLog.e((Object)("IMEI: " + imei));
            return imei;
        }
        ModuleLog.e((Object)("IMEI : " + imei));
        return imei;
    }

    public String getIMSI() {
        Context context = AppConfig.getInstance().getContext();
        TelephonyManager mTelephonyMgr = (TelephonyManager)context.getSystemService("phone");
        if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE") != 0) {
            return "";
        }
        String imsi = mTelephonyMgr.getSubscriberId();
        if (imsi == null) {
            return "";
        }
        return imsi;
    }

    private static void scanningDevice() {
        boolean isScanningDevice = CryptoDevManager.getInstance().isScanning();
        while (isScanningDevice) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            isScanningDevice = CryptoDevManager.getInstance().isScanning();
        }
    }

    protected static CryptoInstance getCryptoInstance(CryptoDevType type) {
        CryptoInstance cryptoDev;
        DeviceWrapper.scanningDevice();
        try {
            cryptoDev = CryptoDevManager.getInstance().createInstance("ChipManagerDriver", type);
        }
        catch (Exception e) {
            ModuleLog.e((Object)("getCryptoInstance : " + e.getMessage()));
            e.printStackTrace();
            return null;
        }
        if (cryptoDev == null) {
            return null;
        }
        int result = cryptoDev.open();
        if (result != 0) {
            return null;
        }
        return cryptoDev;
    }

    private List<CryptoDevInfo> getDeviceList() {
        List devList = CryptoDevManager.getInstance().getCryptoDevInfos();
        if (devList.size() <= 0) {
            return null;
        }
        return devList;
    }

    public Map<Integer, CryptoDevInfo> getDevInfo() {
        DeviceWrapper.scanningDevice();
        HashMap<Integer, CryptoDevInfo> infoMap = new HashMap<Integer, CryptoDevInfo>();
        List<CryptoDevInfo> devList = this.getDeviceList();
        if (devList == null || devList.size() <= 0) {
            return null;
        }
        for (CryptoDevInfo devInfo : devList) {
            switch (devInfo.getType()) {
                case DEV_TYPE_SdCard: {
                    CryptoDevInfo sdDev = devInfo;
                    infoMap.put(CryptoDevType.DEV_TYPE_SdCard.getType(), sdDev);
                    break;
                }
                case DEV_TYPE_Chip: {
                    CryptoDevInfo chipDev = devInfo;
                    infoMap.put(CryptoDevType.DEV_TYPE_Chip.getType(), chipDev);
                    break;
                }
                case DEV_TYPE_SimKey: {
                    CryptoDevInfo simKeyDev = devInfo;
                    infoMap.put(CryptoDevType.DEV_TYPE_SimKey.getType(), simKeyDev);
                    break;
                }
                case DEV_TYPE_Soft: {
                    CryptoDevInfo softDev = devInfo;
                    infoMap.put(CryptoDevType.DEV_TYPE_Soft.getType(), softDev);
                }
            }
        }
        return infoMap;
    }

    public static int verifyPin(CryptoDevType type, int containerNum, String pinInput) {
        CryptoInstance cryptoInstance = DeviceWrapper.getCryptoInstance(type);
        if (cryptoInstance == null) {
            return -1;
        }
        AppConfig module = AppConfig.getInstance();
        String pin = "";
        if (pinInput != null && pinInput.isEmpty()) {
            Pair pinPair = MultiChipUnitePinManager.getInstance().getPin(AppConfig.getInstance().getContext(), String.valueOf(cryptoInstance.getCardId()), module.getRole(type, containerNum));
            if ((Integer)pinPair.first == 0) {
                ModuleLog.d((Object)"315 DeviceWrapper verifyPin : ");
                pin = (String)pinPair.second;
                if (TextUtils.isEmpty((CharSequence)pin)) {
                    pin = "111111";
                }
            } else {
                ModuleLog.d((Object)"319 DeviceWrapper verifyPin : \u6ca1\u6709\u83b7\u53d6\u5230\u9ed8\u8ba4pin\uff0c\u8bbe\u7f6epin");
                pin = "111111";
            }
        } else {
            pin = pinInput;
        }
        int result = cryptoInstance.verifyPIN(pin, module.getRole(type, containerNum));
        return result;
    }

    private static String getFixPin(CryptoInstance cryptoInstance) {
        String pin = "";
        Pair pinPair = MultiChipUnitePinManager.getInstance().getPin(AppConfig.getInstance().getContext(), String.valueOf(cryptoInstance.getCardId()), 1);
        if ((Integer)pinPair.first == 0) {
            ModuleLog.d((Object)"315 DeviceWrapper verifyPin : ");
            pin = (String)pinPair.second;
        } else {
            ModuleLog.d((Object)"319 DeviceWrapper verifyPin : \u6ca1\u6709\u83b7\u53d6\u5230\u9ed8\u8ba4pin\uff0c\u8bbe\u7f6epin");
            pin = "111111";
        }
        return pin;
    }

    private String errorMsg(int errorCode) {
        return CryptoDevManager.getInstance().getErrorText(errorCode);
    }

    public int clearContainer(CryptoDevType type, int containerNum) {
        CryptoInstance cryptoInstance = DeviceWrapper.getCryptoInstance(type);
        if (cryptoInstance == null) {
            return -1;
        }
        AppConfig module = AppConfig.getInstance();
        int ret = cryptoInstance.verifyPIN(DeviceWrapper.getFixPin(cryptoInstance), module.getRole(type, containerNum));
        if (ret == 0) {
            ret = cryptoInstance.clearContainer(module.getRole(type, containerNum), DeviceWrapper.getFixPin(cryptoInstance), containerNum);
        }
        return ret;
    }

    public int writeUpdateCert(CryptoDevType type, int containerNum, String certStr) {
        int signCertRet;
        Stopwatch watch = Stopwatch.createStarted();
        ModuleLog.e((Object)"start writeUpdateCert : ");
        CertSKF certSKF = this.splitCertStr(type, containerNum, certStr);
        CryptoInstance cryptoInstance = DeviceWrapper.getCryptoInstance(type);
        if (cryptoInstance == null) {
            return -1;
        }
        if (certSKF.getErrorCode() == 4) {
            return -4;
        }
        byte[][] certFid = FidUtil.getCertFid(containerNum);
        if (AppConfig.getInstance().getCertConfig().getCertRule(type, containerNum).equals("\u5355\u8bc1")) {
            if (AppConfig.getInstance().getCertConfig().getCertType(type, containerNum).equals("\u7b7e\u540d\u8bc1\u4e66")) {
                signCertRet = cryptoInstance.writeCert(certFid[0], certSKF.getSignCert(), certSKF.getSignCert().length);
                ModuleLog.e((Object)("\u5199\u7b7e\u540d\u8bc1\u4e66 = " + signCertRet));
                if (signCertRet != 0) {
                    return -1;
                }
            }
            if (AppConfig.getInstance().getCertConfig().getCertType(type, containerNum).equals("\u52a0\u5bc6\u8bc1\u4e66")) {
                int exchangeCertRet = cryptoInstance.writeCert(certFid[1], certSKF.getEnCodeCert(), certSKF.getEnCodeCert().length);
                ModuleLog.e((Object)("\u5199\u4ea4\u6362\u8bc1\u4e66 = " + exchangeCertRet));
                if (exchangeCertRet != 0) {
                    return -1;
                }
            }
        } else if (certSKF.getLen() == 4) {
            signCertRet = cryptoInstance.writeCert(certFid[0], certSKF.getSignCert(), certSKF.getSignCert().length);
            ModuleLog.e((Object)("\u5199\u7b7e\u540d\u8bc1\u4e66 = " + signCertRet));
            int exchangeCertRet = cryptoInstance.writeCert(certFid[1], certSKF.getEnCodeCert(), certSKF.getEnCodeCert().length);
            ModuleLog.e((Object)("\u5199\u4ea4\u6362\u8bc1\u4e66 = " + exchangeCertRet));
            if (signCertRet != 0 || exchangeCertRet != 0) {
                return -1;
            }
        }
        int writeProjectLabelRet = this.writeProjectLabel(type, certSKF.getProjectLabel());
        ModuleLog.e((Object)("\u5199\u9879\u76ee\u6807\u7b7e = " + writeProjectLabelRet));
        if (writeProjectLabelRet != 0) {
            return -1;
        }
        watch.elapsed(TimeUnit.NANOSECONDS);
        return 0;
    }

    public int importCert(CryptoDevType type, int containerNum, String certStr) {
        String certType = AppConfig.getInstance().getCertConfig().getCertType(type, containerNum);
        String certRule = AppConfig.getInstance().getCertConfig().getCertRule(type, containerNum);
        String debugMsg = "\u5f53\u524d\u8bbe\u5907:" + CardType.toString(type) + "\n\u5bb9\u5668\u53f7\uff1a" + containerNum + "\n\u8bc1\u4e66\u673a\u5236" + certRule + "\n\u8bc1\u4e66\u7c7b\u578b:" + certType;
        ModuleLog.e((Object)debugMsg);
        CertSKF certSKF = this.splitCertStr(type, containerNum, certStr);
        if (certSKF == null) {
            this.setApplyCertEnd(false);
            return -1;
        }
        if (certSKF.getErrorCode() == 4) {
            this.setApplyCertEnd(false);
            return -4;
        }
        AppConfig module = AppConfig.getInstance();
        int role = module.getRole(type, containerNum);
        CryptoInstance cryptoInstance = DeviceWrapper.getCryptoInstance(type);
        if (cryptoInstance == null) {
            this.setApplyCertEnd(false);
            return -1;
        }
        String pin = DeviceWrapper.getFixPin(cryptoInstance);
        CertBean bean = null;
        if (module.getCertConfig().getAlgType(type, containerNum).equals("1.0")) {
            switch (AppConfig.getInstance().getCertConfig().getCertRule(type, containerNum)) {
                case "\u5355\u8bc1": {
                    bean = AppConfig.getInstance().getCertConfig().getCertType(type, containerNum).equals("\u7b7e\u540d\u8bc1\u4e66") || TextUtils.isEmpty((CharSequence)AppConfig.getInstance().getCertConfig().getCertType(type, containerNum)) ? CertBean.createSingleRSASignCert((int)role, (String)pin, (int)containerNum, (byte[])certSKF.getSignCert()) : CertBean.createSingleRSAExchangeCert((int)role, (String)pin, (int)containerNum, (byte[])certSKF.getEnCodeCert());
                }
            }
        } else {
            switch (AppConfig.getInstance().getCertConfig().getCertRule(type, containerNum)) {
                case "\u5355\u8bc1": {
                    ModuleLog.e((Object)"\u5355\u8bc1\u5199\u5361");
                    if (AppConfig.getInstance().getCertConfig().getCertType(type, containerNum).equals("\u7b7e\u540d\u8bc1\u4e66") || TextUtils.isEmpty((CharSequence)AppConfig.getInstance().getCertConfig().getCertType(type, containerNum))) {
                        bean = CertBean.createSingleSM2SignCert((int)role, (String)pin, (int)containerNum, (byte[])certSKF.getSignCert());
                        break;
                    }
                    bean = CertBean.createSingleSM2ExchangeCert((int)role, (String)pin, (int)containerNum, (byte[])certSKF.getEnCodeCert());
                    break;
                }
                case "\u53cc\u8bc1": {
                    bean = CertBean.createDoubleSM2CertSkf((int)role, (String)pin, (int)containerNum, (byte[])certSKF.getSignCert(), (byte[])certSKF.getEnCodeCert(), (byte[])certSKF.getKeyPair());
                }
            }
        }
        int importCertRet = cryptoInstance.importCert(bean);
        ModuleLog.e((Object)("import cert = " + importCertRet + "\n" + DeviceWrapper.getInstance().errorMsg(importCertRet)));
        if (importCertRet != 0) {
            this.setApplyCertEnd(false);
            return importCertRet;
        }
        int writeProjectLabelRet = this.writeProjectLabel(type, certSKF.getProjectLabel());
        ModuleLog.e((Object)("writeProjectLabelRet = " + writeProjectLabelRet));
        if (writeProjectLabelRet != 0) {
            this.setApplyCertEnd(false);
            return writeProjectLabelRet;
        }
        this.setApplyCertEnd(false);
        return 0;
    }

    public String getSn(CryptoDevType type, int containerNum, String certStr) {
        CertDetailInfo info;
        CertSKF certSKF = this.splitCertStr(type, containerNum, certStr);
        if (certSKF == null) {
            return "";
        }
        byte[][] fid = FidUtil.getCertFid(containerNum);
        if (AppConfig.getInstance().getCertConfig().getCertType(type, containerNum).equals("\u7b7e\u540d\u8bc1\u4e66") || TextUtils.isEmpty((CharSequence)AppConfig.getInstance().getCertConfig().getCertType(type, containerNum))) {
            byte[] signCert = certSKF.getSignCert();
            int signCertLen = signCert != null ? signCert.length : 0;
            int[] signCodeCertLen = new int[]{signCertLen};
            info = this.readBytesToCert(fid[0], signCert, signCodeCertLen);
        } else {
            byte[] encodeCert = certSKF.getEnCodeCert();
            int encodeCertLen = encodeCert != null ? encodeCert.length : 0;
            int[] enCodeCertLen = new int[]{encodeCertLen};
            info = this.readBytesToCert(fid[1], encodeCert, enCodeCertLen);
        }
        if (info == null) {
            return "";
        }
        return info.getSn();
    }

    private CertSKF splitCertStr(CryptoDevType type, int containerNum, String certStr) {
        if (certStr.equals("") || certStr.length() <= 0) {
            return null;
        }
        certStr = certStr.replace("-----BEGIN CERTIFICATE-----", "").replace("-----END CERTIFICATE-----", "");
        certStr = certStr.replace("\r", "").replace("\n", "");
        certStr = certStr.replace("\\r", "").replace("\\n", "");
        String[] pieces = certStr.split("#");
        ModuleLog.e((Object)("\u8bc1\u4e66\u603b\u6bb5\u6570\uff1a" + pieces.length));
        for (int i = 0; i <= pieces.length - 1; ++i) {
            ModuleLog.e((Object)("\u7b2c" + (i + 1) + "\u6bb5\n" + pieces[i]));
        }
        CertSKF certSKF = new CertSKF();
        String certRule = AppConfig.getInstance().getCertConfig().getCertRule(type, containerNum);
        if (certRule.equals("\u5355\u8bc1") && pieces.length != 2 || certRule.equals("\u53cc\u8bc1") && pieces.length != 4) {
            certSKF.setErrorCode(4);
        }
        switch (pieces.length) {
            case 2: {
                if (!TextUtils.isEmpty((CharSequence)pieces[0])) {
                    if (AppConfig.getInstance().getCertConfig().getCertType(type, containerNum).equals("\u7b7e\u540d\u8bc1\u4e66") || TextUtils.isEmpty((CharSequence)AppConfig.getInstance().getCertConfig().getCertType(type, containerNum))) {
                        certSKF.setSignCert(Base64.decode((byte[])pieces[0].getBytes()));
                    } else if (AppConfig.getInstance().getCertConfig().getCertType(type, containerNum).equals("\u52a0\u5bc6\u8bc1\u4e66")) {
                        certSKF.setEnCodeCert(Base64.decode((byte[])pieces[0].getBytes()));
                    }
                }
                if (!TextUtils.isEmpty((CharSequence)pieces[1])) {
                    certSKF.setProjectLabel(pieces[1]);
                }
                certSKF.setLen(2);
                break;
            }
            case 3: {
                if (!TextUtils.isEmpty((CharSequence)pieces[0])) {
                    certSKF.setSignCert(Base64.decode((byte[])pieces[0].getBytes()));
                }
                if (!TextUtils.isEmpty((CharSequence)pieces[1])) {
                    certSKF.setEnCodeCert(Base64.decode((byte[])pieces[1].getBytes()));
                }
                if (!TextUtils.isEmpty((CharSequence)pieces[2])) {
                    certSKF.setProjectLabel(pieces[2]);
                }
                certSKF.setLen(3);
            }
            case 4: {
                if (!TextUtils.isEmpty((CharSequence)pieces[0])) {
                    certSKF.setSignCert(Base64.decode((byte[])pieces[0].getBytes()));
                }
                if (!TextUtils.isEmpty((CharSequence)pieces[1])) {
                    certSKF.setEnCodeCert(Base64.decode((byte[])pieces[1].getBytes()));
                }
                if (!TextUtils.isEmpty((CharSequence)pieces[2])) {
                    certSKF.setKeyPair(Base64.decode((byte[])pieces[2].getBytes()));
                }
                if (!TextUtils.isEmpty((CharSequence)pieces[3])) {
                    certSKF.setProjectLabel(pieces[3]);
                }
                certSKF.setLen(4);
            }
        }
        return certSKF;
    }

    private int writeProjectLabel(CryptoDevType type, String labStr) {
        byte[] labelFid = new byte[]{0, -97};
        CryptoInstance cryptoInstance = DeviceWrapper.getCryptoInstance(type);
        if (cryptoInstance == null) {
            return -1;
        }
        byte[] labStrBytes = labStr.getBytes();
        int writeLabel = -1;
        int createRet = this.createFile(type);
        if (createRet == 0 || createRet == 2033) {
            writeLabel = cryptoInstance.writeFile(labelFid, 0, 64, labStrBytes);
            ModuleLog.e((Object)("\u5199\u6807\u7b7e\u7ed3\u679c\uff1a= " + writeLabel));
        }
        return writeLabel;
    }

    private int createFile(CryptoDevType type) {
        byte[] labelFid = new byte[]{0, -97};
        XDJA_FILE file = new XDJA_FILE();
        file.read_Acl = (byte)-15;
        file.write_Acl = (byte)-15;
        file.room = (short)512;
        file.type = 1;
        file.id = labelFid;
        CryptoInstance cryptoInstance = DeviceWrapper.getCryptoInstance(type);
        if (cryptoInstance == null) {
            return -1;
        }
        int ret = cryptoInstance.createFile(file);
        return ret;
    }

    public CertDetailInfo readCertFromContainer(CryptoDevType type, int containerNo, String certType) {
        byte[] fid = null;
        byte[][] certFid = FidUtil.getCertFid(containerNo);
        if (certType.equals("\u7b7e\u540d\u8bc1\u4e66")) {
            fid = certFid[0];
            return this.readCertFromFid(type, fid);
        }
        if (certType.equals("\u52a0\u5bc6\u8bc1\u4e66")) {
            fid = certFid[1];
            return this.readCertFromFid(type, fid);
        }
        CertDetailInfo info = this.readCertFromFid(type, certFid[0]);
        if (info == null) {
            info = this.readCertFromFid(type, certFid[1]);
        }
        return info;
    }

    private CertDetailInfo readCertFromFid(CryptoDevType type, byte[] fid) {
        byte[] certBuf = new byte[2048];
        int[] certLen = new int[1];
        byte[] bytes = this.readCertBytes(type, fid, certBuf, certLen);
        if (bytes == null) {
            return null;
        }
        return this.readBytesToCert(fid, certBuf, certLen);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean convertCertFile(X509Certificate x509Cert) {
        File dest = new File(Environment.getExternalStorageDirectory() + "/" + "certDataBase" + ".cer");
        try (FileOutputStream fos = new FileOutputStream(dest);){
            if (x509Cert == null) {
                boolean bl2 = false;
                return bl2;
            }
            fos.write(x509Cert.getEncoded());
            fos.flush();
            fos.close();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public byte[] readCertBytes(CryptoDevType type, byte[] fid, byte[] certBuf, int[] certLen) {
        CryptoInstance cryptoInstance = DeviceWrapper.getCryptoInstance(type);
        if (cryptoInstance == null) {
            return null;
        }
        int result = cryptoInstance.readCert(fid, certBuf, certLen);
        cryptoInstance.close();
        if (result != 0) {
            return null;
        }
        return certBuf;
    }

    private CertDetailInfo readBytesToCert(byte[] fid, byte[] certBuf, int[] certLen) {
        if (fid.length == 0 || certBuf.length == 0 || certLen.length == 0) {
            return null;
        }
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy.MM.dd");
            SimpleDateFormat formatterValid = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
            ByteArrayInputStream bin = new ByteArrayInputStream(certBuf);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate cert2 = (X509Certificate)cf.generateCertificate(bin);
            CertDetailInfo certDetailInfo = new CertDetailInfo();
            certDetailInfo.setIssuerOrg(cert2.getIssuerX500Principal().getName());
            certDetailInfo.setIssuerCn(cert2.getIssuerDN().getName());
            certDetailInfo.setSubjectOrg(cert2.getSubjectX500Principal().getName());
            certDetailInfo.setSubjectCn(cert2.getSubjectDN().getName());
            certDetailInfo.setAlg(cert2.getSigAlgName());
            certDetailInfo.setVer(cert2.getVersion());
            System.arraycopy(fid, 0, certDetailInfo.getCertId(), 0, 2);
            certDetailInfo.setIndate(formatter.format(cert2.getNotBefore()) + " - " + formatter.format(cert2.getNotAfter()));
            certDetailInfo.setNotBefore(cert2.getNotBefore());
            certDetailInfo.setNotAfter(cert2.getNotAfter());
            certDetailInfo.setSn(cert2.getSerialNumber().toString(16));
            certDetailInfo.setCertLen(certLen);
            bin.close();
            return certDetailInfo;
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String signData(CryptoDevType type, int containerNum, String str) {
        byte[] signData;
        if (str.equals("")) {
            return null;
        }
        byte[][] keyPair = FidUtil.getKeyPairFid(type, containerNum);
        byte[] pubFid = keyPair[0];
        byte[] priFid = keyPair[1];
        int[] signDataLen = new int[1];
        byte[] certInfoBytes = str.getBytes();
        CryptoInstance cryptoInstance = DeviceWrapper.getCryptoInstance(type);
        if (cryptoInstance == null) {
            ModuleLog.e((Object)"\u5f85\u7b7e\u540d\u4fe1\u606f cryptoInstance = null");
            return null;
        }
        AppConfig module = AppConfig.getInstance();
        int ret = DeviceWrapper.verifyPin(type, containerNum, "");
        if (ret != 0) {
            return "errorCode" + CryptoDevManager.getInstance().getErrorText(ret);
        }
        if (module.getCertConfig().getAlgType(type, containerNum).equals("1.0")) {
            signData = new byte[256];
            ret = cryptoInstance.RSASign(2048, priFid, 1, certInfoBytes, certInfoBytes.length, signData, signDataLen);
        } else {
            signData = new byte[64];
            ret = cryptoInstance.SM2Sign(pubFid, priFid, 1, certInfoBytes, certInfoBytes.length, signData, signDataLen);
        }
        byte[] data = new byte[signDataLen[0]];
        System.arraycopy(signData, 0, data, 0, data.length);
        if (ret == 0) {
            return new String(Base64.encode((byte[])data));
        }
        return "";
    }

    public boolean verifyCertByRoot(Context context, CryptoDevType type, int containerNo) {
        Principal principalSubject;
        BouncyCastleProvider provider = new BouncyCastleProvider();
        Security.removeProvider("BC");
        Security.addProvider((Provider)provider);
        X509Certificate cert2 = this.getX509Certificate(this.readCertFromType(type, containerNo), provider);
        String result = AppConfig.getInstance().getServerSettingConfig().getCertContent();
        if (TextUtils.isEmpty((CharSequence)result)) {
            return false;
        }
        InputStream is = ApplicationInit.string2IS(result);
        X509Certificate root = this.getX509Certificate(is, provider);
        if (cert2 == null || root == null) {
            return false;
        }
        Principal principalIssuer = cert2.getIssuerDN();
        if (!principalIssuer.equals(principalSubject = root.getSubjectDN())) {
            return false;
        }
        try {
            cert2.verify(root.getPublicKey());
            return true;
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
        }
        catch (SignatureException e) {
            e.printStackTrace();
        }
        return false;
    }

    public X509Certificate getX509Certificate(InputStream is, BouncyCastleProvider provider) {
        if (is == null) {
            return null;
        }
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", (Provider)provider);
            X509Certificate certificate = (X509Certificate)cf.generateCertificate(is);
            is.close();
            return certificate;
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public InputStream readCertFromType(CryptoDevType type, int containerNum) {
        byte[][] fid = FidUtil.getCertFid(containerNum);
        byte[] certBuf = new byte[2048];
        int[] certLen = new int[1];
        CryptoInstance cryptoInstance = DeviceWrapper.getCryptoInstance(type);
        if (cryptoInstance == null) {
            return null;
        }
        int result = -1;
        if (AppConfig.getInstance().getCertConfig().getCertType(type, containerNum).equals("\u7b7e\u540d\u8bc1\u4e66") || TextUtils.isEmpty((CharSequence)AppConfig.getInstance().getCertConfig().getCertType(type, containerNum))) {
            result = cryptoInstance.readCert(fid[0], certBuf, certLen);
        } else if (AppConfig.getInstance().getCertConfig().getCertType(type, containerNum).equals("\u52a0\u5bc6\u8bc1\u4e66")) {
            result = cryptoInstance.readCert(fid[1], certBuf, certLen);
        }
        cryptoInstance.close();
        if (result == 0) {
            return new ByteArrayInputStream(certBuf);
        }
        return null;
    }
}

