/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.util;

import android.content.Context;
import android.text.TextUtils;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.HttpResponseCallBack;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.bean.request.IDCard;
import com.xdja.safeclient.certcreation.bean.request.SimpleChipInfo;
import com.xdja.safeclient.certcreation.bean.request.VerifyInfoSelfieRequest;
import com.xdja.safeclient.certcreation.bean.response.BaseErrorResponse;
import com.xdja.safeclient.certcreation.bean.response.CommonResponse;
import com.xdja.safeclient.certcreation.bean.response.CompareResult;
import com.xdja.safeclient.certcreation.bean.result.AuthResult;
import com.xdja.safeclient.certcreation.cache.ImageCache;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.service.CertService;
import com.xdja.safeclient.certcreation.util.Base64Util;
import com.xdja.safeclient.certcreation.util.ModuleLog;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import com.xdja.safeclient.certcreation.util.ShareperencesUtil;
import com.xdja.safeclient.certcreation.util.TypeUtil;
import com.xdja.safeclient.certcreation.util.Util;
import java.io.IOException;
import java.net.URLEncoder;
import okhttp3.Call;

public class ApplyCertUtil {
    public static final String WAIT = "0";
    public static final String SUCCESS = "1";
    public static final String AUTO_VERIFY_NOT_MATCH = "2";

    public static void start(Context context, final WhatHappen happen) {
        happen.showDialog();
        final CryptoDevType cardType = TypeUtil.formatType(ShareperencesUtil.getCurrentDevType(context));
        final String cardNo = DeviceWrapper.getInstance().getCardID(cardType);
        if (TextUtils.isEmpty((CharSequence)cardNo)) {
            ModuleToast.show(context, R.string.card_device_error);
            return;
        }
        VerifyInfoSelfieRequest request = ApplyCertUtil.buildRequest(ShareperencesUtil.getIDCardNo(context, cardType.getType()), ShareperencesUtil.getName(context), ShareperencesUtil.getPhoneNum(context), ShareperencesUtil.getSex(context, cardType.getType()), cardType);
        CertService service = new CertService();
        service.applyAuthentication(request, cardNo, new HttpResponseCallBack<CommonResponse>(){

            @Override
            public void onOtherException(Exception e) {
                e.printStackTrace();
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                happen.IOError();
                OttoUtil.postAuthResult(ApplyCertUtil.buildAuthResult(cardType, cardNo, null, null));
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                OttoUtil.postAuthResult(ApplyCertUtil.buildAuthResult(cardType, cardNo, commonResponse, null));
                happen.handleResult(commonResponse);
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                happen.handleError(baseErrorResponse);
            }

            @Override
            public void dismissDialog() {
                happen.cancelDialog();
            }
        });
    }

    public static AuthResult buildAuthResult(CryptoDevType type, String cardNum, CommonResponse response, BaseErrorResponse errorResponse) {
        CompareResult result = new CompareResult();
        if (response == null && errorResponse == null) {
            result.setResult("");
            result.setMessage("");
            result.setErrCode("");
            result.setSuccess(false);
        } else if (errorResponse != null) {
            result.setResult(errorResponse.getErrCode());
            result.setErrCode(errorResponse.getErrCode());
            if (!TextUtils.isEmpty((CharSequence)errorResponse.getMessage())) {
                result.setMessage(errorResponse.getMessage());
            }
            result.setSuccess(false);
        } else {
            result.setResult(response.getResult());
            result.setMessage(response.getMessage());
            result.setSuccess(true);
        }
        result.setIdentity(cardNum);
        AuthResult auth = new AuthResult(type, result);
        ModuleLog.d(auth);
        return auth;
    }

    public static VerifyInfoSelfieRequest buildRequest(String id2, String name, String phone, int sex, CryptoDevType cardType) {
        VerifyInfoSelfieRequest request = new VerifyInfoSelfieRequest();
        IDCard idCard = new IDCard();
        idCard.setIdNum(id2);
        idCard.setName(name);
        idCard.setSex(sex);
        idCard.setPhoto(URLEncoder.encode(Base64Util.fromFile(ImageCache.PATH_ID_IMG)));
        SimpleChipInfo chipInfo = new SimpleChipInfo();
        chipInfo.setPhone(phone);
        chipInfo.setCardType("" + Util.convertCardType(cardType.getType()));
        int company = AppConfig.getInstance().getLiveCompany();
        return request;
    }

    public static void handleSuccessResult(Context context, CommonResponse response) {
        int liveCompany = AppConfig.getInstance().getLiveCompany();
        String result = response.getResult();
        if (result.equals(WAIT)) {
            OttoUtil.postFinishActivity();
        } else if (result.equals(SUCCESS)) {
            OttoUtil.postFinishActivity();
        } else if (result.equals(AUTO_VERIFY_NOT_MATCH)) {
            ModuleToast.show(context, R.string.auto_verify_not_match);
        }
    }

    public static interface WhatHappen {
        public void showDialog();

        public void cancelDialog();

        public void IOError();

        public void handleResult(CommonResponse var1);

        public void handleError(BaseErrorResponse var1);
    }
}

