/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.view;

import android.content.Context;
import android.os.Message;
import android.support.annotation.StringRes;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.aircert.BusProvider;
import com.aircert.util.WeakReferenceHandler;
import com.alibaba.android.arouter.launcher.ARouter;
import com.squareup.otto.Subscribe;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.adapter.RecyclerViewAdapter;
import com.xdja.safeclient.certcreation.bean.CertDetailInfo;
import com.xdja.safeclient.certcreation.bean.CertItemBean;
import com.xdja.safeclient.certcreation.bean.CertState;
import com.xdja.safeclient.certcreation.bean.ChipBean;
import com.xdja.safeclient.certcreation.cache.RequestCache;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.event.PhonePermissionResult;
import com.xdja.safeclient.certcreation.service.CertService;
import com.xdja.safeclient.certcreation.service.ChipExecutorService;
import com.xdja.safeclient.certcreation.util.AnimUtil;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import com.xdja.safeclient.certcreation.util.ShareperencesUtil;
import com.xdja.safeclient.certcreation.util.Util;
import java.io.Serializable;

public class CertItemView
extends RelativeLayout {
    private FrameLayout container_child;
    private ChipBean chipBean;
    private Context context;
    private static final int QUERY_CERTINFO_FROM_SERVER = 0;
    private static final int APPLY_CERT_REQUEST = 1;
    private static final int QUERY_AUTHENTIATION_RESULT = 2;
    private static final int IMPORT_CERT_FAIL = 3;
    private String cardID;
    private CryptoDevType chipBeanType;
    private RecyclerViewAdapter recyclerViewAdapter;
    private boolean isCertOK = false;
    private CertItemBean certItemBean;
    private ChipExecutorService chipExecutorService = new ChipExecutorService();
    private static final int TAG_QUERY_CERT_STATE = 0;
    private MyHandler myHandler = new MyHandler(this);
    private CertService certService = new CertService();

    public CertItemView(Context context, AttributeSet attrs) {
        super(context, attrs);
        LayoutInflater.from((Context)context).inflate(R.layout.cer_item_layout, (ViewGroup)this);
        BusProvider.register((Object)((Object)this));
    }

    public boolean isCertOK() {
        return this.isCertOK;
    }

    public void setData(Context context, RecyclerViewAdapter recyclerViewAdapter, CertItemBean certItemBean) {
        this.context = context;
        this.certItemBean = certItemBean;
        this.isCertOK = false;
        this.chipBeanType = this.certItemBean.getType();
        this.cardID = DeviceWrapper.getInstance().getCardID(this.chipBeanType);
        this.recyclerViewAdapter = recyclerViewAdapter;
        this.initView();
        if (TextUtils.isEmpty((CharSequence)this.cardID)) {
            this.showErrorResponseLayout(context.getString(R.string.card_not_exist));
            return;
        }
        RequestCache.getInstance().putType(this.cardID, this.chipBeanType.getType());
        if (Util.assetFileIsExist(context, "certDataBase.db")) {
            this.queryCertInfo();
        }
    }

    private void queryCertInfo() {
        this.showChecking();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                int type = CertItemView.this.chipBeanType.getType();
                ChipBean bean = new ChipBean();
                bean.setType(type);
                CertDetailInfo info = DeviceWrapper.getInstance().readCertFromContainer(CertItemView.this.chipBeanType, AppConfig.getInstance().getContainerID());
                if (info == null) {
                    bean.setState(CertState.NO_CERT);
                } else {
                    if (bean.getState() == CertState.CERT_OUT_OF_DATE) {
                        bean.setState(CertState.CERT_OUT_OF_DATE);
                    } else {
                        bean.setState(CertState.SUCCESS);
                    }
                    bean.setCertDetailInfo(info);
                    boolean isVerify = DeviceWrapper.getInstance().verifyCertByRoot(CertItemView.this.chipBeanType, AppConfig.getInstance().getContainerID());
                    bean.setIsVerify(isVerify);
                }
                CertItemView.this.chipExecutorService.sendMessage(CertItemView.this.myHandler, 0, bean);
            }
        };
        this.chipExecutorService.exe(runnable);
    }

    public ChipBean getChipBean() {
        return this.chipBean;
    }

    private void initView() {
        TextView name = (TextView)this.findViewById(R.id.name);
        this.container_child = (FrameLayout)this.findViewById(R.id.container_child);
        if (this.certItemBean.getType() == CryptoDevType.DEV_TYPE_SdCard) {
            name.setText(R.string.tf_cert);
        } else if (this.certItemBean.getType() == CryptoDevType.DEV_TYPE_Chip) {
            name.setText(R.string.chip_cert);
        } else if (this.certItemBean.getType() == CryptoDevType.DEV_TYPE_SimKey) {
            name.setText(R.string.tiemo_cert);
        } else if (this.certItemBean.getType() == CryptoDevType.DEV_TYPE_Soft) {
            name.setText(R.string.soft_cert);
        }
        this.container_child.setVisibility(0);
    }

    private void applyCert() {
        String imsi = DeviceWrapper.getInstance().getIMSI();
        if (imsi == null || imsi.equals("")) {
            ModuleToast.show(this.context, R.string.get_imsi_failed);
            return;
        }
        ShareperencesUtil.saveCurrentDevType(this.context, this.chipBean.getType());
        ShareperencesUtil.saveDevCardID(this.context, this.cardID);
        if (this.recyclerViewAdapter != null) {
            this.recyclerViewAdapter.setIsRefresh(false);
        }
        ARouter.getInstance().build("/cert/phone_info").withSerializable("cardType", (Serializable)this.chipBeanType).withString("cardNum", this.cardID).navigation(this.getContext());
    }

    private void showChecking() {
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.cert_item_layout_loading, null, true);
        ImageView imageView = (ImageView)view.findViewById(R.id.iv_icon);
        AnimUtil.rotate(this.context, (View)imageView);
        this.container_child.removeAllViews();
        this.container_child.addView(view);
    }

    private void showErrorResponseLayout(String title, String message, boolean isReapply) {
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.cert_item_layout_error, null);
        ImageView imgView = (ImageView)view.findViewById(R.id.cert_item_top_two_img);
        TextView content = (TextView)view.findViewById(R.id.cert_item_top_two_content);
        TextView fail_reason = (TextView)view.findViewById(R.id.fail_reason);
        View divider = view.findViewById(R.id.divider);
        View bottom_button_layout = view.findViewById(R.id.bottom_button_layout);
        TextView tv_apply = (TextView)view.findViewById(R.id.tv_apply);
        imgView.setImageResource(R.drawable.pic_gj_02);
        content.setText((CharSequence)title);
        fail_reason.setText((CharSequence)message);
        if (isReapply) {
            divider.setVisibility(0);
            bottom_button_layout.setVisibility(0);
            tv_apply.setText(R.string.reapply);
            bottom_button_layout.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    CertItemView.this.requestPhonePermission();
                }
            });
        } else {
            divider.setVisibility(8);
            bottom_button_layout.setVisibility(8);
        }
        if (message.contains(this.context.getString(R.string.server_error_short))) {
            tv_apply.setText(R.string.retry);
            tv_apply.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                }
            });
        }
        this.container_child.removeAllViews();
        this.container_child.addView(view);
    }

    private void showErrorResponseLayout(String message) {
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.cert_item_layout_error, null);
        view.findViewById(R.id.fail_reason).setVisibility(8);
        TextView button = (TextView)view.findViewById(R.id.tv_apply);
        button.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                CertItemView.this.requestPhonePermission();
            }
        });
        if (message.contains(this.context.getString(R.string.server_error_short)) || message.contains(this.context.getString(R.string.app_time_exception_user))) {
            button.setText(R.string.retry);
            button.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                }
            });
        }
        if (message.contains("\u5b89\u5168\u8bbe\u5907\u5931\u8d25")) {
            button.setText(R.string.retry);
            button.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    CertItemView.this.cardID = DeviceWrapper.getInstance().getCardID(CertItemView.this.chipBeanType);
                    if (TextUtils.isEmpty((CharSequence)CertItemView.this.cardID)) {
                        CertItemView.this.showErrorResponseLayout(CertItemView.this.context.getString(R.string.card_not_exist));
                        return;
                    }
                }
            });
        }
        ImageView imgView = (ImageView)view.findViewById(R.id.cert_item_top_two_img);
        imgView.setImageResource(R.drawable.pic_gj_02);
        TextView content = (TextView)view.findViewById(R.id.cert_item_top_two_content);
        content.setText((CharSequence)message);
        this.container_child.removeAllViews();
        this.container_child.addView(view);
    }

    private void show(String message, int click) {
    }

    private void showNoCert() {
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.cert_item_layout_no_cert, null);
        view.findViewById(R.id.apply_cert_btn).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CertItemView.this.requestPhonePermission();
            }
        });
        this.container_child.removeAllViews();
        this.container_child.addView(view);
    }

    @Subscribe
    public void onPhonePermission(PhonePermissionResult phonePermissionResult) {
        if (phonePermissionResult.type == this.chipBeanType.getType()) {
            this.applyCert();
        }
    }

    private void requestPhonePermission() {
        OttoUtil.postRequestPhonePermission(this.chipBeanType.getType());
    }

    private void showCertDetail(final @StringRes int strRes, final ChipBean chipBean) {
        this.chipBean = chipBean;
        this.isCertOK = true;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                final View view = LayoutInflater.from((Context)CertItemView.this.context).inflate(R.layout.cert_item_layout_detail, null);
                CertItemView.this.myHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        TextView tv_cert_state = (TextView)view.findViewById(R.id.tv_cert_state);
                        TextView tv_container = (TextView)view.findViewById(R.id.tv_container);
                        TextView tv_sn = (TextView)view.findViewById(R.id.tv_sn);
                        TextView tv_user = (TextView)view.findViewById(R.id.tv_user);
                        TextView tv_peroid = (TextView)view.findViewById(R.id.tv_peroid);
                        tv_container.setText((CharSequence)(CertItemView.this.context.getString(R.string.cert_container) + "      " + AppConfig.getInstance().getContainerID()));
                        tv_cert_state.setText(strRes);
                        CertDetailInfo certDetailInfo = chipBean.getCertBean();
                        String sn = CertItemView.this.context.getString(R.string.cert_sn) + "      " + certDetailInfo.sn;
                        tv_sn.setText((CharSequence)sn);
                        String owner = CertItemView.this.context.getString(R.string.cert_owner) + "      " + CertItemView.this.getCertHolder(certDetailInfo.subjectCn);
                        tv_user.setText((CharSequence)owner);
                        String peroid = CertItemView.this.context.getString(R.string.cert_period) + "  " + certDetailInfo.indate;
                        tv_peroid.setText((CharSequence)peroid);
                        CertItemView.this.container_child.removeAllViews();
                        CertItemView.this.container_child.addView(view);
                    }
                }, 10L);
            }
        };
        this.chipExecutorService.exe(runnable);
    }

    private String getCertHolder(String sn) {
        String[] split = sn.split(",");
        for (int i = 0; i < split.length; ++i) {
            String cnStr = split[i];
            if (!cnStr.contains("CN=")) continue;
            int beginIndex = 3;
            int length = cnStr.length();
            return split[i].substring(beginIndex, length);
        }
        return "";
    }

    @Subscribe
    public void updateCertState(ChipBean chipBean) {
        if (chipBean.getType() != this.chipBeanType.getType()) {
            return;
        }
        CertState state = chipBean.getState();
        if (state == CertState.AGREE_UPDATE) {
            this.isCertOK = true;
            chipBean.setState(CertState.SUCCESS);
            this.showCertDetail(R.string.normal_state, chipBean);
        } else if (state == CertState.WAITING_AGREE_REVOKE) {
            this.showCertDetail(R.string.revoke_ing, chipBean);
            chipBean.setState(CertState.WAITING_AGREE_REVOKE);
            this.isCertOK = true;
        } else if (state == CertState.AGREE_REVOKE) {
            this.showCertDetail(R.string.revoke_success, chipBean);
            chipBean.setState(CertState.AGREE_REVOKE);
            this.isCertOK = true;
        } else if (state == CertState.RECOVERY_PROGRESS) {
            this.showCertDetail(R.string.recovery_progress, chipBean);
            chipBean.setState(CertState.RECOVERY_PROGRESS);
            this.isCertOK = true;
        } else if (state == CertState.RECOVERY_SUCCESS) {
            this.isCertOK = true;
            chipBean.setState(CertState.SUCCESS);
            this.showCertDetail(R.string.normal_state, chipBean);
        } else {
            this.isCertOK = false;
            this.showNoCert();
        }
    }

    private int getBeanName(CryptoDevType type) {
        switch (type) {
            case DEV_TYPE_SdCard: {
                return R.string.tf_cert;
            }
            case DEV_TYPE_Chip: {
                return R.string.chip_cert;
            }
            case DEV_TYPE_SimKey: {
                return R.string.tiemo_cert;
            }
            case DEV_TYPE_Soft: {
                return R.string.soft_cert;
            }
        }
        return R.string.chip_cert;
    }

    private boolean isChipBeanSizeIsZero() {
        return this.chipBean.getState() == CertState.NO_CERT;
    }

    public void onDestory() {
        BusProvider.unRegister((Object)((Object)this));
    }

    private static class MyHandler
    extends WeakReferenceHandler<CertItemView> {
        public MyHandler(CertItemView reference) {
            super((Object)reference);
        }

        protected void handleMessage(CertItemView reference, Message msg) {
            reference.chipBean = (ChipBean)msg.obj;
            if (msg.what == 0) {
                if (reference.chipBean.getState() == CertState.SUCCESS && !reference.chipBean.getIsVerify()) {
                    reference.showCertDetail(R.string.cert_not_in_system, reference.chipBean);
                } else {
                    reference.showNoCert();
                }
            } else if (reference.chipBean.getState() == CertState.NO_CERT) {
                reference.showNoCert();
            } else {
                reference.showCertDetail(R.string.normal_state, reference.chipBean);
            }
        }
    }
}

