/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.activity;

import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.RadioGroup;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.squareup.otto.Subscribe;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.BaseActivity;
import com.xdja.safeclient.certcreation.bean.response.BaseErrorResponse;
import com.xdja.safeclient.certcreation.bean.response.CommonResponse;
import com.xdja.safeclient.certcreation.cache.RequestCache;
import com.xdja.safeclient.certcreation.event.FinishActivity;
import com.xdja.safeclient.certcreation.util.ApplyCertUtil;
import com.xdja.safeclient.certcreation.util.CryptoDevTypeUtil;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import com.xdja.safeclient.certcreation.util.ShareperencesUtil;
import com.xdja.safeclient.certcreation.util.ValidUtil;

@Route(path="/cert/basic_info", name="\u57fa\u672c\u4fe1\u606f")
public class BasicInfoActivity
extends BaseActivity {
    Button next;
    RadioGroup gender;
    EditText etName;
    EditText etId;
    String phone;
    Context context;
    CryptoDevType cardType;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_basic_info);
        this.context = this;
        this.etName = (EditText)this.findViewById(R.id.et_name);
        this.gender = (RadioGroup)this.findViewById(R.id.gender);
        this.etId = (EditText)this.findViewById(R.id.et_id);
        this.etId.setRawInputType(2);
        this.phone = ShareperencesUtil.getPhoneNum((Context)this);
        this.next = (Button)this.findViewById(R.id.next);
        int city = AppConfig.getInstance().getProject();
        if (city == 5) {
            this.next.setText(R.string.submit);
        }
        this.next.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (!BasicInfoActivity.this.validContent()) {
                    return;
                }
                RequestCache.getInstance().setTime(System.currentTimeMillis());
                BasicInfoActivity.this.cardType = CryptoDevTypeUtil.formatType(ShareperencesUtil.getCurrentDevType((Context)BasicInfoActivity.this));
                String cardNum = ShareperencesUtil.getDevCardID((Context)BasicInfoActivity.this);
                if (ValidUtil.cardType(BasicInfoActivity.this.cardType) && ValidUtil.cardNum(cardNum) && ValidUtil.name(BasicInfoActivity.this.etName.getText().toString()) && ValidUtil.idNum(BasicInfoActivity.this.etId.getText().toString())) {
                    BasicInfoActivity.this.saveValues();
                    ApplyCertUtil.start((Context)BasicInfoActivity.this, new ApplyCertUtil.WhatHappen(){

                        @Override
                        public void showDialog() {
                            BasicInfoActivity.this.showLoading();
                        }

                        @Override
                        public void cancelDialog() {
                            BasicInfoActivity.this.dismissLoading();
                        }

                        @Override
                        public void IOError() {
                            BasicInfoActivity.this.dismissLoading();
                            BasicInfoActivity.this.showRequestError();
                        }

                        @Override
                        public void handleResult(CommonResponse response) {
                            ApplyCertUtil.handleSuccessResult((Context)BasicInfoActivity.this, response);
                        }

                        @Override
                        public void handleError(BaseErrorResponse baseErrorResponse) {
                            BasicInfoActivity.this.handleError(baseErrorResponse);
                        }
                    });
                }
            }
        });
    }

    private boolean validContent() {
        String name = this.etName.getText().toString();
        if (name.isEmpty() || name.length() <= 0) {
            ModuleToast.show(this.context, this.getResources().getString(R.string.error_name_not_null));
            return false;
        }
        String idNo = this.etId.getText().toString();
        if (idNo.isEmpty() || idNo.length() <= 0) {
            ModuleToast.show(this.context, this.getResources().getString(R.string.error_id_not_null));
            return false;
        }
        if (!idNo.isEmpty() && idNo.length() < 18) {
            ModuleToast.show(this.context, this.getResources().getString(R.string.error_id_size));
            return false;
        }
        return true;
    }

    private void handleError(BaseErrorResponse baseErrorResponse) {
        if (baseErrorResponse.getMessage().equals("identity_not_police") && AppConfig.getInstance().getProject() == 0) {
            this.gotoProfessionActivity();
        } else {
            OttoUtil.postAuthResult(ApplyCertUtil.buildAuthResult(this.cardType, ShareperencesUtil.getDevCardID((Context)this), null, baseErrorResponse));
            OttoUtil.postFinishActivity();
        }
    }

    private void gotoProfessionActivity() {
        this.saveValues();
        ARouter.getInstance().build("/cert/profession").navigation((Context)this);
    }

    private void saveValues() {
        ShareperencesUtil.savePhone(this.context, this.phone);
        ShareperencesUtil.saveIDCardNo((Context)this, this.cardType.getType(), this.etId.getText().toString());
        ShareperencesUtil.saveSex((Context)this, this.cardType.getType(), this.gender.getCheckedRadioButtonId() == R.id.male ? 1 : 2);
        ShareperencesUtil.saveName((Context)this, this.etName.getText().toString());
    }

    @Subscribe
    public void handleFinishActivity(FinishActivity event) {
        this.finish();
    }

    protected int getTitleRes() {
        return R.string.activity_basic_info;
    }

    protected boolean isOCRActivity() {
        return true;
    }
}

