/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.activity;

import android.content.Context;
import android.os.Bundle;
import android.os.Environment;
import android.support.annotation.Nullable;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.xdja.a3rdplugin.demo.event.IDCardHeadResult;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.HttpResponseCallBack;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.BaseActivity;
import com.xdja.safeclient.certcreation.bean.ChipInfo;
import com.xdja.safeclient.certcreation.bean.request.CompareCardInfoAndFaceInfoRequest;
import com.xdja.safeclient.certcreation.bean.response.BaseErrorResponse;
import com.xdja.safeclient.certcreation.bean.response.CommonResponse;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.util.ApplyCertUtil;
import com.xdja.safeclient.certcreation.util.CryptoDevTypeUtil;
import com.xdja.safeclient.certcreation.util.ModuleLog;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import com.xdja.safeclient.certcreation.util.ShareperencesUtil;
import java.io.IOException;
import ocr.bean.IDCardInfo;
import okhttp3.Call;

@Route(path="/cert/id", name="\u8eab\u4efd\u8bc1\u4fe1\u606f")
public class IDResultActivity
extends BaseActivity {
    TextView tvIdNum;
    TextView tvName;
    Button btnNext;
    private IDCardInfo idCardInfo;
    private String faceImg = "ASDASDASDA";
    CryptoDevType cardType;
    public static String dirName = Environment.getExternalStorageDirectory().getAbsolutePath() + "/faceapp";

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_id_result);
        this.cardType = CryptoDevTypeUtil.formatType(ShareperencesUtil.getCurrentDevType((Context)this));
        this.tvIdNum = (TextView)this.findViewById(R.id.tv_id_num);
        this.tvName = (TextView)this.findViewById(R.id.tv_name);
        IDCardHeadResult result = (IDCardHeadResult)this.getIntent().getParcelableExtra("result");
        if (result != null) {
            this.tvIdNum.setText((CharSequence)result.getSfzh());
            this.tvName.setText((CharSequence)result.getXm());
            this.btnNext = (Button)this.findViewById(R.id.btn_next);
            this.btnNext.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    IDResultActivity.this.start();
                }
            });
            this.idCardInfo = new IDCardInfo();
            this.idCardInfo.setName(result.getXm());
            this.idCardInfo.setSex(1);
            this.idCardInfo.setIdNum(result.getSfzh());
            this.idCardInfo.setBirthDate(result.getCsrq());
            this.idCardInfo.setNation(result.getMz());
            this.idCardInfo.setAddr(result.getCsdz());
            this.idCardInfo.setIdNum(result.getSfzh());
            this.idCardInfo.setIssueOffice("\u5468\u53e3\u5e02\u516c\u5b89\u5c40\u6cdb\u533a\u5206\u5c40");
            this.idCardInfo.setValidDate("2009.09.04-2019.09.04");
            this.idCardInfo.setPhoto(this.faceImg);
        } else {
            this.idCardInfo = new IDCardInfo();
            this.idCardInfo.setName(this.getIntent().getStringExtra("name"));
            this.idCardInfo.setIdNum(this.getIntent().getStringExtra("cardNum"));
            this.idCardInfo.setAddr(this.getIntent().getStringExtra("address"));
        }
        ModuleLog.d(this.faceImg);
    }

    private void start() {
        CompareCardInfoAndFaceInfoRequest request = this.buildRequest();
        final String cardID = DeviceWrapper.getInstance().getCardID(this.cardType);
        this.showLoading();
        ModuleLog.d((Object)request);
        this.service.entityAuthentication(request, cardID, new HttpResponseCallBack<CommonResponse>(){

            @Override
            public void onOtherException(Exception e) {
                e.printStackTrace();
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                IDResultActivity.this.requestError();
                OttoUtil.postAuthResult(ApplyCertUtil.buildAuthResult(IDResultActivity.this.cardType, cardID, null, null));
                ModuleLog.e("result io");
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                IDResultActivity.this.requestSuccess();
                ShareperencesUtil.saveIDCardNo((Context)IDResultActivity.this, IDResultActivity.this.cardType.getType(), IDResultActivity.this.idCardInfo.getIdNum());
                OttoUtil.postAuthResult(ApplyCertUtil.buildAuthResult(IDResultActivity.this.cardType, cardID, commonResponse, null));
                ModuleLog.e("result success");
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                IDResultActivity.this.requestFail();
                ModuleLog.e("result fail");
                ModuleLog.d(baseErrorResponse);
                OttoUtil.postAuthResult(ApplyCertUtil.buildAuthResult(IDResultActivity.this.cardType, "", null, baseErrorResponse));
            }

            @Override
            public void dismissDialog() {
                IDResultActivity.this.dismissLoading();
                IDResultActivity.this.finish();
            }
        });
    }

    private CompareCardInfoAndFaceInfoRequest buildRequest() {
        CompareCardInfoAndFaceInfoRequest request = new CompareCardInfoAndFaceInfoRequest();
        ChipInfo chipInfo = new ChipInfo();
        DeviceWrapper deviceWrapper = DeviceWrapper.getInstance();
        chipInfo.setCardType("" + CryptoDevTypeUtil.convertCardType(this.cardType.getType()));
        chipInfo.setImei(deviceWrapper.getIMEI());
        chipInfo.setImsi(DeviceWrapper.getInstance().getIMSI());
        chipInfo.setPhone(ShareperencesUtil.getPhoneNum((Context)this));
        request.setIdCardInfo(this.idCardInfo);
        request.setChipInfo(chipInfo);
        request.setFaceImg(this.faceImg);
        request.setCaAlg(AppConfig.getInstance().getCaAlg());
        ModuleLog.e("\u5b9e\u4f53\u8ba4\u8bc1\u8bf7\u6c42\u53c2\u6570\uff1a" + request.toString());
        return request;
    }
}

