/*
 * Decompiled with CFR 0.152.
 */
package ocr.activity;

import android.content.Context;
import android.os.Bundle;
import android.os.Message;
import android.text.TextUtils;
import android.widget.ImageView;
import android.widget.TextView;
import cn.cloudwalk.libproject.view.RoundProgressBarWidthNumber;
import com.aircert.util.WeakReferenceHandler;
import com.alibaba.android.arouter.launcher.ARouter;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.HttpResponseCallBack;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.BaseActivity;
import com.xdja.safeclient.certcreation.bean.ChipInfo;
import com.xdja.safeclient.certcreation.bean.request.CompareCardInfoAndFaceInfoRequest;
import com.xdja.safeclient.certcreation.bean.response.BaseErrorResponse;
import com.xdja.safeclient.certcreation.bean.response.CommonResponse;
import com.xdja.safeclient.certcreation.bean.response.CompareResult;
import com.xdja.safeclient.certcreation.bean.result.AuthResult;
import com.xdja.safeclient.certcreation.cache.RequestCache;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.util.CryptoDevTypeUtil;
import com.xdja.safeclient.certcreation.util.ModuleLog;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import com.xdja.safeclient.certcreation.util.ShareperencesUtil;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import ocr.bean.IDCardInfo;
import okhttp3.Call;

@Deprecated
public class AuthenticationActivity
extends BaseActivity {
    private String faceImg;
    private IDCardInfo idCardInfo;
    private MyHandler myHandler;
    private RoundProgressBarWidthNumber progress_loading;
    private static final int UPDATE_TIME_LEFT = 100;
    private static final int UPDATE_FINAL = 101;
    private TimerRunnable timerRunnable = null;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.compare_loading);
        this.initView();
        this.getParams();
        this.myHandler = new MyHandler(this);
        this.startTimerRunnable();
        this.request();
        this.leftBtn.setVisibility(4);
    }

    private void request() {
        int devType = ShareperencesUtil.getCurrentDevType((Context)this);
        final CryptoDevType currentChipBeanType = CryptoDevTypeUtil.formatType(devType);
        String cardID = DeviceWrapper.getInstance().getCardID(currentChipBeanType);
        if (TextUtils.isEmpty((CharSequence)cardID)) {
            ModuleToast.show(this.context, R.string.card_device_error);
            return;
        }
        final CompareResult compareResult = new CompareResult();
        CompareCardInfoAndFaceInfoRequest request = this.buildRequest();
        if (request == null) {
            ModuleToast.show(this.context, R.string.get_imsi_failed);
            compareResult.setResult("");
            compareResult.setMessage(this.getResources().getString(R.string.get_imsi_failed));
            compareResult.setSuccess(false);
            compareResult.setIdentity(this.idCardInfo.getIdNum());
            this.verifyFailResultActivity(currentChipBeanType, compareResult);
            OttoUtil.postFinishActivity();
            return;
        }
        this.service.entityAuthentication(request, cardID, new HttpResponseCallBack<CommonResponse>(){

            @Override
            public void onOtherException(Exception e) {
                e.printStackTrace();
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                AuthenticationActivity.this.stopTimer();
                ModuleLog.e("io exception");
                compareResult.setResult("");
                compareResult.setMessage(AuthenticationActivity.this.context.getResources().getString(R.string.net_disconnected_text));
                compareResult.setSuccess(false);
                compareResult.setIdentity(AuthenticationActivity.this.idCardInfo.getIdNum());
                AuthenticationActivity.this.verifyFailResultActivity(currentChipBeanType, compareResult);
                OttoUtil.postFinishActivity();
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                compareResult.setResult(commonResponse.getResult());
                compareResult.setMessage(commonResponse.getMessage());
                compareResult.setIdentity(AuthenticationActivity.this.idCardInfo.getIdNum());
                compareResult.setSuccess(true);
                if (commonResponse.getResult().equals("2")) {
                    AuthenticationActivity.this.verifyFailResultActivity(currentChipBeanType, compareResult);
                    AuthenticationActivity.this.finish();
                    OttoUtil.postFinishActivity();
                } else {
                    AuthResult auth = new AuthResult(currentChipBeanType, compareResult, RequestCache.getInstance().getObject());
                    OttoUtil.postAuthResult(auth);
                    OttoUtil.postFinishActivity();
                }
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                AuthenticationActivity.this.stopTimer();
                compareResult.setResult(baseErrorResponse.getErrCode());
                compareResult.setMessage(baseErrorResponse.getMessage());
                compareResult.setIdentity(AuthenticationActivity.this.idCardInfo.getIdNum());
                compareResult.setSuccess(false);
                AuthenticationActivity.this.verifyFailResultActivity(currentChipBeanType, compareResult);
                AuthenticationActivity.this.finish();
            }

            @Override
            public void dismissDialog() {
            }
        });
    }

    private void verifyFailResultActivity(CryptoDevType type, CompareResult result) {
        ARouter.getInstance().build("/cert/auth_fail").withSerializable("result", (Serializable)result).withSerializable("devType", (Serializable)type).navigation((Context)this);
    }

    private CompareCardInfoAndFaceInfoRequest buildRequest() {
        CompareCardInfoAndFaceInfoRequest request = new CompareCardInfoAndFaceInfoRequest();
        ChipInfo chipInfo = new ChipInfo();
        DeviceWrapper deviceWrapper = DeviceWrapper.getInstance();
        chipInfo.setCardType("" + CryptoDevTypeUtil.convertCardType(ShareperencesUtil.getCurrentDevType((Context)this)));
        chipInfo.setImei(deviceWrapper.getIMEI());
        String imsi = deviceWrapper.getIMSI();
        if (TextUtils.isEmpty((CharSequence)imsi)) {
            return null;
        }
        chipInfo.setImsi(deviceWrapper.getIMSI());
        chipInfo.setPhone(ShareperencesUtil.getPhoneNum((Context)this));
        request.setIdCardInfo(this.idCardInfo);
        request.setChipInfo(chipInfo);
        request.setFaceImg(this.faceImg);
        request.setCaAlg(AppConfig.getInstance().getCaAlg());
        return request;
    }

    private void getParams() {
        Bundle others = this.getIntent().getExtras();
        this.faceImg = others.getString("faceImg");
        if (others.containsKey("IDCardInfo")) {
            this.idCardInfo = (IDCardInfo)others.getParcelable("IDCardInfo");
        }
    }

    private void initView() {
        ImageView img_loading = (ImageView)this.findViewById(R.id.img_loading);
        TextView tv_loading = (TextView)this.findViewById(R.id.tv_loading);
        this.progress_loading = (RoundProgressBarWidthNumber)this.findViewById(R.id.progress_loading);
        img_loading.setImageResource(R.drawable.compare_loading);
        tv_loading.setText(R.string.face_comparing);
    }

    private void initProgress(int max) {
        this.progress_loading.setMax(max);
    }

    private void updateTime(int time) {
        this.progress_loading.setProgress(time);
    }

    private void startTimerRunnable() {
        int totalTime = 40;
        this.initProgress(totalTime);
        this.updateTime(totalTime);
        this.timerRunnable = new TimerRunnable(totalTime, this);
        this.myHandler.post(this.timerRunnable);
    }

    private void stopTimer() {
        if (this.timerRunnable != null) {
            this.timerRunnable.setFlag(true);
            this.myHandler.removeMessages(100);
        }
    }

    public void finish() {
        super.finish();
        this.service.cancelAll();
    }

    protected boolean isOCRActivity() {
        return true;
    }

    protected int getTitleRes() {
        return R.string.identify;
    }

    static class MyHandler
    extends WeakReferenceHandler<AuthenticationActivity> {
        public MyHandler(AuthenticationActivity reference) {
            super((Object)reference);
        }

        protected void handleMessage(AuthenticationActivity reference, Message msg) {
            int what = msg.what;
            if (what == 100) {
                reference.updateTime((Integer)msg.obj);
            }
        }
    }

    static class TimerRunnable
    implements Runnable {
        private int total;
        private final WeakReference<AuthenticationActivity> reference;
        private boolean isStop = false;

        public TimerRunnable(int total, AuthenticationActivity activity) {
            this.total = total;
            this.reference = new WeakReference<AuthenticationActivity>(activity);
        }

        public void setFlag(boolean isStop) {
            this.isStop = isStop;
        }

        @Override
        public void run() {
            AuthenticationActivity activity = (AuthenticationActivity)((Object)this.reference.get());
            if (this.isStop || activity == null) {
                return;
            }
            activity.myHandler.obtainMessage(100, this.total).sendToTarget();
            --this.total;
            if (this.total >= 0) {
                activity.myHandler.postDelayed(activity.timerRunnable, 1000L);
            } else {
                activity.myHandler.obtainMessage(101).sendToTarget();
            }
        }
    }
}

