/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.activity;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.StringRes;
import com.aircert.BusProvider;
import com.aircert.CommonActivity.ToolBarActivity;
import com.aircert.FixHWLeak;
import com.alibaba.android.arouter.launcher.ARouter;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.service.CertService;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.view.LoadingDialog;

public abstract class BaseActivity
extends ToolBarActivity {
    protected LoadingDialog dialog;
    protected CertService service;
    public Context context;
    private int contentResID;

    protected LoadingDialog buildDialog() {
        LoadingDialog loadingDialog = new LoadingDialog((Context)this, this.setLoadingText());
        loadingDialog.setCancelable(this.setDialogCancelable());
        return loadingDialog;
    }

    protected LoadingDialog buildDialog(@StringRes int resId) {
        LoadingDialog loadingDialog = new LoadingDialog((Context)this, resId);
        loadingDialog.setCancelable(this.setDialogCancelable());
        return loadingDialog;
    }

    protected void onCreate(Bundle savedInstanceState) {
        this.overridePendingTransition(R.anim.left_in, R.anim.left_out);
        this.context = this;
        BusProvider.getMainProvider().register((Object)this);
        ARouter.getInstance().inject((Object)this);
        super.onCreate(savedInstanceState);
        this.dialog = this.buildDialog();
        this.service = new CertService();
    }

    protected int setLoadingText() {
        return R.string.cert_creation_loading_tips;
    }

    protected boolean setDialogCancelable() {
        return true;
    }

    protected void onDestroy() {
        super.onDestroy();
        BusProvider.getMainProvider().unregister((Object)this);
        this.dismissLoading();
        FixHWLeak.fixLeak((Context)this.context);
    }

    public void onBackPressed() {
        super.onBackPressed();
        this.overridePendingTransition(R.anim.right_in, R.anim.right_out);
    }

    protected void showLoading() {
        if (this.dialog == null) {
            this.dialog = this.buildDialog();
        }
        this.dialog.showLoading();
    }

    protected void showLoading(int resId) {
        if (this.dialog == null || resId != R.string.cert_creation_loading_tips) {
            this.dialog = this.buildDialog(resId);
        }
        this.dialog.showLoading();
    }

    protected void setLoadingContent(int id2) {
        this.dialog.setContent(id2);
    }

    protected void dismissLoading() {
        if (this.dialog != null) {
            this.dialog.dismissLoading();
            this.dialog = null;
        }
    }

    public void showRequestError() {
        ModuleToast.show(this.context, R.string.cert_creation_network_err);
    }

    protected CryptoDevType getCardType() {
        return (CryptoDevType)this.getIntent().getSerializableExtra("cardType");
    }

    public String getCardNum() {
        return this.getIntent().getStringExtra("cardId");
    }

    public void post(Object object) {
        BusProvider.getMainProvider().post(object);
    }

    public void requestSuccess() {
        ModuleToast.show(this.context, R.string.cert_creation_success);
    }

    public void requestFail() {
        ModuleToast.show(this.context, R.string.cert_creation_fail);
    }

    public void requestError() {
        ModuleToast.show(this.context, "IO");
    }

    public String nextActivity() {
        return null;
    }

    public void next() {
        if (this.valid()) {
            this.saveValue();
            this.route();
        }
    }

    public boolean valid() {
        return true;
    }

    public void saveValue() {
    }

    public void route() {
    }
}

